/* GtkamlMethod.vala
 * 
 * Copyright (C) 2008 Vlad Grecescu
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with main.c; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor Boston, MA 02110-1301,  USA
 *
 * Author:
 *        Vlad Grecescu (b100dian@gmail.com)
 */

#ifndef __GTKAMLMETHOD_H__
#define __GTKAMLMETHOD_H__

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gee/list.h>

G_BEGIN_DECLS


#define GTKAML_TYPE_METHOD (gtkaml_method_get_type ())
#define GTKAML_METHOD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GTKAML_TYPE_METHOD, GtkamlMethod))
#define GTKAML_METHOD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GTKAML_TYPE_METHOD, GtkamlMethodClass))
#define GTKAML_IS_METHOD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GTKAML_TYPE_METHOD))
#define GTKAML_IS_METHOD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GTKAML_TYPE_METHOD))
#define GTKAML_METHOD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GTKAML_TYPE_METHOD, GtkamlMethodClass))

typedef struct _GtkamlMethod GtkamlMethod;
typedef struct _GtkamlMethodClass GtkamlMethodClass;
typedef struct _GtkamlMethodPrivate GtkamlMethodPrivate;

#define GTKAML_TYPE_ADD_METHOD (gtkaml_add_method_get_type ())
#define GTKAML_ADD_METHOD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GTKAML_TYPE_ADD_METHOD, GtkamlAddMethod))
#define GTKAML_ADD_METHOD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GTKAML_TYPE_ADD_METHOD, GtkamlAddMethodClass))
#define GTKAML_IS_ADD_METHOD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GTKAML_TYPE_ADD_METHOD))
#define GTKAML_IS_ADD_METHOD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GTKAML_TYPE_ADD_METHOD))
#define GTKAML_ADD_METHOD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GTKAML_TYPE_ADD_METHOD, GtkamlAddMethodClass))

typedef struct _GtkamlAddMethod GtkamlAddMethod;
typedef struct _GtkamlAddMethodClass GtkamlAddMethodClass;
typedef struct _GtkamlAddMethodPrivate GtkamlAddMethodPrivate;

#define GTKAML_TYPE_CONSTRUCT_METHOD (gtkaml_construct_method_get_type ())
#define GTKAML_CONSTRUCT_METHOD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GTKAML_TYPE_CONSTRUCT_METHOD, GtkamlConstructMethod))
#define GTKAML_CONSTRUCT_METHOD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GTKAML_TYPE_CONSTRUCT_METHOD, GtkamlConstructMethodClass))
#define GTKAML_IS_CONSTRUCT_METHOD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GTKAML_TYPE_CONSTRUCT_METHOD))
#define GTKAML_IS_CONSTRUCT_METHOD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GTKAML_TYPE_CONSTRUCT_METHOD))
#define GTKAML_CONSTRUCT_METHOD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GTKAML_TYPE_CONSTRUCT_METHOD, GtkamlConstructMethodClass))

typedef struct _GtkamlConstructMethod GtkamlConstructMethod;
typedef struct _GtkamlConstructMethodClass GtkamlConstructMethodClass;
typedef struct _GtkamlConstructMethodPrivate GtkamlConstructMethodPrivate;

/**
 * a constructor or an add method
 */
struct _GtkamlMethod {
	GObject parent_instance;
	GtkamlMethodPrivate * priv;
};

struct _GtkamlMethodClass {
	GObjectClass parent_class;
};

/** useless specialization */
struct _GtkamlAddMethod {
	GtkamlMethod parent_instance;
	GtkamlAddMethodPrivate * priv;
};

struct _GtkamlAddMethodClass {
	GtkamlMethodClass parent_class;
};

/** useless specialization */
struct _GtkamlConstructMethod {
	GtkamlMethod parent_instance;
	GtkamlConstructMethodPrivate * priv;
};

struct _GtkamlConstructMethodClass {
	GtkamlMethodClass parent_class;
};


const char* gtkaml_method_get_name (GtkamlMethod* self);
void gtkaml_method_set_name (GtkamlMethod* self, const char* value);
GeeList* gtkaml_method_get_parameter_attributes (GtkamlMethod* self);
void gtkaml_method_set_parameter_attributes (GtkamlMethod* self, GeeList* value);
GType gtkaml_method_get_type (void);
GtkamlAddMethod* gtkaml_add_method_construct (GType object_type);
GtkamlAddMethod* gtkaml_add_method_new (void);
GType gtkaml_add_method_get_type (void);
GtkamlConstructMethod* gtkaml_construct_method_construct (GType object_type);
GtkamlConstructMethod* gtkaml_construct_method_new (void);
GType gtkaml_construct_method_get_type (void);


G_END_DECLS

#endif
