/* GtkamlImplicitsResolver.vala
 * 
 * Copyright (C) 2008 Vlad Grecescu
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with main.c; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor Boston, MA 02110-1301,  USA
 *
 * Author:
 *        Vlad Grecescu (b100dian@gmail.com)
 */

#include <glib.h>
#include <glib-object.h>
#include <vala.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>


#define GTKAML_TYPE_IMPLICITS_RESOLVER (gtkaml_implicits_resolver_get_type ())
#define GTKAML_IMPLICITS_RESOLVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GTKAML_TYPE_IMPLICITS_RESOLVER, GtkamlImplicitsResolver))
#define GTKAML_IMPLICITS_RESOLVER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GTKAML_TYPE_IMPLICITS_RESOLVER, GtkamlImplicitsResolverClass))
#define GTKAML_IS_IMPLICITS_RESOLVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GTKAML_TYPE_IMPLICITS_RESOLVER))
#define GTKAML_IS_IMPLICITS_RESOLVER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GTKAML_TYPE_IMPLICITS_RESOLVER))
#define GTKAML_IMPLICITS_RESOLVER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GTKAML_TYPE_IMPLICITS_RESOLVER, GtkamlImplicitsResolverClass))

typedef struct _GtkamlImplicitsResolver GtkamlImplicitsResolver;
typedef struct _GtkamlImplicitsResolverClass GtkamlImplicitsResolverClass;
typedef struct _GtkamlImplicitsResolverPrivate GtkamlImplicitsResolverPrivate;

#define GTKAML_TYPE_IMPLICITS_STORE (gtkaml_implicits_store_get_type ())
#define GTKAML_IMPLICITS_STORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GTKAML_TYPE_IMPLICITS_STORE, GtkamlImplicitsStore))
#define GTKAML_IMPLICITS_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GTKAML_TYPE_IMPLICITS_STORE, GtkamlImplicitsStoreClass))
#define GTKAML_IS_IMPLICITS_STORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GTKAML_TYPE_IMPLICITS_STORE))
#define GTKAML_IS_IMPLICITS_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GTKAML_TYPE_IMPLICITS_STORE))
#define GTKAML_IMPLICITS_STORE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GTKAML_TYPE_IMPLICITS_STORE, GtkamlImplicitsStoreClass))

typedef struct _GtkamlImplicitsStore GtkamlImplicitsStore;
typedef struct _GtkamlImplicitsStoreClass GtkamlImplicitsStoreClass;

#define GTKAML_TYPE_CLASS_DEFINITION (gtkaml_class_definition_get_type ())
#define GTKAML_CLASS_DEFINITION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GTKAML_TYPE_CLASS_DEFINITION, GtkamlClassDefinition))
#define GTKAML_CLASS_DEFINITION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GTKAML_TYPE_CLASS_DEFINITION, GtkamlClassDefinitionClass))
#define GTKAML_IS_CLASS_DEFINITION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GTKAML_TYPE_CLASS_DEFINITION))
#define GTKAML_IS_CLASS_DEFINITION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GTKAML_TYPE_CLASS_DEFINITION))
#define GTKAML_CLASS_DEFINITION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GTKAML_TYPE_CLASS_DEFINITION, GtkamlClassDefinitionClass))

typedef struct _GtkamlClassDefinition GtkamlClassDefinition;
typedef struct _GtkamlClassDefinitionClass GtkamlClassDefinitionClass;

#define GTKAML_TYPE_REFERENCE_CLASS_DEFINITION (gtkaml_reference_class_definition_get_type ())
#define GTKAML_REFERENCE_CLASS_DEFINITION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GTKAML_TYPE_REFERENCE_CLASS_DEFINITION, GtkamlReferenceClassDefinition))
#define GTKAML_REFERENCE_CLASS_DEFINITION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GTKAML_TYPE_REFERENCE_CLASS_DEFINITION, GtkamlReferenceClassDefinitionClass))
#define GTKAML_IS_REFERENCE_CLASS_DEFINITION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GTKAML_TYPE_REFERENCE_CLASS_DEFINITION))
#define GTKAML_IS_REFERENCE_CLASS_DEFINITION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GTKAML_TYPE_REFERENCE_CLASS_DEFINITION))
#define GTKAML_REFERENCE_CLASS_DEFINITION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GTKAML_TYPE_REFERENCE_CLASS_DEFINITION, GtkamlReferenceClassDefinitionClass))

typedef struct _GtkamlReferenceClassDefinition GtkamlReferenceClassDefinition;
typedef struct _GtkamlReferenceClassDefinitionClass GtkamlReferenceClassDefinitionClass;

#define GTKAML_TYPE_ATTRIBUTE (gtkaml_attribute_get_type ())
#define GTKAML_ATTRIBUTE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GTKAML_TYPE_ATTRIBUTE, GtkamlAttribute))
#define GTKAML_ATTRIBUTE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GTKAML_TYPE_ATTRIBUTE, GtkamlAttributeClass))
#define GTKAML_IS_ATTRIBUTE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GTKAML_TYPE_ATTRIBUTE))
#define GTKAML_IS_ATTRIBUTE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GTKAML_TYPE_ATTRIBUTE))
#define GTKAML_ATTRIBUTE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GTKAML_TYPE_ATTRIBUTE, GtkamlAttributeClass))

typedef struct _GtkamlAttribute GtkamlAttribute;
typedef struct _GtkamlAttributeClass GtkamlAttributeClass;

#define GTKAML_TYPE_COMPLEX_ATTRIBUTE (gtkaml_complex_attribute_get_type ())
#define GTKAML_COMPLEX_ATTRIBUTE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GTKAML_TYPE_COMPLEX_ATTRIBUTE, GtkamlComplexAttribute))
#define GTKAML_COMPLEX_ATTRIBUTE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GTKAML_TYPE_COMPLEX_ATTRIBUTE, GtkamlComplexAttributeClass))
#define GTKAML_IS_COMPLEX_ATTRIBUTE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GTKAML_TYPE_COMPLEX_ATTRIBUTE))
#define GTKAML_IS_COMPLEX_ATTRIBUTE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GTKAML_TYPE_COMPLEX_ATTRIBUTE))
#define GTKAML_COMPLEX_ATTRIBUTE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GTKAML_TYPE_COMPLEX_ATTRIBUTE, GtkamlComplexAttributeClass))

typedef struct _GtkamlComplexAttribute GtkamlComplexAttribute;
typedef struct _GtkamlComplexAttributeClass GtkamlComplexAttributeClass;

#define GTKAML_TYPE_METHOD (gtkaml_method_get_type ())
#define GTKAML_METHOD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GTKAML_TYPE_METHOD, GtkamlMethod))
#define GTKAML_METHOD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GTKAML_TYPE_METHOD, GtkamlMethodClass))
#define GTKAML_IS_METHOD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GTKAML_TYPE_METHOD))
#define GTKAML_IS_METHOD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GTKAML_TYPE_METHOD))
#define GTKAML_METHOD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GTKAML_TYPE_METHOD, GtkamlMethodClass))

typedef struct _GtkamlMethod GtkamlMethod;
typedef struct _GtkamlMethodClass GtkamlMethodClass;

#define GTKAML_TYPE_CONSTRUCT_METHOD (gtkaml_construct_method_get_type ())
#define GTKAML_CONSTRUCT_METHOD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GTKAML_TYPE_CONSTRUCT_METHOD, GtkamlConstructMethod))
#define GTKAML_CONSTRUCT_METHOD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GTKAML_TYPE_CONSTRUCT_METHOD, GtkamlConstructMethodClass))
#define GTKAML_IS_CONSTRUCT_METHOD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GTKAML_TYPE_CONSTRUCT_METHOD))
#define GTKAML_IS_CONSTRUCT_METHOD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GTKAML_TYPE_CONSTRUCT_METHOD))
#define GTKAML_CONSTRUCT_METHOD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GTKAML_TYPE_CONSTRUCT_METHOD, GtkamlConstructMethodClass))

typedef struct _GtkamlConstructMethod GtkamlConstructMethod;
typedef struct _GtkamlConstructMethodClass GtkamlConstructMethodClass;

#define GTKAML_TYPE_ADD_METHOD (gtkaml_add_method_get_type ())
#define GTKAML_ADD_METHOD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GTKAML_TYPE_ADD_METHOD, GtkamlAddMethod))
#define GTKAML_ADD_METHOD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GTKAML_TYPE_ADD_METHOD, GtkamlAddMethodClass))
#define GTKAML_IS_ADD_METHOD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GTKAML_TYPE_ADD_METHOD))
#define GTKAML_IS_ADD_METHOD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GTKAML_TYPE_ADD_METHOD))
#define GTKAML_ADD_METHOD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GTKAML_TYPE_ADD_METHOD, GtkamlAddMethodClass))

typedef struct _GtkamlAddMethod GtkamlAddMethod;
typedef struct _GtkamlAddMethodClass GtkamlAddMethodClass;

#define GTKAML_TYPE_SIMPLE_ATTRIBUTE (gtkaml_simple_attribute_get_type ())
#define GTKAML_SIMPLE_ATTRIBUTE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GTKAML_TYPE_SIMPLE_ATTRIBUTE, GtkamlSimpleAttribute))
#define GTKAML_SIMPLE_ATTRIBUTE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GTKAML_TYPE_SIMPLE_ATTRIBUTE, GtkamlSimpleAttributeClass))
#define GTKAML_IS_SIMPLE_ATTRIBUTE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GTKAML_TYPE_SIMPLE_ATTRIBUTE))
#define GTKAML_IS_SIMPLE_ATTRIBUTE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GTKAML_TYPE_SIMPLE_ATTRIBUTE))
#define GTKAML_SIMPLE_ATTRIBUTE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GTKAML_TYPE_SIMPLE_ATTRIBUTE, GtkamlSimpleAttributeClass))

typedef struct _GtkamlSimpleAttribute GtkamlSimpleAttribute;
typedef struct _GtkamlSimpleAttributeClass GtkamlSimpleAttributeClass;

#define GTKAML_TYPE_METHOD_MATCHER (gtkaml_method_matcher_get_type ())
#define GTKAML_METHOD_MATCHER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GTKAML_TYPE_METHOD_MATCHER, GtkamlMethodMatcher))
#define GTKAML_METHOD_MATCHER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GTKAML_TYPE_METHOD_MATCHER, GtkamlMethodMatcherClass))
#define GTKAML_IS_METHOD_MATCHER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GTKAML_TYPE_METHOD_MATCHER))
#define GTKAML_IS_METHOD_MATCHER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GTKAML_TYPE_METHOD_MATCHER))
#define GTKAML_METHOD_MATCHER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GTKAML_TYPE_METHOD_MATCHER, GtkamlMethodMatcherClass))

typedef struct _GtkamlMethodMatcher GtkamlMethodMatcher;
typedef struct _GtkamlMethodMatcherClass GtkamlMethodMatcherClass;

/** 
 * determines which constructors to use or which container add functions to use;
 * moves attributes from their ClassDefinition to the add or construct methods
 */
struct _GtkamlImplicitsResolver {
	GObject parent_instance;
	GtkamlImplicitsResolverPrivate * priv;
};

struct _GtkamlImplicitsResolverClass {
	GObjectClass parent_class;
};

struct _GtkamlImplicitsResolverPrivate {
	GtkamlImplicitsStore* _implicits_store;
	ValaCodeContext* _context;
};



GType gtkaml_implicits_resolver_get_type (void);
GType gtkaml_implicits_store_get_type (void);
#define GTKAML_IMPLICITS_RESOLVER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GTKAML_TYPE_IMPLICITS_RESOLVER, GtkamlImplicitsResolverPrivate))
enum  {
	GTKAML_IMPLICITS_RESOLVER_DUMMY_PROPERTY,
	GTKAML_IMPLICITS_RESOLVER_IMPLICITS_STORE,
	GTKAML_IMPLICITS_RESOLVER_CONTEXT
};
static void gtkaml_implicits_resolver_set_context (GtkamlImplicitsResolver* self, ValaCodeContext* value);
static void gtkaml_implicits_resolver_set_implicits_store (GtkamlImplicitsResolver* self, GtkamlImplicitsStore* value);
GtkamlImplicitsResolver* gtkaml_implicits_resolver_new (ValaCodeContext* context, GtkamlImplicitsStore* implicits_store);
GtkamlImplicitsResolver* gtkaml_implicits_resolver_construct (GType object_type, ValaCodeContext* context, GtkamlImplicitsStore* implicits_store);
GtkamlImplicitsResolver* gtkaml_implicits_resolver_new (ValaCodeContext* context, GtkamlImplicitsStore* implicits_store);
GType gtkaml_class_definition_get_type (void);
GType gtkaml_reference_class_definition_get_type (void);
static void gtkaml_implicits_resolver_determine_construct_method (GtkamlImplicitsResolver* self, GtkamlClassDefinition* class_definition);
GtkamlClassDefinition* gtkaml_class_definition_get_parent_container (GtkamlClassDefinition* self);
static void gtkaml_implicits_resolver_determine_add_method (GtkamlImplicitsResolver* self, GtkamlClassDefinition* child_definition);
GType gtkaml_attribute_get_type (void);
GeeList* gtkaml_class_definition_get_attrs (GtkamlClassDefinition* self);
ValaSourceReference* gtkaml_class_definition_get_source_reference (GtkamlClassDefinition* self);
void gtkaml_implicits_resolver_resolve_complex_attributes (GtkamlImplicitsResolver* self, GtkamlClassDefinition* class_definition);
static void gtkaml_implicits_resolver_determine_attribute_types (GtkamlImplicitsResolver* self, GtkamlClassDefinition* class_definition);
GeeList* gtkaml_class_definition_get_children (GtkamlClassDefinition* self);
void gtkaml_implicits_resolver_resolve (GtkamlImplicitsResolver* self, GtkamlClassDefinition* class_definition);
GType gtkaml_complex_attribute_get_type (void);
GtkamlClassDefinition* gtkaml_complex_attribute_get_complex_type (GtkamlComplexAttribute* self);
GType gtkaml_method_get_type (void);
GType gtkaml_construct_method_get_type (void);
GtkamlConstructMethod* gtkaml_class_definition_get_construct_method (GtkamlClassDefinition* self);
GeeList* gtkaml_method_get_parameter_attributes (GtkamlMethod* self);
GType gtkaml_add_method_get_type (void);
GtkamlAddMethod* gtkaml_class_definition_get_add_method (GtkamlClassDefinition* self);
void gtkaml_implicits_resolver_lookup_container_add_methods (GtkamlImplicitsResolver* self, const char* ns, ValaClass* container_class, GeeList* methods);
const char* gtkaml_class_definition_get_base_ns (GtkamlClassDefinition* self);
ValaClass* gtkaml_class_definition_get_base_type (GtkamlClassDefinition* self);
GtkamlAddMethod* gtkaml_add_method_new (void);
GtkamlAddMethod* gtkaml_add_method_construct (GType object_type);
GType gtkaml_simple_attribute_get_type (void);
const char* gtkaml_attribute_get_name (GtkamlAttribute* self);
const char* gtkaml_simple_attribute_get_value (GtkamlSimpleAttribute* self);
GtkamlComplexAttribute* gtkaml_complex_attribute_new (const char* name, GtkamlClassDefinition* complex_type);
GtkamlComplexAttribute* gtkaml_complex_attribute_construct (GType object_type, const char* name, GtkamlClassDefinition* complex_type);
GtkamlImplicitsStore* gtkaml_implicits_resolver_get_implicits_store (GtkamlImplicitsResolver* self);
GtkamlMethodMatcher* gtkaml_method_matcher_new (GtkamlImplicitsStore* implicits_store, GtkamlClassDefinition* class_owning_method, const char* wording, GtkamlComplexAttribute* first_parameter);
GtkamlMethodMatcher* gtkaml_method_matcher_construct (GType object_type, GtkamlImplicitsStore* implicits_store, GtkamlClassDefinition* class_owning_method, const char* wording, GtkamlComplexAttribute* first_parameter);
GType gtkaml_method_matcher_get_type (void);
void gtkaml_method_matcher_add_method (GtkamlMethodMatcher* self, ValaMethod* method);
ValaMethod* gtkaml_method_matcher_determine_matching_method (GtkamlMethodMatcher* self);
void gtkaml_method_matcher_set_method_parameters (GtkamlMethodMatcher* self, GtkamlMethod* new_method, ValaMethod* determined_method);
void gtkaml_class_definition_set_add_method (GtkamlClassDefinition* self, GtkamlAddMethod* value);
static GeeList* gtkaml_implicits_resolver_lookup_constructors (GtkamlImplicitsResolver* self, ValaClass* clazz);
GtkamlConstructMethod* gtkaml_construct_method_new (void);
GtkamlConstructMethod* gtkaml_construct_method_construct (GType object_type);
void gtkaml_class_definition_set_construct_method (GtkamlClassDefinition* self, GtkamlConstructMethod* value);
static char* gtkaml_implicits_resolver_get_unresolved_type_ns (GtkamlImplicitsResolver* self, ValaUnresolvedType* dt);
static ValaObjectTypeSymbol* gtkaml_implicits_resolver_lookup_class (GtkamlImplicitsResolver* self, const char* xmlNamespace, const char* name);
static void gtkaml_implicits_resolver_lookup_container_add_methods_for_class (GtkamlImplicitsResolver* self, const char* ns, ValaClass* container_class_implicits_entry, const char* ns2, ValaObjectTypeSymbol* container_class_holding_methods, GeeList* methods);
GeeList* gtkaml_implicits_store_get_adds (GtkamlImplicitsStore* self, const char* ns, const char* class_name);
static ValaMember* gtkaml_implicits_resolver_member_lookup_inherited (GtkamlImplicitsResolver* self, ValaClass* clazz, const char* member);
void gtkaml_attribute_set_target_type (GtkamlAttribute* self, ValaSymbol* value);
ValaSymbol* gtkaml_attribute_get_target_type (GtkamlAttribute* self);
char* gtkaml_class_definition_get_base_full_name (GtkamlClassDefinition* self);
ValaCodeContext* gtkaml_implicits_resolver_get_context (GtkamlImplicitsResolver* self);
static gpointer gtkaml_implicits_resolver_parent_class = NULL;
static void gtkaml_implicits_resolver_finalize (GObject* obj);
static int _vala_strcmp0 (const char * str1, const char * str2);



GtkamlImplicitsResolver* gtkaml_implicits_resolver_construct (GType object_type, ValaCodeContext* context, GtkamlImplicitsStore* implicits_store) {
	GParameter * __params;
	GParameter * __params_it;
	GtkamlImplicitsResolver * self;
	g_return_val_if_fail (context != NULL, NULL);
	g_return_val_if_fail (implicits_store != NULL, NULL);
	__params = g_new0 (GParameter, 1);
	__params_it = __params;
	__params_it->name = "implicits-store";
	g_value_init (&__params_it->value, GTKAML_TYPE_IMPLICITS_STORE);
	g_value_set_object (&__params_it->value, implicits_store);
	__params_it++;
	self = g_object_newv (object_type, __params_it - __params, __params);
	gtkaml_implicits_resolver_set_context (self, context);
	while (__params_it > __params) {
		--__params_it;
		g_value_unset (&__params_it->value);
	}
	g_free (__params);
	return self;
}


GtkamlImplicitsResolver* gtkaml_implicits_resolver_new (ValaCodeContext* context, GtkamlImplicitsStore* implicits_store) {
	return gtkaml_implicits_resolver_construct (GTKAML_TYPE_IMPLICITS_RESOLVER, context, implicits_store);
}


void gtkaml_implicits_resolver_resolve (GtkamlImplicitsResolver* self, GtkamlClassDefinition* class_definition) {
	gboolean _tmp0;
	gboolean _tmp1;
	g_return_if_fail (self != NULL);
	g_return_if_fail (class_definition != NULL);
	/*determine which constructor shall we use
	references don't have to be constructed*/
	if (!GTKAML_IS_REFERENCE_CLASS_DEFINITION (class_definition)) {
		gtkaml_implicits_resolver_determine_construct_method (self, class_definition);
	}
	/*then determine the container add function, if applicable*/
	if (gtkaml_class_definition_get_parent_container (class_definition) != NULL) {
		gtkaml_implicits_resolver_determine_add_method (self, class_definition);
	}
	_tmp0 = FALSE;
	_tmp1 = FALSE;
	if (GTKAML_IS_REFERENCE_CLASS_DEFINITION (class_definition)) {
		_tmp1 = gee_collection_get_size ((GeeCollection*) gtkaml_class_definition_get_attrs (class_definition)) != 0;
	} else {
		_tmp1 = FALSE;
	}
	if (_tmp1) {
		_tmp0 = gtkaml_class_definition_get_parent_container (class_definition) != NULL;
	} else {
		_tmp0 = FALSE;
	}
	/*References should have no other attributes than the 'attached' ones (woa.. i learned xaml)*/
	if (_tmp0) {
		vala_report_error (gtkaml_class_definition_get_source_reference (class_definition), "No attributes other than the container add parameters are allowed on existing widgets which are not standalone");
	}
	/*resolve the rest of the attr types*/
	gtkaml_implicits_resolver_resolve_complex_attributes (self, class_definition);
	gtkaml_implicits_resolver_determine_attribute_types (self, class_definition);
	{
		GeeIterator* _child_it;
		_child_it = gee_iterable_iterator ((GeeIterable*) gtkaml_class_definition_get_children (class_definition));
		while (gee_iterator_next (_child_it)) {
			GtkamlClassDefinition* child;
			child = (GtkamlClassDefinition*) gee_iterator_get (_child_it);
			gtkaml_implicits_resolver_resolve (self, child);
			(child == NULL) ? NULL : (child = (g_object_unref (child), NULL));
		}
		(_child_it == NULL) ? NULL : (_child_it = (gee_collection_object_unref (_child_it), NULL));
	}
}


void gtkaml_implicits_resolver_resolve_complex_attributes (GtkamlImplicitsResolver* self, GtkamlClassDefinition* class_definition) {
	gboolean _tmp1;
	gboolean first;
	gboolean _tmp3;
	g_return_if_fail (self != NULL);
	g_return_if_fail (class_definition != NULL);
	{
		GeeIterator* _attr_it;
		_attr_it = gee_iterable_iterator ((GeeIterable*) gtkaml_class_definition_get_attrs (class_definition));
		while (gee_iterator_next (_attr_it)) {
			GtkamlAttribute* attr;
			attr = (GtkamlAttribute*) gee_iterator_get (_attr_it);
			if (GTKAML_IS_COMPLEX_ATTRIBUTE (attr)) {
				GtkamlAttribute* _tmp0;
				_tmp0 = NULL;
				gtkaml_implicits_resolver_resolve (self, gtkaml_complex_attribute_get_complex_type ((_tmp0 = attr, GTKAML_IS_COMPLEX_ATTRIBUTE (_tmp0) ? ((GtkamlComplexAttribute*) _tmp0) : NULL)));
			}
			(attr == NULL) ? NULL : (attr = (g_object_unref (attr), NULL));
		}
		(_attr_it == NULL) ? NULL : (_attr_it = (gee_collection_object_unref (_attr_it), NULL));
	}
	_tmp1 = FALSE;
	if (gtkaml_class_definition_get_construct_method (class_definition) != NULL) {
		_tmp1 = gtkaml_method_get_parameter_attributes ((GtkamlMethod*) gtkaml_class_definition_get_construct_method (class_definition)) != NULL;
	} else {
		_tmp1 = FALSE;
	}
	if (_tmp1) {
		{
			GeeIterator* _attr_it;
			_attr_it = gee_iterable_iterator ((GeeIterable*) gtkaml_method_get_parameter_attributes ((GtkamlMethod*) gtkaml_class_definition_get_construct_method (class_definition)));
			while (gee_iterator_next (_attr_it)) {
				GtkamlAttribute* attr;
				attr = (GtkamlAttribute*) gee_iterator_get (_attr_it);
				if (GTKAML_IS_COMPLEX_ATTRIBUTE (attr)) {
					GtkamlAttribute* _tmp2;
					_tmp2 = NULL;
					gtkaml_implicits_resolver_resolve (self, gtkaml_complex_attribute_get_complex_type ((_tmp2 = attr, GTKAML_IS_COMPLEX_ATTRIBUTE (_tmp2) ? ((GtkamlComplexAttribute*) _tmp2) : NULL)));
				}
				(attr == NULL) ? NULL : (attr = (g_object_unref (attr), NULL));
			}
			(_attr_it == NULL) ? NULL : (_attr_it = (gee_collection_object_unref (_attr_it), NULL));
		}
	}
	first = TRUE;
	_tmp3 = FALSE;
	if (gtkaml_class_definition_get_add_method (class_definition) != NULL) {
		_tmp3 = gtkaml_method_get_parameter_attributes ((GtkamlMethod*) gtkaml_class_definition_get_add_method (class_definition)) != NULL;
	} else {
		_tmp3 = FALSE;
	}
	/*do not generate the first parameter of the container add child method*/
	if (_tmp3) {
		{
			GeeIterator* _attr_it;
			_attr_it = gee_iterable_iterator ((GeeIterable*) gtkaml_method_get_parameter_attributes ((GtkamlMethod*) gtkaml_class_definition_get_add_method (class_definition)));
			while (gee_iterator_next (_attr_it)) {
				GtkamlAttribute* attr;
				gboolean _tmp4;
				attr = (GtkamlAttribute*) gee_iterator_get (_attr_it);
				_tmp4 = FALSE;
				if (GTKAML_IS_COMPLEX_ATTRIBUTE (attr)) {
					_tmp4 = !first;
				} else {
					_tmp4 = FALSE;
				}
				if (_tmp4) {
					GtkamlAttribute* _tmp5;
					_tmp5 = NULL;
					gtkaml_implicits_resolver_resolve (self, gtkaml_complex_attribute_get_complex_type ((_tmp5 = attr, GTKAML_IS_COMPLEX_ATTRIBUTE (_tmp5) ? ((GtkamlComplexAttribute*) _tmp5) : NULL)));
				}
				first = FALSE;
				(attr == NULL) ? NULL : (attr = (g_object_unref (attr), NULL));
			}
			(_attr_it == NULL) ? NULL : (_attr_it = (gee_collection_object_unref (_attr_it), NULL));
		}
	}
}


/**
 * Determines which add method of parent container would be useful
 */
static void gtkaml_implicits_resolver_determine_add_method (GtkamlImplicitsResolver* self, GtkamlClassDefinition* child_definition) {
	GeeList* adds;
	ValaMethod* determined_add;
	GtkamlAddMethod* new_method;
	GeeList* to_remove;
	GtkamlComplexAttribute* first_parameter;
	GtkamlMethodMatcher* method_matcher;
	g_return_if_fail (self != NULL);
	g_return_if_fail (child_definition != NULL);
	adds = (GeeList*) gee_array_list_new (VALA_TYPE_METHOD, (GBoxedCopyFunc) vala_code_node_ref, vala_code_node_unref, g_direct_equal);
	gtkaml_implicits_resolver_lookup_container_add_methods (self, gtkaml_class_definition_get_base_ns (gtkaml_class_definition_get_parent_container (child_definition)), gtkaml_class_definition_get_base_type (gtkaml_class_definition_get_parent_container (child_definition)), adds);
	determined_add = NULL;
	new_method = gtkaml_add_method_new ();
	to_remove = (GeeList*) gee_array_list_new (GTKAML_TYPE_ATTRIBUTE, (GBoxedCopyFunc) g_object_ref, g_object_unref, g_direct_equal);
	/*pass one: see if we find an explicitly specified add method*/
	{
		GeeIterator* _add_it;
		/*pass one: see if we find an explicitly specified add method*/
		_add_it = gee_iterable_iterator ((GeeIterable*) adds);
		/*pass one: see if we find an explicitly specified add method*/
		while (gee_iterator_next (_add_it)) {
			ValaMethod* add;
			/*pass one: see if we find an explicitly specified add method*/
			add = (ValaMethod*) gee_iterator_get (_add_it);
			{
				GeeIterator* _attr_it;
				_attr_it = gee_iterable_iterator ((GeeIterable*) gtkaml_class_definition_get_attrs (child_definition));
				while (gee_iterator_next (_attr_it)) {
					GtkamlAttribute* attr;
					gboolean _tmp0;
					gboolean _tmp1;
					attr = (GtkamlAttribute*) gee_iterator_get (_attr_it);
					_tmp0 = FALSE;
					_tmp1 = FALSE;
					if (GTKAML_IS_SIMPLE_ATTRIBUTE (attr)) {
						_tmp1 = _vala_strcmp0 (gtkaml_attribute_get_name (attr), vala_symbol_get_name ((ValaSymbol*) add)) == 0;
					} else {
						_tmp1 = FALSE;
					}
					if (_tmp1) {
						GtkamlAttribute* _tmp2;
						_tmp2 = NULL;
						_tmp0 = _vala_strcmp0 (gtkaml_simple_attribute_get_value ((_tmp2 = attr, GTKAML_IS_SIMPLE_ATTRIBUTE (_tmp2) ? ((GtkamlSimpleAttribute*) _tmp2) : NULL)), "true") == 0;
					} else {
						_tmp0 = FALSE;
					}
					if (_tmp0) {
						ValaMethod* _tmp4;
						ValaMethod* _tmp3;
						_tmp4 = NULL;
						_tmp3 = NULL;
						determined_add = (_tmp4 = (_tmp3 = add, (_tmp3 == NULL) ? NULL : vala_code_node_ref (_tmp3)), (determined_add == NULL) ? NULL : (determined_add = (vala_code_node_unref (determined_add), NULL)), _tmp4);
						gee_collection_add ((GeeCollection*) to_remove, attr);
						(attr == NULL) ? NULL : (attr = (g_object_unref (attr), NULL));
						break;
					}
					(attr == NULL) ? NULL : (attr = (g_object_unref (attr), NULL));
				}
				(_attr_it == NULL) ? NULL : (_attr_it = (gee_collection_object_unref (_attr_it), NULL));
			}
			(add == NULL) ? NULL : (add = (vala_code_node_unref (add), NULL));
		}
		(_add_it == NULL) ? NULL : (_add_it = (gee_collection_object_unref (_add_it), NULL));
	}
	first_parameter = gtkaml_complex_attribute_new ("widget", child_definition);
	method_matcher = gtkaml_method_matcher_new (self->priv->_implicits_store, gtkaml_class_definition_get_parent_container (child_definition), "container add method", first_parameter);
	/*pass two: the first who matches the most parameters + warning if there are more*/
	if (determined_add == NULL) {
		ValaMethod* _tmp5;
		{
			GeeIterator* _method_it;
			_method_it = gee_iterable_iterator ((GeeIterable*) adds);
			while (gee_iterator_next (_method_it)) {
				ValaMethod* method;
				method = (ValaMethod*) gee_iterator_get (_method_it);
				gtkaml_method_matcher_add_method (method_matcher, method);
				(method == NULL) ? NULL : (method = (vala_code_node_unref (method), NULL));
			}
			(_method_it == NULL) ? NULL : (_method_it = (gee_collection_object_unref (_method_it), NULL));
		}
		_tmp5 = NULL;
		determined_add = (_tmp5 = gtkaml_method_matcher_determine_matching_method (method_matcher), (determined_add == NULL) ? NULL : (determined_add = (vala_code_node_unref (determined_add), NULL)), _tmp5);
		if (determined_add == NULL) {
			(adds == NULL) ? NULL : (adds = (gee_collection_object_unref (adds), NULL));
			(determined_add == NULL) ? NULL : (determined_add = (vala_code_node_unref (determined_add), NULL));
			(new_method == NULL) ? NULL : (new_method = (g_object_unref (new_method), NULL));
			(to_remove == NULL) ? NULL : (to_remove = (gee_collection_object_unref (to_remove), NULL));
			(first_parameter == NULL) ? NULL : (first_parameter = (g_object_unref (first_parameter), NULL));
			(method_matcher == NULL) ? NULL : (method_matcher = (g_object_unref (method_matcher), NULL));
			return;
		}
	} else {
		ValaMethod* _tmp6;
		gboolean _tmp7;
		gtkaml_method_matcher_add_method (method_matcher, determined_add);
		_tmp6 = NULL;
		if ((_tmp7 = NULL == (_tmp6 = gtkaml_method_matcher_determine_matching_method (method_matcher)), (_tmp6 == NULL) ? NULL : (_tmp6 = (vala_code_node_unref (_tmp6), NULL)), _tmp7)) {
			(adds == NULL) ? NULL : (adds = (gee_collection_object_unref (adds), NULL));
			(determined_add == NULL) ? NULL : (determined_add = (vala_code_node_unref (determined_add), NULL));
			(new_method == NULL) ? NULL : (new_method = (g_object_unref (new_method), NULL));
			(to_remove == NULL) ? NULL : (to_remove = (gee_collection_object_unref (to_remove), NULL));
			(first_parameter == NULL) ? NULL : (first_parameter = (g_object_unref (first_parameter), NULL));
			(method_matcher == NULL) ? NULL : (method_matcher = (g_object_unref (method_matcher), NULL));
			return;
		}
	}
	gtkaml_method_matcher_set_method_parameters (method_matcher, (GtkamlMethod*) new_method, determined_add);
	{
		GeeIterator* _attr_it;
		_attr_it = gee_iterable_iterator ((GeeIterable*) to_remove);
		while (gee_iterator_next (_attr_it)) {
			GtkamlAttribute* attr;
			attr = (GtkamlAttribute*) gee_iterator_get (_attr_it);
			gee_collection_remove ((GeeCollection*) gtkaml_class_definition_get_attrs (child_definition), attr);
			(attr == NULL) ? NULL : (attr = (g_object_unref (attr), NULL));
		}
		(_attr_it == NULL) ? NULL : (_attr_it = (gee_collection_object_unref (_attr_it), NULL));
	}
	gtkaml_class_definition_set_add_method (child_definition, new_method);
	(adds == NULL) ? NULL : (adds = (gee_collection_object_unref (adds), NULL));
	(determined_add == NULL) ? NULL : (determined_add = (vala_code_node_unref (determined_add), NULL));
	(new_method == NULL) ? NULL : (new_method = (g_object_unref (new_method), NULL));
	(to_remove == NULL) ? NULL : (to_remove = (gee_collection_object_unref (to_remove), NULL));
	(first_parameter == NULL) ? NULL : (first_parameter = (g_object_unref (first_parameter), NULL));
	(method_matcher == NULL) ? NULL : (method_matcher = (g_object_unref (method_matcher), NULL));
}


static void gtkaml_implicits_resolver_determine_construct_method (GtkamlImplicitsResolver* self, GtkamlClassDefinition* class_definition) {
	GeeList* constructors;
	ValaMethod* determined_constructor;
	GtkamlConstructMethod* new_method;
	GeeList* to_remove;
	GtkamlMethodMatcher* method_matcher;
	g_return_if_fail (self != NULL);
	g_return_if_fail (class_definition != NULL);
	constructors = gtkaml_implicits_resolver_lookup_constructors (self, gtkaml_class_definition_get_base_type (class_definition));
	determined_constructor = NULL;
	new_method = gtkaml_construct_method_new ();
	to_remove = (GeeList*) gee_array_list_new (GTKAML_TYPE_ATTRIBUTE, (GBoxedCopyFunc) g_object_ref, g_object_unref, g_direct_equal);
	/*pass one: see if we find an explicitly specified constructor*/
	{
		GeeIterator* _constructor_it;
		/*pass one: see if we find an explicitly specified constructor*/
		_constructor_it = gee_iterable_iterator ((GeeIterable*) constructors);
		/*pass one: see if we find an explicitly specified constructor*/
		while (gee_iterator_next (_constructor_it)) {
			ValaMethod* constructor;
			/*pass one: see if we find an explicitly specified constructor*/
			constructor = (ValaMethod*) gee_iterator_get (_constructor_it);
			{
				GeeIterator* _attr_it;
				_attr_it = gee_iterable_iterator ((GeeIterable*) gtkaml_class_definition_get_attrs (class_definition));
				while (gee_iterator_next (_attr_it)) {
					GtkamlAttribute* attr;
					gboolean _tmp0;
					gboolean _tmp1;
					attr = (GtkamlAttribute*) gee_iterator_get (_attr_it);
					_tmp0 = FALSE;
					_tmp1 = FALSE;
					if (GTKAML_IS_SIMPLE_ATTRIBUTE (attr)) {
						_tmp1 = _vala_strcmp0 (gtkaml_attribute_get_name (attr), vala_symbol_get_name ((ValaSymbol*) constructor)) == 0;
					} else {
						_tmp1 = FALSE;
					}
					if (_tmp1) {
						GtkamlAttribute* _tmp2;
						_tmp2 = NULL;
						_tmp0 = _vala_strcmp0 (gtkaml_simple_attribute_get_value ((_tmp2 = attr, GTKAML_IS_SIMPLE_ATTRIBUTE (_tmp2) ? ((GtkamlSimpleAttribute*) _tmp2) : NULL)), "true") == 0;
					} else {
						_tmp0 = FALSE;
					}
					if (_tmp0) {
						ValaMethod* _tmp4;
						ValaMethod* _tmp3;
						_tmp4 = NULL;
						_tmp3 = NULL;
						determined_constructor = (_tmp4 = (_tmp3 = constructor, (_tmp3 == NULL) ? NULL : vala_code_node_ref (_tmp3)), (determined_constructor == NULL) ? NULL : (determined_constructor = (vala_code_node_unref (determined_constructor), NULL)), _tmp4);
						gee_collection_add ((GeeCollection*) to_remove, attr);
						(attr == NULL) ? NULL : (attr = (g_object_unref (attr), NULL));
						break;
					}
					(attr == NULL) ? NULL : (attr = (g_object_unref (attr), NULL));
				}
				(_attr_it == NULL) ? NULL : (_attr_it = (gee_collection_object_unref (_attr_it), NULL));
			}
			(constructor == NULL) ? NULL : (constructor = (vala_code_node_unref (constructor), NULL));
		}
		(_constructor_it == NULL) ? NULL : (_constructor_it = (gee_collection_object_unref (_constructor_it), NULL));
	}
	method_matcher = gtkaml_method_matcher_new (self->priv->_implicits_store, class_definition, "constructor", NULL);
	/*pass two: the first who matches the most parameters + warning if there are more*/
	if (determined_constructor == NULL) {
		ValaMethod* _tmp5;
		{
			GeeIterator* _method_it;
			_method_it = gee_iterable_iterator ((GeeIterable*) constructors);
			while (gee_iterator_next (_method_it)) {
				ValaMethod* method;
				method = (ValaMethod*) gee_iterator_get (_method_it);
				gtkaml_method_matcher_add_method (method_matcher, method);
				(method == NULL) ? NULL : (method = (vala_code_node_unref (method), NULL));
			}
			(_method_it == NULL) ? NULL : (_method_it = (gee_collection_object_unref (_method_it), NULL));
		}
		_tmp5 = NULL;
		determined_constructor = (_tmp5 = gtkaml_method_matcher_determine_matching_method (method_matcher), (determined_constructor == NULL) ? NULL : (determined_constructor = (vala_code_node_unref (determined_constructor), NULL)), _tmp5);
		if (determined_constructor == NULL) {
			(constructors == NULL) ? NULL : (constructors = (gee_collection_object_unref (constructors), NULL));
			(determined_constructor == NULL) ? NULL : (determined_constructor = (vala_code_node_unref (determined_constructor), NULL));
			(new_method == NULL) ? NULL : (new_method = (g_object_unref (new_method), NULL));
			(to_remove == NULL) ? NULL : (to_remove = (gee_collection_object_unref (to_remove), NULL));
			(method_matcher == NULL) ? NULL : (method_matcher = (g_object_unref (method_matcher), NULL));
			return;
		}
	} else {
		ValaMethod* _tmp6;
		gboolean _tmp7;
		gtkaml_method_matcher_add_method (method_matcher, determined_constructor);
		_tmp6 = NULL;
		if ((_tmp7 = NULL == (_tmp6 = gtkaml_method_matcher_determine_matching_method (method_matcher)), (_tmp6 == NULL) ? NULL : (_tmp6 = (vala_code_node_unref (_tmp6), NULL)), _tmp7)) {
			(constructors == NULL) ? NULL : (constructors = (gee_collection_object_unref (constructors), NULL));
			(determined_constructor == NULL) ? NULL : (determined_constructor = (vala_code_node_unref (determined_constructor), NULL));
			(new_method == NULL) ? NULL : (new_method = (g_object_unref (new_method), NULL));
			(to_remove == NULL) ? NULL : (to_remove = (gee_collection_object_unref (to_remove), NULL));
			(method_matcher == NULL) ? NULL : (method_matcher = (g_object_unref (method_matcher), NULL));
			return;
		}
	}
	gtkaml_method_matcher_set_method_parameters (method_matcher, (GtkamlMethod*) new_method, determined_constructor);
	{
		GeeIterator* _attr_it;
		_attr_it = gee_iterable_iterator ((GeeIterable*) to_remove);
		while (gee_iterator_next (_attr_it)) {
			GtkamlAttribute* attr;
			attr = (GtkamlAttribute*) gee_iterator_get (_attr_it);
			gee_collection_remove ((GeeCollection*) gtkaml_class_definition_get_attrs (class_definition), attr);
			(attr == NULL) ? NULL : (attr = (g_object_unref (attr), NULL));
		}
		(_attr_it == NULL) ? NULL : (_attr_it = (gee_collection_object_unref (_attr_it), NULL));
	}
	gtkaml_class_definition_set_construct_method (class_definition, new_method);
	(constructors == NULL) ? NULL : (constructors = (gee_collection_object_unref (constructors), NULL));
	(determined_constructor == NULL) ? NULL : (determined_constructor = (vala_code_node_unref (determined_constructor), NULL));
	(new_method == NULL) ? NULL : (new_method = (g_object_unref (new_method), NULL));
	(to_remove == NULL) ? NULL : (to_remove = (gee_collection_object_unref (to_remove), NULL));
	(method_matcher == NULL) ? NULL : (method_matcher = (g_object_unref (method_matcher), NULL));
}


static void gtkaml_implicits_resolver_lookup_container_add_methods_for_class (GtkamlImplicitsResolver* self, const char* ns, ValaClass* container_class_implicits_entry, const char* ns2, ValaObjectTypeSymbol* container_class_holding_methods, GeeList* methods) {
	GeeList* base_types;
	GeeList* add_methods;
	g_return_if_fail (self != NULL);
	g_return_if_fail (ns != NULL);
	g_return_if_fail (container_class_implicits_entry != NULL);
	g_return_if_fail (methods != NULL);
	if (ns2 == NULL) {
		return;
	}
	base_types = NULL;
	if (VALA_IS_CLASS (container_class_holding_methods)) {
		GeeList* _tmp1;
		ValaObjectTypeSymbol* _tmp0;
		_tmp1 = NULL;
		_tmp0 = NULL;
		base_types = (_tmp1 = vala_class_get_base_types ((_tmp0 = container_class_holding_methods, VALA_IS_CLASS (_tmp0) ? ((ValaClass*) _tmp0) : NULL)), (base_types == NULL) ? NULL : (base_types = (gee_collection_object_unref (base_types), NULL)), _tmp1);
	} else {
		if (VALA_IS_INTERFACE (container_class_holding_methods)) {
			GeeList* _tmp3;
			ValaObjectTypeSymbol* _tmp2;
			_tmp3 = NULL;
			_tmp2 = NULL;
			base_types = (_tmp3 = vala_interface_get_prerequisites ((_tmp2 = container_class_holding_methods, VALA_IS_INTERFACE (_tmp2) ? ((ValaInterface*) _tmp2) : NULL)), (base_types == NULL) ? NULL : (base_types = (gee_collection_object_unref (base_types), NULL)), _tmp3);
		} else {
			GeeList* _tmp4;
			_tmp4 = NULL;
			base_types = (_tmp4 = (GeeList*) gee_read_only_list_new (VALA_TYPE_DATA_TYPE, (GBoxedCopyFunc) vala_code_node_ref, vala_code_node_unref, NULL), (base_types == NULL) ? NULL : (base_types = (gee_collection_object_unref (base_types), NULL)), _tmp4);
		}
	}
	/*recurse over base classes - ugly ugly ugly!*/
	{
		GeeIterator* _dt_it;
		/*recurse over base classes - ugly ugly ugly!*/
		_dt_it = gee_iterable_iterator ((GeeIterable*) base_types);
		/*recurse over base classes - ugly ugly ugly!*/
		while (gee_iterator_next (_dt_it)) {
			ValaDataType* dt;
			/*recurse over base classes - ugly ugly ugly!*/
			dt = (ValaDataType*) gee_iterator_get (_dt_it);
			if (VALA_IS_UNRESOLVED_TYPE (dt)) {
				ValaDataType* _tmp5;
				char* utns;
				ValaDataType* _tmp6;
				ValaObjectTypeSymbol* c;
				_tmp5 = NULL;
				utns = gtkaml_implicits_resolver_get_unresolved_type_ns (self, (_tmp5 = dt, VALA_IS_UNRESOLVED_TYPE (_tmp5) ? ((ValaUnresolvedType*) _tmp5) : NULL));
				if (utns == NULL) {
					utns = (g_free (utns), NULL);
					(dt == NULL) ? NULL : (dt = (vala_code_node_unref (dt), NULL));
					continue;
				}
				_tmp6 = NULL;
				c = gtkaml_implicits_resolver_lookup_class (self, utns, vala_symbol_get_name ((ValaSymbol*) vala_unresolved_type_get_unresolved_symbol ((_tmp6 = dt, VALA_IS_UNRESOLVED_TYPE (_tmp6) ? ((ValaUnresolvedType*) _tmp6) : NULL))));
				if (c != NULL) {
					gtkaml_implicits_resolver_lookup_container_add_methods_for_class (self, ns, container_class_implicits_entry, utns, c, methods);
				}
				utns = (g_free (utns), NULL);
				(c == NULL) ? NULL : (c = (vala_code_node_unref (c), NULL));
			}
			(dt == NULL) ? NULL : (dt = (vala_code_node_unref (dt), NULL));
		}
		(_dt_it == NULL) ? NULL : (_dt_it = (gee_collection_object_unref (_dt_it), NULL));
	}
	add_methods = gtkaml_implicits_store_get_adds (self->priv->_implicits_store, ns, vala_symbol_get_name ((ValaSymbol*) container_class_implicits_entry));
	if (gee_collection_get_size ((GeeCollection*) add_methods) != 0) {
		{
			GeeIterator* _add_method_it;
			_add_method_it = gee_iterable_iterator ((GeeIterable*) add_methods);
			while (gee_iterator_next (_add_method_it)) {
				char* add_method;
				add_method = (char*) gee_iterator_get (_add_method_it);
				{
					GeeList* _tmp7;
					GeeIterator* _tmp8;
					GeeIterator* _method_it;
					_tmp7 = NULL;
					_tmp8 = NULL;
					_method_it = (_tmp8 = gee_iterable_iterator ((GeeIterable*) (_tmp7 = vala_object_type_symbol_get_methods (container_class_holding_methods))), (_tmp7 == NULL) ? NULL : (_tmp7 = (gee_collection_object_unref (_tmp7), NULL)), _tmp8);
					while (gee_iterator_next (_method_it)) {
						ValaMethod* method;
						method = (ValaMethod*) gee_iterator_get (_method_it);
						if (_vala_strcmp0 (vala_symbol_get_name ((ValaSymbol*) method), add_method) == 0) {
							gee_collection_add ((GeeCollection*) methods, method);
							/*stderr.printf ("Found direct add method '%s.%s' for %s, we now have %d\n", container_class_holding_methods.name, method.name, container_class_implicits_entry.name, methods.size);*/
							(method == NULL) ? NULL : (method = (vala_code_node_unref (method), NULL));
							break;
						}
						(method == NULL) ? NULL : (method = (vala_code_node_unref (method), NULL));
					}
					(_method_it == NULL) ? NULL : (_method_it = (gee_collection_object_unref (_method_it), NULL));
				}
				add_method = (g_free (add_method), NULL);
			}
			(_add_method_it == NULL) ? NULL : (_add_method_it = (gee_collection_object_unref (_add_method_it), NULL));
		}
	}
	(base_types == NULL) ? NULL : (base_types = (gee_collection_object_unref (base_types), NULL));
	(add_methods == NULL) ? NULL : (add_methods = (gee_collection_object_unref (add_methods), NULL));
}


void gtkaml_implicits_resolver_lookup_container_add_methods (GtkamlImplicitsResolver* self, const char* ns, ValaClass* container_class, GeeList* methods) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (methods != NULL);
	/*FIXME workaround to stop recursion at TypeInstance and Object*/
	if (NULL == ns) {
		return;
	}
	/*first recurse over class hierarchy*/
	gtkaml_implicits_resolver_lookup_container_add_methods_for_class (self, ns, container_class, ns, (ValaObjectTypeSymbol*) container_class, methods);
	/*then recurse over implicits definitions*/
	{
		GeeList* _tmp0;
		GeeIterator* _tmp1;
		GeeIterator* _dt_it;
		/*then recurse over implicits definitions*/
		_tmp0 = NULL;
		_tmp1 = NULL;
		_dt_it = (_tmp1 = gee_iterable_iterator ((GeeIterable*) (_tmp0 = vala_class_get_base_types (container_class))), (_tmp0 == NULL) ? NULL : (_tmp0 = (gee_collection_object_unref (_tmp0), NULL)), _tmp1);
		/*then recurse over implicits definitions*/
		while (gee_iterator_next (_dt_it)) {
			ValaDataType* dt;
			/*then recurse over implicits definitions*/
			dt = (ValaDataType*) gee_iterator_get (_dt_it);
			if (VALA_IS_UNRESOLVED_TYPE (dt)) {
				ValaDataType* _tmp2;
				char* utns;
				ValaDataType* _tmp3;
				ValaObjectTypeSymbol* _tmp4;
				ValaClass* c;
				_tmp2 = NULL;
				utns = gtkaml_implicits_resolver_get_unresolved_type_ns (self, (_tmp2 = dt, VALA_IS_UNRESOLVED_TYPE (_tmp2) ? ((ValaUnresolvedType*) _tmp2) : NULL));
				if (utns == NULL) {
					utns = (g_free (utns), NULL);
					(dt == NULL) ? NULL : (dt = (vala_code_node_unref (dt), NULL));
					continue;
				}
				_tmp3 = NULL;
				_tmp4 = NULL;
				c = (_tmp4 = gtkaml_implicits_resolver_lookup_class (self, utns, vala_symbol_get_name ((ValaSymbol*) vala_unresolved_type_get_unresolved_symbol ((_tmp3 = dt, VALA_IS_UNRESOLVED_TYPE (_tmp3) ? ((ValaUnresolvedType*) _tmp3) : NULL)))), VALA_IS_CLASS (_tmp4) ? ((ValaClass*) _tmp4) : NULL);
				if (c != NULL) {
					/*over inherited implicits definitions*/
					gtkaml_implicits_resolver_lookup_container_add_methods (self, utns, c, methods);
					utns = (g_free (utns), NULL);
					(c == NULL) ? NULL : (c = (vala_code_node_unref (c), NULL));
					(dt == NULL) ? NULL : (dt = (vala_code_node_unref (dt), NULL));
					break;
				}
				utns = (g_free (utns), NULL);
				(c == NULL) ? NULL : (c = (vala_code_node_unref (c), NULL));
			}
			(dt == NULL) ? NULL : (dt = (vala_code_node_unref (dt), NULL));
		}
		(_dt_it == NULL) ? NULL : (_dt_it = (gee_collection_object_unref (_dt_it), NULL));
	}
}


static char* gtkaml_implicits_resolver_get_unresolved_type_ns (GtkamlImplicitsResolver* self, ValaUnresolvedType* dt) {
	const char* _tmp1;
	g_return_val_if_fail (self != NULL, NULL);
	if (vala_unresolved_symbol_get_inner (vala_unresolved_type_get_unresolved_symbol (dt)) == NULL) {
		return NULL;
	}
	_tmp1 = NULL;
	return (_tmp1 = vala_symbol_get_name ((ValaSymbol*) vala_unresolved_symbol_get_inner (vala_unresolved_type_get_unresolved_symbol (dt))), (_tmp1 == NULL) ? NULL : g_strdup (_tmp1));
}


static void gtkaml_implicits_resolver_determine_attribute_types (GtkamlImplicitsResolver* self, GtkamlClassDefinition* class_definition) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (class_definition != NULL);
	{
		GeeIterator* _attr_it;
		_attr_it = gee_iterable_iterator ((GeeIterable*) gtkaml_class_definition_get_attrs (class_definition));
		while (gee_iterator_next (_attr_it)) {
			GtkamlAttribute* attr;
			ValaMember* _tmp0;
			attr = (GtkamlAttribute*) gee_iterator_get (_attr_it);
			_tmp0 = NULL;
			gtkaml_attribute_set_target_type (attr, (ValaSymbol*) (_tmp0 = gtkaml_implicits_resolver_member_lookup_inherited (self, gtkaml_class_definition_get_base_type (class_definition), gtkaml_attribute_get_name (attr))));
			(_tmp0 == NULL) ? NULL : (_tmp0 = (vala_code_node_unref (_tmp0), NULL));
			if (gtkaml_attribute_get_target_type (attr) == NULL) {
				char* _tmp2;
				char* _tmp1;
				_tmp2 = NULL;
				_tmp1 = NULL;
				vala_report_error (gtkaml_class_definition_get_source_reference (class_definition), _tmp2 = g_strdup_printf ("Cannot find member %s of class %s\n", gtkaml_attribute_get_name (attr), _tmp1 = gtkaml_class_definition_get_base_full_name (class_definition)));
				_tmp2 = (g_free (_tmp2), NULL);
				_tmp1 = (g_free (_tmp1), NULL);
			}
			(attr == NULL) ? NULL : (attr = (g_object_unref (attr), NULL));
		}
		(_attr_it == NULL) ? NULL : (_attr_it = (gee_collection_object_unref (_attr_it), NULL));
	}
}


static ValaMember* gtkaml_implicits_resolver_member_lookup_inherited (GtkamlImplicitsResolver* self, ValaClass* clazz, const char* member) {
	ValaSymbol* _tmp0;
	ValaMember* result;
	ValaMember* _tmp16;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (clazz != NULL, NULL);
	g_return_val_if_fail (member != NULL, NULL);
	_tmp0 = NULL;
	result = (_tmp0 = vala_scope_lookup (vala_symbol_get_scope ((ValaSymbol*) clazz), member), VALA_IS_MEMBER (_tmp0) ? ((ValaMember*) _tmp0) : NULL);
	if (result != NULL) {
		return result;
	}
	{
		GeeList* _tmp2;
		GeeIterator* _tmp3;
		GeeIterator* _dt_it;
		_tmp2 = NULL;
		_tmp3 = NULL;
		_dt_it = (_tmp3 = gee_iterable_iterator ((GeeIterable*) (_tmp2 = vala_class_get_base_types (clazz))), (_tmp2 == NULL) ? NULL : (_tmp2 = (gee_collection_object_unref (_tmp2), NULL)), _tmp3);
		while (gee_iterator_next (_dt_it)) {
			ValaDataType* dt;
			dt = (ValaDataType*) gee_iterator_get (_dt_it);
			if (VALA_IS_UNRESOLVED_TYPE (dt)) {
				const char* _tmp5;
				ValaDataType* _tmp4;
				char* name;
				char* ns;
				ValaDataType* _tmp6;
				ValaObjectTypeSymbol* _tmp11;
				ValaClass* otherclazz;
				gboolean _tmp12;
				_tmp5 = NULL;
				_tmp4 = NULL;
				name = (_tmp5 = vala_symbol_get_name ((ValaSymbol*) vala_unresolved_type_get_unresolved_symbol ((_tmp4 = dt, VALA_IS_UNRESOLVED_TYPE (_tmp4) ? ((ValaUnresolvedType*) _tmp4) : NULL))), (_tmp5 == NULL) ? NULL : g_strdup (_tmp5));
				ns = NULL;
				_tmp6 = NULL;
				if (vala_unresolved_symbol_get_inner (vala_unresolved_type_get_unresolved_symbol ((_tmp6 = dt, VALA_IS_UNRESOLVED_TYPE (_tmp6) ? ((ValaUnresolvedType*) _tmp6) : NULL))) != NULL) {
					char* _tmp9;
					const char* _tmp8;
					ValaDataType* _tmp7;
					_tmp9 = NULL;
					_tmp8 = NULL;
					_tmp7 = NULL;
					ns = (_tmp9 = (_tmp8 = vala_symbol_get_name ((ValaSymbol*) vala_unresolved_symbol_get_inner (vala_unresolved_type_get_unresolved_symbol ((_tmp7 = dt, VALA_IS_UNRESOLVED_TYPE (_tmp7) ? ((ValaUnresolvedType*) _tmp7) : NULL)))), (_tmp8 == NULL) ? NULL : g_strdup (_tmp8)), ns = (g_free (ns), NULL), _tmp9);
				} else {
					char* _tmp10;
					_tmp10 = NULL;
					ns = (_tmp10 = NULL, ns = (g_free (ns), NULL), _tmp10);
				}
				_tmp11 = NULL;
				otherclazz = (_tmp11 = gtkaml_implicits_resolver_lookup_class (self, ns, name), VALA_IS_CLASS (_tmp11) ? ((ValaClass*) _tmp11) : NULL);
				_tmp12 = FALSE;
				if (otherclazz != NULL) {
					ValaMember* _tmp14;
					ValaMember* _tmp13;
					_tmp14 = NULL;
					_tmp13 = NULL;
					_tmp12 = NULL != (result = (_tmp14 = (_tmp13 = gtkaml_implicits_resolver_member_lookup_inherited (self, otherclazz, member), VALA_IS_MEMBER (_tmp13) ? ((ValaMember*) _tmp13) : NULL), (result == NULL) ? NULL : (result = (vala_code_node_unref (result), NULL)), _tmp14));
				} else {
					_tmp12 = FALSE;
				}
				if (_tmp12) {
					ValaMember* _tmp15;
					_tmp15 = NULL;
					return (_tmp15 = result, name = (g_free (name), NULL), ns = (g_free (ns), NULL), (otherclazz == NULL) ? NULL : (otherclazz = (vala_code_node_unref (otherclazz), NULL)), (dt == NULL) ? NULL : (dt = (vala_code_node_unref (dt), NULL)), (_dt_it == NULL) ? NULL : (_dt_it = (gee_collection_object_unref (_dt_it), NULL)), _tmp15);
				}
				name = (g_free (name), NULL);
				ns = (g_free (ns), NULL);
				(otherclazz == NULL) ? NULL : (otherclazz = (vala_code_node_unref (otherclazz), NULL));
			}
			(dt == NULL) ? NULL : (dt = (vala_code_node_unref (dt), NULL));
		}
		(_dt_it == NULL) ? NULL : (_dt_it = (gee_collection_object_unref (_dt_it), NULL));
	}
	_tmp16 = NULL;
	return (_tmp16 = NULL, (result == NULL) ? NULL : (result = (vala_code_node_unref (result), NULL)), _tmp16);
}


static ValaObjectTypeSymbol* gtkaml_implicits_resolver_lookup_class (GtkamlImplicitsResolver* self, const char* xmlNamespace, const char* name) {
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (xmlNamespace != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	{
		GeeList* _tmp0;
		GeeIterator* _tmp1;
		GeeIterator* _ns_it;
		_tmp0 = NULL;
		_tmp1 = NULL;
		_ns_it = (_tmp1 = gee_iterable_iterator ((GeeIterable*) (_tmp0 = vala_namespace_get_namespaces (vala_code_context_get_root (self->priv->_context)))), (_tmp0 == NULL) ? NULL : (_tmp0 = (gee_collection_object_unref (_tmp0), NULL)), _tmp1);
		while (gee_iterator_next (_ns_it)) {
			ValaNamespace* ns;
			gboolean _tmp2;
			gboolean _tmp3;
			ns = (ValaNamespace*) gee_iterator_get (_ns_it);
			_tmp2 = FALSE;
			_tmp3 = FALSE;
			if (vala_symbol_get_name ((ValaSymbol*) ns) == NULL) {
				_tmp3 = xmlNamespace == NULL;
			} else {
				_tmp3 = FALSE;
			}
			if (_tmp3) {
				_tmp2 = TRUE;
			} else {
				_tmp2 = _vala_strcmp0 (vala_symbol_get_name ((ValaSymbol*) ns), xmlNamespace) == 0;
			}
			if (_tmp2) {
				ValaSymbol* s;
				s = vala_scope_lookup (vala_symbol_get_scope ((ValaSymbol*) ns), name);
				if (VALA_IS_OBJECT_TYPE_SYMBOL (s)) {
					ValaObjectTypeSymbol* _tmp5;
					ValaSymbol* _tmp4;
					ValaObjectTypeSymbol* _tmp6;
					_tmp5 = NULL;
					_tmp4 = NULL;
					_tmp6 = NULL;
					return (_tmp6 = (_tmp5 = (_tmp4 = s, VALA_IS_OBJECT_TYPE_SYMBOL (_tmp4) ? ((ValaObjectTypeSymbol*) _tmp4) : NULL), (_tmp5 == NULL) ? NULL : vala_code_node_ref (_tmp5)), (s == NULL) ? NULL : (s = (vala_code_node_unref (s), NULL)), (ns == NULL) ? NULL : (ns = (vala_code_node_unref (ns), NULL)), (_ns_it == NULL) ? NULL : (_ns_it = (gee_collection_object_unref (_ns_it), NULL)), _tmp6);
				}
				(s == NULL) ? NULL : (s = (vala_code_node_unref (s), NULL));
			}
			(ns == NULL) ? NULL : (ns = (vala_code_node_unref (ns), NULL));
		}
		(_ns_it == NULL) ? NULL : (_ns_it = (gee_collection_object_unref (_ns_it), NULL));
	}
	return NULL;
}


static GeeList* gtkaml_implicits_resolver_lookup_constructors (GtkamlImplicitsResolver* self, ValaClass* clazz) {
	GeeArrayList* constructors;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (clazz != NULL, NULL);
	constructors = gee_array_list_new (VALA_TYPE_METHOD, (GBoxedCopyFunc) vala_code_node_ref, vala_code_node_unref, g_direct_equal);
	{
		GeeList* _tmp0;
		GeeIterator* _tmp1;
		GeeIterator* _m_it;
		_tmp0 = NULL;
		_tmp1 = NULL;
		_m_it = (_tmp1 = gee_iterable_iterator ((GeeIterable*) (_tmp0 = vala_object_type_symbol_get_methods ((ValaObjectTypeSymbol*) clazz))), (_tmp0 == NULL) ? NULL : (_tmp0 = (gee_collection_object_unref (_tmp0), NULL)), _tmp1);
		while (gee_iterator_next (_m_it)) {
			ValaMethod* m;
			m = (ValaMethod*) gee_iterator_get (_m_it);
			if (VALA_IS_CREATION_METHOD (m)) {
				gee_collection_add ((GeeCollection*) constructors, m);
			}
			(m == NULL) ? NULL : (m = (vala_code_node_unref (m), NULL));
		}
		(_m_it == NULL) ? NULL : (_m_it = (gee_collection_object_unref (_m_it), NULL));
	}
	return (GeeList*) constructors;
}


GtkamlImplicitsStore* gtkaml_implicits_resolver_get_implicits_store (GtkamlImplicitsResolver* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return self->priv->_implicits_store;
}


static void gtkaml_implicits_resolver_set_implicits_store (GtkamlImplicitsResolver* self, GtkamlImplicitsStore* value) {
	GtkamlImplicitsStore* _tmp2;
	GtkamlImplicitsStore* _tmp1;
	g_return_if_fail (self != NULL);
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->_implicits_store = (_tmp2 = (_tmp1 = value, (_tmp1 == NULL) ? NULL : g_object_ref (_tmp1)), (self->priv->_implicits_store == NULL) ? NULL : (self->priv->_implicits_store = (g_object_unref (self->priv->_implicits_store), NULL)), _tmp2);
	g_object_notify ((GObject *) self, "implicits-store");
}


ValaCodeContext* gtkaml_implicits_resolver_get_context (GtkamlImplicitsResolver* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return self->priv->_context;
}


static void gtkaml_implicits_resolver_set_context (GtkamlImplicitsResolver* self, ValaCodeContext* value) {
	ValaCodeContext* _tmp2;
	ValaCodeContext* _tmp1;
	g_return_if_fail (self != NULL);
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->_context = (_tmp2 = (_tmp1 = value, (_tmp1 == NULL) ? NULL : vala_code_context_ref (_tmp1)), (self->priv->_context == NULL) ? NULL : (self->priv->_context = (vala_code_context_unref (self->priv->_context), NULL)), _tmp2);
	g_object_notify ((GObject *) self, "context");
}


static void gtkaml_implicits_resolver_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	GtkamlImplicitsResolver * self;
	gpointer boxed;
	self = GTKAML_IMPLICITS_RESOLVER (object);
	switch (property_id) {
		case GTKAML_IMPLICITS_RESOLVER_IMPLICITS_STORE:
		g_value_set_object (value, gtkaml_implicits_resolver_get_implicits_store (self));
		break;
		case GTKAML_IMPLICITS_RESOLVER_CONTEXT:
		vala_value_set_code_context (value, gtkaml_implicits_resolver_get_context (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void gtkaml_implicits_resolver_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	GtkamlImplicitsResolver * self;
	self = GTKAML_IMPLICITS_RESOLVER (object);
	switch (property_id) {
		case GTKAML_IMPLICITS_RESOLVER_IMPLICITS_STORE:
		gtkaml_implicits_resolver_set_implicits_store (self, g_value_get_object (value));
		break;
		case GTKAML_IMPLICITS_RESOLVER_CONTEXT:
		gtkaml_implicits_resolver_set_context (self, vala_value_get_code_context (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void gtkaml_implicits_resolver_class_init (GtkamlImplicitsResolverClass * klass) {
	gtkaml_implicits_resolver_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (GtkamlImplicitsResolverPrivate));
	G_OBJECT_CLASS (klass)->get_property = gtkaml_implicits_resolver_get_property;
	G_OBJECT_CLASS (klass)->set_property = gtkaml_implicits_resolver_set_property;
	G_OBJECT_CLASS (klass)->finalize = gtkaml_implicits_resolver_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GTKAML_IMPLICITS_RESOLVER_IMPLICITS_STORE, g_param_spec_object ("implicits-store", "implicits-store", "implicits-store", GTKAML_TYPE_IMPLICITS_STORE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GTKAML_IMPLICITS_RESOLVER_CONTEXT, vala_param_spec_code_context ("context", "context", "context", VALA_TYPE_CODE_CONTEXT, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void gtkaml_implicits_resolver_instance_init (GtkamlImplicitsResolver * self) {
	self->priv = GTKAML_IMPLICITS_RESOLVER_GET_PRIVATE (self);
}


static void gtkaml_implicits_resolver_finalize (GObject* obj) {
	GtkamlImplicitsResolver * self;
	self = GTKAML_IMPLICITS_RESOLVER (obj);
	(self->priv->_implicits_store == NULL) ? NULL : (self->priv->_implicits_store = (g_object_unref (self->priv->_implicits_store), NULL));
	(self->priv->_context == NULL) ? NULL : (self->priv->_context = (vala_code_context_unref (self->priv->_context), NULL));
	G_OBJECT_CLASS (gtkaml_implicits_resolver_parent_class)->finalize (obj);
}


GType gtkaml_implicits_resolver_get_type (void) {
	static GType gtkaml_implicits_resolver_type_id = 0;
	if (gtkaml_implicits_resolver_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (GtkamlImplicitsResolverClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gtkaml_implicits_resolver_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GtkamlImplicitsResolver), 0, (GInstanceInitFunc) gtkaml_implicits_resolver_instance_init, NULL };
		gtkaml_implicits_resolver_type_id = g_type_register_static (G_TYPE_OBJECT, "GtkamlImplicitsResolver", &g_define_type_info, 0);
	}
	return gtkaml_implicits_resolver_type_id;
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}




