/* GtkamlRootClassDefinition.vala
 * 
 * Copyright (C) 2008 Vlad Grecescu
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with main.c; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor Boston, MA 02110-1301,  USA
 *
 * Author:
 *        Vlad Grecescu (b100dian@gmail.com)
 */

#include "GtkamlRootClassDefinition.h"
#include <gee/arraylist.h>
#include "GtkamlAttribute.h"




struct _GtkamlRootClassDefinitionPrivate {
	GeeMap* _prefixes_namespaces;
	char* _target_name;
	char* _target_namespace;
	GeeList* _code;
	gint _original_first_code_line;
	char* _implements;
};

#define GTKAML_ROOT_CLASS_DEFINITION_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GTKAML_TYPE_ROOT_CLASS_DEFINITION, GtkamlRootClassDefinitionPrivate))
enum  {
	GTKAML_ROOT_CLASS_DEFINITION_DUMMY_PROPERTY,
	GTKAML_ROOT_CLASS_DEFINITION_PREFIXES_NAMESPACES,
	GTKAML_ROOT_CLASS_DEFINITION_TARGET_NAME,
	GTKAML_ROOT_CLASS_DEFINITION_TARGET_NAMESPACE,
	GTKAML_ROOT_CLASS_DEFINITION_CODE,
	GTKAML_ROOT_CLASS_DEFINITION_ORIGINAL_FIRST_CODE_LINE,
	GTKAML_ROOT_CLASS_DEFINITION_IMPLEMENTS
};
static gpointer gtkaml_root_class_definition_parent_class = NULL;
static void gtkaml_root_class_definition_finalize (GObject* obj);



GtkamlRootClassDefinition* gtkaml_root_class_definition_construct (GType object_type, ValaSourceReference* source_reference, const char* identifier, const char* base_ns, ValaClass* base_type, DefinitionScope definition_scope, GtkamlClassDefinition* parent_container) {
	GtkamlRootClassDefinition * self;
	GeeArrayList* _tmp0;
	GeeArrayList* _tmp1;
	GeeArrayList* _tmp2;
	g_return_val_if_fail (source_reference != NULL, NULL);
	g_return_val_if_fail (identifier != NULL, NULL);
	g_return_val_if_fail (base_ns != NULL, NULL);
	g_return_val_if_fail (base_type != NULL, NULL);
	self = g_object_newv (object_type, 0, NULL);
	gtkaml_class_definition_set_source_reference ((GtkamlClassDefinition*) self, source_reference);
	gtkaml_class_definition_set_base_ns ((GtkamlClassDefinition*) self, base_ns);
	gtkaml_class_definition_set_identifier ((GtkamlClassDefinition*) self, identifier);
	gtkaml_class_definition_set_base_type ((GtkamlClassDefinition*) self, base_type);
	gtkaml_class_definition_set_definition_scope ((GtkamlClassDefinition*) self, definition_scope);
	gtkaml_class_definition_set_parent_container ((GtkamlClassDefinition*) self, parent_container);
	_tmp0 = NULL;
	gtkaml_class_definition_set_attrs ((GtkamlClassDefinition*) self, (GeeList*) (_tmp0 = gee_array_list_new (GTKAML_TYPE_ATTRIBUTE, (GBoxedCopyFunc) g_object_ref, g_object_unref, g_direct_equal)));
	(_tmp0 == NULL) ? NULL : (_tmp0 = (gee_collection_object_unref (_tmp0), NULL));
	gtkaml_class_definition_set_construct_method ((GtkamlClassDefinition*) self, NULL);
	_tmp1 = NULL;
	gtkaml_class_definition_set_children ((GtkamlClassDefinition*) self, (GeeList*) (_tmp1 = gee_array_list_new (GTKAML_TYPE_CLASS_DEFINITION, (GBoxedCopyFunc) g_object_ref, g_object_unref, g_direct_equal)));
	(_tmp1 == NULL) ? NULL : (_tmp1 = (gee_collection_object_unref (_tmp1), NULL));
	gtkaml_class_definition_set_construct_code ((GtkamlClassDefinition*) self, NULL);
	gtkaml_class_definition_set_preconstruct_code ((GtkamlClassDefinition*) self, NULL);
	gtkaml_root_class_definition_set_target_name (self, NULL);
	gtkaml_root_class_definition_set_target_namespace (self, NULL);
	_tmp2 = NULL;
	gtkaml_root_class_definition_set_code (self, (GeeList*) (_tmp2 = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, g_direct_equal)));
	(_tmp2 == NULL) ? NULL : (_tmp2 = (gee_collection_object_unref (_tmp2), NULL));
	gtkaml_root_class_definition_set_implements (self, NULL);
	gtkaml_root_class_definition_set_original_first_code_line (self, -1);
	return self;
}


GtkamlRootClassDefinition* gtkaml_root_class_definition_new (ValaSourceReference* source_reference, const char* identifier, const char* base_ns, ValaClass* base_type, DefinitionScope definition_scope, GtkamlClassDefinition* parent_container) {
	return gtkaml_root_class_definition_construct (GTKAML_TYPE_ROOT_CLASS_DEFINITION, source_reference, identifier, base_ns, base_type, definition_scope, parent_container);
}


GeeMap* gtkaml_root_class_definition_get_prefixes_namespaces (GtkamlRootClassDefinition* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return self->priv->_prefixes_namespaces;
}


void gtkaml_root_class_definition_set_prefixes_namespaces (GtkamlRootClassDefinition* self, GeeMap* value) {
	GeeMap* _tmp2;
	GeeMap* _tmp1;
	g_return_if_fail (self != NULL);
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->_prefixes_namespaces = (_tmp2 = (_tmp1 = value, (_tmp1 == NULL) ? NULL : gee_collection_object_ref (_tmp1)), (self->priv->_prefixes_namespaces == NULL) ? NULL : (self->priv->_prefixes_namespaces = (gee_collection_object_unref (self->priv->_prefixes_namespaces), NULL)), _tmp2);
	g_object_notify ((GObject *) self, "prefixes-namespaces");
}


const char* gtkaml_root_class_definition_get_target_name (GtkamlRootClassDefinition* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return self->priv->_target_name;
}


void gtkaml_root_class_definition_set_target_name (GtkamlRootClassDefinition* self, const char* value) {
	char* _tmp2;
	const char* _tmp1;
	g_return_if_fail (self != NULL);
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->_target_name = (_tmp2 = (_tmp1 = value, (_tmp1 == NULL) ? NULL : g_strdup (_tmp1)), self->priv->_target_name = (g_free (self->priv->_target_name), NULL), _tmp2);
	g_object_notify ((GObject *) self, "target-name");
}


const char* gtkaml_root_class_definition_get_target_namespace (GtkamlRootClassDefinition* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return self->priv->_target_namespace;
}


void gtkaml_root_class_definition_set_target_namespace (GtkamlRootClassDefinition* self, const char* value) {
	char* _tmp2;
	const char* _tmp1;
	g_return_if_fail (self != NULL);
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->_target_namespace = (_tmp2 = (_tmp1 = value, (_tmp1 == NULL) ? NULL : g_strdup (_tmp1)), self->priv->_target_namespace = (g_free (self->priv->_target_namespace), NULL), _tmp2);
	g_object_notify ((GObject *) self, "target-namespace");
}


GeeList* gtkaml_root_class_definition_get_code (GtkamlRootClassDefinition* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return self->priv->_code;
}


void gtkaml_root_class_definition_set_code (GtkamlRootClassDefinition* self, GeeList* value) {
	GeeList* _tmp2;
	GeeList* _tmp1;
	g_return_if_fail (self != NULL);
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->_code = (_tmp2 = (_tmp1 = value, (_tmp1 == NULL) ? NULL : gee_collection_object_ref (_tmp1)), (self->priv->_code == NULL) ? NULL : (self->priv->_code = (gee_collection_object_unref (self->priv->_code), NULL)), _tmp2);
	g_object_notify ((GObject *) self, "code");
}


gint gtkaml_root_class_definition_get_original_first_code_line (GtkamlRootClassDefinition* self) {
	g_return_val_if_fail (self != NULL, 0);
	return self->priv->_original_first_code_line;
}


void gtkaml_root_class_definition_set_original_first_code_line (GtkamlRootClassDefinition* self, gint value) {
	g_return_if_fail (self != NULL);
	self->priv->_original_first_code_line = value;
	g_object_notify ((GObject *) self, "original-first-code-line");
}


const char* gtkaml_root_class_definition_get_implements (GtkamlRootClassDefinition* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return self->priv->_implements;
}


void gtkaml_root_class_definition_set_implements (GtkamlRootClassDefinition* self, const char* value) {
	char* _tmp2;
	const char* _tmp1;
	g_return_if_fail (self != NULL);
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->_implements = (_tmp2 = (_tmp1 = value, (_tmp1 == NULL) ? NULL : g_strdup (_tmp1)), self->priv->_implements = (g_free (self->priv->_implements), NULL), _tmp2);
	g_object_notify ((GObject *) self, "implements");
}


static void gtkaml_root_class_definition_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	GtkamlRootClassDefinition * self;
	self = GTKAML_ROOT_CLASS_DEFINITION (object);
	switch (property_id) {
		case GTKAML_ROOT_CLASS_DEFINITION_PREFIXES_NAMESPACES:
		g_value_set_object (value, gtkaml_root_class_definition_get_prefixes_namespaces (self));
		break;
		case GTKAML_ROOT_CLASS_DEFINITION_TARGET_NAME:
		g_value_set_string (value, gtkaml_root_class_definition_get_target_name (self));
		break;
		case GTKAML_ROOT_CLASS_DEFINITION_TARGET_NAMESPACE:
		g_value_set_string (value, gtkaml_root_class_definition_get_target_namespace (self));
		break;
		case GTKAML_ROOT_CLASS_DEFINITION_CODE:
		g_value_set_object (value, gtkaml_root_class_definition_get_code (self));
		break;
		case GTKAML_ROOT_CLASS_DEFINITION_ORIGINAL_FIRST_CODE_LINE:
		g_value_set_int (value, gtkaml_root_class_definition_get_original_first_code_line (self));
		break;
		case GTKAML_ROOT_CLASS_DEFINITION_IMPLEMENTS:
		g_value_set_string (value, gtkaml_root_class_definition_get_implements (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void gtkaml_root_class_definition_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	GtkamlRootClassDefinition * self;
	self = GTKAML_ROOT_CLASS_DEFINITION (object);
	switch (property_id) {
		case GTKAML_ROOT_CLASS_DEFINITION_PREFIXES_NAMESPACES:
		gtkaml_root_class_definition_set_prefixes_namespaces (self, g_value_get_object (value));
		break;
		case GTKAML_ROOT_CLASS_DEFINITION_TARGET_NAME:
		gtkaml_root_class_definition_set_target_name (self, g_value_get_string (value));
		break;
		case GTKAML_ROOT_CLASS_DEFINITION_TARGET_NAMESPACE:
		gtkaml_root_class_definition_set_target_namespace (self, g_value_get_string (value));
		break;
		case GTKAML_ROOT_CLASS_DEFINITION_CODE:
		gtkaml_root_class_definition_set_code (self, g_value_get_object (value));
		break;
		case GTKAML_ROOT_CLASS_DEFINITION_ORIGINAL_FIRST_CODE_LINE:
		gtkaml_root_class_definition_set_original_first_code_line (self, g_value_get_int (value));
		break;
		case GTKAML_ROOT_CLASS_DEFINITION_IMPLEMENTS:
		gtkaml_root_class_definition_set_implements (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void gtkaml_root_class_definition_class_init (GtkamlRootClassDefinitionClass * klass) {
	gtkaml_root_class_definition_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (GtkamlRootClassDefinitionPrivate));
	G_OBJECT_CLASS (klass)->get_property = gtkaml_root_class_definition_get_property;
	G_OBJECT_CLASS (klass)->set_property = gtkaml_root_class_definition_set_property;
	G_OBJECT_CLASS (klass)->finalize = gtkaml_root_class_definition_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GTKAML_ROOT_CLASS_DEFINITION_PREFIXES_NAMESPACES, gee_param_spec_collection_object ("prefixes-namespaces", "prefixes-namespaces", "prefixes-namespaces", GEE_TYPE_MAP, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GTKAML_ROOT_CLASS_DEFINITION_TARGET_NAME, g_param_spec_string ("target-name", "target-name", "target-name", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GTKAML_ROOT_CLASS_DEFINITION_TARGET_NAMESPACE, g_param_spec_string ("target-namespace", "target-namespace", "target-namespace", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GTKAML_ROOT_CLASS_DEFINITION_CODE, gee_param_spec_collection_object ("code", "code", "code", GEE_TYPE_LIST, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GTKAML_ROOT_CLASS_DEFINITION_ORIGINAL_FIRST_CODE_LINE, g_param_spec_int ("original-first-code-line", "original-first-code-line", "original-first-code-line", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GTKAML_ROOT_CLASS_DEFINITION_IMPLEMENTS, g_param_spec_string ("implements", "implements", "implements", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void gtkaml_root_class_definition_instance_init (GtkamlRootClassDefinition * self) {
	self->priv = GTKAML_ROOT_CLASS_DEFINITION_GET_PRIVATE (self);
}


static void gtkaml_root_class_definition_finalize (GObject* obj) {
	GtkamlRootClassDefinition * self;
	self = GTKAML_ROOT_CLASS_DEFINITION (obj);
	(self->priv->_prefixes_namespaces == NULL) ? NULL : (self->priv->_prefixes_namespaces = (gee_collection_object_unref (self->priv->_prefixes_namespaces), NULL));
	self->priv->_target_name = (g_free (self->priv->_target_name), NULL);
	self->priv->_target_namespace = (g_free (self->priv->_target_namespace), NULL);
	(self->priv->_code == NULL) ? NULL : (self->priv->_code = (gee_collection_object_unref (self->priv->_code), NULL));
	self->priv->_implements = (g_free (self->priv->_implements), NULL);
	G_OBJECT_CLASS (gtkaml_root_class_definition_parent_class)->finalize (obj);
}


GType gtkaml_root_class_definition_get_type (void) {
	static GType gtkaml_root_class_definition_type_id = 0;
	if (gtkaml_root_class_definition_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (GtkamlRootClassDefinitionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gtkaml_root_class_definition_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GtkamlRootClassDefinition), 0, (GInstanceInitFunc) gtkaml_root_class_definition_instance_init, NULL };
		gtkaml_root_class_definition_type_id = g_type_register_static (GTKAML_TYPE_CLASS_DEFINITION, "GtkamlRootClassDefinition", &g_define_type_info, 0);
	}
	return gtkaml_root_class_definition_type_id;
}




