/* GtkamlComplexAttribute.vala
 * 
 * Copyright (C) 2008 Vlad Grecescu
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with main.c; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor Boston, MA 02110-1301,  USA
 *
 * Author:
 *        Vlad Grecescu (b100dian@gmail.com)
 */

#ifndef __GTKAMLCOMPLEXATTRIBUTE_H__
#define __GTKAMLCOMPLEXATTRIBUTE_H__

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include "GtkamlAttribute.h"
#include "GtkamlClassDefinition.h"

G_BEGIN_DECLS


#define GTKAML_TYPE_COMPLEX_ATTRIBUTE (gtkaml_complex_attribute_get_type ())
#define GTKAML_COMPLEX_ATTRIBUTE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GTKAML_TYPE_COMPLEX_ATTRIBUTE, GtkamlComplexAttribute))
#define GTKAML_COMPLEX_ATTRIBUTE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GTKAML_TYPE_COMPLEX_ATTRIBUTE, GtkamlComplexAttributeClass))
#define GTKAML_IS_COMPLEX_ATTRIBUTE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GTKAML_TYPE_COMPLEX_ATTRIBUTE))
#define GTKAML_IS_COMPLEX_ATTRIBUTE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GTKAML_TYPE_COMPLEX_ATTRIBUTE))
#define GTKAML_COMPLEX_ATTRIBUTE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GTKAML_TYPE_COMPLEX_ATTRIBUTE, GtkamlComplexAttributeClass))

typedef struct _GtkamlComplexAttribute GtkamlComplexAttribute;
typedef struct _GtkamlComplexAttributeClass GtkamlComplexAttributeClass;
typedef struct _GtkamlComplexAttributePrivate GtkamlComplexAttributePrivate;

/**
 * An attribute that is defined using a sub-tag
 */
struct _GtkamlComplexAttribute {
	GtkamlAttribute parent_instance;
	GtkamlComplexAttributePrivate * priv;
};

struct _GtkamlComplexAttributeClass {
	GtkamlAttributeClass parent_class;
};


GtkamlComplexAttribute* gtkaml_complex_attribute_construct (GType object_type, const char* name, GtkamlClassDefinition* complex_type);
GtkamlComplexAttribute* gtkaml_complex_attribute_new (const char* name, GtkamlClassDefinition* complex_type);
GtkamlClassDefinition* gtkaml_complex_attribute_get_complex_type (GtkamlComplexAttribute* self);
void gtkaml_complex_attribute_set_complex_type (GtkamlComplexAttribute* self, GtkamlClassDefinition* value);
GType gtkaml_complex_attribute_get_type (void);


G_END_DECLS

#endif
