/* GtkamlState.vala
 * 
 * Copyright (C) 2008 Vlad Grecescu
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with main.c; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor Boston, MA 02110-1301,  USA
 *
 * Author:
 *        Vlad Grecescu (b100dian@gmail.com)
 */

#include "GtkamlState.h"




struct _GtkamlStatePrivate {
	GtkamlStateId _state_id;
	GtkamlClassDefinition* _class_definition;
	GtkamlAttribute* _attribute;
	char* _attribute_name;
};

#define GTKAML_STATE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GTKAML_TYPE_STATE, GtkamlStatePrivate))
enum  {
	GTKAML_STATE_DUMMY_PROPERTY,
	GTKAML_STATE_STATE_ID,
	GTKAML_STATE_CLASS_DEFINITION,
	GTKAML_STATE_ATTRIBUTE,
	GTKAML_STATE_ATTRIBUTE_NAME
};
static gpointer gtkaml_state_parent_class = NULL;
static void gtkaml_state_finalize (GObject* obj);




GType gtkaml_state_id_get_type (void) {
	static GType gtkaml_state_id_type_id = 0;
	if (G_UNLIKELY (gtkaml_state_id_type_id == 0)) {
		static const GEnumValue values[] = {{GTKAML_STATE_ID_SAX_PARSER_INITIAL_STATE, "GTKAML_STATE_ID_SAX_PARSER_INITIAL_STATE", "sax-parser-initial-state"}, {GTKAML_STATE_ID_SAX_PARSER_CONTAINER_STATE, "GTKAML_STATE_ID_SAX_PARSER_CONTAINER_STATE", "sax-parser-container-state"}, {GTKAML_STATE_ID_SAX_PARSER_ATTRIBUTE_STATE, "GTKAML_STATE_ID_SAX_PARSER_ATTRIBUTE_STATE", "sax-parser-attribute-state"}, {0, NULL, NULL}};
		gtkaml_state_id_type_id = g_enum_register_static ("GtkamlStateId", values);
	}
	return gtkaml_state_id_type_id;
}


GtkamlState* gtkaml_state_construct (GType object_type, GtkamlStateId state_id, GtkamlClassDefinition* class_definition, GtkamlAttribute* attribute, const char* attribute_name) {
	GtkamlState * self;
	self = g_object_newv (object_type, 0, NULL);
	gtkaml_state_set_state_id (self, state_id);
	gtkaml_state_set_class_definition (self, class_definition);
	gtkaml_state_set_attribute (self, attribute);
	gtkaml_state_set_attribute_name (self, attribute_name);
	return self;
}


GtkamlState* gtkaml_state_new (GtkamlStateId state_id, GtkamlClassDefinition* class_definition, GtkamlAttribute* attribute, const char* attribute_name) {
	return gtkaml_state_construct (GTKAML_TYPE_STATE, state_id, class_definition, attribute, attribute_name);
}


GtkamlStateId gtkaml_state_get_state_id (GtkamlState* self) {
	g_return_val_if_fail (self != NULL, 0);
	return self->priv->_state_id;
}


void gtkaml_state_set_state_id (GtkamlState* self, GtkamlStateId value) {
	g_return_if_fail (self != NULL);
	self->priv->_state_id = value;
	g_object_notify (((GObject *) (self)), "state-id");
}


GtkamlClassDefinition* gtkaml_state_get_class_definition (GtkamlState* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return self->priv->_class_definition;
}


void gtkaml_state_set_class_definition (GtkamlState* self, GtkamlClassDefinition* value) {
	GtkamlClassDefinition* _tmp2;
	GtkamlClassDefinition* _tmp1;
	g_return_if_fail (self != NULL);
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->_class_definition = (_tmp2 = (_tmp1 = value, (_tmp1 == NULL ? NULL : g_object_ref (_tmp1))), (self->priv->_class_definition == NULL ? NULL : (self->priv->_class_definition = (g_object_unref (self->priv->_class_definition), NULL))), _tmp2);
	g_object_notify (((GObject *) (self)), "class-definition");
}


GtkamlAttribute* gtkaml_state_get_attribute (GtkamlState* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return self->priv->_attribute;
}


void gtkaml_state_set_attribute (GtkamlState* self, GtkamlAttribute* value) {
	GtkamlAttribute* _tmp2;
	GtkamlAttribute* _tmp1;
	g_return_if_fail (self != NULL);
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->_attribute = (_tmp2 = (_tmp1 = value, (_tmp1 == NULL ? NULL : g_object_ref (_tmp1))), (self->priv->_attribute == NULL ? NULL : (self->priv->_attribute = (g_object_unref (self->priv->_attribute), NULL))), _tmp2);
	g_object_notify (((GObject *) (self)), "attribute");
}


const char* gtkaml_state_get_attribute_name (GtkamlState* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return self->priv->_attribute_name;
}


void gtkaml_state_set_attribute_name (GtkamlState* self, const char* value) {
	char* _tmp2;
	const char* _tmp1;
	g_return_if_fail (self != NULL);
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->_attribute_name = (_tmp2 = (_tmp1 = value, (_tmp1 == NULL ? NULL : g_strdup (_tmp1))), (self->priv->_attribute_name = (g_free (self->priv->_attribute_name), NULL)), _tmp2);
	g_object_notify (((GObject *) (self)), "attribute-name");
}


static void gtkaml_state_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	GtkamlState * self;
	self = GTKAML_STATE (object);
	switch (property_id) {
		case GTKAML_STATE_STATE_ID:
		g_value_set_enum (value, gtkaml_state_get_state_id (self));
		break;
		case GTKAML_STATE_CLASS_DEFINITION:
		g_value_set_object (value, gtkaml_state_get_class_definition (self));
		break;
		case GTKAML_STATE_ATTRIBUTE:
		g_value_set_object (value, gtkaml_state_get_attribute (self));
		break;
		case GTKAML_STATE_ATTRIBUTE_NAME:
		g_value_set_string (value, gtkaml_state_get_attribute_name (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void gtkaml_state_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	GtkamlState * self;
	self = GTKAML_STATE (object);
	switch (property_id) {
		case GTKAML_STATE_STATE_ID:
		gtkaml_state_set_state_id (self, g_value_get_enum (value));
		break;
		case GTKAML_STATE_CLASS_DEFINITION:
		gtkaml_state_set_class_definition (self, g_value_get_object (value));
		break;
		case GTKAML_STATE_ATTRIBUTE:
		gtkaml_state_set_attribute (self, g_value_get_object (value));
		break;
		case GTKAML_STATE_ATTRIBUTE_NAME:
		gtkaml_state_set_attribute_name (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void gtkaml_state_class_init (GtkamlStateClass * klass) {
	gtkaml_state_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (GtkamlStatePrivate));
	G_OBJECT_CLASS (klass)->get_property = gtkaml_state_get_property;
	G_OBJECT_CLASS (klass)->set_property = gtkaml_state_set_property;
	G_OBJECT_CLASS (klass)->finalize = gtkaml_state_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GTKAML_STATE_STATE_ID, g_param_spec_enum ("state-id", "state-id", "state-id", GTKAML_TYPE_STATE_ID, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GTKAML_STATE_CLASS_DEFINITION, g_param_spec_object ("class-definition", "class-definition", "class-definition", GTKAML_TYPE_CLASS_DEFINITION, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GTKAML_STATE_ATTRIBUTE, g_param_spec_object ("attribute", "attribute", "attribute", GTKAML_TYPE_ATTRIBUTE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GTKAML_STATE_ATTRIBUTE_NAME, g_param_spec_string ("attribute-name", "attribute-name", "attribute-name", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void gtkaml_state_instance_init (GtkamlState * self) {
	self->priv = GTKAML_STATE_GET_PRIVATE (self);
}


static void gtkaml_state_finalize (GObject* obj) {
	GtkamlState * self;
	self = GTKAML_STATE (obj);
	(self->priv->_class_definition == NULL ? NULL : (self->priv->_class_definition = (g_object_unref (self->priv->_class_definition), NULL)));
	(self->priv->_attribute == NULL ? NULL : (self->priv->_attribute = (g_object_unref (self->priv->_attribute), NULL)));
	self->priv->_attribute_name = (g_free (self->priv->_attribute_name), NULL);
	G_OBJECT_CLASS (gtkaml_state_parent_class)->finalize (obj);
}


GType gtkaml_state_get_type (void) {
	static GType gtkaml_state_type_id = 0;
	if (gtkaml_state_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (GtkamlStateClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gtkaml_state_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GtkamlState), 0, (GInstanceInitFunc) gtkaml_state_instance_init, NULL };
		gtkaml_state_type_id = g_type_register_static (G_TYPE_OBJECT, "GtkamlState", &g_define_type_info, 0);
	}
	return gtkaml_state_type_id;
}




