/* GtkamlComplexAttribute.vala
 * 
 * Copyright (C) 2008 Vlad Grecescu
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with main.c; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor Boston, MA 02110-1301,  USA
 *
 * Author:
 *        Vlad Grecescu (b100dian@gmail.com)
 */

#include "GtkamlComplexAttribute.h"




struct _GtkamlComplexAttributePrivate {
	GtkamlClassDefinition* _complex_type;
};

#define GTKAML_COMPLEX_ATTRIBUTE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GTKAML_TYPE_COMPLEX_ATTRIBUTE, GtkamlComplexAttributePrivate))
enum  {
	GTKAML_COMPLEX_ATTRIBUTE_DUMMY_PROPERTY,
	GTKAML_COMPLEX_ATTRIBUTE_COMPLEX_TYPE
};
static gpointer gtkaml_complex_attribute_parent_class = NULL;
static void gtkaml_complex_attribute_finalize (GObject* obj);



GtkamlComplexAttribute* gtkaml_complex_attribute_construct (GType object_type, const char* name, GtkamlClassDefinition* complex_type) {
	GtkamlComplexAttribute * self;
	g_return_val_if_fail (name != NULL, NULL);
	g_return_val_if_fail (complex_type != NULL, NULL);
	self = g_object_newv (object_type, 0, NULL);
	gtkaml_attribute_set_name (((GtkamlAttribute*) (self)), name);
	gtkaml_complex_attribute_set_complex_type (self, complex_type);
	return self;
}


GtkamlComplexAttribute* gtkaml_complex_attribute_new (const char* name, GtkamlClassDefinition* complex_type) {
	return gtkaml_complex_attribute_construct (GTKAML_TYPE_COMPLEX_ATTRIBUTE, name, complex_type);
}


GtkamlClassDefinition* gtkaml_complex_attribute_get_complex_type (GtkamlComplexAttribute* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return self->priv->_complex_type;
}


void gtkaml_complex_attribute_set_complex_type (GtkamlComplexAttribute* self, GtkamlClassDefinition* value) {
	GtkamlClassDefinition* _tmp2;
	GtkamlClassDefinition* _tmp1;
	g_return_if_fail (self != NULL);
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->_complex_type = (_tmp2 = (_tmp1 = value, (_tmp1 == NULL ? NULL : g_object_ref (_tmp1))), (self->priv->_complex_type == NULL ? NULL : (self->priv->_complex_type = (g_object_unref (self->priv->_complex_type), NULL))), _tmp2);
	g_object_notify (((GObject *) (self)), "complex-type");
}


static void gtkaml_complex_attribute_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	GtkamlComplexAttribute * self;
	self = GTKAML_COMPLEX_ATTRIBUTE (object);
	switch (property_id) {
		case GTKAML_COMPLEX_ATTRIBUTE_COMPLEX_TYPE:
		g_value_set_object (value, gtkaml_complex_attribute_get_complex_type (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void gtkaml_complex_attribute_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	GtkamlComplexAttribute * self;
	self = GTKAML_COMPLEX_ATTRIBUTE (object);
	switch (property_id) {
		case GTKAML_COMPLEX_ATTRIBUTE_COMPLEX_TYPE:
		gtkaml_complex_attribute_set_complex_type (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void gtkaml_complex_attribute_class_init (GtkamlComplexAttributeClass * klass) {
	gtkaml_complex_attribute_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (GtkamlComplexAttributePrivate));
	G_OBJECT_CLASS (klass)->get_property = gtkaml_complex_attribute_get_property;
	G_OBJECT_CLASS (klass)->set_property = gtkaml_complex_attribute_set_property;
	G_OBJECT_CLASS (klass)->finalize = gtkaml_complex_attribute_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GTKAML_COMPLEX_ATTRIBUTE_COMPLEX_TYPE, g_param_spec_object ("complex-type", "complex-type", "complex-type", GTKAML_TYPE_CLASS_DEFINITION, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void gtkaml_complex_attribute_instance_init (GtkamlComplexAttribute * self) {
	self->priv = GTKAML_COMPLEX_ATTRIBUTE_GET_PRIVATE (self);
}


static void gtkaml_complex_attribute_finalize (GObject* obj) {
	GtkamlComplexAttribute * self;
	self = GTKAML_COMPLEX_ATTRIBUTE (obj);
	(self->priv->_complex_type == NULL ? NULL : (self->priv->_complex_type = (g_object_unref (self->priv->_complex_type), NULL)));
	G_OBJECT_CLASS (gtkaml_complex_attribute_parent_class)->finalize (obj);
}


GType gtkaml_complex_attribute_get_type (void) {
	static GType gtkaml_complex_attribute_type_id = 0;
	if (gtkaml_complex_attribute_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (GtkamlComplexAttributeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gtkaml_complex_attribute_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GtkamlComplexAttribute), 0, (GInstanceInitFunc) gtkaml_complex_attribute_instance_init, NULL };
		gtkaml_complex_attribute_type_id = g_type_register_static (GTKAML_TYPE_ATTRIBUTE, "GtkamlComplexAttribute", &g_define_type_info, 0);
	}
	return gtkaml_complex_attribute_type_id;
}




