/* GtkamlCodeGenerator.vala
 *
 * Copyright (C) 2008 Vlad Grecescu
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with main.c; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor Boston, MA 02110-1301,  USA
 *
 * Author:
 *        Vlad Grecescu (b100dian@gmail.com)
 */

#include "GtkamlCodeGenerator.h"
#include <gee/map.h>
#include <vala/valareport.h>
#include <vala/valasourcereference.h>
#include <vala/valasymbol.h>
#include <gee/collection.h>
#include <gee/list.h>
#include <vala/valafield.h>
#include <vala/valaproperty.h>
#include <vala/valasignal.h>
#include <vala/valadatatype.h>
#include <vala/valaformalparameter.h>
#include <vala/valaunresolvedtype.h>
#include "GtkamlReferenceClassDefinition.h"
#include "GtkamlComplexAttribute.h"
#include "GtkamlMethod.h"
#include "GtkamlSimpleAttribute.h"
#include <string.h>




struct _GtkamlCodeGeneratorPrivate {
	char* using_directives;
	char* class_start;
	char* members_declarations;
	char* code;
	char* construct_signals;
	char* constructors;
	char* construct_body_locals;
	char* construct_body;
	char* class_end;
	ValaCodeContext* _context;
	GtkamlRootClassDefinition* _root_class_definition;
};

#define GTKAML_CODE_GENERATOR_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GTKAML_TYPE_CODE_GENERATOR, GtkamlCodeGeneratorPrivate))
enum  {
	GTKAML_CODE_GENERATOR_DUMMY_PROPERTY,
	GTKAML_CODE_GENERATOR_CONTEXT
};
static gint gtkaml_code_generator_line_count (GtkamlCodeGenerator* self, const char* s);
static void gtkaml_code_generator_set_context (GtkamlCodeGenerator* self, ValaCodeContext* value);
static GtkamlRootClassDefinition* gtkaml_code_generator_get_root_class_definition (GtkamlCodeGenerator* self);
static void gtkaml_code_generator_set_root_class_definition (GtkamlCodeGenerator* self, GtkamlRootClassDefinition* value);
static gpointer gtkaml_code_generator_parent_class = NULL;
static void gtkaml_code_generator_finalize (GObject* obj);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static int _vala_strcmp0 (const char * str1, const char * str2);



GtkamlCodeGenerator* gtkaml_code_generator_construct (GType object_type, ValaCodeContext* context) {
	GtkamlCodeGenerator * self;
	g_return_val_if_fail (context != NULL, NULL);
	self = g_object_newv (object_type, 0, NULL);
	gtkaml_code_generator_set_context (self, context);
	return self;
}


GtkamlCodeGenerator* gtkaml_code_generator_new (ValaCodeContext* context) {
	return gtkaml_code_generator_construct (GTKAML_TYPE_CODE_GENERATOR, context);
}


/**
 * returns a string that is the Vala source code
 */
char* gtkaml_code_generator_yield (GtkamlCodeGenerator* self) {
	char* _tmp3;
	char* _tmp2;
	char* _tmp1;
	char* _tmp0;
	char* _tmp4;
	char* yielded;
	char* _tmp18;
	char* _tmp17;
	char* _tmp16;
	char* _tmp15;
	char* _tmp14;
	char* _tmp13;
	char* _tmp12;
	char* _tmp11;
	char* _tmp10;
	char* _tmp9;
	char* _tmp8;
	char* _tmp7;
	char* _tmp6;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp3 = NULL;
	_tmp2 = NULL;
	_tmp1 = NULL;
	_tmp0 = NULL;
	_tmp4 = NULL;
	yielded = (_tmp4 = g_strconcat ((_tmp3 = g_strconcat ((_tmp2 = g_strconcat ((_tmp1 = g_strconcat ((_tmp0 = g_strconcat (self->priv->using_directives, "\n", NULL)), self->priv->class_start, NULL)), "\n", NULL)), self->priv->members_declarations, NULL)), "\n", NULL), (_tmp3 = (g_free (_tmp3), NULL)), (_tmp2 = (g_free (_tmp2), NULL)), (_tmp1 = (g_free (_tmp1), NULL)), (_tmp0 = (g_free (_tmp0), NULL)), _tmp4);
	{
		gint i;
		i = gtkaml_code_generator_line_count (self, yielded) + 1;
		for (; i < gtkaml_root_class_definition_get_original_first_code_line (self->priv->_root_class_definition); i++) {
			char* _tmp5;
			_tmp5 = NULL;
			yielded = (_tmp5 = g_strconcat (yielded, ("\n"), NULL), (yielded = (g_free (yielded), NULL)), _tmp5);
		}
	}
	_tmp18 = NULL;
	_tmp17 = NULL;
	_tmp16 = NULL;
	_tmp15 = NULL;
	_tmp14 = NULL;
	_tmp13 = NULL;
	_tmp12 = NULL;
	_tmp11 = NULL;
	_tmp10 = NULL;
	_tmp9 = NULL;
	_tmp8 = NULL;
	_tmp7 = NULL;
	_tmp6 = NULL;
	yielded = (_tmp18 = g_strconcat (yielded, (_tmp17 = (g_strconcat ((_tmp16 = g_strconcat ((_tmp15 = g_strconcat ((_tmp14 = g_strconcat ((_tmp13 = g_strconcat ((_tmp12 = g_strconcat ((_tmp11 = g_strconcat ((_tmp10 = g_strconcat ((_tmp9 = g_strconcat ((_tmp8 = g_strconcat ((_tmp7 = g_strconcat ((_tmp6 = g_strconcat (self->priv->code, "\n", NULL)), self->priv->construct_signals, NULL)), "\n", NULL)), "\tconstruct {\n", NULL)), self->priv->construct_body_locals, NULL)), "\n", NULL)), self->priv->constructors, NULL)), "\n", NULL)), self->priv->construct_body, NULL)), "\n", NULL)), "\t}\n", NULL)), self->priv->class_end, NULL))), NULL), (yielded = (g_free (yielded), NULL)), _tmp18);
	_tmp17 = (g_free (_tmp17), NULL);
	_tmp16 = (g_free (_tmp16), NULL);
	_tmp15 = (g_free (_tmp15), NULL);
	_tmp14 = (g_free (_tmp14), NULL);
	_tmp13 = (g_free (_tmp13), NULL);
	_tmp12 = (g_free (_tmp12), NULL);
	_tmp11 = (g_free (_tmp11), NULL);
	_tmp10 = (g_free (_tmp10), NULL);
	_tmp9 = (g_free (_tmp9), NULL);
	_tmp8 = (g_free (_tmp8), NULL);
	_tmp7 = (g_free (_tmp7), NULL);
	_tmp6 = (g_free (_tmp6), NULL);
	return yielded;
}


/** 
 * processes the root class definition and its children
 */
void gtkaml_code_generator_generate (GtkamlCodeGenerator* self, GtkamlClassDefinition* class_definition) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (class_definition != NULL);
	if (GTKAML_IS_ROOT_CLASS_DEFINITION (class_definition)) {
		GtkamlClassDefinition* _tmp0;
		_tmp0 = NULL;
		gtkaml_code_generator_set_root_class_definition (self, (_tmp0 = class_definition, (GTKAML_IS_ROOT_CLASS_DEFINITION (_tmp0) ? ((GtkamlRootClassDefinition*) (_tmp0)) : NULL)));
		{
			GeeSet* prefix_collection;
			GeeIterator* prefix_it;
			prefix_collection = gee_map_get_keys (gtkaml_root_class_definition_get_prefixes_namespaces (self->priv->_root_class_definition));
			prefix_it = gee_iterable_iterator (GEE_ITERABLE (prefix_collection));
			while (gee_iterator_next (prefix_it)) {
				char* prefix;
				prefix = ((char*) (gee_iterator_get (prefix_it)));
				{
					char* _tmp1;
					_tmp1 = NULL;
					gtkaml_code_generator_write_using (self, (_tmp1 = gtkaml_code_generator_prefix_to_namespace (self, prefix)));
					_tmp1 = (g_free (_tmp1), NULL);
					prefix = (g_free (prefix), NULL);
				}
			}
			(prefix_it == NULL ? NULL : (prefix_it = (gee_collection_object_unref (prefix_it), NULL)));
			(prefix_collection == NULL ? NULL : (prefix_collection = (gee_collection_object_unref (prefix_collection), NULL)));
		}
		gtkaml_code_generator_write_root_class_definition (self, self->priv->_root_class_definition);
		gtkaml_code_generator_write_preconstruct (self, ((GtkamlClassDefinition*) (self->priv->_root_class_definition)));
		gtkaml_code_generator_write_root_constructor_parameters (self, self->priv->_root_class_definition);
		gtkaml_code_generator_write_complex_attributes (self, ((GtkamlClassDefinition*) (self->priv->_root_class_definition)));
		gtkaml_code_generator_write_setters (self, class_definition);
		gtkaml_code_generator_generate_children (self, class_definition);
		gtkaml_code_generator_write_construct (self, class_definition);
	} else {
		if (GTKAML_IS_REFERENCE_CLASS_DEFINITION (class_definition)) {
			gtkaml_code_generator_generate_children (self, class_definition);
			gtkaml_code_generator_write_add (self, class_definition);
		} else {
			gtkaml_code_generator_write_declaration (self, class_definition);
			gtkaml_code_generator_write_complex_attributes (self, class_definition);
			/*this must *really* go before the constructor*/
			gtkaml_code_generator_write_constructor (self, class_definition);
			gtkaml_code_generator_write_preconstruct (self, class_definition);
			gtkaml_code_generator_write_setters (self, class_definition);
			gtkaml_code_generator_generate_children (self, class_definition);
			gtkaml_code_generator_write_construct (self, class_definition);
			gtkaml_code_generator_write_add (self, class_definition);
		}
	}
}


static gint gtkaml_code_generator_line_count (GtkamlCodeGenerator* self, const char* s) {
	gint count;
	const char* current;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (s != NULL, 0);
	count = 0;
	current = s;
	while (g_utf8_get_char (current) != 0) {
		if (g_utf8_get_char (current) == '\n') {
			count++;
		}
		current = g_utf8_next_char (current);
	}
	return count;
}


void gtkaml_code_generator_generate_children (GtkamlCodeGenerator* self, GtkamlClassDefinition* class_definition) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (class_definition != NULL);
	{
		GeeList* child_collection;
		int child_it;
		child_collection = gtkaml_class_definition_get_children (class_definition);
		for (child_it = 0; child_it < gee_collection_get_size (GEE_COLLECTION (child_collection)); child_it = child_it + 1) {
			GtkamlClassDefinition* child;
			child = ((GtkamlClassDefinition*) (gee_list_get (GEE_LIST (child_collection), child_it)));
			{
				gtkaml_code_generator_generate (self, child);
				(child == NULL ? NULL : (child = (g_object_unref (child), NULL)));
			}
		}
	}
}


void gtkaml_code_generator_write_preconstruct (GtkamlCodeGenerator* self, GtkamlClassDefinition* class_definition) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (class_definition != NULL);
	if (gtkaml_class_definition_get_preconstruct_code (class_definition) != NULL) {
		gtkaml_code_generator_write_construct_call (self, gtkaml_class_definition_get_identifier (class_definition), gtkaml_class_definition_get_base_full_name (class_definition), "preconstruct", gtkaml_class_definition_get_preconstruct_code (class_definition));
	}
}


void gtkaml_code_generator_write_construct (GtkamlCodeGenerator* self, GtkamlClassDefinition* class_definition) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (class_definition != NULL);
	if (gtkaml_class_definition_get_construct_code (class_definition) != NULL) {
		gtkaml_code_generator_write_construct_call (self, gtkaml_class_definition_get_identifier (class_definition), gtkaml_class_definition_get_base_full_name (class_definition), "construct", gtkaml_class_definition_get_construct_code (class_definition));
	}
}


void gtkaml_code_generator_write_construct_call (GtkamlCodeGenerator* self, const char* identifier, const char* identifier_type, const char* construct_type, const char* construct_code) {
	char* _tmp0;
	char* _tmp1;
	char* construct_signal;
	const char* _tmp2;
	char* real_construct_code;
	char* _tmp8;
	char* _tmp7;
	char* _tmp13;
	char* _tmp12;
	char* _tmp11;
	char* _tmp10;
	char* _tmp9;
	char* _tmp14;
	char* to_append;
	g_return_if_fail (self != NULL);
	g_return_if_fail (identifier != NULL);
	g_return_if_fail (identifier_type != NULL);
	g_return_if_fail (construct_type != NULL);
	g_return_if_fail (construct_code != NULL);
	_tmp0 = NULL;
	_tmp1 = NULL;
	construct_signal = (_tmp1 = g_strconcat ((_tmp0 = g_strconcat (identifier, "_", NULL)), construct_type, NULL), (_tmp0 = (g_free (_tmp0), NULL)), _tmp1);
	_tmp2 = NULL;
	real_construct_code = (_tmp2 = construct_code, (_tmp2 == NULL ? NULL : g_strdup (_tmp2)));
	g_strstrip (real_construct_code);
	if (g_str_has_prefix (real_construct_code, "{")) {
		if (g_str_has_suffix (real_construct_code, "}")) {
			char* _tmp4;
			char* _tmp3;
			_tmp4 = NULL;
			_tmp3 = NULL;
			real_construct_code = (_tmp4 = (_tmp3 = g_utf8_offset_to_pointer (real_construct_code, ((glong) (1))), g_strndup (_tmp3, g_utf8_offset_to_pointer (_tmp3, g_utf8_strlen (real_construct_code, -1) - 2) - _tmp3)), (real_construct_code = (g_free (real_construct_code), NULL)), _tmp4);
		} else {
			char* _tmp5;
			_tmp5 = NULL;
			vala_report_error (NULL, (_tmp5 = g_strdup_printf ("%s for %s not properly ended", construct_type, identifier)));
			_tmp5 = (g_free (_tmp5), NULL);
		}
	} else {
		char* _tmp6;
		_tmp6 = NULL;
		real_construct_code = (_tmp6 = g_strdup_printf (" (thiz, target) => { %s; }", construct_code), (real_construct_code = (g_free (real_construct_code), NULL)), _tmp6);
	}
	_tmp8 = NULL;
	_tmp7 = NULL;
	self->priv->construct_signals = (_tmp8 = g_strconcat (self->priv->construct_signals, (_tmp7 = (g_strdup_printf ("\tprivate signal void %s (%s target);\n", construct_signal, identifier_type))), NULL), (self->priv->construct_signals = (g_free (self->priv->construct_signals), NULL)), _tmp8);
	_tmp7 = (g_free (_tmp7), NULL);
	_tmp13 = NULL;
	_tmp12 = NULL;
	_tmp11 = NULL;
	_tmp10 = NULL;
	_tmp9 = NULL;
	_tmp14 = NULL;
	to_append = (_tmp14 = g_strconcat ((_tmp13 = g_strconcat ((_tmp12 = g_strconcat ((_tmp11 = g_strconcat ((_tmp10 = g_strconcat ((_tmp9 = g_strdup_printf ("\t\t%s += %s;\n", construct_signal, real_construct_code)), "\t\t", NULL)), construct_signal, NULL)), " (", NULL)), identifier, NULL)), ");\n", NULL), (_tmp13 = (g_free (_tmp13), NULL)), (_tmp12 = (g_free (_tmp12), NULL)), (_tmp11 = (g_free (_tmp11), NULL)), (_tmp10 = (g_free (_tmp10), NULL)), (_tmp9 = (g_free (_tmp9), NULL)), _tmp14);
	if (_vala_strcmp0 (construct_type, "preconstruct") == 0) {
		char* _tmp15;
		_tmp15 = NULL;
		self->priv->constructors = (_tmp15 = g_strconcat (self->priv->constructors, (to_append), NULL), (self->priv->constructors = (g_free (self->priv->constructors), NULL)), _tmp15);
	} else {
		char* _tmp16;
		_tmp16 = NULL;
		self->priv->construct_body = (_tmp16 = g_strconcat (self->priv->construct_body, (to_append), NULL), (self->priv->construct_body = (g_free (self->priv->construct_body), NULL)), _tmp16);
	}
	construct_signal = (g_free (construct_signal), NULL);
	real_construct_code = (g_free (real_construct_code), NULL);
	to_append = (g_free (to_append), NULL);
}


void gtkaml_code_generator_write_complex_attributes (GtkamlCodeGenerator* self, GtkamlClassDefinition* class_definition) {
	gboolean first;
	g_return_if_fail (self != NULL);
	g_return_if_fail (class_definition != NULL);
	{
		GeeList* attr_collection;
		int attr_it;
		attr_collection = gtkaml_class_definition_get_attrs (class_definition);
		for (attr_it = 0; attr_it < gee_collection_get_size (GEE_COLLECTION (attr_collection)); attr_it = attr_it + 1) {
			GtkamlAttribute* attr;
			attr = ((GtkamlAttribute*) (gee_list_get (GEE_LIST (attr_collection), attr_it)));
			{
				if (GTKAML_IS_COMPLEX_ATTRIBUTE (attr)) {
					GtkamlAttribute* _tmp0;
					_tmp0 = NULL;
					gtkaml_code_generator_generate (self, gtkaml_complex_attribute_get_complex_type (((_tmp0 = attr, (GTKAML_IS_COMPLEX_ATTRIBUTE (_tmp0) ? ((GtkamlComplexAttribute*) (_tmp0)) : NULL)))));
				}
				(attr == NULL ? NULL : (attr = (g_object_unref (attr), NULL)));
			}
		}
	}
	if (gtkaml_class_definition_get_construct_method (class_definition) != NULL && gtkaml_method_get_parameter_attributes (((GtkamlMethod*) (gtkaml_class_definition_get_construct_method (class_definition)))) != NULL) {
		{
			GeeList* attr_collection;
			int attr_it;
			attr_collection = gtkaml_method_get_parameter_attributes (((GtkamlMethod*) (gtkaml_class_definition_get_construct_method (class_definition))));
			for (attr_it = 0; attr_it < gee_collection_get_size (GEE_COLLECTION (attr_collection)); attr_it = attr_it + 1) {
				GtkamlAttribute* attr;
				attr = ((GtkamlAttribute*) (gee_list_get (GEE_LIST (attr_collection), attr_it)));
				{
					if (GTKAML_IS_COMPLEX_ATTRIBUTE (attr)) {
						GtkamlAttribute* _tmp1;
						_tmp1 = NULL;
						gtkaml_code_generator_generate (self, gtkaml_complex_attribute_get_complex_type (((_tmp1 = attr, (GTKAML_IS_COMPLEX_ATTRIBUTE (_tmp1) ? ((GtkamlComplexAttribute*) (_tmp1)) : NULL)))));
					}
					(attr == NULL ? NULL : (attr = (g_object_unref (attr), NULL)));
				}
			}
		}
	}
	first = TRUE;
	/*do not generate the first parameter of the container add child method*/
	if (gtkaml_class_definition_get_add_method (class_definition) != NULL && gtkaml_method_get_parameter_attributes (((GtkamlMethod*) (gtkaml_class_definition_get_add_method (class_definition)))) != NULL) {
		{
			GeeList* attr_collection;
			int attr_it;
			attr_collection = gtkaml_method_get_parameter_attributes (((GtkamlMethod*) (gtkaml_class_definition_get_add_method (class_definition))));
			for (attr_it = 0; attr_it < gee_collection_get_size (GEE_COLLECTION (attr_collection)); attr_it = attr_it + 1) {
				GtkamlAttribute* attr;
				attr = ((GtkamlAttribute*) (gee_list_get (GEE_LIST (attr_collection), attr_it)));
				{
					if (GTKAML_IS_COMPLEX_ATTRIBUTE (attr) && !first) {
						GtkamlAttribute* _tmp2;
						_tmp2 = NULL;
						gtkaml_code_generator_generate (self, gtkaml_complex_attribute_get_complex_type (((_tmp2 = attr, (GTKAML_IS_COMPLEX_ATTRIBUTE (_tmp2) ? ((GtkamlComplexAttribute*) (_tmp2)) : NULL)))));
					}
					first = FALSE;
					(attr == NULL ? NULL : (attr = (g_object_unref (attr), NULL)));
				}
			}
		}
	}
}


void gtkaml_code_generator_write_root_class_definition (GtkamlCodeGenerator* self, GtkamlRootClassDefinition* root_class_definition) {
	const char* _tmp0;
	char* ns;
	const char* _tmp1;
	char* name;
	const char* _tmp2;
	char* base_ns;
	const char* _tmp3;
	char* base_name;
	char* _tmp4;
	char* _tmp8;
	char* _tmp7;
	char* _tmp11;
	char* _tmp14;
	char* _tmp15;
	g_return_if_fail (self != NULL);
	g_return_if_fail (root_class_definition != NULL);
	_tmp0 = NULL;
	ns = (_tmp0 = gtkaml_root_class_definition_get_target_namespace (root_class_definition), (_tmp0 == NULL ? NULL : g_strdup (_tmp0)));
	_tmp1 = NULL;
	name = (_tmp1 = gtkaml_root_class_definition_get_target_name (root_class_definition), (_tmp1 == NULL ? NULL : g_strdup (_tmp1)));
	_tmp2 = NULL;
	base_ns = (_tmp2 = gtkaml_class_definition_get_base_ns (((GtkamlClassDefinition*) (root_class_definition))), (_tmp2 == NULL ? NULL : g_strdup (_tmp2)));
	_tmp3 = NULL;
	base_name = (_tmp3 = vala_symbol_get_name (((ValaSymbol*) (gtkaml_class_definition_get_base_type (((GtkamlClassDefinition*) (root_class_definition)))))), (_tmp3 == NULL ? NULL : g_strdup (_tmp3)));
	_tmp4 = NULL;
	self->priv->class_start = (_tmp4 = g_strconcat (self->priv->class_start, ("public class "), NULL), (self->priv->class_start = (g_free (self->priv->class_start), NULL)), _tmp4);
	if (ns != NULL) {
		char* _tmp6;
		char* _tmp5;
		_tmp6 = NULL;
		_tmp5 = NULL;
		self->priv->class_start = (_tmp6 = g_strconcat (self->priv->class_start, (_tmp5 = (g_strconcat (ns, ".", NULL))), NULL), (self->priv->class_start = (g_free (self->priv->class_start), NULL)), _tmp6);
		_tmp5 = (g_free (_tmp5), NULL);
	}
	_tmp8 = NULL;
	_tmp7 = NULL;
	self->priv->class_start = (_tmp8 = g_strconcat (self->priv->class_start, (_tmp7 = (g_strconcat (name, " : ", NULL))), NULL), (self->priv->class_start = (g_free (self->priv->class_start), NULL)), _tmp8);
	_tmp7 = (g_free (_tmp7), NULL);
	if (base_ns != NULL) {
		char* _tmp10;
		char* _tmp9;
		_tmp10 = NULL;
		_tmp9 = NULL;
		self->priv->class_start = (_tmp10 = g_strconcat (self->priv->class_start, (_tmp9 = (g_strconcat (base_ns, ".", NULL))), NULL), (self->priv->class_start = (g_free (self->priv->class_start), NULL)), _tmp10);
		_tmp9 = (g_free (_tmp9), NULL);
	}
	_tmp11 = NULL;
	self->priv->class_start = (_tmp11 = g_strconcat (self->priv->class_start, (base_name), NULL), (self->priv->class_start = (g_free (self->priv->class_start), NULL)), _tmp11);
	if (gtkaml_root_class_definition_get_implements (root_class_definition) != NULL) {
		char* _tmp13;
		char* _tmp12;
		_tmp13 = NULL;
		_tmp12 = NULL;
		self->priv->class_start = (_tmp13 = g_strconcat (self->priv->class_start, (_tmp12 = (g_strconcat (", ", gtkaml_root_class_definition_get_implements (root_class_definition), NULL))), NULL), (self->priv->class_start = (g_free (self->priv->class_start), NULL)), _tmp13);
		_tmp12 = (g_free (_tmp12), NULL);
	}
	_tmp14 = NULL;
	self->priv->class_start = (_tmp14 = g_strconcat (self->priv->class_start, ("\n{\n"), NULL), (self->priv->class_start = (g_free (self->priv->class_start), NULL)), _tmp14);
	_tmp15 = NULL;
	self->priv->class_end = (_tmp15 = g_strconcat (self->priv->class_end, ("}\n"), NULL), (self->priv->class_end = (g_free (self->priv->class_end), NULL)), _tmp15);
	{
		GeeList* code_collection;
		int code_it;
		code_collection = gtkaml_root_class_definition_get_code (root_class_definition);
		for (code_it = 0; code_it < gee_collection_get_size (GEE_COLLECTION (code_collection)); code_it = code_it + 1) {
			char* code;
			code = ((char*) (gee_list_get (GEE_LIST (code_collection), code_it)));
			{
				gtkaml_code_generator_add_code (self, code);
				code = (g_free (code), NULL);
			}
		}
	}
	ns = (g_free (ns), NULL);
	name = (g_free (name), NULL);
	base_ns = (g_free (base_ns), NULL);
	base_name = (g_free (base_name), NULL);
}


void gtkaml_code_generator_write_declaration (GtkamlCodeGenerator* self, GtkamlClassDefinition* class_definition) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (class_definition != NULL);
	switch (gtkaml_class_definition_get_definition_scope (class_definition)) {
		case DEFINITION_SCOPE_PUBLIC:
		{
			char* _tmp4;
			char* _tmp3;
			char* _tmp2;
			char* _tmp1;
			char* _tmp0;
			_tmp4 = NULL;
			_tmp3 = NULL;
			_tmp2 = NULL;
			_tmp1 = NULL;
			_tmp0 = NULL;
			self->priv->members_declarations = (_tmp4 = g_strconcat (self->priv->members_declarations, (_tmp3 = (g_strconcat ((_tmp2 = g_strconcat ((_tmp1 = g_strconcat ((_tmp0 = g_strconcat ("\tpublic ", gtkaml_class_definition_get_base_full_name (class_definition), NULL)), " ", NULL)), gtkaml_class_definition_get_identifier (class_definition), NULL)), ";\n", NULL))), NULL), (self->priv->members_declarations = (g_free (self->priv->members_declarations), NULL)), _tmp4);
			_tmp3 = (g_free (_tmp3), NULL);
			_tmp2 = (g_free (_tmp2), NULL);
			_tmp1 = (g_free (_tmp1), NULL);
			_tmp0 = (g_free (_tmp0), NULL);
			break;
		}
		case DEFINITION_SCOPE_PRIVATE:
		{
			char* _tmp9;
			char* _tmp8;
			char* _tmp7;
			char* _tmp6;
			char* _tmp5;
			_tmp9 = NULL;
			_tmp8 = NULL;
			_tmp7 = NULL;
			_tmp6 = NULL;
			_tmp5 = NULL;
			self->priv->members_declarations = (_tmp9 = g_strconcat (self->priv->members_declarations, (_tmp8 = (g_strconcat ((_tmp7 = g_strconcat ((_tmp6 = g_strconcat ((_tmp5 = g_strconcat ("\tprivate ", gtkaml_class_definition_get_base_full_name (class_definition), NULL)), " ", NULL)), gtkaml_class_definition_get_identifier (class_definition), NULL)), ";\n", NULL))), NULL), (self->priv->members_declarations = (g_free (self->priv->members_declarations), NULL)), _tmp9);
			_tmp8 = (g_free (_tmp8), NULL);
			_tmp7 = (g_free (_tmp7), NULL);
			_tmp6 = (g_free (_tmp6), NULL);
			_tmp5 = (g_free (_tmp5), NULL);
			break;
		}
		case DEFINITION_SCOPE_CONSTRUCTOR:
		{
			char* _tmp14;
			char* _tmp13;
			char* _tmp12;
			char* _tmp11;
			char* _tmp10;
			_tmp14 = NULL;
			_tmp13 = NULL;
			_tmp12 = NULL;
			_tmp11 = NULL;
			_tmp10 = NULL;
			self->priv->construct_body_locals = (_tmp14 = g_strconcat (self->priv->construct_body_locals, (_tmp13 = (g_strconcat ((_tmp12 = g_strconcat ((_tmp11 = g_strconcat ((_tmp10 = g_strconcat ("\t\t", gtkaml_class_definition_get_base_full_name (class_definition), NULL)), " ", NULL)), gtkaml_class_definition_get_identifier (class_definition), NULL)), ";\n", NULL))), NULL), (self->priv->construct_body_locals = (g_free (self->priv->construct_body_locals), NULL)), _tmp14);
			_tmp13 = (g_free (_tmp13), NULL);
			_tmp12 = (g_free (_tmp12), NULL);
			_tmp11 = (g_free (_tmp11), NULL);
			_tmp10 = (g_free (_tmp10), NULL);
			break;
		}
	}
}


void gtkaml_code_generator_write_root_constructor_parameters (GtkamlCodeGenerator* self, GtkamlRootClassDefinition* class_definition) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (class_definition != NULL);
	{
		GeeList* attr_collection;
		int attr_it;
		attr_collection = gtkaml_method_get_parameter_attributes (((GtkamlMethod*) (gtkaml_class_definition_get_construct_method (((GtkamlClassDefinition*) (class_definition))))));
		for (attr_it = 0; attr_it < gee_collection_get_size (GEE_COLLECTION (attr_collection)); attr_it = attr_it + 1) {
			GtkamlAttribute* attr;
			attr = ((GtkamlAttribute*) (gee_list_get (GEE_LIST (attr_collection), attr_it)));
			{
				gtkaml_code_generator_write_setter (self, ((GtkamlClassDefinition*) (class_definition)), attr);
				(attr == NULL ? NULL : (attr = (g_object_unref (attr), NULL)));
			}
		}
	}
}


void gtkaml_code_generator_write_constructor (GtkamlCodeGenerator* self, GtkamlClassDefinition* class_definition) {
	const char* _tmp0;
	char* construct_name;
	char* _tmp8;
	char* _tmp7;
	char* _tmp6;
	char* _tmp5;
	char* _tmp4;
	char* _tmp3;
	gint i;
	char* _tmp15;
	g_return_if_fail (self != NULL);
	g_return_if_fail (class_definition != NULL);
	_tmp0 = NULL;
	construct_name = (_tmp0 = gtkaml_method_get_name (((GtkamlMethod*) (gtkaml_class_definition_get_construct_method (class_definition)))), (_tmp0 == NULL ? NULL : g_strdup (_tmp0)));
	if (_vala_strcmp0 (construct_name, "new") != 0) {
		char* _tmp1;
		_tmp1 = NULL;
		construct_name = (_tmp1 = g_strconcat (".", construct_name, NULL), (construct_name = (g_free (construct_name), NULL)), _tmp1);
	} else {
		char* _tmp2;
		_tmp2 = NULL;
		construct_name = (_tmp2 = g_strdup (""), (construct_name = (g_free (construct_name), NULL)), _tmp2);
	}
	_tmp8 = NULL;
	_tmp7 = NULL;
	_tmp6 = NULL;
	_tmp5 = NULL;
	_tmp4 = NULL;
	_tmp3 = NULL;
	self->priv->constructors = (_tmp8 = g_strconcat (self->priv->constructors, (_tmp7 = (g_strconcat ((_tmp6 = g_strconcat ((_tmp5 = g_strconcat ((_tmp4 = g_strconcat ((_tmp3 = g_strconcat ("\t\t", gtkaml_class_definition_get_identifier (class_definition), NULL)), " = new ", NULL)), gtkaml_class_definition_get_base_full_name (class_definition), NULL)), construct_name, NULL)), " (", NULL))), NULL), (self->priv->constructors = (g_free (self->priv->constructors), NULL)), _tmp8);
	_tmp7 = (g_free (_tmp7), NULL);
	_tmp6 = (g_free (_tmp6), NULL);
	_tmp5 = (g_free (_tmp5), NULL);
	_tmp4 = (g_free (_tmp4), NULL);
	_tmp3 = (g_free (_tmp3), NULL);
	i = 0;
	for (; i < gee_collection_get_size (((GeeCollection*) (gtkaml_method_get_parameter_attributes (((GtkamlMethod*) (gtkaml_class_definition_get_construct_method (class_definition))))))) - 1; i++) {
		GtkamlAttribute* attr;
		char* _tmp11;
		char* _tmp10;
		char* _tmp9;
		attr = ((GtkamlAttribute*) (gee_list_get (gtkaml_method_get_parameter_attributes (((GtkamlMethod*) (gtkaml_class_definition_get_construct_method (class_definition)))), i)));
		_tmp11 = NULL;
		_tmp10 = NULL;
		_tmp9 = NULL;
		self->priv->constructors = (_tmp11 = g_strconcat (self->priv->constructors, (_tmp10 = (g_strconcat ((_tmp9 = gtkaml_code_generator_generate_literal (self, attr)), ", ", NULL))), NULL), (self->priv->constructors = (g_free (self->priv->constructors), NULL)), _tmp11);
		_tmp10 = (g_free (_tmp10), NULL);
		_tmp9 = (g_free (_tmp9), NULL);
		(attr == NULL ? NULL : (attr = (g_object_unref (attr), NULL)));
	}
	if (i < gee_collection_get_size (((GeeCollection*) (gtkaml_method_get_parameter_attributes (((GtkamlMethod*) (gtkaml_class_definition_get_construct_method (class_definition)))))))) {
		char* _tmp14;
		char* _tmp13;
		GtkamlAttribute* _tmp12;
		_tmp14 = NULL;
		_tmp13 = NULL;
		_tmp12 = NULL;
		self->priv->constructors = (_tmp14 = g_strconcat (self->priv->constructors, (_tmp13 = (gtkaml_code_generator_generate_literal (self, (_tmp12 = ((GtkamlAttribute*) (gee_list_get (gtkaml_method_get_parameter_attributes (((GtkamlMethod*) (gtkaml_class_definition_get_construct_method (class_definition)))), i))))))), NULL), (self->priv->constructors = (g_free (self->priv->constructors), NULL)), _tmp14);
		_tmp13 = (g_free (_tmp13), NULL);
		(_tmp12 == NULL ? NULL : (_tmp12 = (g_object_unref (_tmp12), NULL)));
	}
	_tmp15 = NULL;
	self->priv->constructors = (_tmp15 = g_strconcat (self->priv->constructors, (");\n"), NULL), (self->priv->constructors = (g_free (self->priv->constructors), NULL)), _tmp15);
	construct_name = (g_free (construct_name), NULL);
}


void gtkaml_code_generator_write_add (GtkamlCodeGenerator* self, GtkamlClassDefinition* child_definition) {
	char* _tmp1;
	char* _tmp0;
	gint i;
	char* _tmp8;
	g_return_if_fail (self != NULL);
	g_return_if_fail (child_definition != NULL);
	if (gtkaml_class_definition_get_parent_container (child_definition) == NULL) {
		return;
	}
	_tmp1 = NULL;
	_tmp0 = NULL;
	self->priv->construct_body = (_tmp1 = g_strconcat (self->priv->construct_body, (_tmp0 = (g_strdup_printf ("\t\t%s.%s (", gtkaml_class_definition_get_identifier (gtkaml_class_definition_get_parent_container (child_definition)), gtkaml_method_get_name (((GtkamlMethod*) (gtkaml_class_definition_get_add_method (child_definition))))))), NULL), (self->priv->construct_body = (g_free (self->priv->construct_body), NULL)), _tmp1);
	_tmp0 = (g_free (_tmp0), NULL);
	i = 0;
	for (; i < gee_collection_get_size (((GeeCollection*) (gtkaml_method_get_parameter_attributes (((GtkamlMethod*) (gtkaml_class_definition_get_add_method (child_definition))))))) - 1; i++) {
		GtkamlAttribute* attr;
		char* _tmp4;
		char* _tmp3;
		char* _tmp2;
		attr = ((GtkamlAttribute*) (gee_list_get (gtkaml_method_get_parameter_attributes (((GtkamlMethod*) (gtkaml_class_definition_get_add_method (child_definition)))), i)));
		_tmp4 = NULL;
		_tmp3 = NULL;
		_tmp2 = NULL;
		self->priv->construct_body = (_tmp4 = g_strconcat (self->priv->construct_body, (_tmp3 = (g_strconcat ((_tmp2 = gtkaml_code_generator_generate_literal (self, attr)), ", ", NULL))), NULL), (self->priv->construct_body = (g_free (self->priv->construct_body), NULL)), _tmp4);
		_tmp3 = (g_free (_tmp3), NULL);
		_tmp2 = (g_free (_tmp2), NULL);
		(attr == NULL ? NULL : (attr = (g_object_unref (attr), NULL)));
	}
	if (i < gee_collection_get_size (((GeeCollection*) (gtkaml_method_get_parameter_attributes (((GtkamlMethod*) (gtkaml_class_definition_get_add_method (child_definition)))))))) {
		char* _tmp7;
		char* _tmp6;
		GtkamlAttribute* _tmp5;
		_tmp7 = NULL;
		_tmp6 = NULL;
		_tmp5 = NULL;
		self->priv->construct_body = (_tmp7 = g_strconcat (self->priv->construct_body, (_tmp6 = (gtkaml_code_generator_generate_literal (self, (_tmp5 = ((GtkamlAttribute*) (gee_list_get (gtkaml_method_get_parameter_attributes (((GtkamlMethod*) (gtkaml_class_definition_get_add_method (child_definition)))), i))))))), NULL), (self->priv->construct_body = (g_free (self->priv->construct_body), NULL)), _tmp7);
		_tmp6 = (g_free (_tmp6), NULL);
		(_tmp5 == NULL ? NULL : (_tmp5 = (g_object_unref (_tmp5), NULL)));
	}
	_tmp8 = NULL;
	self->priv->construct_body = (_tmp8 = g_strconcat (self->priv->construct_body, (");\n"), NULL), (self->priv->construct_body = (g_free (self->priv->construct_body), NULL)), _tmp8);
}


void gtkaml_code_generator_write_setters (GtkamlCodeGenerator* self, GtkamlClassDefinition* class_definition) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (class_definition != NULL);
	{
		GeeList* attr_collection;
		int attr_it;
		attr_collection = gtkaml_class_definition_get_attrs (class_definition);
		for (attr_it = 0; attr_it < gee_collection_get_size (GEE_COLLECTION (attr_collection)); attr_it = attr_it + 1) {
			GtkamlAttribute* attr;
			attr = ((GtkamlAttribute*) (gee_list_get (GEE_LIST (attr_collection), attr_it)));
			{
				if (VALA_IS_FIELD (gtkaml_attribute_get_target_type (attr))) {
					gtkaml_code_generator_write_setter (self, class_definition, attr);
				} else {
					if (VALA_IS_PROPERTY (gtkaml_attribute_get_target_type (attr))) {
						gtkaml_code_generator_write_setter (self, class_definition, attr);
					} else {
						if (VALA_IS_SIGNAL (gtkaml_attribute_get_target_type (attr))) {
							gtkaml_code_generator_write_signal_setter (self, class_definition, attr);
						} else {
							char* _tmp0;
							_tmp0 = NULL;
							vala_report_error (gtkaml_class_definition_get_source_reference (class_definition), (_tmp0 = g_strdup_printf ("Unknown attribute type %s", gtkaml_attribute_get_name (attr))));
							_tmp0 = (g_free (_tmp0), NULL);
							(attr == NULL ? NULL : (attr = (g_object_unref (attr), NULL)));
							return;
						}
					}
				}
				(attr == NULL ? NULL : (attr = (g_object_unref (attr), NULL)));
			}
		}
	}
}


char* gtkaml_code_generator_prefix_to_namespace (GtkamlCodeGenerator* self, const char* prefix) {
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (prefix != NULL, NULL);
	return ((char*) (gee_map_get (gtkaml_root_class_definition_get_prefixes_namespaces (self->priv->_root_class_definition), ((prefix == NULL) ? "" : prefix))));
}


void gtkaml_code_generator_write_using (GtkamlCodeGenerator* self, const char* ns) {
	char* _tmp1;
	char* _tmp0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (ns != NULL);
	_tmp1 = NULL;
	_tmp0 = NULL;
	self->priv->using_directives = (_tmp1 = g_strconcat (self->priv->using_directives, (_tmp0 = (g_strdup_printf ("using %s;\n", ns))), NULL), (self->priv->using_directives = (g_free (self->priv->using_directives), NULL)), _tmp1);
	_tmp0 = (g_free (_tmp0), NULL);
}


char* gtkaml_code_generator_generate_literal (GtkamlCodeGenerator* self, GtkamlAttribute* attr) {
	char* literal;
	ValaDataType* type;
	const char* _tmp4;
	GtkamlAttribute* _tmp3;
	char* value;
	const char* _tmp15;
	char* stripped_value;
	char* _tmp31;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (attr != NULL, NULL);
	literal = NULL;
	type = NULL;
	if (GTKAML_IS_COMPLEX_ATTRIBUTE (attr)) {
		const char* _tmp1;
		GtkamlAttribute* _tmp0;
		char* _tmp2;
		_tmp1 = NULL;
		_tmp0 = NULL;
		_tmp2 = NULL;
		return (_tmp2 = (_tmp1 = gtkaml_class_definition_get_identifier (gtkaml_complex_attribute_get_complex_type (((_tmp0 = attr, (GTKAML_IS_COMPLEX_ATTRIBUTE (_tmp0) ? ((GtkamlComplexAttribute*) (_tmp0)) : NULL))))), (_tmp1 == NULL ? NULL : g_strdup (_tmp1))), (literal = (g_free (literal), NULL)), (type == NULL ? NULL : (type = (vala_code_node_unref (type), NULL))), _tmp2);
	}
	_tmp4 = NULL;
	_tmp3 = NULL;
	value = (_tmp4 = gtkaml_simple_attribute_get_value (((_tmp3 = attr, (GTKAML_IS_SIMPLE_ATTRIBUTE (_tmp3) ? ((GtkamlSimpleAttribute*) (_tmp3)) : NULL)))), (_tmp4 == NULL ? NULL : g_strdup (_tmp4)));
	if (VALA_IS_FIELD (gtkaml_attribute_get_target_type (attr))) {
		ValaDataType* _tmp7;
		ValaDataType* _tmp6;
		ValaSymbol* _tmp5;
		_tmp7 = NULL;
		_tmp6 = NULL;
		_tmp5 = NULL;
		type = (_tmp7 = (_tmp6 = vala_field_get_field_type (((_tmp5 = gtkaml_attribute_get_target_type (attr), (VALA_IS_FIELD (_tmp5) ? ((ValaField*) (_tmp5)) : NULL)))), (_tmp6 == NULL ? NULL : vala_code_node_ref (_tmp6))), (type == NULL ? NULL : (type = (vala_code_node_unref (type), NULL))), _tmp7);
	} else {
		if (VALA_IS_PROPERTY (gtkaml_attribute_get_target_type (attr))) {
			ValaDataType* _tmp10;
			ValaDataType* _tmp9;
			ValaSymbol* _tmp8;
			_tmp10 = NULL;
			_tmp9 = NULL;
			_tmp8 = NULL;
			type = (_tmp10 = (_tmp9 = vala_property_get_property_type (((_tmp8 = gtkaml_attribute_get_target_type (attr), (VALA_IS_PROPERTY (_tmp8) ? ((ValaProperty*) (_tmp8)) : NULL)))), (_tmp9 == NULL ? NULL : vala_code_node_ref (_tmp9))), (type == NULL ? NULL : (type = (vala_code_node_unref (type), NULL))), _tmp10);
		} else {
			if (VALA_IS_FORMAL_PARAMETER (gtkaml_attribute_get_target_type (attr))) {
				ValaDataType* _tmp13;
				ValaDataType* _tmp12;
				ValaSymbol* _tmp11;
				_tmp13 = NULL;
				_tmp12 = NULL;
				_tmp11 = NULL;
				type = (_tmp13 = (_tmp12 = vala_formal_parameter_get_parameter_type (((_tmp11 = gtkaml_attribute_get_target_type (attr), (VALA_IS_FORMAL_PARAMETER (_tmp11) ? ((ValaFormalParameter*) (_tmp11)) : NULL)))), (_tmp12 == NULL ? NULL : vala_code_node_ref (_tmp12))), (type == NULL ? NULL : (type = (vala_code_node_unref (type), NULL))), _tmp13);
			} else {
				char* _tmp14;
				_tmp14 = NULL;
				vala_report_error (NULL, (_tmp14 = g_strdup_printf ("The attribute %s with value %s is not Field, Property or FormalParameter", gtkaml_attribute_get_name (attr), value)));
				_tmp14 = (g_free (_tmp14), NULL);
			}
		}
	}
	_tmp15 = NULL;
	stripped_value = (_tmp15 = value, (_tmp15 == NULL ? NULL : g_strdup (_tmp15)));
	g_strstrip (stripped_value);
	if (g_str_has_prefix (stripped_value, "{")) {
		if (g_str_has_suffix (stripped_value, "}")) {
			char* _tmp17;
			char* _tmp16;
			_tmp17 = NULL;
			_tmp16 = NULL;
			literal = (_tmp17 = (_tmp16 = g_utf8_offset_to_pointer (stripped_value, ((glong) (1))), g_strndup (_tmp16, g_utf8_offset_to_pointer (_tmp16, g_utf8_strlen (stripped_value, -1) - 2) - _tmp16)), (literal = (g_free (literal), NULL)), _tmp17);
		} else {
			char* _tmp18;
			_tmp18 = NULL;
			vala_report_error (NULL, (_tmp18 = g_strdup_printf ("Attribute %s not properly ended", gtkaml_attribute_get_name (attr))));
			_tmp18 = (g_free (_tmp18), NULL);
		}
	} else {
		if (VALA_IS_UNRESOLVED_TYPE (type)) {
			ValaUnresolvedType* _tmp20;
			ValaDataType* _tmp19;
			ValaUnresolvedType* utype;
			_tmp20 = NULL;
			_tmp19 = NULL;
			utype = (_tmp20 = (_tmp19 = type, (VALA_IS_UNRESOLVED_TYPE (_tmp19) ? ((ValaUnresolvedType*) (_tmp19)) : NULL)), (_tmp20 == NULL ? NULL : vala_code_node_ref (_tmp20)));
			if (_vala_strcmp0 (vala_symbol_get_name (((ValaSymbol*) (vala_unresolved_type_get_unresolved_symbol (utype)))), "string") == 0) {
				char* _tmp23;
				char* _tmp22;
				char* _tmp21;
				_tmp23 = NULL;
				_tmp22 = NULL;
				_tmp21 = NULL;
				literal = (_tmp23 = g_strconcat ((_tmp22 = g_strconcat ("\"", (_tmp21 = g_strescape (value, "")), NULL)), "\"", NULL), (literal = (g_free (literal), NULL)), _tmp23);
				_tmp22 = (g_free (_tmp22), NULL);
				_tmp21 = (g_free (_tmp21), NULL);
			} else {
				if (_vala_strcmp0 (vala_symbol_get_name (((ValaSymbol*) (vala_unresolved_type_get_unresolved_symbol (utype)))), "bool") == 0) {
					char* _tmp26;
					const char* _tmp25;
					if (_vala_strcmp0 (stripped_value, "true") != 0 && _vala_strcmp0 (stripped_value, "false") != 0) {
						char* _tmp24;
						_tmp24 = NULL;
						vala_report_error (NULL, (_tmp24 = g_strdup_printf ("'%s' is not a boolean literal", value)));
						_tmp24 = (g_free (_tmp24), NULL);
					}
					_tmp26 = NULL;
					_tmp25 = NULL;
					literal = (_tmp26 = (_tmp25 = stripped_value, (_tmp25 == NULL ? NULL : g_strdup (_tmp25))), (literal = (g_free (literal), NULL)), _tmp26);
				} else {
					char* _tmp28;
					const char* _tmp27;
					_tmp28 = NULL;
					_tmp27 = NULL;
					literal = (_tmp28 = (_tmp27 = stripped_value, (_tmp27 == NULL ? NULL : g_strdup (_tmp27))), (literal = (g_free (literal), NULL)), _tmp28);
				}
			}
			(utype == NULL ? NULL : (utype = (vala_code_node_unref (utype), NULL)));
		} else {
			char* _tmp29;
			char* _tmp30;
			_tmp29 = NULL;
			vala_report_error (NULL, (_tmp29 = g_strdup_printf ("Don't know any literal of type '%s'\n", vala_symbol_get_name (gtkaml_attribute_get_target_type (attr)))));
			_tmp29 = (g_free (_tmp29), NULL);
			_tmp30 = NULL;
			return (_tmp30 = stripped_value, (literal = (g_free (literal), NULL)), (type == NULL ? NULL : (type = (vala_code_node_unref (type), NULL))), (value = (g_free (value), NULL)), _tmp30);
		}
	}
	_tmp31 = NULL;
	return (_tmp31 = literal, (type == NULL ? NULL : (type = (vala_code_node_unref (type), NULL))), (value = (g_free (value), NULL)), (stripped_value = (g_free (stripped_value), NULL)), _tmp31);
}


void gtkaml_code_generator_write_setter (GtkamlCodeGenerator* self, GtkamlClassDefinition* class_definition, GtkamlAttribute* attr) {
	char* _tmp2;
	char* _tmp1;
	char* _tmp0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (class_definition != NULL);
	g_return_if_fail (attr != NULL);
	_tmp2 = NULL;
	_tmp1 = NULL;
	_tmp0 = NULL;
	self->priv->construct_body = (_tmp2 = g_strconcat (self->priv->construct_body, (_tmp1 = (g_strdup_printf ("\t\t%s.%s = %s;\n", gtkaml_class_definition_get_identifier (class_definition), gtkaml_attribute_get_name (attr), (_tmp0 = gtkaml_code_generator_generate_literal (self, attr))))), NULL), (self->priv->construct_body = (g_free (self->priv->construct_body), NULL)), _tmp2);
	_tmp1 = (g_free (_tmp1), NULL);
	_tmp0 = (g_free (_tmp0), NULL);
}


void gtkaml_code_generator_write_signal_setter (GtkamlCodeGenerator* self, GtkamlClassDefinition* class_definition, GtkamlAttribute* signal_attr) {
	GtkamlSimpleAttribute* _tmp2;
	GtkamlAttribute* _tmp1;
	GtkamlSimpleAttribute* simple_attribute;
	ValaSignal* _tmp4;
	ValaSymbol* _tmp3;
	ValaSignal* the_signal;
	char* parameters_joined;
	const char* _tmp5;
	char* body;
	GeeList* parameters;
	char** _tmp11;
	gint parameter_names_length1;
	char** parameter_names;
	gint i;
	char* _tmp12;
	g_return_if_fail (self != NULL);
	g_return_if_fail (class_definition != NULL);
	g_return_if_fail (signal_attr != NULL);
	if (!(GTKAML_IS_SIMPLE_ATTRIBUTE (signal_attr))) {
		char* _tmp0;
		_tmp0 = NULL;
		vala_report_error (gtkaml_class_definition_get_source_reference (class_definition), (_tmp0 = g_strdup_printf ("Cannot set the signal '%s' to this value.", gtkaml_attribute_get_name (signal_attr))));
		_tmp0 = (g_free (_tmp0), NULL);
		return;
	}
	_tmp2 = NULL;
	_tmp1 = NULL;
	simple_attribute = (_tmp2 = (_tmp1 = signal_attr, (GTKAML_IS_SIMPLE_ATTRIBUTE (_tmp1) ? ((GtkamlSimpleAttribute*) (_tmp1)) : NULL)), (_tmp2 == NULL ? NULL : g_object_ref (_tmp2)));
	_tmp4 = NULL;
	_tmp3 = NULL;
	the_signal = (_tmp4 = (_tmp3 = gtkaml_attribute_get_target_type (((GtkamlAttribute*) (simple_attribute))), (VALA_IS_SIGNAL (_tmp3) ? ((ValaSignal*) (_tmp3)) : NULL)), (_tmp4 == NULL ? NULL : vala_code_node_ref (_tmp4)));
	parameters_joined = g_strdup ("");
	_tmp5 = NULL;
	body = (_tmp5 = gtkaml_simple_attribute_get_value (simple_attribute), (_tmp5 == NULL ? NULL : g_strdup (_tmp5)));
	g_strstrip (body);
	if (g_str_has_prefix (body, "{")) {
		if (g_str_has_suffix (body, "}")) {
			char* _tmp7;
			char* _tmp6;
			char* _tmp9;
			char* _tmp8;
			_tmp7 = NULL;
			_tmp6 = NULL;
			parameters_joined = (_tmp7 = (_tmp6 = g_utf8_offset_to_pointer (body, ((glong) (1))), g_strndup (_tmp6, g_utf8_offset_to_pointer (_tmp6, g_utf8_strlen (body, -1) - 2) - _tmp6)), (parameters_joined = (g_free (parameters_joined), NULL)), _tmp7);
			_tmp9 = NULL;
			_tmp8 = NULL;
			self->priv->construct_body = (_tmp9 = g_strconcat (self->priv->construct_body, (_tmp8 = (g_strdup_printf ("\t\t%s.%s += %s;\n", gtkaml_class_definition_get_identifier (class_definition), gtkaml_attribute_get_name (signal_attr), parameters_joined))), NULL), (self->priv->construct_body = (g_free (self->priv->construct_body), NULL)), _tmp9);
			_tmp8 = (g_free (_tmp8), NULL);
			(simple_attribute == NULL ? NULL : (simple_attribute = (g_object_unref (simple_attribute), NULL)));
			(the_signal == NULL ? NULL : (the_signal = (vala_code_node_unref (the_signal), NULL)));
			parameters_joined = (g_free (parameters_joined), NULL);
			body = (g_free (body), NULL);
			return;
		} else {
			char* _tmp10;
			_tmp10 = NULL;
			vala_report_error (gtkaml_class_definition_get_source_reference (class_definition), (_tmp10 = g_strdup_printf ("Signal %s not properly ended", gtkaml_attribute_get_name (signal_attr))));
			_tmp10 = (g_free (_tmp10), NULL);
			(simple_attribute == NULL ? NULL : (simple_attribute = (g_object_unref (simple_attribute), NULL)));
			(the_signal == NULL ? NULL : (the_signal = (vala_code_node_unref (the_signal), NULL)));
			parameters_joined = (g_free (parameters_joined), NULL);
			body = (g_free (body), NULL);
			return;
		}
	}
	parameters = vala_signal_get_parameters (the_signal);
	_tmp11 = NULL;
	parameter_names = (_tmp11 = g_new0 (char*, 0 + 1), parameter_names_length1 = 0, _tmp11);
	i = 0;
	_tmp12 = NULL;
	parameters_joined = (_tmp12 = g_strdup ("target"), (parameters_joined = (g_free (parameters_joined), NULL)), _tmp12);
	if (gee_collection_get_size (((GeeCollection*) (parameters))) > 0) {
		gint _tmp13;
		gint _tmp18;
		char* _tmp17;
		char* _tmp21;
		char* _tmp20;
		char* _tmp19;
		char* _tmp23;
		char* _tmp22;
		_tmp13 = gee_collection_get_size (((GeeCollection*) (parameters))) + 1;
		parameter_names = g_renew (char*, parameter_names, gee_collection_get_size (((GeeCollection*) (parameters))) + 1);
		(_tmp13 > parameter_names_length1 ? memset (parameter_names + parameter_names_length1, 0, sizeof (char*) * (_tmp13 - parameter_names_length1)) : NULL);
		parameter_names_length1 = _tmp13;
		{
			GeeList* p_collection;
			int p_it;
			p_collection = parameters;
			for (p_it = 0; p_it < gee_collection_get_size (GEE_COLLECTION (p_collection)); p_it = p_it + 1) {
				ValaFormalParameter* p;
				p = ((ValaFormalParameter*) (gee_list_get (GEE_LIST (p_collection), p_it)));
				{
					gint _tmp16;
					char* _tmp15;
					const char* _tmp14;
					_tmp15 = NULL;
					_tmp14 = NULL;
					_tmp16 = i++;
					parameter_names[_tmp16] = (_tmp15 = (_tmp14 = vala_symbol_get_name (((ValaSymbol*) (p))), (_tmp14 == NULL ? NULL : g_strdup (_tmp14))), (parameter_names[_tmp16] = (g_free (parameter_names[_tmp16]), NULL)), _tmp15);
					(p == NULL ? NULL : (p = (vala_code_node_unref (p), NULL)));
				}
			}
		}
		_tmp17 = NULL;
		_tmp18 = gee_collection_get_size (((GeeCollection*) (parameters)));
		parameter_names[_tmp18] = (_tmp17 = NULL, (parameter_names[_tmp18] = (g_free (parameter_names[_tmp18]), NULL)), _tmp17);
		_tmp21 = NULL;
		_tmp20 = NULL;
		_tmp19 = NULL;
		parameters_joined = (_tmp21 = g_strconcat (parameters_joined, (_tmp20 = (g_strconcat (", ", (_tmp19 = g_strjoinv (",", parameter_names)), NULL))), NULL), (parameters_joined = (g_free (parameters_joined), NULL)), _tmp21);
		_tmp20 = (g_free (_tmp20), NULL);
		_tmp19 = (g_free (_tmp19), NULL);
		_tmp23 = NULL;
		_tmp22 = NULL;
		self->priv->construct_body = (_tmp23 = g_strconcat (self->priv->construct_body, (_tmp22 = (g_strdup_printf ("\t\t%s.%s += (%s) => { %s; };\n", gtkaml_class_definition_get_identifier (class_definition), gtkaml_attribute_get_name (signal_attr), parameters_joined, gtkaml_simple_attribute_get_value (simple_attribute)))), NULL), (self->priv->construct_body = (g_free (self->priv->construct_body), NULL)), _tmp23);
		_tmp22 = (g_free (_tmp22), NULL);
	} else {
		char* _tmp25;
		char* _tmp24;
		_tmp25 = NULL;
		_tmp24 = NULL;
		self->priv->construct_body = (_tmp25 = g_strconcat (self->priv->construct_body, (_tmp24 = (g_strdup_printf ("\t\t%s.%s += %s => { %s; };\n", gtkaml_class_definition_get_identifier (class_definition), gtkaml_attribute_get_name (signal_attr), parameters_joined, gtkaml_simple_attribute_get_value (simple_attribute)))), NULL), (self->priv->construct_body = (g_free (self->priv->construct_body), NULL)), _tmp25);
		_tmp24 = (g_free (_tmp24), NULL);
	}
	(simple_attribute == NULL ? NULL : (simple_attribute = (g_object_unref (simple_attribute), NULL)));
	(the_signal == NULL ? NULL : (the_signal = (vala_code_node_unref (the_signal), NULL)));
	parameters_joined = (g_free (parameters_joined), NULL);
	body = (g_free (body), NULL);
	(parameters == NULL ? NULL : (parameters = (gee_collection_object_unref (parameters), NULL)));
	parameter_names = (_vala_array_free (parameter_names, parameter_names_length1, ((GDestroyNotify) (g_free))), NULL);
}


void gtkaml_code_generator_add_code (GtkamlCodeGenerator* self, const char* value) {
	char* _tmp1;
	char* _tmp0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (value != NULL);
	_tmp1 = NULL;
	_tmp0 = NULL;
	self->priv->code = (_tmp1 = g_strconcat (self->priv->code, (_tmp0 = (g_strconcat (value, "\n", NULL))), NULL), (self->priv->code = (g_free (self->priv->code), NULL)), _tmp1);
	_tmp0 = (g_free (_tmp0), NULL);
}


ValaCodeContext* gtkaml_code_generator_get_context (GtkamlCodeGenerator* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return self->priv->_context;
}


static void gtkaml_code_generator_set_context (GtkamlCodeGenerator* self, ValaCodeContext* value) {
	ValaCodeContext* _tmp2;
	ValaCodeContext* _tmp1;
	g_return_if_fail (self != NULL);
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->_context = (_tmp2 = (_tmp1 = value, (_tmp1 == NULL ? NULL : vala_code_context_ref (_tmp1))), (self->priv->_context == NULL ? NULL : (self->priv->_context = (vala_code_context_unref (self->priv->_context), NULL))), _tmp2);
	g_object_notify (((GObject *) (self)), "context");
}


static GtkamlRootClassDefinition* gtkaml_code_generator_get_root_class_definition (GtkamlCodeGenerator* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return self->priv->_root_class_definition;
}


static void gtkaml_code_generator_set_root_class_definition (GtkamlCodeGenerator* self, GtkamlRootClassDefinition* value) {
	GtkamlRootClassDefinition* _tmp2;
	GtkamlRootClassDefinition* _tmp1;
	g_return_if_fail (self != NULL);
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->_root_class_definition = (_tmp2 = (_tmp1 = value, (_tmp1 == NULL ? NULL : g_object_ref (_tmp1))), (self->priv->_root_class_definition == NULL ? NULL : (self->priv->_root_class_definition = (g_object_unref (self->priv->_root_class_definition), NULL))), _tmp2);
}


static void gtkaml_code_generator_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	GtkamlCodeGenerator * self;
	self = GTKAML_CODE_GENERATOR (object);
	switch (property_id) {
		case GTKAML_CODE_GENERATOR_CONTEXT:
		vala_value_set_code_context (value, gtkaml_code_generator_get_context (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void gtkaml_code_generator_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	GtkamlCodeGenerator * self;
	self = GTKAML_CODE_GENERATOR (object);
	switch (property_id) {
		case GTKAML_CODE_GENERATOR_CONTEXT:
		gtkaml_code_generator_set_context (self, vala_value_get_code_context (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void gtkaml_code_generator_class_init (GtkamlCodeGeneratorClass * klass) {
	gtkaml_code_generator_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (GtkamlCodeGeneratorPrivate));
	G_OBJECT_CLASS (klass)->get_property = gtkaml_code_generator_get_property;
	G_OBJECT_CLASS (klass)->set_property = gtkaml_code_generator_set_property;
	G_OBJECT_CLASS (klass)->finalize = gtkaml_code_generator_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GTKAML_CODE_GENERATOR_CONTEXT, vala_param_spec_code_context ("context", "context", "context", VALA_TYPE_CODE_CONTEXT, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void gtkaml_code_generator_instance_init (GtkamlCodeGenerator * self) {
	self->priv = GTKAML_CODE_GENERATOR_GET_PRIVATE (self);
	self->priv->using_directives = g_new0 (char, 1);
	self->priv->class_start = g_new0 (char, 1);
	self->priv->members_declarations = g_new0 (char, 1);
	self->priv->code = g_new0 (char, 1);
	self->priv->construct_signals = g_new0 (char, 1);
	self->priv->constructors = g_new0 (char, 1);
	self->priv->construct_body_locals = g_new0 (char, 1);
	self->priv->construct_body = g_new0 (char, 1);
	self->priv->class_end = g_new0 (char, 1);
}


static void gtkaml_code_generator_finalize (GObject* obj) {
	GtkamlCodeGenerator * self;
	self = GTKAML_CODE_GENERATOR (obj);
	self->priv->using_directives = (g_free (self->priv->using_directives), NULL);
	self->priv->class_start = (g_free (self->priv->class_start), NULL);
	self->priv->members_declarations = (g_free (self->priv->members_declarations), NULL);
	self->priv->code = (g_free (self->priv->code), NULL);
	self->priv->construct_signals = (g_free (self->priv->construct_signals), NULL);
	self->priv->constructors = (g_free (self->priv->constructors), NULL);
	self->priv->construct_body_locals = (g_free (self->priv->construct_body_locals), NULL);
	self->priv->construct_body = (g_free (self->priv->construct_body), NULL);
	self->priv->class_end = (g_free (self->priv->class_end), NULL);
	(self->priv->_context == NULL ? NULL : (self->priv->_context = (vala_code_context_unref (self->priv->_context), NULL)));
	(self->priv->_root_class_definition == NULL ? NULL : (self->priv->_root_class_definition = (g_object_unref (self->priv->_root_class_definition), NULL)));
	G_OBJECT_CLASS (gtkaml_code_generator_parent_class)->finalize (obj);
}


GType gtkaml_code_generator_get_type (void) {
	static GType gtkaml_code_generator_type_id = 0;
	if (gtkaml_code_generator_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (GtkamlCodeGeneratorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gtkaml_code_generator_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GtkamlCodeGenerator), 0, (GInstanceInitFunc) gtkaml_code_generator_instance_init, NULL };
		gtkaml_code_generator_type_id = g_type_register_static (G_TYPE_OBJECT, "GtkamlCodeGenerator", &g_define_type_info, 0);
	}
	return gtkaml_code_generator_type_id;
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if (array != NULL && destroy_func != NULL) {
		int i;
		if (array_length >= 0)
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) (array))[i] != NULL)
			destroy_func (((gpointer*) (array))[i]);
		}
		else
		for (i = 0; ((gpointer*) (array))[i] != NULL; i = i + 1) {
			destroy_func (((gpointer*) (array))[i]);
		}
	}
	g_free (array);
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return (str1 != str2);
	}
	return strcmp (str1, str2);
}




