/* GtkamlClassDefinition.vala
 *
 * Copyright (C) 2008 Vlad Grecescu
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with main.c; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor Boston, MA 02110-1301,  USA
 *
 * Author:
 *        Vlad Grecescu (b100dian@gmail.com)
 */

#ifndef __GTKAMLCLASSDEFINITION_H__
#define __GTKAMLCLASSDEFINITION_H__

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <vala/valaclass.h>
#include <vala/valasourcereference.h>
#include <gee/list.h>
#include "GtkamlAttribute.h"
#include "GtkamlMethod.h"

G_BEGIN_DECLS


#define TYPE_DEFINITION_SCOPE (definition_scope_get_type ())

#define GTKAML_TYPE_CLASS_DEFINITION (gtkaml_class_definition_get_type ())
#define GTKAML_CLASS_DEFINITION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GTKAML_TYPE_CLASS_DEFINITION, GtkamlClassDefinition))
#define GTKAML_CLASS_DEFINITION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GTKAML_TYPE_CLASS_DEFINITION, GtkamlClassDefinitionClass))
#define GTKAML_IS_CLASS_DEFINITION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GTKAML_TYPE_CLASS_DEFINITION))
#define GTKAML_IS_CLASS_DEFINITION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GTKAML_TYPE_CLASS_DEFINITION))
#define GTKAML_CLASS_DEFINITION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GTKAML_TYPE_CLASS_DEFINITION, GtkamlClassDefinitionClass))

typedef struct _GtkamlClassDefinition GtkamlClassDefinition;
typedef struct _GtkamlClassDefinitionClass GtkamlClassDefinitionClass;
typedef struct _GtkamlClassDefinitionPrivate GtkamlClassDefinitionPrivate;

typedef enum  {
	DEFINITION_SCOPE_MAIN_CLASS = 0,
	DEFINITION_SCOPE_PUBLIC,
	DEFINITION_SCOPE_PRIVATE,
	DEFINITION_SCOPE_CONSTRUCTOR
} DefinitionScope;

/** represents a gtkaml tag */
struct _GtkamlClassDefinition {
	GObject parent_instance;
	GtkamlClassDefinitionPrivate * priv;
};

struct _GtkamlClassDefinitionClass {
	GObjectClass parent_class;
};


GType definition_scope_get_type (void);
GtkamlClassDefinition* gtkaml_class_definition_construct (GType object_type, ValaSourceReference* source_reference, const char* identifier, const char* base_ns, ValaClass* base_type, DefinitionScope definition_scope, GtkamlClassDefinition* parent_container);
GtkamlClassDefinition* gtkaml_class_definition_new (ValaSourceReference* source_reference, const char* identifier, const char* base_ns, ValaClass* base_type, DefinitionScope definition_scope, GtkamlClassDefinition* parent_container);
void gtkaml_class_definition_add_attribute (GtkamlClassDefinition* self, GtkamlAttribute* attr);
void gtkaml_class_definition_add_child (GtkamlClassDefinition* self, GtkamlClassDefinition* child);
ValaSourceReference* gtkaml_class_definition_get_source_reference (GtkamlClassDefinition* self);
void gtkaml_class_definition_set_source_reference (GtkamlClassDefinition* self, ValaSourceReference* value);
const char* gtkaml_class_definition_get_identifier (GtkamlClassDefinition* self);
void gtkaml_class_definition_set_identifier (GtkamlClassDefinition* self, const char* value);
char* gtkaml_class_definition_get_base_full_name (GtkamlClassDefinition* self);
const char* gtkaml_class_definition_get_base_ns (GtkamlClassDefinition* self);
void gtkaml_class_definition_set_base_ns (GtkamlClassDefinition* self, const char* value);
ValaClass* gtkaml_class_definition_get_base_type (GtkamlClassDefinition* self);
void gtkaml_class_definition_set_base_type (GtkamlClassDefinition* self, ValaClass* value);
GeeList* gtkaml_class_definition_get_attrs (GtkamlClassDefinition* self);
void gtkaml_class_definition_set_attrs (GtkamlClassDefinition* self, GeeList* value);
GtkamlClassDefinition* gtkaml_class_definition_get_parent_container (GtkamlClassDefinition* self);
void gtkaml_class_definition_set_parent_container (GtkamlClassDefinition* self, GtkamlClassDefinition* value);
GeeList* gtkaml_class_definition_get_children (GtkamlClassDefinition* self);
void gtkaml_class_definition_set_children (GtkamlClassDefinition* self, GeeList* value);
DefinitionScope gtkaml_class_definition_get_definition_scope (GtkamlClassDefinition* self);
void gtkaml_class_definition_set_definition_scope (GtkamlClassDefinition* self, DefinitionScope value);
GtkamlConstructMethod* gtkaml_class_definition_get_construct_method (GtkamlClassDefinition* self);
void gtkaml_class_definition_set_construct_method (GtkamlClassDefinition* self, GtkamlConstructMethod* value);
GtkamlAddMethod* gtkaml_class_definition_get_add_method (GtkamlClassDefinition* self);
void gtkaml_class_definition_set_add_method (GtkamlClassDefinition* self, GtkamlAddMethod* value);
const char* gtkaml_class_definition_get_construct_code (GtkamlClassDefinition* self);
void gtkaml_class_definition_set_construct_code (GtkamlClassDefinition* self, const char* value);
const char* gtkaml_class_definition_get_preconstruct_code (GtkamlClassDefinition* self);
void gtkaml_class_definition_set_preconstruct_code (GtkamlClassDefinition* self, const char* value);
GType gtkaml_class_definition_get_type (void);


G_END_DECLS

#endif
