/* GtkamlXmlAttribute.vala
 * 
 * Copyright (C) 2008 Vlad Grecescu
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with main.c; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor Boston, MA 02110-1301,  USA
 *
 * Author:
 *        Vlad Grecescu (b100dian@gmail.com)
 */

#ifndef __GTKAMLXMLATTRIBUTE_H__
#define __GTKAMLXMLATTRIBUTE_H__

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>

G_BEGIN_DECLS


#define GTKAML_TYPE_XML_ATTRIBUTE (gtkaml_xml_attribute_get_type ())
#define GTKAML_XML_ATTRIBUTE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GTKAML_TYPE_XML_ATTRIBUTE, GtkamlXmlAttribute))
#define GTKAML_XML_ATTRIBUTE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GTKAML_TYPE_XML_ATTRIBUTE, GtkamlXmlAttributeClass))
#define GTKAML_IS_XML_ATTRIBUTE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GTKAML_TYPE_XML_ATTRIBUTE))
#define GTKAML_IS_XML_ATTRIBUTE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GTKAML_TYPE_XML_ATTRIBUTE))
#define GTKAML_XML_ATTRIBUTE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GTKAML_TYPE_XML_ATTRIBUTE, GtkamlXmlAttributeClass))

typedef struct _GtkamlXmlAttribute GtkamlXmlAttribute;
typedef struct _GtkamlXmlAttributeClass GtkamlXmlAttributeClass;
typedef struct _GtkamlXmlAttributePrivate GtkamlXmlAttributePrivate;

/**
 * an attribute as presented by libxml2
 */
struct _GtkamlXmlAttribute {
	GObject parent_instance;
	GtkamlXmlAttributePrivate * priv;
	char* localname;
	char* prefix;
	char* URI;
	char* value;
};

struct _GtkamlXmlAttributeClass {
	GObjectClass parent_class;
};


GtkamlXmlAttribute* gtkaml_xml_attribute_new (void);
GType gtkaml_xml_attribute_get_type (void);


G_END_DECLS

#endif
