/* GtkamlSAXParser.vala
 * 
 * Copyright (C) 2008 Vlad Grecescu
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with main.c; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor Boston, MA 02110-1301,  USA
 *
 * Author:
 *        Vlad Grecescu (b100dian@gmail.com)
 */

#include "GtkamlSAXParser.h"
#include <gee/hashmap.h>
#include <gee/map.h>
#include <gee/arraylist.h>
#include <gee/collection.h>
#include <glib/gstdio.h>
#include <vala/valareport.h>
#include <vala/valanamespacereference.h>
#include <vala/valanamespace.h>
#include <vala/valasymbol.h>
#include <vala/valascope.h>
#include <config.h>
#include "GtkamlStateStack.h"
#include "GtkamlState.h"
#include "GtkamlAttribute.h"
#include "GtkamlXmlNamespace.h"
#include "GtkamlComplexAttribute.h"
#include "GtkamlSimpleAttribute.h"
#include "GtkamlXmlAttribute.h"
#include "GtkamlReferenceClassDefinition.h"




struct _GtkamlSAXParserPrivate {
	ValaCodeContext* _context;
	ValaSourceFile* _source_file;
	GtkamlStateStack* _states;
	GeeMap* generated_identifiers_counter;
	GeeCollection* used_identifiers;
	GeeMap* _prefixes_namespaces;
	GtkamlRootClassDefinition* _root_class_definition;
};

#define GTKAML_SAX_PARSER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GTKAML_TYPE_SAX_PARSER, GtkamlSAXParserPrivate))
enum  {
	GTKAML_SAX_PARSER_DUMMY_PROPERTY,
	GTKAML_SAX_PARSER_CONTEXT,
	GTKAML_SAX_PARSER_SOURCE_FILE
};
static GtkamlRootClassDefinition* gtkaml_sax_parser_real_parse (GtkamlSAXParser* self);
static void gtkaml_sax_parser_parse_attribute_content_as_text (GtkamlSAXParser* self, GtkamlState* state, const char* content);
static char* gtkaml_sax_parser_prefix_to_namespace (GtkamlSAXParser* self, const char* prefix);
static ValaClass* gtkaml_sax_parser_lookup_class (GtkamlSAXParser* self, const char* xmlNamespace, const char* name);
static char* gtkaml_sax_parser_strip_attribute_hyphens (GtkamlSAXParser* self, const char* attrname);
static GeeList* gtkaml_sax_parser_parse_attributes (GtkamlSAXParser* self, char** attributes, gint nb_attributes);
static GeeList* gtkaml_sax_parser_parse_namespaces (GtkamlSAXParser* self, char** namespaces, gint nb_namespaces);
static void gtkaml_sax_parser_set_context (GtkamlSAXParser* self, ValaCodeContext* value);
static void gtkaml_sax_parser_set_source_file (GtkamlSAXParser* self, ValaSourceFile* value);
static GtkamlStateStack* gtkaml_sax_parser_get_states (GtkamlSAXParser* self);
static void gtkaml_sax_parser_set_states (GtkamlSAXParser* self, GtkamlStateStack* value);
static GeeMap* gtkaml_sax_parser_get_prefixes_namespaces (GtkamlSAXParser* self);
static void gtkaml_sax_parser_set_prefixes_namespaces (GtkamlSAXParser* self, GeeMap* value);
static GtkamlRootClassDefinition* gtkaml_sax_parser_get_root_class_definition (GtkamlSAXParser* self);
static void gtkaml_sax_parser_set_root_class_definition (GtkamlSAXParser* self, GtkamlRootClassDefinition* value);
static GObject * gtkaml_sax_parser_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static gpointer gtkaml_sax_parser_parent_class = NULL;
static void gtkaml_sax_parser_dispose (GObject * obj);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static int _vala_strcmp0 (const char * str1, const char * str2);



GtkamlSAXParser* gtkaml_sax_parser_new (ValaCodeContext* context, ValaSourceFile* source_file) {
	GParameter * __params;
	GParameter * __params_it;
	GtkamlSAXParser * self;
	g_return_val_if_fail (VALA_IS_CODE_CONTEXT (context), NULL);
	g_return_val_if_fail (VALA_IS_SOURCE_FILE (source_file), NULL);
	__params = g_new0 (GParameter, 2);
	__params_it = __params;
	__params_it->name = "context";
	g_value_init (&__params_it->value, VALA_TYPE_CODE_CONTEXT);
	g_value_set_object (&__params_it->value, context);
	__params_it++;
	__params_it->name = "source-file";
	g_value_init (&__params_it->value, VALA_TYPE_SOURCE_FILE);
	g_value_set_object (&__params_it->value, source_file);
	__params_it++;
	self = g_object_newv (GTKAML_TYPE_SAX_PARSER, __params_it - __params, __params);
	while (__params_it > __params) {
		--__params_it;
		g_value_unset (&__params_it->value);
	}
	g_free (__params);
	return self;
}


static GtkamlRootClassDefinition* gtkaml_sax_parser_real_parse (GtkamlSAXParser* self) {
	GError * inner_error;
	char* contents;
	gulong length;
	GtkamlState* initial_state;
	GtkamlRootClassDefinition* _tmp3;
	GtkamlRootClassDefinition* _tmp4;
	g_return_val_if_fail (GTKAML_IS_SAX_PARSER (self), NULL);
	inner_error = NULL;
	contents = NULL;
	length = 0UL;
	{
		char* _tmp2;
		gboolean _tmp1;
		char* _tmp0;
		_tmp2 = NULL;
		_tmp0 = NULL;
		_tmp1 = g_file_get_contents (vala_source_file_get_filename (self->priv->_source_file), &_tmp0, &length, &inner_error);
		contents = (_tmp2 = _tmp0, (contents = (g_free (contents), NULL)), _tmp2);
		_tmp1;
		if (inner_error != NULL) {
			if (inner_error->domain == G_FILE_ERROR) {
				goto __catch2_g_file_error;
			}
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, inner_error->message);
			g_clear_error (&inner_error);
		}
	}
	goto __finally2;
	__catch2_g_file_error:
	{
		GError * e;
		e = inner_error;
		inner_error = NULL;
		{
			vala_report_error (NULL, e->message);
		}
	}
	__finally2:
	;
	initial_state = gtkaml_state_new (GTKAML_STATE_ID_SAX_PARSER_INITIAL_STATE, NULL, NULL, NULL);
	gtkaml_state_stack_push (self->priv->_states, initial_state);
	gtkaml_sax_parser_start_parsing (self, contents, length);
	_tmp3 = NULL;
	_tmp4 = NULL;
	return (_tmp4 = (_tmp3 = self->priv->_root_class_definition, (_tmp3 == NULL ? NULL : g_object_ref (_tmp3))), (contents = (g_free (contents), NULL)), (initial_state == NULL ? NULL : (initial_state = (g_object_unref (initial_state), NULL))), _tmp4);
}


GtkamlRootClassDefinition* gtkaml_sax_parser_parse (GtkamlSAXParser* self) {
	return GTKAML_SAX_PARSER_GET_CLASS (self)->parse (self);
}


void gtkaml_sax_parser_start_element (GtkamlSAXParser* self, const char* localname, const char* prefix, const char* URI, gint nb_namespaces, char** namespaces, gint nb_attributes, gint nb_defaulted, char** attributes) {
	GeeList* attrs;
	GtkamlState* state;
	ValaSourceReference* source_reference;
	GtkamlStateId _tmp23;
	g_return_if_fail (GTKAML_IS_SAX_PARSER (self));
	g_return_if_fail (localname != NULL);
	g_return_if_fail (URI != NULL);
	attrs = gtkaml_sax_parser_parse_attributes (self, attributes, nb_attributes);
	state = gtkaml_state_stack_peek (self->priv->_states, 0);
	source_reference = gtkaml_sax_parser_create_source_reference (self);
	_tmp23 = gtkaml_state_get_state_id (state);
	if (_tmp23 == GTKAML_STATE_ID_SAX_PARSER_INITIAL_STATE)
	do {
		{
			GeeList* nss;
			char* _tmp1;
			ValaClass* _tmp2;
			ValaClass* clazz;
			GtkamlRootClassDefinition* _tmp4;
			GtkamlState* _tmp5;
			/*Frist Tag! - that means, add "using" directives first*/
			nss = gtkaml_sax_parser_parse_namespaces (self, namespaces, nb_namespaces);
			{
				GeeList* ns_collection;
				int ns_it;
				ns_collection = nss;
				for (ns_it = 0; ns_it < gee_collection_get_size (GEE_COLLECTION (ns_collection)); ns_it = ns_it + 1) {
					XmlNamespace* ns;
					ns = ((XmlNamespace*) (gee_list_get (GEE_LIST (ns_collection), ns_it)));
					{
						if (NULL == ns->prefix || NULL != ns->prefix && _vala_strcmp0 (ns->prefix, self->gtkaml_prefix) != 0) {
							char** _tmp0;
							gint uri_definition_length1;
							char** uri_definition;
							ValaNamespaceReference* namespace_reference;
							_tmp0 = NULL;
							uri_definition = (_tmp0 = g_strsplit_set (ns->URI, ":", 0), uri_definition_length1 = -1, _tmp0);
							namespace_reference = vala_namespace_reference_new (uri_definition[0], source_reference);
							vala_source_file_add_using_directive (self->priv->_source_file, namespace_reference);
							if (NULL == ns->prefix) {
								/*stderr.printf ("adding '%s':'%s' to prefixes_namespaces map\n", "", uri_definition[0]);*/
								gee_map_set (self->priv->_prefixes_namespaces, "", uri_definition[0]);
							} else {
								/*stderr.printf ("adding '%s':'%s' to prefixes_namespaces map\n", ns.prefix, uri_definition[0]);*/
								gee_map_set (self->priv->_prefixes_namespaces, ns->prefix, uri_definition[0]);
							}
							uri_definition = (_vala_array_free (uri_definition, uri_definition_length1, ((GDestroyNotify) (g_free))), NULL);
							(namespace_reference == NULL ? NULL : (namespace_reference = (g_object_unref (namespace_reference), NULL)));
						}
						(ns == NULL ? NULL : (ns = (g_object_unref (ns), NULL)));
					}
				}
			}
			_tmp1 = NULL;
			_tmp2 = NULL;
			clazz = (_tmp2 = gtkaml_sax_parser_lookup_class (self, (_tmp1 = gtkaml_sax_parser_prefix_to_namespace (self, prefix)), localname), (_tmp1 = (g_free (_tmp1), NULL)), _tmp2);
			if (clazz == NULL) {
				char* _tmp3;
				_tmp3 = NULL;
				vala_report_error (source_reference, (_tmp3 = g_strdup_printf ("%s not a class", localname)));
				_tmp3 = (g_free (_tmp3), NULL);
				gtkaml_sax_parser_stop_parsing (self);
				(nss == NULL ? NULL : (nss = (g_object_unref (nss), NULL)));
				(clazz == NULL ? NULL : (clazz = (g_object_unref (clazz), NULL)));
				(attrs == NULL ? NULL : (attrs = (g_object_unref (attrs), NULL)));
				(state == NULL ? NULL : (state = (g_object_unref (state), NULL)));
				(source_reference == NULL ? NULL : (source_reference = (g_object_unref (source_reference), NULL)));
				return;
			}
			_tmp4 = NULL;
			gtkaml_sax_parser_set_root_class_definition (self, (_tmp4 = gtkaml_sax_parser_get_root_definition (self, clazz, attrs, prefix)));
			(_tmp4 == NULL ? NULL : (_tmp4 = (g_object_unref (_tmp4), NULL)));
			if (vala_report_get_errors () > 0) {
				gtkaml_sax_parser_stop_parsing (self);
				(nss == NULL ? NULL : (nss = (g_object_unref (nss), NULL)));
				(clazz == NULL ? NULL : (clazz = (g_object_unref (clazz), NULL)));
				(attrs == NULL ? NULL : (attrs = (g_object_unref (attrs), NULL)));
				(state == NULL ? NULL : (state = (g_object_unref (state), NULL)));
				(source_reference == NULL ? NULL : (source_reference = (g_object_unref (source_reference), NULL)));
				return;
			}
			_tmp5 = NULL;
			gtkaml_state_stack_push (self->priv->_states, (_tmp5 = gtkaml_state_new (GTKAML_STATE_ID_SAX_PARSER_CONTAINER_STATE, GTKAML_CLASS_DEFINITION (self->priv->_root_class_definition), NULL, NULL)));
			(_tmp5 == NULL ? NULL : (_tmp5 = (g_object_unref (_tmp5), NULL)));
			(nss == NULL ? NULL : (nss = (g_object_unref (nss), NULL)));
			(clazz == NULL ? NULL : (clazz = (g_object_unref (clazz), NULL)));
			break;
		}
	} while (0); else if (_tmp23 == GTKAML_STATE_ID_SAX_PARSER_CONTAINER_STATE)
	do {
		{
			char* _tmp6;
			ValaClass* _tmp7;
			ValaClass* clazz;
			char* fqan;
			_tmp6 = NULL;
			_tmp7 = NULL;
			clazz = (_tmp7 = gtkaml_sax_parser_lookup_class (self, (_tmp6 = gtkaml_sax_parser_prefix_to_namespace (self, prefix)), localname), (_tmp6 = (g_free (_tmp6), NULL)), _tmp7);
			fqan = NULL;
			if (clazz != NULL) {
				GtkamlClassDefinition* class_definition;
				GtkamlState* _tmp8;
				/*this is a member/container child object*/
				class_definition = gtkaml_sax_parser_get_child_for_container (self, clazz, gtkaml_state_get_class_definition (state), attrs, prefix);
				_tmp8 = NULL;
				gtkaml_state_stack_push (self->priv->_states, (_tmp8 = gtkaml_state_new (GTKAML_STATE_ID_SAX_PARSER_CONTAINER_STATE, class_definition, NULL, NULL)));
				(_tmp8 == NULL ? NULL : (_tmp8 = (g_object_unref (_tmp8), NULL)));
				(class_definition == NULL ? NULL : (class_definition = (g_object_unref (class_definition), NULL)));
			} else {
				GtkamlClassDefinition* _tmp9;
				GtkamlClassDefinition* attribute_parent_class_definition;
				GtkamlState* _tmp14;
				/*no class with this name found, assume it's an attribute*/
				_tmp9 = NULL;
				attribute_parent_class_definition = (_tmp9 = gtkaml_state_get_class_definition (state), (_tmp9 == NULL ? NULL : g_object_ref (_tmp9)));
				if (prefix != NULL) {
					char* _tmp11;
					char* _tmp10;
					_tmp11 = NULL;
					_tmp10 = NULL;
					fqan = (_tmp11 = g_strconcat ((_tmp10 = g_strconcat (prefix, ".", NULL)), localname, NULL), (fqan = (g_free (fqan), NULL)), _tmp11);
					_tmp10 = (g_free (_tmp10), NULL);
				} else {
					char* _tmp13;
					const char* _tmp12;
					_tmp13 = NULL;
					_tmp12 = NULL;
					fqan = (_tmp13 = (_tmp12 = localname, (_tmp12 == NULL ? NULL : g_strdup (_tmp12))), (fqan = (g_free (fqan), NULL)), _tmp13);
				}
				_tmp14 = NULL;
				gtkaml_state_stack_push (self->priv->_states, (_tmp14 = gtkaml_state_new (GTKAML_STATE_ID_SAX_PARSER_ATTRIBUTE_STATE, attribute_parent_class_definition, NULL, fqan)));
				(_tmp14 == NULL ? NULL : (_tmp14 = (g_object_unref (_tmp14), NULL)));
				(attribute_parent_class_definition == NULL ? NULL : (attribute_parent_class_definition = (g_object_unref (attribute_parent_class_definition), NULL)));
			}
			if (vala_report_get_errors () > 0) {
				gtkaml_sax_parser_stop_parsing (self);
				(clazz == NULL ? NULL : (clazz = (g_object_unref (clazz), NULL)));
				fqan = (g_free (fqan), NULL);
				(attrs == NULL ? NULL : (attrs = (g_object_unref (attrs), NULL)));
				(state == NULL ? NULL : (state = (g_object_unref (state), NULL)));
				(source_reference == NULL ? NULL : (source_reference = (g_object_unref (source_reference), NULL)));
				return;
			}
			(clazz == NULL ? NULL : (clazz = (g_object_unref (clazz), NULL)));
			fqan = (g_free (fqan), NULL);
			break;
		}
	} while (0); else if (_tmp23 == GTKAML_STATE_ID_SAX_PARSER_ATTRIBUTE_STATE)
	do {
		{
			char* _tmp16;
			ValaClass* _tmp17;
			ValaClass* clazz;
			GtkamlClassDefinition* attribute_value_definition;
			char* _tmp20;
			GtkamlComplexAttribute* _tmp21;
			GtkamlComplexAttribute* attr;
			GtkamlState* _tmp22;
			/*a tag found within an attribute state switches us to container_state*/
			if (gtkaml_state_get_attribute (state) != NULL) {
				char* _tmp15;
				/*this was created by non-discardable text nodes*/
				_tmp15 = NULL;
				vala_report_error (source_reference, (_tmp15 = g_strdup_printf ("Incorrect attribute definition for %s", gtkaml_state_get_attribute_name (state))));
				_tmp15 = (g_free (_tmp15), NULL);
				gtkaml_sax_parser_stop_parsing (self);
				(attrs == NULL ? NULL : (attrs = (g_object_unref (attrs), NULL)));
				(state == NULL ? NULL : (state = (g_object_unref (state), NULL)));
				(source_reference == NULL ? NULL : (source_reference = (g_object_unref (source_reference), NULL)));
				return;
			}
			_tmp16 = NULL;
			_tmp17 = NULL;
			clazz = (_tmp17 = gtkaml_sax_parser_lookup_class (self, (_tmp16 = gtkaml_sax_parser_prefix_to_namespace (self, prefix)), localname), (_tmp16 = (g_free (_tmp16), NULL)), _tmp17);
			attribute_value_definition = NULL;
			if (clazz != NULL) {
				GtkamlClassDefinition* _tmp18;
				/*this is a member/container child object*/
				_tmp18 = NULL;
				attribute_value_definition = (_tmp18 = gtkaml_sax_parser_get_child_for_container (self, clazz, NULL, attrs, prefix), (attribute_value_definition == NULL ? NULL : (attribute_value_definition = (g_object_unref (attribute_value_definition), NULL))), _tmp18);
			} else {
				char* _tmp19;
				_tmp19 = NULL;
				vala_report_error (source_reference, (_tmp19 = g_strdup_printf ("No class %s found", localname)));
				_tmp19 = (g_free (_tmp19), NULL);
			}
			_tmp20 = NULL;
			_tmp21 = NULL;
			attr = (_tmp21 = gtkaml_complex_attribute_new ((_tmp20 = gtkaml_sax_parser_strip_attribute_hyphens (self, gtkaml_state_get_attribute_name (state))), attribute_value_definition), (_tmp20 = (g_free (_tmp20), NULL)), _tmp21);
			/*add the attribute into the parent container*/
			gtkaml_class_definition_add_attribute (gtkaml_state_get_class_definition (state), GTKAML_ATTRIBUTE (attr));
			if (vala_report_get_errors () > 0) {
				gtkaml_sax_parser_stop_parsing (self);
				(clazz == NULL ? NULL : (clazz = (g_object_unref (clazz), NULL)));
				(attribute_value_definition == NULL ? NULL : (attribute_value_definition = (g_object_unref (attribute_value_definition), NULL)));
				(attr == NULL ? NULL : (attr = (g_object_unref (attr), NULL)));
				(attrs == NULL ? NULL : (attrs = (g_object_unref (attrs), NULL)));
				(state == NULL ? NULL : (state = (g_object_unref (state), NULL)));
				(source_reference == NULL ? NULL : (source_reference = (g_object_unref (source_reference), NULL)));
				return;
			}
			_tmp22 = NULL;
			gtkaml_state_stack_push (self->priv->_states, (_tmp22 = gtkaml_state_new (GTKAML_STATE_ID_SAX_PARSER_CONTAINER_STATE, attribute_value_definition, NULL, NULL)));
			(_tmp22 == NULL ? NULL : (_tmp22 = (g_object_unref (_tmp22), NULL)));
			(clazz == NULL ? NULL : (clazz = (g_object_unref (clazz), NULL)));
			(attribute_value_definition == NULL ? NULL : (attribute_value_definition = (g_object_unref (attribute_value_definition), NULL)));
			(attr == NULL ? NULL : (attr = (g_object_unref (attr), NULL)));
			break;
		}
	} while (0); else
	do {
		vala_report_error (source_reference, "Invalid Gtkaml SAX Parser state");
		gtkaml_sax_parser_stop_parsing (self);
		(attrs == NULL ? NULL : (attrs = (g_object_unref (attrs), NULL)));
		(state == NULL ? NULL : (state = (g_object_unref (state), NULL)));
		(source_reference == NULL ? NULL : (source_reference = (g_object_unref (source_reference), NULL)));
		return;
	} while (0);
	(attrs == NULL ? NULL : (attrs = (g_object_unref (attrs), NULL)));
	(state == NULL ? NULL : (state = (g_object_unref (state), NULL)));
	(source_reference == NULL ? NULL : (source_reference = (g_object_unref (source_reference), NULL)));
}


void gtkaml_sax_parser_characters (GtkamlSAXParser* self, const char* data, gint len) {
	GtkamlState* state;
	char* value;
	const char* _tmp0;
	char* stripped_value;
	g_return_if_fail (GTKAML_IS_SAX_PARSER (self));
	g_return_if_fail (data != NULL);
	state = gtkaml_state_stack_peek (self->priv->_states, 0);
	value = g_strndup (data, ((gulong) (len)));
	_tmp0 = NULL;
	stripped_value = (_tmp0 = value, (_tmp0 == NULL ? NULL : g_strdup (_tmp0)));
	g_strstrip (stripped_value);
	if (_vala_strcmp0 (stripped_value, "") != 0) {
		gtkaml_sax_parser_parse_attribute_content_as_text (self, state, value);
	}
	(state == NULL ? NULL : (state = (g_object_unref (state), NULL)));
	value = (g_free (value), NULL);
	stripped_value = (g_free (stripped_value), NULL);
}


void gtkaml_sax_parser_end_element (GtkamlSAXParser* self, const char* localname, const char* prefix, const char* URI) {
	GtkamlState* _tmp0;
	g_return_if_fail (GTKAML_IS_SAX_PARSER (self));
	g_return_if_fail (localname != NULL);
	g_return_if_fail (URI != NULL);
	_tmp0 = NULL;
	_tmp0 = gtkaml_state_stack_pop (self->priv->_states);
	(_tmp0 == NULL ? NULL : (_tmp0 = (g_object_unref (_tmp0), NULL)));
}


void gtkaml_sax_parser_cdata_block (GtkamlSAXParser* self, const char* cdata, gint len) {
	GtkamlState* state;
	g_return_if_fail (GTKAML_IS_SAX_PARSER (self));
	g_return_if_fail (cdata != NULL);
	state = gtkaml_state_stack_peek (self->priv->_states, 0);
	if (gtkaml_state_get_state_id (state) != GTKAML_STATE_ID_SAX_PARSER_INITIAL_STATE) {
		GtkamlState* previous_state;
		previous_state = gtkaml_state_stack_peek (self->priv->_states, 1);
		if (gtkaml_state_get_state_id (previous_state) == GTKAML_STATE_ID_SAX_PARSER_INITIAL_STATE) {
			GtkamlRootClassDefinition* _tmp1;
			GtkamlClassDefinition* _tmp0;
			GtkamlRootClassDefinition* root_class;
			char* _tmp2;
			_tmp1 = NULL;
			_tmp0 = NULL;
			root_class = (_tmp1 = (_tmp0 = gtkaml_state_get_class_definition (state), (GTKAML_IS_ROOT_CLASS_DEFINITION (_tmp0) ? ((GtkamlRootClassDefinition*) (_tmp0)) : NULL)), (_tmp1 == NULL ? NULL : g_object_ref (_tmp1)));
			if (gtkaml_root_class_definition_get_original_first_code_line (root_class) < 0) {
				gtkaml_root_class_definition_set_original_first_code_line (root_class, gtkaml_sax_parser_line_number (self));
			}
			_tmp2 = NULL;
			gee_collection_add (GEE_COLLECTION (gtkaml_root_class_definition_get_code (root_class)), (_tmp2 = g_strndup (cdata, ((gulong) (len)))));
			_tmp2 = (g_free (_tmp2), NULL);
			(root_class == NULL ? NULL : (root_class = (g_object_unref (root_class), NULL)));
		} else {
			char* _tmp3;
			_tmp3 = NULL;
			gtkaml_sax_parser_parse_attribute_content_as_text (self, state, (_tmp3 = g_strndup (cdata, ((gulong) (len)))));
			_tmp3 = (g_free (_tmp3), NULL);
		}
		(previous_state == NULL ? NULL : (previous_state = (g_object_unref (previous_state), NULL)));
	}
	(state == NULL ? NULL : (state = (g_object_unref (state), NULL)));
}


static void gtkaml_sax_parser_parse_attribute_content_as_text (GtkamlSAXParser* self, GtkamlState* state, const char* content) {
	g_return_if_fail (GTKAML_IS_SAX_PARSER (self));
	g_return_if_fail (GTKAML_IS_STATE (state));
	g_return_if_fail (content != NULL);
	if (gtkaml_state_get_state_id (state) == GTKAML_STATE_ID_SAX_PARSER_ATTRIBUTE_STATE) {
		char* _tmp0;
		gboolean _tmp1;
		_tmp0 = NULL;
		if ((_tmp1 = _vala_strcmp0 (gtkaml_state_get_attribute_name (state), (_tmp0 = g_strconcat (self->gtkaml_prefix, ".preconstruct", NULL))) == 0, (_tmp0 = (g_free (_tmp0), NULL)), _tmp1)) {
			if (gtkaml_class_definition_get_preconstruct_code (gtkaml_state_get_class_definition (state)) != NULL) {
				char* _tmp3;
				ValaSourceReference* _tmp2;
				_tmp3 = NULL;
				_tmp2 = NULL;
				vala_report_error ((_tmp2 = gtkaml_sax_parser_create_source_reference (self)), (_tmp3 = g_strdup_printf ("A preconstruct attribute already exists for %s", gtkaml_class_definition_get_identifier (gtkaml_state_get_class_definition (state)))));
				_tmp3 = (g_free (_tmp3), NULL);
				(_tmp2 == NULL ? NULL : (_tmp2 = (g_object_unref (_tmp2), NULL)));
				gtkaml_sax_parser_stop_parsing (self);
				return;
			}
			gtkaml_class_definition_set_preconstruct_code (gtkaml_state_get_class_definition (state), content);
		} else {
			char* _tmp4;
			gboolean _tmp5;
			_tmp4 = NULL;
			if ((_tmp5 = _vala_strcmp0 (gtkaml_state_get_attribute_name (state), (_tmp4 = g_strconcat (self->gtkaml_prefix, ".construct", NULL))) == 0, (_tmp4 = (g_free (_tmp4), NULL)), _tmp5)) {
				if (gtkaml_class_definition_get_construct_code (gtkaml_state_get_class_definition (state)) != NULL) {
					char* _tmp7;
					ValaSourceReference* _tmp6;
					_tmp7 = NULL;
					_tmp6 = NULL;
					vala_report_error ((_tmp6 = gtkaml_sax_parser_create_source_reference (self)), (_tmp7 = g_strdup_printf ("A construct attribute already exists for %s", gtkaml_class_definition_get_identifier (gtkaml_state_get_class_definition (state)))));
					_tmp7 = (g_free (_tmp7), NULL);
					(_tmp6 == NULL ? NULL : (_tmp6 = (g_object_unref (_tmp6), NULL)));
					gtkaml_sax_parser_stop_parsing (self);
					return;
				}
				gtkaml_class_definition_set_construct_code (gtkaml_state_get_class_definition (state), content);
			} else {
				if (gtkaml_state_get_attribute (state) == NULL) {
					GtkamlSimpleAttribute* _tmp9;
					char* _tmp8;
					_tmp9 = NULL;
					_tmp8 = NULL;
					gtkaml_state_set_attribute (state, GTKAML_ATTRIBUTE ((_tmp9 = gtkaml_simple_attribute_new ((_tmp8 = gtkaml_sax_parser_strip_attribute_hyphens (self, gtkaml_state_get_attribute_name (state))), content))));
					(_tmp9 == NULL ? NULL : (_tmp9 = (g_object_unref (_tmp9), NULL)));
					_tmp8 = (g_free (_tmp8), NULL);
					gtkaml_class_definition_add_attribute (gtkaml_state_get_class_definition (state), gtkaml_state_get_attribute (state));
				} else {
					if (GTKAML_IS_SIMPLE_ATTRIBUTE (gtkaml_state_get_attribute (state))) {
						char* _tmp13;
						char* _tmp12;
						GtkamlAttribute* _tmp10;
						GtkamlAttribute* _tmp11;
						_tmp13 = NULL;
						_tmp12 = NULL;
						_tmp10 = NULL;
						_tmp11 = NULL;
						gtkaml_simple_attribute_set_value (((_tmp11 = gtkaml_state_get_attribute (state), (GTKAML_IS_SIMPLE_ATTRIBUTE (_tmp11) ? ((GtkamlSimpleAttribute*) (_tmp11)) : NULL))), (_tmp13 = g_strconcat (gtkaml_simple_attribute_get_value (((_tmp11 = gtkaml_state_get_attribute (state), (GTKAML_IS_SIMPLE_ATTRIBUTE (_tmp11) ? ((GtkamlSimpleAttribute*) (_tmp11)) : NULL)))), (_tmp12 = (g_strconcat ("\n", content, NULL))), NULL)));
						_tmp13 = (g_free (_tmp13), NULL);
						_tmp12 = (g_free (_tmp12), NULL);
					} else {
						char* _tmp15;
						ValaSourceReference* _tmp14;
						_tmp15 = NULL;
						_tmp14 = NULL;
						vala_report_error ((_tmp14 = gtkaml_sax_parser_create_source_reference (self)), (_tmp15 = g_strdup_printf ("Cannot mix a complex attribute definition with simple values like this: attribute %s", gtkaml_attribute_get_name (gtkaml_state_get_attribute (state)))));
						_tmp15 = (g_free (_tmp15), NULL);
						(_tmp14 == NULL ? NULL : (_tmp14 = (g_object_unref (_tmp14), NULL)));
						gtkaml_sax_parser_stop_parsing (self);
						return;
					}
				}
			}
		}
	} else {
		ValaSourceReference* _tmp16;
		_tmp16 = NULL;
		vala_report_error ((_tmp16 = gtkaml_sax_parser_create_source_reference (self)), "Invalid non-whitespace text found");
		(_tmp16 == NULL ? NULL : (_tmp16 = (g_object_unref (_tmp16), NULL)));
		gtkaml_sax_parser_stop_parsing (self);
		return;
	}
}


static char* gtkaml_sax_parser_prefix_to_namespace (GtkamlSAXParser* self, const char* prefix) {
	g_return_val_if_fail (GTKAML_IS_SAX_PARSER (self), NULL);
	if (prefix == NULL) {
		return ((char*) (gee_map_get (self->priv->_prefixes_namespaces, "")));
	}
	return ((char*) (gee_map_get (self->priv->_prefixes_namespaces, prefix)));
}


ValaSourceReference* gtkaml_sax_parser_create_source_reference (GtkamlSAXParser* self) {
	g_return_val_if_fail (GTKAML_IS_SAX_PARSER (self), NULL);
	return vala_source_reference_new (self->priv->_source_file, gtkaml_sax_parser_line_number (self), gtkaml_sax_parser_column_number (self), gtkaml_sax_parser_line_number (self), gtkaml_sax_parser_column_number (self));
}


static ValaClass* gtkaml_sax_parser_lookup_class (GtkamlSAXParser* self, const char* xmlNamespace, const char* name) {
	g_return_val_if_fail (GTKAML_IS_SAX_PARSER (self), NULL);
	g_return_val_if_fail (name != NULL, NULL);
	{
		GeeList* ns_collection;
		int ns_it;
		ns_collection = vala_namespace_get_namespaces (vala_code_context_get_root (self->priv->_context));
		for (ns_it = 0; ns_it < gee_collection_get_size (GEE_COLLECTION (ns_collection)); ns_it = ns_it + 1) {
			ValaNamespace* ns;
			ns = ((ValaNamespace*) (gee_list_get (GEE_LIST (ns_collection), ns_it)));
			{
				if (_vala_strcmp0 (xmlNamespace, vala_symbol_get_name (VALA_SYMBOL (ns))) == 0) {
					ValaSymbol* s;
					s = vala_scope_lookup (vala_symbol_get_scope (VALA_SYMBOL (ns)), name);
					if (VALA_IS_CLASS (s)) {
						ValaClass* _tmp1;
						ValaSymbol* _tmp0;
						ValaClass* _tmp2;
						_tmp1 = NULL;
						_tmp0 = NULL;
						_tmp2 = NULL;
						return (_tmp2 = (_tmp1 = ((_tmp0 = s, (VALA_IS_CLASS (_tmp0) ? ((ValaClass*) (_tmp0)) : NULL))), (_tmp1 == NULL ? NULL : g_object_ref (_tmp1))), (s == NULL ? NULL : (s = (g_object_unref (s), NULL))), (ns == NULL ? NULL : (ns = (g_object_unref (ns), NULL))), (ns_collection == NULL ? NULL : (ns_collection = (g_object_unref (ns_collection), NULL))), _tmp2);
					}
					(s == NULL ? NULL : (s = (g_object_unref (s), NULL)));
				}
				(ns == NULL ? NULL : (ns = (g_object_unref (ns), NULL)));
			}
		}
		(ns_collection == NULL ? NULL : (ns_collection = (g_object_unref (ns_collection), NULL)));
	}
	return NULL;
}


static char* gtkaml_sax_parser_strip_attribute_hyphens (GtkamlSAXParser* self, const char* attrname) {
	char** _tmp0;
	gint tokens_length1;
	char** tokens;
	char* _tmp1;
	g_return_val_if_fail (GTKAML_IS_SAX_PARSER (self), NULL);
	g_return_val_if_fail (attrname != NULL, NULL);
	/*see TDWTF, "The Hard Way"*/
	_tmp0 = NULL;
	tokens = (_tmp0 = g_strsplit (attrname, "-", 0), tokens_length1 = -1, _tmp0);
	_tmp1 = NULL;
	return (_tmp1 = g_strjoinv ("_", tokens), (tokens = (_vala_array_free (tokens, tokens_length1, ((GDestroyNotify) (g_free))), NULL)), _tmp1);
}


GtkamlRootClassDefinition* gtkaml_sax_parser_get_root_definition (GtkamlSAXParser* self, ValaClass* clazz, GeeList* attrs, const char* prefix) {
	char* _tmp1;
	ValaSourceReference* _tmp0;
	GtkamlRootClassDefinition* _tmp2;
	GtkamlRootClassDefinition* root_class_definition;
	g_return_val_if_fail (GTKAML_IS_SAX_PARSER (self), NULL);
	g_return_val_if_fail (VALA_IS_CLASS (clazz), NULL);
	g_return_val_if_fail (GEE_IS_LIST (attrs), NULL);
	_tmp1 = NULL;
	_tmp0 = NULL;
	_tmp2 = NULL;
	root_class_definition = (_tmp2 = gtkaml_root_class_definition_new ((_tmp0 = gtkaml_sax_parser_create_source_reference (self)), "this", (_tmp1 = gtkaml_sax_parser_prefix_to_namespace (self, prefix)), clazz, DEFINITION_SCOPE_MAIN_CLASS, NULL), (_tmp1 = (g_free (_tmp1), NULL)), (_tmp0 == NULL ? NULL : (_tmp0 = (g_object_unref (_tmp0), NULL))), _tmp2);
	gtkaml_root_class_definition_set_prefixes_namespaces (root_class_definition, self->priv->_prefixes_namespaces);
	{
		GeeList* attr_collection;
		int attr_it;
		attr_collection = attrs;
		for (attr_it = 0; attr_it < gee_collection_get_size (GEE_COLLECTION (attr_collection)); attr_it = attr_it + 1) {
			GtkamlXmlAttribute* attr;
			attr = ((GtkamlXmlAttribute*) (gee_list_get (GEE_LIST (attr_collection), attr_it)));
			{
				if (attr->prefix != NULL) {
					if (_vala_strcmp0 (attr->prefix, self->gtkaml_prefix) == 0) {
						GQuark _tmp13;
						char* _tmp12;
						_tmp12 = NULL;
						static GQuark _tmp13_label0 = 0;
						static GQuark _tmp13_label1 = 0;
						static GQuark _tmp13_label2 = 0;
						static GQuark _tmp13_label3 = 0;
						static GQuark _tmp13_label4 = 0;
						static GQuark _tmp13_label5 = 0;
						static GQuark _tmp13_label6 = 0;
						_tmp12 = attr->localname;
						_tmp13 = (NULL == _tmp12 ? 0 : g_quark_from_string (_tmp12));
						if (_tmp13 == (0 != _tmp13_label0 ? _tmp13_label0 : (_tmp13_label0 = g_quark_from_static_string ("public"))) || _tmp13 == (0 != _tmp13_label1 ? _tmp13_label1 : (_tmp13_label1 = g_quark_from_static_string ("name"))))
						do {
							if (gtkaml_root_class_definition_get_target_name (root_class_definition) != NULL) {
								char* _tmp4;
								ValaSourceReference* _tmp3;
								_tmp4 = NULL;
								_tmp3 = NULL;
								vala_report_error ((_tmp3 = gtkaml_sax_parser_create_source_reference (self)), (_tmp4 = g_strdup_printf ("A name for the class already exists ('%s')", gtkaml_root_class_definition_get_target_name (root_class_definition))));
								_tmp4 = (g_free (_tmp4), NULL);
								(_tmp3 == NULL ? NULL : (_tmp3 = (g_object_unref (_tmp3), NULL)));
								gtkaml_sax_parser_stop_parsing (self);
							}
							gtkaml_root_class_definition_set_target_name (root_class_definition, attr->value);
							break;
						} while (0); else if (_tmp13 == (0 != _tmp13_label2 ? _tmp13_label2 : (_tmp13_label2 = g_quark_from_static_string ("namespace"))))
						do {
							gtkaml_root_class_definition_set_target_namespace (root_class_definition, attr->value);
							break;
						} while (0); else if (_tmp13 == (0 != _tmp13_label3 ? _tmp13_label3 : (_tmp13_label3 = g_quark_from_static_string ("private"))))
						do {
							ValaSourceReference* _tmp5;
							_tmp5 = NULL;
							vala_report_error ((_tmp5 = gtkaml_sax_parser_create_source_reference (self)), "'private' not allowed on root tag.");
							(_tmp5 == NULL ? NULL : (_tmp5 = (g_object_unref (_tmp5), NULL)));
							gtkaml_sax_parser_stop_parsing (self);
							break;
						} while (0); else if (_tmp13 == (0 != _tmp13_label4 ? _tmp13_label4 : (_tmp13_label4 = g_quark_from_static_string ("construct"))))
						do {
							if (gtkaml_class_definition_get_construct_code (GTKAML_CLASS_DEFINITION (root_class_definition)) != NULL) {
								ValaSourceReference* _tmp6;
								_tmp6 = NULL;
								vala_report_error ((_tmp6 = gtkaml_sax_parser_create_source_reference (self)), "A construct attribute already exists for the root class");
								(_tmp6 == NULL ? NULL : (_tmp6 = (g_object_unref (_tmp6), NULL)));
								gtkaml_sax_parser_stop_parsing (self);
							}
							gtkaml_class_definition_set_construct_code (GTKAML_CLASS_DEFINITION (root_class_definition), attr->value);
							break;
						} while (0); else if (_tmp13 == (0 != _tmp13_label5 ? _tmp13_label5 : (_tmp13_label5 = g_quark_from_static_string ("preconstruct"))))
						do {
							if (gtkaml_class_definition_get_preconstruct_code (GTKAML_CLASS_DEFINITION (root_class_definition)) != NULL) {
								ValaSourceReference* _tmp7;
								_tmp7 = NULL;
								vala_report_error ((_tmp7 = gtkaml_sax_parser_create_source_reference (self)), "A preconstruct attribute already exists for the root class");
								(_tmp7 == NULL ? NULL : (_tmp7 = (g_object_unref (_tmp7), NULL)));
								gtkaml_sax_parser_stop_parsing (self);
							}
							gtkaml_class_definition_set_preconstruct_code (GTKAML_CLASS_DEFINITION (root_class_definition), attr->value);
							break;
						} while (0); else if (_tmp13 == (0 != _tmp13_label6 ? _tmp13_label6 : (_tmp13_label6 = g_quark_from_static_string ("implements"))))
						do {
							char** _tmp8;
							gint implementsv_length1;
							char** implementsv;
							char* _tmp9;
							_tmp8 = NULL;
							implementsv = (_tmp8 = g_strsplit (attr->value, ",", 0), implementsv_length1 = -1, _tmp8);
							{
								gint i;
								i = 0;
								for (; implementsv[i] != NULL; i++) {
									g_strstrip (implementsv[i]);
								}
							}
							_tmp9 = NULL;
							gtkaml_root_class_definition_set_implements (root_class_definition, (_tmp9 = g_strjoinv (", ", implementsv)));
							_tmp9 = (g_free (_tmp9), NULL);
							implementsv = (_vala_array_free (implementsv, implementsv_length1, ((GDestroyNotify) (g_free))), NULL);
							break;
						} while (0); else
						do {
							char* _tmp11;
							ValaSourceReference* _tmp10;
							_tmp11 = NULL;
							_tmp10 = NULL;
							vala_report_warning ((_tmp10 = gtkaml_sax_parser_create_source_reference (self)), (_tmp11 = g_strdup_printf ("Unknown gtkaml attribute '%s'.", attr->localname)));
							_tmp11 = (g_free (_tmp11), NULL);
							(_tmp10 == NULL ? NULL : (_tmp10 = (g_object_unref (_tmp10), NULL)));
							break;
						} while (0);
					} else {
						char* _tmp15;
						ValaSourceReference* _tmp14;
						_tmp15 = NULL;
						_tmp14 = NULL;
						vala_report_error ((_tmp14 = gtkaml_sax_parser_create_source_reference (self)), (_tmp15 = g_strdup_printf ("'%s' is the only allowed prefix for attributes. Other attributes must be left unprefixed", self->gtkaml_prefix)));
						_tmp15 = (g_free (_tmp15), NULL);
						(_tmp14 == NULL ? NULL : (_tmp14 = (g_object_unref (_tmp14), NULL)));
						gtkaml_sax_parser_stop_parsing (self);
					}
				} else {
					char* _tmp16;
					GtkamlSimpleAttribute* _tmp17;
					GtkamlSimpleAttribute* simple_attribute;
					_tmp16 = NULL;
					_tmp17 = NULL;
					simple_attribute = (_tmp17 = gtkaml_simple_attribute_new ((_tmp16 = gtkaml_sax_parser_strip_attribute_hyphens (self, attr->localname)), attr->value), (_tmp16 = (g_free (_tmp16), NULL)), _tmp17);
					gtkaml_class_definition_add_attribute (GTKAML_CLASS_DEFINITION (root_class_definition), GTKAML_ATTRIBUTE (simple_attribute));
					(simple_attribute == NULL ? NULL : (simple_attribute = (g_object_unref (simple_attribute), NULL)));
				}
				(attr == NULL ? NULL : (attr = (g_object_unref (attr), NULL)));
			}
		}
	}
	if (gtkaml_root_class_definition_get_target_name (root_class_definition) == NULL) {
		char* _tmp19;
		ValaSourceReference* _tmp18;
		_tmp19 = NULL;
		_tmp18 = NULL;
		vala_report_error ((_tmp18 = gtkaml_sax_parser_create_source_reference (self)), (_tmp19 = g_strdup_printf ("No class name specified: use %s:name for this", self->gtkaml_prefix)));
		_tmp19 = (g_free (_tmp19), NULL);
		(_tmp18 == NULL ? NULL : (_tmp18 = (g_object_unref (_tmp18), NULL)));
	}
	return root_class_definition;
}


GtkamlClassDefinition* gtkaml_sax_parser_get_child_for_container (GtkamlSAXParser* self, ValaClass* clazz, GtkamlClassDefinition* container_definition, GeeList* attrs, const char* prefix) {
	char* identifier;
	DefinitionScope identifier_scope;
	char* reference;
	char* construct_code;
	char* preconstruct_code;
	GtkamlClassDefinition* _tmp0;
	GtkamlClassDefinition* parent_container;
	GtkamlClassDefinition* class_definition;
	GtkamlClassDefinition* _tmp35;
	g_return_val_if_fail (GTKAML_IS_SAX_PARSER (self), NULL);
	g_return_val_if_fail (VALA_IS_CLASS (clazz), NULL);
	g_return_val_if_fail (container_definition == NULL || GTKAML_IS_CLASS_DEFINITION (container_definition), NULL);
	g_return_val_if_fail (GEE_IS_LIST (attrs), NULL);
	identifier = NULL;
	identifier_scope = DEFINITION_SCOPE_CONSTRUCTOR;
	reference = NULL;
	construct_code = NULL;
	preconstruct_code = NULL;
	_tmp0 = NULL;
	parent_container = (_tmp0 = container_definition, (_tmp0 == NULL ? NULL : g_object_ref (_tmp0)));
	{
		GeeList* attr_collection;
		int attr_it;
		attr_collection = attrs;
		for (attr_it = 0; attr_it < gee_collection_get_size (GEE_COLLECTION (attr_collection)); attr_it = attr_it + 1) {
			GtkamlXmlAttribute* attr;
			attr = ((GtkamlXmlAttribute*) (gee_list_get (GEE_LIST (attr_collection), attr_it)));
			{
				if (attr->prefix != NULL && _vala_strcmp0 (attr->prefix, self->gtkaml_prefix) == 0) {
					if ((_vala_strcmp0 (attr->localname, "public") == 0 || _vala_strcmp0 (attr->localname, "private") == 0)) {
						char* _tmp4;
						const char* _tmp3;
						if (identifier != NULL) {
							char* _tmp2;
							ValaSourceReference* _tmp1;
							_tmp2 = NULL;
							_tmp1 = NULL;
							vala_report_error ((_tmp1 = gtkaml_sax_parser_create_source_reference (self)), (_tmp2 = g_strdup_printf ("Cannot have multiple identifier names:%s", attr->localname)));
							_tmp2 = (g_free (_tmp2), NULL);
							(_tmp1 == NULL ? NULL : (_tmp1 = (g_object_unref (_tmp1), NULL)));
							gtkaml_sax_parser_stop_parsing (self);
							(attr == NULL ? NULL : (attr = (g_object_unref (attr), NULL)));
							break;
						}
						_tmp4 = NULL;
						_tmp3 = NULL;
						identifier = (_tmp4 = (_tmp3 = attr->value, (_tmp3 == NULL ? NULL : g_strdup (_tmp3))), (identifier = (g_free (identifier), NULL)), _tmp4);
						if (_vala_strcmp0 (attr->localname, "public") == 0) {
							identifier_scope = DEFINITION_SCOPE_PUBLIC;
						} else {
							identifier_scope = DEFINITION_SCOPE_PRIVATE;
						}
					} else {
						if (_vala_strcmp0 (attr->localname, "existing") == 0) {
							char* _tmp6;
							const char* _tmp5;
							_tmp6 = NULL;
							_tmp5 = NULL;
							reference = (_tmp6 = (_tmp5 = attr->value, (_tmp5 == NULL ? NULL : g_strdup (_tmp5))), (reference = (g_free (reference), NULL)), _tmp6);
						} else {
							if (_vala_strcmp0 (attr->localname, "construct") == 0) {
								char* _tmp8;
								const char* _tmp7;
								_tmp8 = NULL;
								_tmp7 = NULL;
								construct_code = (_tmp8 = (_tmp7 = attr->value, (_tmp7 == NULL ? NULL : g_strdup (_tmp7))), (construct_code = (g_free (construct_code), NULL)), _tmp8);
							} else {
								if (_vala_strcmp0 (attr->localname, "preconstruct") == 0) {
									char* _tmp10;
									const char* _tmp9;
									_tmp10 = NULL;
									_tmp9 = NULL;
									preconstruct_code = (_tmp10 = (_tmp9 = attr->value, (_tmp9 == NULL ? NULL : g_strdup (_tmp9))), (preconstruct_code = (g_free (preconstruct_code), NULL)), _tmp10);
								} else {
									if (_vala_strcmp0 (attr->localname, "standalone") == 0) {
										if (_vala_strcmp0 (attr->value, "true") == 0) {
											GtkamlClassDefinition* _tmp11;
											_tmp11 = NULL;
											parent_container = (_tmp11 = NULL, (parent_container == NULL ? NULL : (parent_container = (g_object_unref (parent_container), NULL))), _tmp11);
										} else {
											ValaSourceReference* _tmp12;
											_tmp12 = NULL;
											vala_report_error ((_tmp12 = gtkaml_sax_parser_create_source_reference (self)), "Invalid 'standalone' value");
											(_tmp12 == NULL ? NULL : (_tmp12 = (g_object_unref (_tmp12), NULL)));
											gtkaml_sax_parser_stop_parsing (self);
										}
									} else {
										char* _tmp14;
										ValaSourceReference* _tmp13;
										_tmp14 = NULL;
										_tmp13 = NULL;
										vala_report_error ((_tmp13 = gtkaml_sax_parser_create_source_reference (self)), (_tmp14 = g_strdup_printf ("Unkown gtkaml attribute '%s'", attr->localname)));
										_tmp14 = (g_free (_tmp14), NULL);
										(_tmp13 == NULL ? NULL : (_tmp13 = (g_object_unref (_tmp13), NULL)));
										gtkaml_sax_parser_stop_parsing (self);
									}
								}
							}
						}
					}
				} else {
					if (attr->prefix != NULL) {
						char* _tmp16;
						ValaSourceReference* _tmp15;
						_tmp16 = NULL;
						_tmp15 = NULL;
						vala_report_error ((_tmp15 = gtkaml_sax_parser_create_source_reference (self)), (_tmp16 = g_strdup_printf ("%s is the only allowed prefix for attributes. Other attributes must be left unprefixed", self->gtkaml_prefix)));
						_tmp16 = (g_free (_tmp16), NULL);
						(_tmp15 == NULL ? NULL : (_tmp15 = (g_object_unref (_tmp15), NULL)));
						gtkaml_sax_parser_stop_parsing (self);
					}
				}
				(attr == NULL ? NULL : (attr = (g_object_unref (attr), NULL)));
			}
		}
	}
	if (identifier != NULL && reference != NULL) {
		ValaSourceReference* _tmp17;
		_tmp17 = NULL;
		vala_report_error ((_tmp17 = gtkaml_sax_parser_create_source_reference (self)), "Cannot specify both existing and a new identifier name");
		(_tmp17 == NULL ? NULL : (_tmp17 = (g_object_unref (_tmp17), NULL)));
		gtkaml_sax_parser_stop_parsing (self);
	}
	class_definition = NULL;
	if (reference == NULL) {
		gint counter;
		GtkamlClassDefinition* _tmp23;
		char* _tmp22;
		ValaSourceReference* _tmp21;
		counter = 0;
		if (identifier == NULL) {
			char* _tmp18;
			char* _tmp19;
			char* _tmp20;
			/*generate a name for the identifier*/
			_tmp18 = NULL;
			identifier = (_tmp18 = g_utf8_strdown (vala_symbol_get_name (VALA_SYMBOL (clazz)), g_utf8_strlen (vala_symbol_get_name (VALA_SYMBOL (clazz)), -1)), (identifier = (g_free (identifier), NULL)), _tmp18);
			if (gee_map_contains (self->priv->generated_identifiers_counter, identifier)) {
				counter = GPOINTER_TO_INT (GPOINTER_TO_INT (gee_map_get (self->priv->generated_identifiers_counter, identifier)));
			}
			_tmp19 = NULL;
			identifier = (_tmp19 = g_strdup_printf ("_%s%d", identifier, counter), (identifier = (g_free (identifier), NULL)), _tmp19);
			counter++;
			_tmp20 = NULL;
			gee_map_set (self->priv->generated_identifiers_counter, (_tmp20 = g_utf8_strdown (vala_symbol_get_name (VALA_SYMBOL (clazz)), g_utf8_strlen (vala_symbol_get_name (VALA_SYMBOL (clazz)), -1))), GINT_TO_POINTER (counter));
			_tmp20 = (g_free (_tmp20), NULL);
		}
		_tmp23 = NULL;
		_tmp22 = NULL;
		_tmp21 = NULL;
		class_definition = (_tmp23 = gtkaml_class_definition_new ((_tmp21 = gtkaml_sax_parser_create_source_reference (self)), identifier, (_tmp22 = gtkaml_sax_parser_prefix_to_namespace (self, prefix)), clazz, identifier_scope, parent_container), (class_definition == NULL ? NULL : (class_definition = (g_object_unref (class_definition), NULL))), _tmp23);
		_tmp22 = (g_free (_tmp22), NULL);
		(_tmp21 == NULL ? NULL : (_tmp21 = (g_object_unref (_tmp21), NULL)));
		gtkaml_class_definition_set_construct_code (class_definition, construct_code);
		gtkaml_class_definition_set_preconstruct_code (class_definition, preconstruct_code);
	} else {
		GtkamlClassDefinition* _tmp27;
		char* _tmp26;
		ValaSourceReference* _tmp25;
		const char* _tmp28;
		char* reference_stripped;
		if (construct_code != NULL || preconstruct_code != NULL) {
			ValaSourceReference* _tmp24;
			_tmp24 = NULL;
			vala_report_error ((_tmp24 = gtkaml_sax_parser_create_source_reference (self)), "Cannot specify 'construct' or 'preconstruct' code for references");
			(_tmp24 == NULL ? NULL : (_tmp24 = (g_object_unref (_tmp24), NULL)));
			gtkaml_sax_parser_stop_parsing (self);
		}
		_tmp27 = NULL;
		_tmp26 = NULL;
		_tmp25 = NULL;
		class_definition = (_tmp27 = GTKAML_CLASS_DEFINITION (gtkaml_reference_class_definition_new ((_tmp25 = gtkaml_sax_parser_create_source_reference (self)), reference, (_tmp26 = gtkaml_sax_parser_prefix_to_namespace (self, prefix)), clazz, parent_container)), (class_definition == NULL ? NULL : (class_definition = (g_object_unref (class_definition), NULL))), _tmp27);
		_tmp26 = (g_free (_tmp26), NULL);
		(_tmp25 == NULL ? NULL : (_tmp25 = (g_object_unref (_tmp25), NULL)));
		/* now post-process the reference FIXME put this in code generator or something*/
		_tmp28 = NULL;
		reference_stripped = (_tmp28 = reference, (_tmp28 == NULL ? NULL : g_strdup (_tmp28)));
		g_strstrip (reference_stripped);
		if (g_str_has_prefix (reference_stripped, "{")) {
			if (g_str_has_suffix (reference_stripped, "}")) {
				char* _tmp30;
				char* _tmp29;
				_tmp30 = NULL;
				_tmp29 = NULL;
				gtkaml_class_definition_set_identifier (class_definition, (_tmp30 = (_tmp29 = g_utf8_offset_to_pointer (reference_stripped, ((glong) (1))), g_strndup (_tmp29, g_utf8_offset_to_pointer (_tmp29, g_utf8_strlen (reference_stripped, -1) - 2) - _tmp29))));
				_tmp30 = (g_free (_tmp30), NULL);
			} else {
				ValaSourceReference* _tmp31;
				_tmp31 = NULL;
				vala_report_error ((_tmp31 = gtkaml_sax_parser_create_source_reference (self)), "'existing' attribute not properly ended");
				(_tmp31 == NULL ? NULL : (_tmp31 = (g_object_unref (_tmp31), NULL)));
			}
		} else {
			char* _tmp32;
			_tmp32 = NULL;
			gtkaml_class_definition_set_identifier (class_definition, (_tmp32 = g_strdup_printf ("(%s as %s)", reference, gtkaml_class_definition_get_base_full_name (class_definition))));
			_tmp32 = (g_free (_tmp32), NULL);
		}
		reference_stripped = (g_free (reference_stripped), NULL);
	}
	if (container_definition != NULL) {
		gtkaml_class_definition_add_child (container_definition, class_definition);
	}
	{
		GeeList* attr_collection;
		int attr_it;
		attr_collection = attrs;
		for (attr_it = 0; attr_it < gee_collection_get_size (GEE_COLLECTION (attr_collection)); attr_it = attr_it + 1) {
			GtkamlXmlAttribute* attr;
			attr = ((GtkamlXmlAttribute*) (gee_list_get (GEE_LIST (attr_collection), attr_it)));
			{
				if (attr->prefix == NULL) {
					char* _tmp33;
					GtkamlSimpleAttribute* _tmp34;
					GtkamlSimpleAttribute* simple_attribute;
					_tmp33 = NULL;
					_tmp34 = NULL;
					simple_attribute = (_tmp34 = gtkaml_simple_attribute_new ((_tmp33 = gtkaml_sax_parser_strip_attribute_hyphens (self, attr->localname)), attr->value), (_tmp33 = (g_free (_tmp33), NULL)), _tmp34);
					gtkaml_class_definition_add_attribute (class_definition, GTKAML_ATTRIBUTE (simple_attribute));
					(simple_attribute == NULL ? NULL : (simple_attribute = (g_object_unref (simple_attribute), NULL)));
				}
				(attr == NULL ? NULL : (attr = (g_object_unref (attr), NULL)));
			}
		}
	}
	_tmp35 = NULL;
	return (_tmp35 = class_definition, (identifier = (g_free (identifier), NULL)), (reference = (g_free (reference), NULL)), (construct_code = (g_free (construct_code), NULL)), (preconstruct_code = (g_free (preconstruct_code), NULL)), (parent_container == NULL ? NULL : (parent_container = (g_object_unref (parent_container), NULL))), _tmp35);
}


static GeeList* gtkaml_sax_parser_parse_attributes (GtkamlSAXParser* self, char** attributes, gint nb_attributes) {
	gint walker;
	char* end;
	GeeArrayList* attribute_list;
	GeeList* _tmp11;
	g_return_val_if_fail (GTKAML_IS_SAX_PARSER (self), NULL);
	walker = 0;
	end = NULL;
	attribute_list = gee_array_list_new (GTKAML_TYPE_XML_ATTRIBUTE, ((GBoxedCopyFunc) (g_object_ref)), g_object_unref, g_direct_equal);
	{
		gint i;
		i = 0;
		for (; i < nb_attributes; i++) {
			GtkamlXmlAttribute* attr;
			char* _tmp1;
			const char* _tmp0;
			char* _tmp3;
			const char* _tmp2;
			char* _tmp5;
			const char* _tmp4;
			char* _tmp7;
			const char* _tmp6;
			char* _tmp9;
			const char* _tmp8;
			char* _tmp10;
			attr = gtkaml_xml_attribute_new ();
			_tmp1 = NULL;
			_tmp0 = NULL;
			attr->localname = (_tmp1 = (_tmp0 = attributes[walker], (_tmp0 == NULL ? NULL : g_strdup (_tmp0))), (attr->localname = (g_free (attr->localname), NULL)), _tmp1);
			_tmp3 = NULL;
			_tmp2 = NULL;
			attr->prefix = (_tmp3 = (_tmp2 = attributes[walker + 1], (_tmp2 == NULL ? NULL : g_strdup (_tmp2))), (attr->prefix = (g_free (attr->prefix), NULL)), _tmp3);
			_tmp5 = NULL;
			_tmp4 = NULL;
			attr->URI = (_tmp5 = (_tmp4 = attributes[walker + 2], (_tmp4 == NULL ? NULL : g_strdup (_tmp4))), (attr->URI = (g_free (attr->URI), NULL)), _tmp5);
			_tmp7 = NULL;
			_tmp6 = NULL;
			attr->value = (_tmp7 = (_tmp6 = attributes[walker + 3], (_tmp6 == NULL ? NULL : g_strdup (_tmp6))), (attr->value = (g_free (attr->value), NULL)), _tmp7);
			_tmp9 = NULL;
			_tmp8 = NULL;
			end = (_tmp9 = (_tmp8 = attributes[walker + 4], (_tmp8 == NULL ? NULL : g_strdup (_tmp8))), (end = (g_free (end), NULL)), _tmp9);
			_tmp10 = NULL;
			attr->value = (_tmp10 = g_strndup (attr->value, ((gulong) (g_utf8_strlen (attr->value, -1) - g_utf8_strlen (end, -1)))), (attr->value = (g_free (attr->value), NULL)), _tmp10);
			gee_collection_add (GEE_COLLECTION (attribute_list), attr);
			walker = walker + (5);
			(attr == NULL ? NULL : (attr = (g_object_unref (attr), NULL)));
		}
	}
	_tmp11 = NULL;
	return (_tmp11 = GEE_LIST (attribute_list), (end = (g_free (end), NULL)), _tmp11);
}


static GeeList* gtkaml_sax_parser_parse_namespaces (GtkamlSAXParser* self, char** namespaces, gint nb_namespaces) {
	gint walker;
	GeeArrayList* namespace_list;
	g_return_val_if_fail (GTKAML_IS_SAX_PARSER (self), NULL);
	walker = 0;
	namespace_list = gee_array_list_new (TYPE_XML_NAMESPACE, ((GBoxedCopyFunc) (g_object_ref)), g_object_unref, g_direct_equal);
	{
		gint i;
		i = 0;
		for (; i < nb_namespaces; i++) {
			XmlNamespace* ns;
			char* _tmp1;
			const char* _tmp0;
			char* _tmp3;
			const char* _tmp2;
			ns = xml_namespace_new ();
			_tmp1 = NULL;
			_tmp0 = NULL;
			ns->prefix = (_tmp1 = (_tmp0 = namespaces[walker], (_tmp0 == NULL ? NULL : g_strdup (_tmp0))), (ns->prefix = (g_free (ns->prefix), NULL)), _tmp1);
			_tmp3 = NULL;
			_tmp2 = NULL;
			ns->URI = (_tmp3 = (_tmp2 = namespaces[walker + 1], (_tmp2 == NULL ? NULL : g_strdup (_tmp2))), (ns->URI = (g_free (ns->URI), NULL)), _tmp3);
			if (ns->URI != NULL && g_str_has_prefix (ns->URI, "http://gtkaml.org/")) {
				if (ns->prefix != NULL) {
					char* _tmp5;
					const char* _tmp4;
					char* _tmp6;
					char* version;
					_tmp5 = NULL;
					_tmp4 = NULL;
					self->gtkaml_prefix = (_tmp5 = (_tmp4 = ns->prefix, (_tmp4 == NULL ? NULL : g_strdup (_tmp4))), (self->gtkaml_prefix = (g_free (self->gtkaml_prefix), NULL)), _tmp5);
					_tmp6 = NULL;
					version = (_tmp6 = g_utf8_offset_to_pointer (ns->URI, g_utf8_strlen ("http://gtkaml.org/", -1)), g_strndup (_tmp6, g_utf8_offset_to_pointer (_tmp6, g_utf8_strlen (ns->URI, -1) - g_utf8_strlen ("http://gtkaml.org/", -1)) - _tmp6));
					if (_vala_strcmp0 (version, PACKAGE_VERSION) > 0) {
						char* _tmp8;
						ValaSourceReference* _tmp7;
						_tmp8 = NULL;
						_tmp7 = NULL;
						vala_report_warning ((_tmp7 = gtkaml_sax_parser_create_source_reference (self)), (_tmp8 = g_strdup_printf ("Source file version (%s) newer than gtkaml compiler version (%s)", version, PACKAGE_VERSION)));
						_tmp8 = (g_free (_tmp8), NULL);
						(_tmp7 == NULL ? NULL : (_tmp7 = (g_object_unref (_tmp7), NULL)));
					}
					version = (g_free (version), NULL);
				} else {
					ValaSourceReference* _tmp9;
					_tmp9 = NULL;
					vala_report_error ((_tmp9 = gtkaml_sax_parser_create_source_reference (self)), "You cannot use the gtkaml namespace as default namespace");
					(_tmp9 == NULL ? NULL : (_tmp9 = (g_object_unref (_tmp9), NULL)));
				}
			}
			gee_collection_add (GEE_COLLECTION (namespace_list), ns);
			walker = walker + (2);
			(ns == NULL ? NULL : (ns = (g_object_unref (ns), NULL)));
		}
	}
	return GEE_LIST (namespace_list);
}


ValaCodeContext* gtkaml_sax_parser_get_context (GtkamlSAXParser* self) {
	g_return_val_if_fail (GTKAML_IS_SAX_PARSER (self), NULL);
	return self->priv->_context;
}


static void gtkaml_sax_parser_set_context (GtkamlSAXParser* self, ValaCodeContext* value) {
	ValaCodeContext* _tmp2;
	ValaCodeContext* _tmp1;
	g_return_if_fail (GTKAML_IS_SAX_PARSER (self));
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->_context = (_tmp2 = (_tmp1 = value, (_tmp1 == NULL ? NULL : g_object_ref (_tmp1))), (self->priv->_context == NULL ? NULL : (self->priv->_context = (g_object_unref (self->priv->_context), NULL))), _tmp2);
}


ValaSourceFile* gtkaml_sax_parser_get_source_file (GtkamlSAXParser* self) {
	g_return_val_if_fail (GTKAML_IS_SAX_PARSER (self), NULL);
	return self->priv->_source_file;
}


static void gtkaml_sax_parser_set_source_file (GtkamlSAXParser* self, ValaSourceFile* value) {
	g_return_if_fail (GTKAML_IS_SAX_PARSER (self));
	self->priv->_source_file = value;
}


static GtkamlStateStack* gtkaml_sax_parser_get_states (GtkamlSAXParser* self) {
	g_return_val_if_fail (GTKAML_IS_SAX_PARSER (self), NULL);
	return self->priv->_states;
}


static void gtkaml_sax_parser_set_states (GtkamlSAXParser* self, GtkamlStateStack* value) {
	GtkamlStateStack* _tmp2;
	GtkamlStateStack* _tmp1;
	g_return_if_fail (GTKAML_IS_SAX_PARSER (self));
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->_states = (_tmp2 = (_tmp1 = value, (_tmp1 == NULL ? NULL : g_object_ref (_tmp1))), (self->priv->_states == NULL ? NULL : (self->priv->_states = (g_object_unref (self->priv->_states), NULL))), _tmp2);
}


static GeeMap* gtkaml_sax_parser_get_prefixes_namespaces (GtkamlSAXParser* self) {
	g_return_val_if_fail (GTKAML_IS_SAX_PARSER (self), NULL);
	return self->priv->_prefixes_namespaces;
}


static void gtkaml_sax_parser_set_prefixes_namespaces (GtkamlSAXParser* self, GeeMap* value) {
	GeeMap* _tmp2;
	GeeMap* _tmp1;
	g_return_if_fail (GTKAML_IS_SAX_PARSER (self));
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->_prefixes_namespaces = (_tmp2 = (_tmp1 = value, (_tmp1 == NULL ? NULL : g_object_ref (_tmp1))), (self->priv->_prefixes_namespaces == NULL ? NULL : (self->priv->_prefixes_namespaces = (g_object_unref (self->priv->_prefixes_namespaces), NULL))), _tmp2);
}


static GtkamlRootClassDefinition* gtkaml_sax_parser_get_root_class_definition (GtkamlSAXParser* self) {
	g_return_val_if_fail (GTKAML_IS_SAX_PARSER (self), NULL);
	return self->priv->_root_class_definition;
}


static void gtkaml_sax_parser_set_root_class_definition (GtkamlSAXParser* self, GtkamlRootClassDefinition* value) {
	GtkamlRootClassDefinition* _tmp2;
	GtkamlRootClassDefinition* _tmp1;
	g_return_if_fail (GTKAML_IS_SAX_PARSER (self));
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->_root_class_definition = (_tmp2 = (_tmp1 = value, (_tmp1 == NULL ? NULL : g_object_ref (_tmp1))), (self->priv->_root_class_definition == NULL ? NULL : (self->priv->_root_class_definition = (g_object_unref (self->priv->_root_class_definition), NULL))), _tmp2);
}


static GObject * gtkaml_sax_parser_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GtkamlSAXParserClass * klass;
	GObjectClass * parent_class;
	GtkamlSAXParser * self;
	klass = GTKAML_SAX_PARSER_CLASS (g_type_class_peek (GTKAML_TYPE_SAX_PARSER));
	parent_class = G_OBJECT_CLASS (g_type_class_peek_parent (klass));
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = GTKAML_SAX_PARSER (obj);
	{
		GtkamlStateStack* _tmp0;
		GeeHashMap* _tmp1;
		_tmp0 = NULL;
		gtkaml_sax_parser_set_states (self, (_tmp0 = gtkaml_state_stack_new ()));
		(_tmp0 == NULL ? NULL : (_tmp0 = (g_object_unref (_tmp0), NULL)));
		_tmp1 = NULL;
		gtkaml_sax_parser_set_prefixes_namespaces (self, GEE_MAP ((_tmp1 = gee_hash_map_new (G_TYPE_STRING, ((GBoxedCopyFunc) (g_strdup)), g_free, G_TYPE_STRING, ((GBoxedCopyFunc) (g_strdup)), g_free, g_str_hash, g_str_equal, g_str_equal))));
		(_tmp1 == NULL ? NULL : (_tmp1 = (g_object_unref (_tmp1), NULL)));
		gtkaml_sax_parser_set_root_class_definition (self, NULL);
	}
	return obj;
}


static void gtkaml_sax_parser_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	GtkamlSAXParser * self;
	self = GTKAML_SAX_PARSER (object);
	switch (property_id) {
		case GTKAML_SAX_PARSER_CONTEXT:
		g_value_set_object (value, gtkaml_sax_parser_get_context (self));
		break;
		case GTKAML_SAX_PARSER_SOURCE_FILE:
		g_value_set_object (value, gtkaml_sax_parser_get_source_file (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void gtkaml_sax_parser_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	GtkamlSAXParser * self;
	self = GTKAML_SAX_PARSER (object);
	switch (property_id) {
		case GTKAML_SAX_PARSER_CONTEXT:
		gtkaml_sax_parser_set_context (self, g_value_get_object (value));
		break;
		case GTKAML_SAX_PARSER_SOURCE_FILE:
		gtkaml_sax_parser_set_source_file (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void gtkaml_sax_parser_class_init (GtkamlSAXParserClass * klass) {
	gtkaml_sax_parser_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (GtkamlSAXParserPrivate));
	G_OBJECT_CLASS (klass)->get_property = gtkaml_sax_parser_get_property;
	G_OBJECT_CLASS (klass)->set_property = gtkaml_sax_parser_set_property;
	G_OBJECT_CLASS (klass)->constructor = gtkaml_sax_parser_constructor;
	G_OBJECT_CLASS (klass)->dispose = gtkaml_sax_parser_dispose;
	GTKAML_SAX_PARSER_CLASS (klass)->parse = gtkaml_sax_parser_real_parse;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GTKAML_SAX_PARSER_CONTEXT, g_param_spec_object ("context", "context", "context", VALA_TYPE_CODE_CONTEXT, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GTKAML_SAX_PARSER_SOURCE_FILE, g_param_spec_object ("source-file", "source-file", "source-file", VALA_TYPE_SOURCE_FILE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
}


static void gtkaml_sax_parser_instance_init (GtkamlSAXParser * self) {
	self->priv = GTKAML_SAX_PARSER_GET_PRIVATE (self);
	self->priv->generated_identifiers_counter = GEE_MAP (gee_hash_map_new (G_TYPE_STRING, ((GBoxedCopyFunc) (g_strdup)), g_free, G_TYPE_INT, NULL, NULL, g_str_hash, g_str_equal, g_direct_equal));
	self->priv->used_identifiers = GEE_COLLECTION (gee_array_list_new (G_TYPE_STRING, ((GBoxedCopyFunc) (g_strdup)), g_free, g_str_equal));
	self->gtkaml_prefix = g_strdup ("gtkaml");
}


static void gtkaml_sax_parser_dispose (GObject * obj) {
	GtkamlSAXParser * self;
	self = GTKAML_SAX_PARSER (obj);
	(self->priv->_context == NULL ? NULL : (self->priv->_context = (g_object_unref (self->priv->_context), NULL)));
	(self->priv->_states == NULL ? NULL : (self->priv->_states = (g_object_unref (self->priv->_states), NULL)));
	(self->priv->generated_identifiers_counter == NULL ? NULL : (self->priv->generated_identifiers_counter = (g_object_unref (self->priv->generated_identifiers_counter), NULL)));
	(self->priv->used_identifiers == NULL ? NULL : (self->priv->used_identifiers = (g_object_unref (self->priv->used_identifiers), NULL)));
	(self->priv->_prefixes_namespaces == NULL ? NULL : (self->priv->_prefixes_namespaces = (g_object_unref (self->priv->_prefixes_namespaces), NULL)));
	(self->priv->_root_class_definition == NULL ? NULL : (self->priv->_root_class_definition = (g_object_unref (self->priv->_root_class_definition), NULL)));
	self->gtkaml_prefix = (g_free (self->gtkaml_prefix), NULL);
	G_OBJECT_CLASS (gtkaml_sax_parser_parent_class)->dispose (obj);
}


GType gtkaml_sax_parser_get_type (void) {
	static GType gtkaml_sax_parser_type_id = 0;
	if (G_UNLIKELY (gtkaml_sax_parser_type_id == 0)) {
		static const GTypeInfo g_define_type_info = { sizeof (GtkamlSAXParserClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gtkaml_sax_parser_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GtkamlSAXParser), 0, (GInstanceInitFunc) gtkaml_sax_parser_instance_init };
		gtkaml_sax_parser_type_id = g_type_register_static (G_TYPE_OBJECT, "GtkamlSAXParser", &g_define_type_info, 0);
	}
	return gtkaml_sax_parser_type_id;
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if (array != NULL && destroy_func != NULL) {
		int i;
		if (array_length >= 0)
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) (array))[i] != NULL)
			destroy_func (((gpointer*) (array))[i]);
		}
		else
		for (i = 0; ((gpointer*) (array))[i] != NULL; i = i + 1) {
			destroy_func (((gpointer*) (array))[i]);
		}
	}
	g_free (array);
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return (str1 != str2);
	}
	return strcmp (str1, str2);
}




