/* GtkamlImplicitsStore.vala
 * 
 * Copyright (C) 2008 Vlad Grecescu
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with main.c; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor Boston, MA 02110-1301,  USA
 *
 * Author:
 *        Vlad Grecescu (b100dian@gmail.com)
 */

#include "GtkamlImplicitsStore.h"
#include <gee/arraylist.h>
#include <gee/hashmap.h>
#include <gee/map.h>
#include <gee/collection.h>
#include <glib/gstdio.h>
#include <vala/valareport.h>
#include <vala/valasourcereference.h>
#include <vala/valasymbol.h>
#include <vala/valaformalparameter.h>


#define GTKAML_TYPE_KEY_FILE_WRAPPER (gtkaml_key_file_wrapper_get_type ())
#define GTKAML_KEY_FILE_WRAPPER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GTKAML_TYPE_KEY_FILE_WRAPPER, GtkamlKeyFileWrapper))
#define GTKAML_KEY_FILE_WRAPPER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GTKAML_TYPE_KEY_FILE_WRAPPER, GtkamlKeyFileWrapperClass))
#define GTKAML_IS_KEY_FILE_WRAPPER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GTKAML_TYPE_KEY_FILE_WRAPPER))
#define GTKAML_IS_KEY_FILE_WRAPPER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GTKAML_TYPE_KEY_FILE_WRAPPER))
#define GTKAML_KEY_FILE_WRAPPER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GTKAML_TYPE_KEY_FILE_WRAPPER, GtkamlKeyFileWrapperClass))

typedef struct _GtkamlKeyFileWrapper GtkamlKeyFileWrapper;
typedef struct _GtkamlKeyFileWrapperClass GtkamlKeyFileWrapperClass;
typedef struct _GtkamlKeyFileWrapperPrivate GtkamlKeyFileWrapperPrivate;

/**
 * GObject-ification of KeyFile
 */
struct _GtkamlKeyFileWrapper {
	GObject parent_instance;
	GtkamlKeyFileWrapperPrivate * priv;
	GKeyFile* key_file;
};

struct _GtkamlKeyFileWrapperClass {
	GObjectClass parent_class;
};



enum  {
	GTKAML_IMPLICITS_PARAMETER_DUMMY_PROPERTY
};
static gpointer gtkaml_implicits_parameter_parent_class = NULL;
static void gtkaml_implicits_parameter_dispose (GObject * obj);
enum  {
	GTKAML_KEY_FILE_WRAPPER_DUMMY_PROPERTY
};
static gboolean gtkaml_key_file_wrapper_has_key (GtkamlKeyFileWrapper* self, const char* group, const char* key);
static char** gtkaml_key_file_wrapper_get_string_list (GtkamlKeyFileWrapper* self, const char* group, const char* key, int* result_length1);
static GtkamlKeyFileWrapper* gtkaml_key_file_wrapper_new (void);
static GObject * gtkaml_key_file_wrapper_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static gpointer gtkaml_key_file_wrapper_parent_class = NULL;
static void gtkaml_key_file_wrapper_dispose (GObject * obj);
static GType gtkaml_key_file_wrapper_get_type (void);
struct _GtkamlImplicitsStorePrivate {
	GeeList* implicits_dirs;
	GeeMap* loaded_ns;
};

#define GTKAML_IMPLICITS_STORE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GTKAML_TYPE_IMPLICITS_STORE, GtkamlImplicitsStorePrivate))
enum  {
	GTKAML_IMPLICITS_STORE_DUMMY_PROPERTY
};
static GeeList* gtkaml_implicits_store_get_ns (GtkamlImplicitsStore* self, const char* ns);
static gpointer gtkaml_implicits_store_parent_class = NULL;
static void gtkaml_implicits_store_dispose (GObject * obj);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);



/** a method parameter as it came from an .implicits file, with its default value */
GtkamlImplicitsParameter* gtkaml_implicits_parameter_new (void) {
	GtkamlImplicitsParameter * self;
	self = g_object_newv (GTKAML_TYPE_IMPLICITS_PARAMETER, 0, NULL);
	return self;
}


static void gtkaml_implicits_parameter_class_init (GtkamlImplicitsParameterClass * klass) {
	gtkaml_implicits_parameter_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->dispose = gtkaml_implicits_parameter_dispose;
}


static void gtkaml_implicits_parameter_instance_init (GtkamlImplicitsParameter * self) {
}


static void gtkaml_implicits_parameter_dispose (GObject * obj) {
	GtkamlImplicitsParameter * self;
	self = GTKAML_IMPLICITS_PARAMETER (obj);
	self->name = (g_free (self->name), NULL);
	self->default_value = (g_free (self->default_value), NULL);
	G_OBJECT_CLASS (gtkaml_implicits_parameter_parent_class)->dispose (obj);
}


GType gtkaml_implicits_parameter_get_type (void) {
	static GType gtkaml_implicits_parameter_type_id = 0;
	if (G_UNLIKELY (gtkaml_implicits_parameter_type_id == 0)) {
		static const GTypeInfo g_define_type_info = { sizeof (GtkamlImplicitsParameterClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gtkaml_implicits_parameter_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GtkamlImplicitsParameter), 0, (GInstanceInitFunc) gtkaml_implicits_parameter_instance_init };
		gtkaml_implicits_parameter_type_id = g_type_register_static (G_TYPE_OBJECT, "GtkamlImplicitsParameter", &g_define_type_info, 0);
	}
	return gtkaml_implicits_parameter_type_id;
}


static gboolean gtkaml_key_file_wrapper_has_key (GtkamlKeyFileWrapper* self, const char* group, const char* key) {
	GError * inner_error;
	g_return_val_if_fail (GTKAML_IS_KEY_FILE_WRAPPER (self), FALSE);
	g_return_val_if_fail (group != NULL, FALSE);
	g_return_val_if_fail (key != NULL, FALSE);
	inner_error = NULL;
	{
		return g_key_file_has_key (self->key_file, group, key, &inner_error);
	}
	goto __finally4;
	__catch4_g_key_file_error:
	{
		GError * e;
		e = inner_error;
		inner_error = NULL;
		{
			return FALSE;
		}
	}
	__finally4:
	;
}


static char** gtkaml_key_file_wrapper_get_string_list (GtkamlKeyFileWrapper* self, const char* group, const char* key, int* result_length1) {
	GError * inner_error;
	g_return_val_if_fail (GTKAML_IS_KEY_FILE_WRAPPER (self), NULL);
	g_return_val_if_fail (group != NULL, NULL);
	g_return_val_if_fail (key != NULL, NULL);
	inner_error = NULL;
	{
		gint _tmp0;
		char** _tmp1;
		_tmp1 = NULL;
		return (_tmp1 = g_key_file_get_string_list (self->key_file, group, key, &_tmp0, &inner_error), (*result_length1) = _tmp0, _tmp1);
	}
	goto __finally5;
	__catch5_g_error:
	{
		GError * e;
		e = inner_error;
		inner_error = NULL;
		{
			char** _tmp3;
			_tmp3 = NULL;
			return (_tmp3 = g_new0 (char*, 0 + 1), (*result_length1) = 0, _tmp3);
		}
	}
	__finally5:
	;
}


/**
 * GObject-ification of KeyFile
 */
static GtkamlKeyFileWrapper* gtkaml_key_file_wrapper_new (void) {
	GtkamlKeyFileWrapper * self;
	self = g_object_newv (GTKAML_TYPE_KEY_FILE_WRAPPER, 0, NULL);
	return self;
}


static GObject * gtkaml_key_file_wrapper_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GtkamlKeyFileWrapperClass * klass;
	GObjectClass * parent_class;
	GtkamlKeyFileWrapper * self;
	klass = GTKAML_KEY_FILE_WRAPPER_CLASS (g_type_class_peek (GTKAML_TYPE_KEY_FILE_WRAPPER));
	parent_class = G_OBJECT_CLASS (g_type_class_peek_parent (klass));
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = GTKAML_KEY_FILE_WRAPPER (obj);
	{
		GKeyFile* _tmp0;
		_tmp0 = NULL;
		self->key_file = (_tmp0 = g_key_file_new (), (self->key_file == NULL ? NULL : (self->key_file = (g_key_file_free (self->key_file), NULL))), _tmp0);
	}
	return obj;
}


static void gtkaml_key_file_wrapper_class_init (GtkamlKeyFileWrapperClass * klass) {
	gtkaml_key_file_wrapper_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->constructor = gtkaml_key_file_wrapper_constructor;
	G_OBJECT_CLASS (klass)->dispose = gtkaml_key_file_wrapper_dispose;
}


static void gtkaml_key_file_wrapper_instance_init (GtkamlKeyFileWrapper * self) {
}


static void gtkaml_key_file_wrapper_dispose (GObject * obj) {
	GtkamlKeyFileWrapper * self;
	self = GTKAML_KEY_FILE_WRAPPER (obj);
	(self->key_file == NULL ? NULL : (self->key_file = (g_key_file_free (self->key_file), NULL)));
	G_OBJECT_CLASS (gtkaml_key_file_wrapper_parent_class)->dispose (obj);
}


static GType gtkaml_key_file_wrapper_get_type (void) {
	static GType gtkaml_key_file_wrapper_type_id = 0;
	if (G_UNLIKELY (gtkaml_key_file_wrapper_type_id == 0)) {
		static const GTypeInfo g_define_type_info = { sizeof (GtkamlKeyFileWrapperClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gtkaml_key_file_wrapper_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GtkamlKeyFileWrapper), 0, (GInstanceInitFunc) gtkaml_key_file_wrapper_instance_init };
		gtkaml_key_file_wrapper_type_id = g_type_register_static (G_TYPE_OBJECT, "GtkamlKeyFileWrapper", &g_define_type_info, 0);
	}
	return gtkaml_key_file_wrapper_type_id;
}


GeeReadOnlyList* gtkaml_implicits_store_get_implicits_dirs (GtkamlImplicitsStore* self) {
	g_return_val_if_fail (GTKAML_IS_IMPLICITS_STORE (self), NULL);
	return gee_read_only_list_new (G_TYPE_STRING, ((GBoxedCopyFunc) (g_strdup)), g_free, self->priv->implicits_dirs);
}


void gtkaml_implicits_store_add_implicits_dir (GtkamlImplicitsStore* self, const char* directory) {
	g_return_if_fail (GTKAML_IS_IMPLICITS_STORE (self));
	g_return_if_fail (directory != NULL);
	gee_collection_add (GEE_COLLECTION (self->priv->implicits_dirs), directory);
}


static GeeList* gtkaml_implicits_store_get_ns (GtkamlImplicitsStore* self, const char* ns) {
	GError * inner_error;
	g_return_val_if_fail (GTKAML_IS_IMPLICITS_STORE (self), NULL);
	g_return_val_if_fail (ns != NULL, NULL);
	inner_error = NULL;
	if (gee_map_contains (self->priv->loaded_ns, ns)) {
		return ((GeeList*) (gee_map_get (self->priv->loaded_ns, ns)));
	} else {
		GeeArrayList* key_file_list;
		key_file_list = gee_array_list_new (GTKAML_TYPE_KEY_FILE_WRAPPER, ((GBoxedCopyFunc) (g_object_ref)), g_object_unref, g_direct_equal);
		{
			GeeList* implicits_dir_collection;
			int implicits_dir_it;
			implicits_dir_collection = self->priv->implicits_dirs;
			for (implicits_dir_it = 0; implicits_dir_it < gee_collection_get_size (GEE_COLLECTION (implicits_dir_collection)); implicits_dir_it = implicits_dir_it + 1) {
				char* implicits_dir;
				implicits_dir = ((char*) (gee_list_get (GEE_LIST (implicits_dir_collection), implicits_dir_it)));
				{
					char* _tmp1;
					char* _tmp2;
					char* file_name;
					_tmp1 = NULL;
					_tmp2 = NULL;
					file_name = (_tmp2 = g_build_filename (implicits_dir, (_tmp1 = g_strconcat (ns, ".implicits", NULL)), NULL), (_tmp1 = (g_free (_tmp1), NULL)), _tmp2);
					if (g_file_test (file_name, G_FILE_TEST_EXISTS)) {
						GtkamlKeyFileWrapper* key_file_wrapper;
						key_file_wrapper = gtkaml_key_file_wrapper_new ();
						{
							g_key_file_load_from_file (key_file_wrapper->key_file, file_name, G_KEY_FILE_NONE, &inner_error);
							if (inner_error != NULL) {
								goto __catch6_g_error;
							}
							gee_collection_add (GEE_COLLECTION (key_file_list), key_file_wrapper);
						}
						goto __finally6;
						__catch6_g_error:
						{
							GError * e;
							e = inner_error;
							inner_error = NULL;
							{
								char* _tmp3;
								_tmp3 = NULL;
								vala_report_warning (NULL, (_tmp3 = g_strdup_printf ("Invalid implicits file %s", file_name)));
								_tmp3 = (g_free (_tmp3), NULL);
							}
						}
						__finally6:
						;
						(key_file_wrapper == NULL ? NULL : (key_file_wrapper = (g_object_unref (key_file_wrapper), NULL)));
					}
					implicits_dir = (g_free (implicits_dir), NULL);
					file_name = (g_free (file_name), NULL);
				}
			}
		}
		/*even an empty list does it: so that we don't scan the directories again*/
		gee_map_set (self->priv->loaded_ns, ns, GEE_LIST (key_file_list));
		return GEE_LIST (key_file_list);
	}
}


GeeList* gtkaml_implicits_store_get_adds (GtkamlImplicitsStore* self, const char* ns, const char* class_name) {
	GeeList* adds;
	GeeList* kf_ns;
	GeeList* _tmp3;
	g_return_val_if_fail (GTKAML_IS_IMPLICITS_STORE (self), NULL);
	g_return_val_if_fail (ns != NULL, NULL);
	g_return_val_if_fail (class_name != NULL, NULL);
	adds = GEE_LIST (gee_array_list_new (G_TYPE_STRING, ((GBoxedCopyFunc) (g_strdup)), g_free, g_direct_equal));
	kf_ns = gtkaml_implicits_store_get_ns (self, ns);
	{
		GeeList* kfw_collection;
		int kfw_it;
		kfw_collection = kf_ns;
		for (kfw_it = 0; kfw_it < gee_collection_get_size (GEE_COLLECTION (kfw_collection)); kfw_it = kfw_it + 1) {
			GtkamlKeyFileWrapper* kfw;
			kfw = ((GtkamlKeyFileWrapper*) (gee_list_get (GEE_LIST (kfw_collection), kfw_it)));
			{
				if (gtkaml_key_file_wrapper_has_key (kfw, class_name, "adds")) {
					char** _tmp1;
					gint kf_adds_length1;
					gint _tmp0;
					char** kf_adds;
					_tmp1 = NULL;
					kf_adds = (_tmp1 = gtkaml_key_file_wrapper_get_string_list (kfw, class_name, "adds", &_tmp0), kf_adds_length1 = _tmp0, _tmp1);
					{
						char** add_collection;
						int add_collection_length1;
						int add_it;
						add_collection = kf_adds;
						add_collection_length1 = kf_adds_length1;
						for (add_it = 0; (kf_adds_length1 != -1 && add_it < kf_adds_length1) || (kf_adds_length1 == -1 && add_collection[add_it] != NULL); add_it = add_it + 1) {
							const char* _tmp2;
							char* add;
							_tmp2 = NULL;
							add = (_tmp2 = add_collection[add_it], (_tmp2 == NULL ? NULL : g_strdup (_tmp2)));
							{
								/*stderr.printf ("store contains %s\n", add);*/
								gee_collection_add (GEE_COLLECTION (adds), add);
								add = (g_free (add), NULL);
							}
						}
					}
					kf_adds = (_vala_array_free (kf_adds, kf_adds_length1, ((GDestroyNotify) (g_free))), NULL);
				}
				(kfw == NULL ? NULL : (kfw = (g_object_unref (kfw), NULL)));
			}
		}
	}
	_tmp3 = NULL;
	return (_tmp3 = adds, (kf_ns == NULL ? NULL : (kf_ns = (g_object_unref (kf_ns), NULL))), _tmp3);
}


GeeList* gtkaml_implicits_store_get_method_parameters (GtkamlImplicitsStore* self, const char* ns, const char* class_name, const char* method_name) {
	GeeList* parameters;
	g_return_val_if_fail (GTKAML_IS_IMPLICITS_STORE (self), NULL);
	g_return_val_if_fail (ns != NULL, NULL);
	g_return_val_if_fail (class_name != NULL, NULL);
	g_return_val_if_fail (method_name != NULL, NULL);
	parameters = GEE_LIST (gee_array_list_new (GTKAML_TYPE_IMPLICITS_PARAMETER, ((GBoxedCopyFunc) (g_object_ref)), g_object_unref, g_direct_equal));
	{
		GeeList* kfw_collection;
		int kfw_it;
		kfw_collection = gtkaml_implicits_store_get_ns (self, ns);
		for (kfw_it = 0; kfw_it < gee_collection_get_size (GEE_COLLECTION (kfw_collection)); kfw_it = kfw_it + 1) {
			GtkamlKeyFileWrapper* kfw;
			kfw = ((GtkamlKeyFileWrapper*) (gee_list_get (GEE_LIST (kfw_collection), kfw_it)));
			{
				if (gtkaml_key_file_wrapper_has_key (kfw, class_name, method_name)) {
					char** _tmp1;
					gint kf_parameters_length1;
					gint _tmp0;
					char** kf_parameters;
					GeeList* _tmp8;
					_tmp1 = NULL;
					kf_parameters = (_tmp1 = gtkaml_key_file_wrapper_get_string_list (kfw, class_name, method_name, &_tmp0), kf_parameters_length1 = _tmp0, _tmp1);
					{
						char** parameter_collection;
						int parameter_collection_length1;
						int parameter_it;
						parameter_collection = kf_parameters;
						parameter_collection_length1 = kf_parameters_length1;
						for (parameter_it = 0; (kf_parameters_length1 != -1 && parameter_it < kf_parameters_length1) || (kf_parameters_length1 == -1 && parameter_collection[parameter_it] != NULL); parameter_it = parameter_it + 1) {
							const char* _tmp7;
							char* parameter;
							_tmp7 = NULL;
							parameter = (_tmp7 = parameter_collection[parameter_it], (_tmp7 == NULL ? NULL : g_strdup (_tmp7)));
							{
								GtkamlImplicitsParameter* implicits_parameter;
								char** _tmp2;
								gint name_value_length1;
								char** name_value;
								char* _tmp4;
								const char* _tmp3;
								char* _tmp6;
								const char* _tmp5;
								implicits_parameter = gtkaml_implicits_parameter_new ();
								_tmp2 = NULL;
								name_value = (_tmp2 = g_strsplit (parameter, "=", 0), name_value_length1 = -1, _tmp2);
								_tmp4 = NULL;
								_tmp3 = NULL;
								implicits_parameter->name = (_tmp4 = (_tmp3 = name_value[0], (_tmp3 == NULL ? NULL : g_strdup (_tmp3))), (implicits_parameter->name = (g_free (implicits_parameter->name), NULL)), _tmp4);
								_tmp6 = NULL;
								_tmp5 = NULL;
								implicits_parameter->default_value = (_tmp6 = (_tmp5 = name_value[1], (_tmp5 == NULL ? NULL : g_strdup (_tmp5))), (implicits_parameter->default_value = (g_free (implicits_parameter->default_value), NULL)), _tmp6);
								/*either null or not*/
								gee_collection_add (GEE_COLLECTION (parameters), implicits_parameter);
								parameter = (g_free (parameter), NULL);
								(implicits_parameter == NULL ? NULL : (implicits_parameter = (g_object_unref (implicits_parameter), NULL)));
								name_value = (_vala_array_free (name_value, name_value_length1, ((GDestroyNotify) (g_free))), NULL);
							}
						}
					}
					_tmp8 = NULL;
					return (_tmp8 = parameters, (kf_parameters = (_vala_array_free (kf_parameters, kf_parameters_length1, ((GDestroyNotify) (g_free))), NULL)), (kfw == NULL ? NULL : (kfw = (g_object_unref (kfw), NULL))), (kfw_collection == NULL ? NULL : (kfw_collection = (g_object_unref (kfw_collection), NULL))), _tmp8);
				}
				(kfw == NULL ? NULL : (kfw = (g_object_unref (kfw), NULL)));
			}
		}
		(kfw_collection == NULL ? NULL : (kfw_collection = (g_object_unref (kfw_collection), NULL)));
	}
	return parameters;
}


/*empty*/
GeeList* gtkaml_implicits_store_determine_parameter_names_and_default_values (GtkamlImplicitsStore* self, GtkamlClassDefinition* class_definition, ValaMethod* method) {
	char* ns;
	const char* _tmp0;
	char* clazz;
	GeeArrayList* result;
	const char* _tmp1;
	char* method_name;
	GeeList* result_array;
	GeeList* _tmp8;
	g_return_val_if_fail (GTKAML_IS_IMPLICITS_STORE (self), NULL);
	g_return_val_if_fail (GTKAML_IS_CLASS_DEFINITION (class_definition), NULL);
	g_return_val_if_fail (VALA_IS_METHOD (method), NULL);
	ns = vala_symbol_get_full_name (vala_symbol_get_parent_symbol (vala_symbol_get_parent_symbol (VALA_SYMBOL (method))));
	_tmp0 = NULL;
	clazz = (_tmp0 = vala_symbol_get_name (vala_symbol_get_parent_symbol (VALA_SYMBOL (method))), (_tmp0 == NULL ? NULL : g_strdup (_tmp0)));
	/*stderr.printf ("determine_parameter_names_and_default_values %s %s of %s.%s\n", class_definition.base_full_name, method.name, ns, clazz);*/
	result = gee_array_list_new (GTKAML_TYPE_IMPLICITS_PARAMETER, ((GBoxedCopyFunc) (g_object_ref)), g_object_unref, g_direct_equal);
	_tmp1 = NULL;
	method_name = (_tmp1 = vala_symbol_get_name (VALA_SYMBOL (method)), (_tmp1 == NULL ? NULL : g_strdup (_tmp1)));
	if (g_str_has_prefix (vala_symbol_get_name (VALA_SYMBOL (method)), ".new")) {
		char* _tmp3;
		char* _tmp2;
		_tmp3 = NULL;
		_tmp2 = NULL;
		method_name = (_tmp3 = (_tmp2 = g_utf8_offset_to_pointer (vala_symbol_get_name (VALA_SYMBOL (method)), ((glong) (1))), g_strndup (_tmp2, g_utf8_offset_to_pointer (_tmp2, g_utf8_strlen (vala_symbol_get_name (VALA_SYMBOL (method)), -1) - 1) - _tmp2)), (method_name = (g_free (method_name), NULL)), _tmp3);
	} else {
		char* _tmp4;
		_tmp4 = NULL;
		method_name = (_tmp4 = g_strconcat ("add.", vala_symbol_get_name (VALA_SYMBOL (method)), NULL), (method_name = (g_free (method_name), NULL)), _tmp4);
	}
	result_array = gtkaml_implicits_store_get_method_parameters (self, ns, clazz, method_name);
	if (gee_collection_get_size (GEE_COLLECTION (result_array)) != 0) {
		{
			GeeList* result_item_collection;
			int result_item_it;
			result_item_collection = result_array;
			for (result_item_it = 0; result_item_it < gee_collection_get_size (GEE_COLLECTION (result_item_collection)); result_item_it = result_item_it + 1) {
				GtkamlImplicitsParameter* result_item;
				result_item = ((GtkamlImplicitsParameter*) (gee_list_get (GEE_LIST (result_item_collection), result_item_it)));
				{
					if (result_item->default_value != NULL) {
					}
					/*stderr.printf ("default value for %s=<%s>\n", result_item.name, result_item.default_value);*/
					gee_collection_add (GEE_COLLECTION (result), result_item);
					(result_item == NULL ? NULL : (result_item = (g_object_unref (result_item), NULL)));
				}
			}
		}
	} else {
		{
			GeeList* p_collection;
			int p_it;
			p_collection = vala_method_get_parameters (method);
			for (p_it = 0; p_it < gee_collection_get_size (GEE_COLLECTION (p_collection)); p_it = p_it + 1) {
				ValaFormalParameter* p;
				p = ((ValaFormalParameter*) (gee_list_get (GEE_LIST (p_collection), p_it)));
				{
					if (!vala_formal_parameter_get_ellipsis (p)) {
						GtkamlImplicitsParameter* new_implicits_parameter;
						char* _tmp6;
						const char* _tmp5;
						char* _tmp7;
						/*hack for add_with_parameters (widget, ...)*/
						new_implicits_parameter = gtkaml_implicits_parameter_new ();
						_tmp6 = NULL;
						_tmp5 = NULL;
						new_implicits_parameter->name = (_tmp6 = (_tmp5 = vala_symbol_get_name (VALA_SYMBOL (p)), (_tmp5 == NULL ? NULL : g_strdup (_tmp5))), (new_implicits_parameter->name = (g_free (new_implicits_parameter->name), NULL)), _tmp6);
						_tmp7 = NULL;
						new_implicits_parameter->default_value = (_tmp7 = NULL, (new_implicits_parameter->default_value = (g_free (new_implicits_parameter->default_value), NULL)), _tmp7);
						/*here we can go for "zero"es and "false"s*/
						gee_collection_add (GEE_COLLECTION (result), new_implicits_parameter);
						(new_implicits_parameter == NULL ? NULL : (new_implicits_parameter = (g_object_unref (new_implicits_parameter), NULL)));
					}
					(p == NULL ? NULL : (p = (g_object_unref (p), NULL)));
				}
			}
			(p_collection == NULL ? NULL : (p_collection = (g_object_unref (p_collection), NULL)));
		}
	}
	_tmp8 = NULL;
	return (_tmp8 = GEE_LIST (result), (ns = (g_free (ns), NULL)), (clazz = (g_free (clazz), NULL)), (method_name = (g_free (method_name), NULL)), (result_array == NULL ? NULL : (result_array = (g_object_unref (result_array), NULL))), _tmp8);
}


/** 
 * collects $(ns).implicits key files and provides key information from all of them
 */
GtkamlImplicitsStore* gtkaml_implicits_store_new (void) {
	GtkamlImplicitsStore * self;
	self = g_object_newv (GTKAML_TYPE_IMPLICITS_STORE, 0, NULL);
	return self;
}


static void gtkaml_implicits_store_class_init (GtkamlImplicitsStoreClass * klass) {
	gtkaml_implicits_store_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (GtkamlImplicitsStorePrivate));
	G_OBJECT_CLASS (klass)->dispose = gtkaml_implicits_store_dispose;
}


static void gtkaml_implicits_store_instance_init (GtkamlImplicitsStore * self) {
	self->priv = GTKAML_IMPLICITS_STORE_GET_PRIVATE (self);
	self->priv->implicits_dirs = GEE_LIST (gee_array_list_new (G_TYPE_STRING, ((GBoxedCopyFunc) (g_strdup)), g_free, g_str_equal));
	self->priv->loaded_ns = GEE_MAP (gee_hash_map_new (G_TYPE_STRING, ((GBoxedCopyFunc) (g_strdup)), g_free, GEE_TYPE_LIST, ((GBoxedCopyFunc) (g_object_ref)), g_object_unref, g_str_hash, g_str_equal, g_direct_equal));
}


static void gtkaml_implicits_store_dispose (GObject * obj) {
	GtkamlImplicitsStore * self;
	self = GTKAML_IMPLICITS_STORE (obj);
	(self->priv->implicits_dirs == NULL ? NULL : (self->priv->implicits_dirs = (g_object_unref (self->priv->implicits_dirs), NULL)));
	(self->priv->loaded_ns == NULL ? NULL : (self->priv->loaded_ns = (g_object_unref (self->priv->loaded_ns), NULL)));
	G_OBJECT_CLASS (gtkaml_implicits_store_parent_class)->dispose (obj);
}


GType gtkaml_implicits_store_get_type (void) {
	static GType gtkaml_implicits_store_type_id = 0;
	if (G_UNLIKELY (gtkaml_implicits_store_type_id == 0)) {
		static const GTypeInfo g_define_type_info = { sizeof (GtkamlImplicitsStoreClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gtkaml_implicits_store_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GtkamlImplicitsStore), 0, (GInstanceInitFunc) gtkaml_implicits_store_instance_init };
		gtkaml_implicits_store_type_id = g_type_register_static (G_TYPE_OBJECT, "GtkamlImplicitsStore", &g_define_type_info, 0);
	}
	return gtkaml_implicits_store_type_id;
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if (array != NULL && destroy_func != NULL) {
		int i;
		if (array_length >= 0)
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) (array))[i] != NULL)
			destroy_func (((gpointer*) (array))[i]);
		}
		else
		for (i = 0; ((gpointer*) (array))[i] != NULL; i = i + 1) {
			destroy_func (((gpointer*) (array))[i]);
		}
	}
	g_free (array);
}




