.\" Written by Brian St. Pierre (bstpierre@bstpierre.org)
.\" Modified by RAM (Raphael_Manfredi@pobox.com)
.\" Integrated by RAM at version 0.18 within debian/ for Debian packaging
.\" Integrated by RAM at version 0.93 within mainstream
.\" Process this file with
.\"    groff -man -Tascii gtk-gnutella.1
.\" or simply:
.\"    nroff -man gtk-gnutella.1 | less -s
.\"
.TH GTK-GNUTELLA 1 "Nov 2001" Version "0.18"
.SH NAME
gtk-gnutella \- A Gnutella client for Gtk+
.SH SYNOPSIS
.B gtk-gnutella
.SH DESCRIPTION
.I gtk-gnutella
is a GTK+ Gnutella client for Unix. It supports both searching and
sharing with the 0.6 version of the gnutella protocol.
.PP
You should be aware that as of October 19th, 2002, this manual page
is fairly incomplete, with parts that are obsolete.  If you would like
to remedy to this situation and write a decent manual page, please
send your patch/updates to gtk-gnutella-devel@lists.sourceforge.net.
.SH OPTIONS
None.
.SH GETTING STARTED
When
.I gtk-gnutella
is first started, it will attempt to connect to a well-known hosts
server for some hosts to connect to. If you know a host you want to
connect to, you can enter it in the box on the GnutellaNet tab and
push the Add button. When first connecting to the gnutella network, it
can take a minute or two to establish a stable connection. Be
patient.
.SH SEARCHING
Click "Search" to switch to the search tab. Type what you are searching
for into the edit box at the top of the window and either press Enter
or push the "New Search" button. A new tab, labeled with your search
term, will appear in the window, with files that are found listed in
the list below.
.PP
You can have multiple searches running at once. To start another
search while the first one is running, simply enter another search
term into the edit box at the top of the window. A new tab will
appear. You can switch between the two tabs by clicking on them, or by
selecting the search from the "Active searches" drop-down list.
.PP
To stop a particular search and remove its tab from the search window,
select the search by clicking on its tab and click the "Close this
search" button. If you want to clear the list for a particular search,
but want to continue to see new files that are received for this
search, click the "Clear results" button.
.PP
You can also switch from the default tab to a nice list where all
your searches appear on the left side, but you need to have a big-enough
screen to benefit from that.  To enable it, right-click in the search
window and select "Show search list".
.PP
By entering a number in the "Minimum connection speed" box, you can
limit search results to only those files that are shared by hosts with
at least the connection speed that you specify. The units are in kbps,
so if you only want to hear from hosts that are connected at 56k or
higher, enter 56 in this box.
.PP
When you find a file that you want to download, select the file in the
list and press "Download selected files". This file will be placed in
the download queue. If the "Jump to downloads" checkbox is checked,
when you click "Download selected files",
.I gtk-gnutella
will switch to the downloads tab. From there you can watch the
download progress of the file(s) you are downloading. If "Jump to
downloads" is not checked, you will still be staring at the search
tab. But no worries, the file will be downloading whether you're
looking or not.
.PP
It is also possible to select a bunch of files for downloading at
once. By holding down the control or shift keys while clicking files,
you can select several files and then click "Download selected files"
to put them all in the download queue at once.
.SH CONFIGURATION
Most of the configuration can be done via the "Config" pane.  You will
find several tabs there, each tab regrouping common information.
But some specific information pertaining to downloads or searches are
directly available on the "Downloads" and "Uploads" panes.
.PP
If you linger your mouse over each configuration parameter, a tooltip window
will popup explaining the meaning of that parameter.  You may have to press
"Enter" after a text input, or move the focus to another parameter to
validate your entry.  Items configured via spin buttons normally take
effect immediately, unless you type text instead of using the spin buttons.
.SH FILES
.TP
.I $GTK_GNUTELLA_DIR/config_gnet
.RS
Per-user configuration file, for Gnet. This can be edited when the program
is not running, but it is best to use the GUI to change configuration
variables.
.B gtk-gnutella
saves this file every time the program is exited normally.
.RE
.TP
.I $GTK_GNUTELLA_DIR/config_gui
.RS
GUI configuration.  It is best to not edit this file.
.RE
.TP
.I $GTK_GNUTELLA_DIR/dmesh
.RS
This is where the download mesh is persisted.  You don't need to worry
about this.
.RE
.TP
.I $GTK_GNUTELLA_DIR/dmesh_ban
.RS
This is where temporarily banned download mesh entries are stored.
.RE
.TP
.I $GTK_GNUTELLA_DIR/done.namesize
.RS
This file holds the name and size of files completely downloaded by
.B gtk-gnutella
and which will now be ignored.
.RE
.TP
.I $GTK_GNUTELLA_DIR/done.sha1
.RS
This file holds the SHA1 of files completely downloaded by
.B gtk-gnutella
and which will now be ignored.
.RE
.TP
.I $GTK_GNUTELLA_DIR/downloads
.RS
This is where the download queue is persisted.  Only the direct downloads
(i.e. non-pushed) can be saved, since they don't need routing information.
.RE
.TP
.I $GTK_GNUTELLA_DIR/gwcache
.RS
This is the list of known other Gnutella web caches, which.
.B gtk-gnutella
refreshes regularly.
.RE
.TP
.I $GTK_GNUTELLA_DIR/hosts
.RS
This is the host cache. This is saved by
.B gtk-gnutella
on exit and should not be edited by hand.
.RE
.TP
.I $GTK_GNUTELLA_DIR/searches.xml
.RS
This is where the open searches and all the search filters are saved.
.RE
.TP
.I $GTK_GNUTELLA_DIR/sha1_cache
.RS
This is where the cache of all the computed SHA1 is stored.
.RE
.TP
.I $GTK_GNUTELLA_DIR/upload_stats
.RS
This file keeps track of the upload statistics.
.RE
.SH ENVIRONMENT
.I Gtk-Gnutella
searches
.B GTK_GNUTELLA_DIR
for configuration files. If this variable is not set,
.B HOME
is used instead. If 
.B HOME
is not set, then no configuration information will be saved when
.I gtk-gnutella
exits.
.SH MAILING LISTS
There are a couple of mailing lists for
.I gtk-gnutella.
See http://sourceforge.net/mail/?group_id=4467 for more info.
.SH BUGS
.I gtk-gnutella
is beta-quality software, and still has bugs and incomplete or missing
features.  But which software doesn't for its authors?
.PP
There are probably other missing features that should
be listed here.
.PP
A list of known bugs might be available at the
.I gtk-gnutella
web site (see below.)
.SH "SEE ALSO"
Additional information about gtk-gnutella and the latest version are
available at
.B http://gtk-gnutella.sourceforge.net/
.PP
Additional information about gnutella is available at
.B  http://www.the-gdf.com/
.B  http://www.infoanarchy.org/wiki/wiki.pl?Gnutella
.B  http://rfc-gnutella.sourceforge.net/
.SH AUTHORS
Yann Grossel wrote the original
.B Gtk-Gnutella .
.PP
Raphael Manfredi <Raphael_Manfredi@pobox.com> is the current maintainer
and project leader (since version 0.14, released early September 2001).
.br
Richard Eckart <wyldfire@users.sourceforge.net> is actively working
on GUI issues.
.PP
For a full list of contributors, open the "About" menu.
.PP
Brian St. Pierre <bstpierre@bstpierre.org> wrote the initial version
of this manpage.
.SH COPYRIGHT
.I gtk-gnutella
is Copyright (c) 2000, Yann Grossel, with additional copyrights held
by other contributors 2000, 2001 and 2002.
.PP
License to use and copy
.I gtk-gnutella
is given under the terms of the GNU General Public
License (GPL), version 2. Please see the file COPYING in the
distribution for complete information.

Permission is granted to make and distribute verbatim copies of this
manual page provided the copyright notice and this permission notice
are preserved on all copies.

Permission is granted to copy and distribute modified versions  of
this manual page under the conditions for verbatim copying, provided
that the entire resulting derived work is distributed under the
terms of a permission notice identical to this one.
