/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/*
 *  GThumb
 *
 *  Copyright (C) 2001 The Free Software Foundation, Inc.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Street #330, Boston, MA 02111-1307, USA.
 */

#ifndef GTHUMB_WINDOW_H
#define GTHUMB_WINDOW_H

#include "image-viewer.h"
#include "file-list.h"
#include "dir-list.h"
#include "catalog-list.h"

typedef struct {
	GtkWidget       *app;
	GtkWidget       *statusbar;

	GtkWidget       *viewer;
	GtkWidget       *viewer_container;  /* Container widget for the 
					     * viewer.  Used by fullscreen in
					     * order to reparent the viewer.*/
	FileList        *file_list;
	DirList         *dir_list;
	CatalogList     *catalog_list;
	
	gchar *catalog_path;      /* the catalog file we are showing in the
				   * file list. */

	gchar *image_path;        /* the image file we are showing in the
				   * image viewer. */

	gchar *image_catalog;     /* the catalog the current image belongs to,
				   * NULL if the image is not from a 
				   * catalog. */

	/* toolbar items. */

	GtkWidget   *tool_item_up_dir;
	GtkWidget   *tool_item_show_dir;
	GtkWidget   *tool_item_show_catalog;
	GtkWidget   *tool_item_show_history;
	GtkWidget   *tool_item_zoom_to_fit;

	/* menu items. */

	GtkWidget   *mitem_rename;
	GtkWidget   *mitem_copy;
	GtkWidget   *mitem_move;
	GtkWidget   *mitem_delete;
	GtkWidget   *mitem_modify_image;
	GtkWidget   *mitem_add_comment;
	GtkWidget   *mitem_delete_comment;
	GtkWidget   *mitem_add_to_catalog;
	GtkWidget   *mitem_remove_from_catalog;
	GtkWidget   *mitem_go_to_container;
	GtkWidget   *mitem_add_bookmark;
	GtkWidget   *mitem_slideshow;
	GtkWidget   *mitem_thumbnails;
	GtkWidget   *mitem_white_trans;
	GtkWidget   *mitem_transparenty[4];
	GtkWidget   *mitem_zoom_quality[2];
	GtkWidget   *mitem_bookmarks;
	GtkWidget   *mitem_go;
	GtkWidget   *mitem_print;
	GtkWidget   *mitem_browser;
	GtkWidget   *mitem_wallpaper;
	GtkWidget   *mitem_open_with;
	GtkWidget   *mitem_export;
	GtkWidget   *mitem_edit_catalog;
	GtkWidget   *mitem_catalog_search[2];

	GtkTooltips *bookmarks_tooltips;
	GtkTooltips *history_tooltips;

	GtkWidget   *popmitem_fullscreen;

	GtkWidget   *popupmenu_file[14];
	GtkWidget   *popupmenu_catalog[6];

	/* misc. */

	GtkWidget   *toolbar;
	GtkWidget   *main_pane;
	GtkWidget   *content_pane;
	GtkWidget   *image_table;
	GtkWidget   *notebook;
	GtkWidget   *location_entry;
	gboolean     location_on_main_bar;

	/* popup menus. */

	GtkWidget   *file_popup_menu;
	GtkWidget   *catalog_popup_menu;
	GtkWidget   *image_popup_menu;

	/* statusbar widgets. */

	GtkWidget   *image_info;
	GtkWidget   *progress;
	
	gchar        sidebar_content;    /* SidebarContent values. */
	gint         sidebar_width;
	gboolean     sidebar_visible;

	guint        dir_load_timeout_handle;       /* activity timeout 
						     * handle. */
	gfloat       dir_load_progress;
	gint         activity_ref;                  /* when > 0 some activity
						     * is present. */

	gboolean     setting_file_list;
	gboolean     changing_directory;

	guint        timer;              /* slideshow timer. */
	gboolean     slideshow;          /* whether the slideshow is active. */
	gboolean     fullscreen;         /* whether the fullscreen mode is 
					  * active. */

	GtkWidget   *focused;            /* the focused widget. */

	gboolean     view_first_image;   /* whether to automatically view 
					  * the first image of the list.
					  * Used when called with arguments
					  * on command line. */

	gboolean     refreshing;         /* true if we are refreshing
					  * the file list.  Used to handle
					  * the refreshing case in special 
					  * mode. */

	guint        view_image_timer;   /* timer for the view_image_at_pos 
					  * function. */
} GThumbWindow;


GThumbWindow *  window_new                          (gboolean view_first_image);

void            window_close                        (GThumbWindow *window);

void            window_set_sidebar_content          (GThumbWindow *window,
						     gint sidebar_content); 

void            window_hide_sidebar                 (GThumbWindow *window);

void            window_show_sidebar                 (GThumbWindow *window);

void            window_refresh                      (GThumbWindow *window);

void            window_update_file_list             (GThumbWindow *window);

void            window_update_catalog_list          (GThumbWindow *window);

void            window_update_bookmark_list         (GThumbWindow *window);

void            window_update_history_list          (GThumbWindow *window);

void            window_update_title                 (GThumbWindow *window);

void            window_update_statusbar             (GThumbWindow *window);

void            window_go_to_directory              (GThumbWindow *window,
						     const gchar *dir_path);

void            window_go_to_catalog                (GThumbWindow *window,
						     const gchar *catalog_path);

void            window_update_menu_sensitivity      (GThumbWindow *window);

gboolean        window_show_next_image              (GThumbWindow *window);

gboolean        window_show_prev_image              (GThumbWindow *window);

gboolean        window_show_first_image             (GThumbWindow *window);

gboolean        window_show_last_image              (GThumbWindow *window);

void            window_load_image                   (GThumbWindow *window, 
						     const gchar *filename);

void            window_start_slideshow              (GThumbWindow *window);

void            window_stop_slideshow               (GThumbWindow *window);

void            window_start_activity_mode          (GThumbWindow *window);

void            window_stop_activity_mode           (GThumbWindow *window);

/* functions used to notify a change. */

void            window_notify_files_deleted         (GThumbWindow *window,
						     GList *list);

void            window_notify_cat_files_deleted     (GThumbWindow *window,
						     const gchar *catalog_name,
						     GList *list);

void            window_notify_file_rename           (GThumbWindow *window,
						     const gchar *old_name,
						     const gchar *new_name);

void            window_notify_update_comment        (GThumbWindow *window,
						     const gchar *filename);

void            window_notify_update_directory      (GThumbWindow *window,
						     const gchar *dir_path);

void            window_notify_update_layout         (GThumbWindow *window);

#endif /*  GTHUMB_WINDOW_H */
