/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/*
 *  GThumb
 *
 *  Copyright (C) 2001 The Free Software Foundation, Inc.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Street #330, Boston, MA 02111-1307, USA.
 */

#ifndef FILE_UTILS_H
#define FILE_UTILS_H

#include <sys/stat.h>
#include <sys/types.h>
#include <time.h>
#include <libgnomevfs/gnome-vfs-types.h>
#include "typedefs.h"

typedef struct _PathListData PathListData;

typedef void (*PathListDoneFunc) (PathListData *dld, gpointer data);

struct _PathListData {
	GnomeVFSURI *uri;
	GnomeVFSResult result;
	GList *files;               /* gchar* items. */
	GList *dirs;                /* gchar* items. */
	PathListDoneFunc done_func;
	gpointer data;
};


typedef struct {
	GnomeVFSAsyncHandle *vfs_handle;
	PathListData *pli_data;
} PathListHandle;


PathListData *      path_list_data_new           ();
void                path_list_data_free          (PathListData *dli);
void                path_list_handle_free        (PathListHandle *handle);

gboolean            path_is_file                 (const gchar *s);

gboolean            path_is_dir                  (const gchar *s);

gboolean            dir_is_empty                 (const gchar *s);

GnomeVFSFileSize    get_file_size                (const gchar *s);

time_t              get_file_mtime               (const gchar *s);

time_t              get_file_ctime               (const gchar *s);

gboolean            file_copy                    (const gchar *from, 
						  const gchar *to);

gboolean            file_move                    (const gchar *from, 
						  const gchar *to);

gint                file_in_path                 (const gchar *name);

gboolean            ensure_dir_exists            (const gchar *a_path,
						  mode_t mode);

gboolean            file_is_hidden               (const gchar *name);

const gchar *       file_name_from_path          (const gchar *path);

gchar *             remove_level_from_path       (const gchar *path);

gchar *             remove_extension_from_path   (const gchar *path);

gchar *             remove_ending_separator      (const gchar *path);


/* Return TRUE on success, it is up to you to free
 * the lists with path_list_free()
 */
gboolean                path_list_new              (const gchar *path, 
						    GList **files, 
						    GList **dirs);

void                    path_list_free             (GList *list);


PathListHandle *        path_list_async_new        (const gchar *uri, 
						    PathListDoneFunc f,
						    gpointer  data);

void                    path_list_async_interrupt  (PathListHandle *handle);

gboolean                visit_rc_directory         (const gchar *rc_dir,
						    const gchar *rc_ext,
						    const char *dir,
						    gboolean recursive,
						    gboolean clear_all);

typedef void (*VisitFunc) (gchar *real_file, gchar *rc_file, gpointer data);
typedef void (*VisitDoneFunc) (const GList *dir_list, gpointer data);

void                    visit_rc_directory_async   (const gchar *rc_dir,
						    const gchar *rc_ext,
						    const char *dir,
						    gboolean recursive,
						    VisitFunc do_something,
						    VisitDoneFunc done_func,
						    gpointer data);

gboolean                file_is_image              (const gchar *name,
						    gboolean fast_file_type);

long                    checksum_simple            (const gchar *path);

GList *                 dir_list_filter_and_sort   (GList *dir_list, 
						    gboolean names_only,
						    gboolean show_dot_files);

gchar*                  shell_escape               (const gchar *filename);


#endif /* FILE_UTILS_H */
