/*
 *  PGSectionedString.m
 *  graphviz
 *
 *  Created by Glen Low on Thu Jan 08 2004.
 *  Copyright (c) 2004, Pixelglow Software. All rights reserved.
 *  http://www.pixelglow.com/graphviz/
 *  graphviz@pixelglow.com
 *
 *  Redistribution and use in source and binary forms, with or without modification, are permitted
 *  provided that the following conditions are met:
 *  * Redistributions of source code must retain the above copyright notice, this list of conditions
 *    and the following disclaimer.
 *  * Redistributions in binary form must reproduce the above copyright notice, this list of conditions
 *    and the following disclaimer in the documentation and/or other materials provided with the distribution.
 *  * Neither the name of Pixelglow Software nor the names of its contributors may be used to endorse or
 *    promote products derived from this software without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
 *  INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 *  ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 *  LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 *  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 *  THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#import "PGSectionedString.h"

unsigned int maxOrder_ = 0;

@implementation PGSectionedString

- (id) initWithMutableAttributedString: (NSMutableAttributedString*) string
	{
		if ((self = [super init]))
			{
				string_ = [string retain];
				order_ = maxOrder_++;
				attributeAtIndexEffectiveRange_ = (AttributeAtIndexEffectiveRangeMethod)
					[string methodForSelector: @selector (attribute:atIndex:effectiveRange:)];
			}
		return self;
	}

- (NSMutableAttributedString*) attributedString
	{
		return string_;
	}
	
- (NSRange) range
	{
		unsigned int stringLength = [string_ length];
		
		unsigned int start = 0;
		unsigned int finish = stringLength;
		
		while (start != finish)
			{
				unsigned int check = (start + finish - 1) / 2;
				
				NSRange effectiveRange;
				NSNumber* checkOrder =
					attributeAtIndexEffectiveRange_ (string_, @selector (attribute:atIndex:effectiveRange:), SectionedStringOrder, check, &effectiveRange);
			
				if (checkOrder)
					{
						unsigned int checkOrderValue = [checkOrder unsignedIntValue];
						if (checkOrderValue < order_)
							start = effectiveRange.location + effectiveRange.length;
						else if (checkOrderValue > order_)
							finish = effectiveRange.location;
						else
							{
								IsEqualToNumberMethod isEqualToNumber = (IsEqualToNumberMethod) [checkOrder methodForSelector: @selector (isEqualToNumber:)];
							
								start = effectiveRange.location;
								do
									finish = effectiveRange.location + effectiveRange.length;
								while (finish != stringLength
									&& isEqualToNumber (checkOrder, @selector (isEqualToNumber:), attributeAtIndexEffectiveRange_ (string_, @selector (attribute:atIndex:effectiveRange:), SectionedStringOrder, finish, &effectiveRange)));
									
								do
									start = effectiveRange.location;
								while (start != 0
									&& isEqualToNumber (checkOrder, @selector (isEqualToNumber:), attributeAtIndexEffectiveRange_ (string_, @selector (attribute:atIndex:effectiveRange:), SectionedStringOrder, start - 1, &effectiveRange)));
									
								return NSMakeRange (start, finish - start);
							
							}
					}
				else
					break;
			}
		return NSMakeRange (start, 0);
	}

- (void) appendAttributedString: (NSAttributedString*) attributedString
	{
		NSRange selfRange = [self range];
		unsigned int finish = selfRange.location + selfRange.length;
		[string_ insertAttributedString: attributedString atIndex: finish];
		[string_ addAttribute: SectionedStringOrder value: [NSNumber numberWithUnsignedInt: order_] range: NSMakeRange (finish, [attributedString length])];
	}
	
- (void) removeAttribute: (NSString*) attribute range: (NSRange) range
	{
		NSRange selfRange = [self range];
		if (range.length > selfRange.length)
			[[NSException exceptionWithName: NSRangeException reason: @"" userInfo: nil] raise];
		range.location += range.location;
		[string_ removeAttribute: attribute range: [self range]];
	}

- (unsigned int) length
	{
		return [self range].length;
	}

- (void) removeAttribute: (NSString*) attribute
	{
		[string_ removeAttribute: attribute range: [self range]];
	}
	
- (void) dealloc
	{
		[string_ release];
		[super dealloc];
	}

@end

NSString* SectionedStringOrder = @"SectionedStringOrder";