/*
 *  PGGraphvizStatusController.m
 *  graphviz
 *
 *  Created by Glen Low on Thu Dec 25 2003.
 *  Copyright (c) 2003, Pixelglow Software. All rights reserved.
 *  http://www.pixelglow.com/graphviz/
 *  graphviz@pixelglow.com
 *
 *  Redistribution and use in source and binary forms, with or without modification, are permitted
 *  provided that the following conditions are met:
 *  * Redistributions of source code must retain the above copyright notice, this list of conditions
 *    and the following disclaimer.
 *  * Redistributions in binary form must reproduce the above copyright notice, this list of conditions
 *    and the following disclaimer in the documentation and/or other materials provided with the distribution.
 *  * Neither the name of Pixelglow Software nor the names of its contributors may be used to endorse or
 *    promote products derived from this software without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
 *  INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 *  ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 *  LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 *  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 *  THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#import "PGGraphvizStatusController.h"
#import "PGGraphvizDocument.h"

@implementation PGGraphvizStatusController

- (void) awakeFromNib
	{
		[[NSNotificationCenter defaultCenter]
			addObserver: self
			selector: @selector (processDidChange:)
			name: DotDocumentProcessDidChange
			object: document];

		[[NSNotificationCenter defaultCenter]
			addObserver: self
			selector: @selector (imageDidChange:)
			name: DotDocumentImageDidChange
			object: document];
	}

- (void) imageDidChange: (NSNotification*) notification
	{
		[imageSize_ release];
		imageSize_ = @"";
		
		NSImage* image = [document image];
		if (image)
			{
				NSSize size = [image size];
				imageSize_ = [[NSString stringWithFormat: @"%.f pt %C %.f pt.", size.width, 0x00d7, size.height] retain];
				
				switch ([document process])
					{
						case ProcessRenderedOK:
						case ProcessExportedOK:
							[messager setStringValue: imageSize_];
							break;
						default:
							break;
					}
			}
	}
	
- (void) processDidChange: (NSNotification*) notification
	{
		switch ([document process])
			{
				case ProcessRendering:
					[alerter setImage: nil];
					[alerter setEnabled: NO];
					[progresser startAnimation: self];
					[messager setStringValue: @"Rendering..."];
					break;
					
				case ProcessExporting:
					[alerter setImage: nil];
					[alerter setEnabled: NO];
					[progresser startAnimation: self];
					[messager setStringValue: @"Exporting..."];
					break;
				
				case ProcessRenderedOK:
					[alerter setImage: nil];
					[alerter setEnabled: NO];
					[progresser stopAnimation: self];
					[messager setStringValue: imageSize_];
					break;
				
				case ProcessExportedOK:
					[alerter setImage: nil];
					[alerter setEnabled: NO];
					[progresser stopAnimation: self];
					[messager setStringValue: imageSize_];
					break;

				case ProcessRenderedError:
					[alerter setImage: [NSImage imageNamed: @"warning"]];
					[alerter setEnabled: YES];
					[progresser stopAnimation: self];
					[messager setStringValue: @"Failed to render."];
					break;
					
				case ProcessExportedError:
					[alerter setImage: [NSImage imageNamed: @"warning"]];
					[alerter setEnabled: YES];
					[progresser stopAnimation: self];
					[messager setStringValue: @"Failed to export."];
					break;
					
				default:
					break;
			}
	
	}
	
- (void) dealloc
	{
		[[NSNotificationCenter defaultCenter] removeObserver: self];
		[imageSize_ release];
		[super dealloc];
	}
	
@end
