#
# Gramps - a GTK+/GNOME based genealogy program
#
# Copyright (C) 2002-2006  Donald N. Allingham
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#

# $Id: _FilterMenu.py 9912 2008-01-22 09:17:46Z acraphae $

#-------------------------------------------------------------------------
#
# GTK
#
#-------------------------------------------------------------------------
import gtk
from gettext import gettext as _
import gobject

#-------------------------------------------------------------------------
#
# This is used by plugins to create a menu of available filters
#
#-------------------------------------------------------------------------
def build_filter_menu(local_filters = [], default=""):
    from Filters import SystemFilters, CustomFilters
    menu = gtk.Menu()

    for filt in local_filters:
        menuitem = gtk.MenuItem(filt.get_name())
        menuitem.show()
        menu.append(menuitem)
        menuitem.set_data("filter", filt)
        
    for filt in SystemFilters.get_filters():
        menuitem = gtk.MenuItem(_(filt.get_name()))
        menuitem.show()
        menu.append(menuitem)
        menuitem.set_data("filter", filt)

    for filt in CustomFilters.get_filters():
        menuitem = gtk.MenuItem(_(filt.get_name()))
        menuitem.show()
        menu.append(menuitem)
        menuitem.set_data("filter", filt)

    return menu

#-------------------------------------------------------------------------
#
# This is used by plugins to create a menu of available filters
#
#-------------------------------------------------------------------------
def build_filter_model(space, local = [], default=""):
    from Filters import SystemFilters, CustomFilters

    model = gtk.ListStore(gobject.TYPE_STRING, object)

    flist = local + SystemFilters.get_filters(space) + \
	                                           CustomFilters.get_filters(space)

    for filt in flist:
        model.append(row=[filt.get_name(), filt])
    return model
