/*
 * Copyright (c) 1999 G. Adam Stanislav
 * All rights reserved.
 *
 * This software is distributed under the Whiz Kid Technomagic
 * No-Nonsense License. Please read the file NNL, or visit
 * http://www.whizkidtech.net/nnl/
 *
 * This program counts the number of seconds, minutes, hours, or days
 * remaining till the year 2000 UTC.
 *
 * Its main purpose is to be run within a GCL script.
 * You need version 2.30 (or later) of gracula.
 * If you do not have it, visit http://www.whizkidtech.net/gcl/
 *
 * To use it, create a GCL file as usual, then add these two lines at the end:
 *
 *	nocompile
 *	count = `/usr/local/bin/sec2000`
 *
 * This will create a counter with the number of seconds till the year 2000 UTC.
 * If you want some other time zone, simply add or subtract the number of
 * seconds needed, by appending this line AFTER the two above:
 *
 *	count -= 3600
 *
 * Of course, you may need to use + instead of -, and a different number of
 * seconds. If you live WEST of UTC, the year 2000 will arrive sooner, so
 * you need to subtract. If you live EAST of UTC, you need to add.
 *
 * If you wish to display the number of minutes rather than second, change it
 * to
 *
 *	nocompile
 *	count = `/usr/local/bin/sec2000 m`
 *
 * To show number of hours:
 *
 *	nocompile
 *	count = `/usr/local/bin/sec2000 h`
 *
 * To show number of days:
 *
 *	nocompile
 *	count = `/usr/local/bin/sec2000 d`
 *
 * In any case, if the program is somewhere other than /usr/local/bin,
 * use whatever directory it is in. Please note that the command is
 * surrounded by backticks, not by single quotes...
 */

#include <time.h>
#include <stdio.h>

char what = 0;

main(int argv, char *argc[]) {
	time_t diff;

	if (argv > 1) what = *argc[1];

	diff = 946684800 - time(NULL);
	if (what == 'm') diff /= 60;
	else if (what == 'h') diff /= 3600;
	else if (what == 'd') {diff /= (3600 * 24); diff++;}
	printf("%i", diff);
}

