/*
 * GQview
 * (C) 2002 John Ellis
 *
 * Author: John Ellis
 *
 * This software is released under the GNU General Public License (GNU GPL).
 * Please read the included file COPYING for more information.
 * This software comes with no warranty of any kind, use at your own risk!
 */


#include "gqview.h"
#include "dnd.h"

#include "collect.h"
#include "image.h"
#include "ui_fileops.h"


GtkTargetEntry dnd_file_drag_types[] = {
	{ "text/uri-list", 0, TARGET_URI_LIST },
	{ "text/plain", 0, TARGET_TEXT_PLAIN }
};
gint dnd_file_drag_types_count = 2;

GtkTargetEntry dnd_file_drop_types[] = {
	{ "application/x-gqview-collection-member", 0, TARGET_APP_COLLECTION_MEMBER },
	{ "text/uri-list", 0, TARGET_URI_LIST }
};
gint dnd_file_drop_types_count = 2;


GList *get_uri_file_list(gchar *data)
{
	GList *list = NULL;
	gint b, e;

	b = e = 0;

	while (data[b] != '\0')
		{
		while (data[e] != '\r' && data[e] != '\n' && data[e] != '\0') e++;
		if (!strncmp(data + b, "file:", 5))
			{
			b += 5;
			while (data[b] == '/' && data[b+1] == '/') b++;
			list = g_list_append(list, g_strndup(data + b, e - b));
			}
		while (data[e] == '\r' || data[e] == '\n') e++;
		b = e;
		}

	return list;
}

gchar *make_uri_file_list(GList *list, gint plain_text, gint *length)
{
	gchar *uri_text = NULL;
	gchar *leader = "file:";
	gchar *sep = "\r\n";
	gint total;
	gint leader_l;
	gint sep_l = strlen(sep);
	gchar *ptr;
	GList *work;

	if (!list)
		{
		*length = 0;
		return NULL;
		}

	if (plain_text)
		{
		leader_l = 0;
		}
	else
		{
		leader_l = strlen(leader);
		}
	

	work = list;
	total = 0;

	/* compute length */

	while (work)
		{
		gchar *name = work->data;
		total += leader_l + strlen(name) + sep_l;
		work = work->next;
		}

	/* create list */
	uri_text = g_malloc(total + 1);
	ptr = uri_text;

	work = list;
	while (work)
		{
		gchar *name = work->data;
		if (leader_l > 0)
			{
			strcpy(ptr, leader);
			ptr += leader_l;
			}
		strcpy(ptr, name);
		ptr += strlen(name);
		strcpy(ptr, sep);
		ptr += sep_l;
		work = work->next;
		}
	ptr[0] = '\0';

	*length = total;

	return uri_text;
}

