/*
 * (SLIK) SimpLIstic sKin functions
 * (C) 2001 John Ellis
 *
 * Author: John Ellis
 *
 * This software is released under the GNU General Public License (GNU GPL).
 * Please read the included file COPYING for more information.
 * This software comes with no warranty of any kind, use at your own risk!
 */


#ifndef UI_CLIST_EDIT_H
#define UI_CLIST_EDIT_H


typedef struct _ClistEditData ClistEditData;
struct _ClistEditData
{
	GtkWidget *window;
	GtkWidget *entry;

	gchar *old_name;
	gchar *new_name;

	gint (*edit_func)(ClistEditData *ced, const gchar *oldname, const gchar *newname, gpointer data);
	gpointer edit_data;

	GtkCList *clist;
	gint row;
	gint column;
};


/*
 * edit_func: return TRUE is rename successful, FALSE on failure.
 */
gint clist_edit_by_row(GtkCList *clist, gint row, gint column,
		       gint (*edit_func)(ClistEditData *, const gchar *, const gchar *, gpointer), gpointer data);


#endif

