/*
 * (SLIK) SimpLIstic sKin functions
 * (C) 2001 John Ellis
 *
 * Author: John Ellis
 *
 * This software is released under the GNU General Public License (GNU GPL).
 * Please read the included file COPYING for more information.
 * This software comes with no warranty of any kind, use at your own risk!
 */

#ifndef UI2_TEXT_H
#define UI2_TEXT_H

typedef struct _FontData FontData;
struct _FontData
{
	GdkPixbuf *overlay;
	gint char_width;
	gint char_height;
	gint extended;	/* to support chars above 128 */
	gint ref;	/* ref count */
};

typedef struct _TextData TextData;
struct _TextData
{
	FontData *font;

	GdkPixbuf *pixbuf;
	gint length;
	gint width;
	gint height;
	gint x;
	gint y;
	gint sizeable;
	gint size_width;
	gchar *text;
	gint offset;
	gint scroll;
	gint autoscroll;
	gint autoscroll_reverse_count;
	gint autoscroll_delay;

	gint scroll_cb_id;
	SkinData *skin;
};


FontData *font_new(GdkPixbuf *pb, gint extended);
FontData *font_new_from_data(gchar **data, gint extended);
FontData *font_new_from_file(const gchar *file, gint extended);

void font_ref(FontData *font);
void font_unref(FontData *font);

WidgetData *font_register(SkinData *skin, FontData *font, const gchar *key, const gchar *text_id);
WidgetType font_type_id(void);
void font_type_init(void);


TextData *text_new(FontData *font, gint length, gint sizeable, gint x, gint y);
TextData *text_new_from_data(gchar **data, gint length, gint extended, gint sizeable, gint x, gint y);
TextData *text_new_from_file(const gchar *file, gint length, gint extended, gint sizeable, gint x, gint y);
void text_free(TextData *text);

gint text_set_text(const gchar *key, UIData *ui, const gchar *new_text);

gint text_set_autoscroll(const gchar *key, UIData *ui, gint enable);

gint text_set_scroll_speed(const gchar *key, UIData *ui, gint delay);

WidgetData *text_register(SkinData *skin, TextData *text, const gchar *key, const gchar *text_id);
RegisterData *text_register_key(const gchar *key, UIData *ui,
				const gchar *(*status_get_func)(TextData *text, const gchar *key, gpointer data), gpointer status_get_data);


WidgetType text_type_id(void);
void text_type_init(void);


#endif


