/*
 * GQmpeg
 * (C) 2001 John Ellis
 *
 * Author: John Ellis
 *
 * This software is released under the GNU General Public License (GNU GPL).
 * Please read the included file COPYING for more information.
 * This software comes with no warranty of any kind, use at your own risk!
 */


#include "gqmpeg.h"
#include "songinfo.h"

#include "players.h"
#include "ui_fileops.h"

static void close_song_info_window(GtkWidget *widget, gpointer data)
{
	GtkWidget *window = data;
	gtk_widget_destroy(window);
}

static void destroy_song_info_window(GtkWidget *widget, GdkEvent *event, gpointer data)
{
	gtk_widget_destroy(widget);
}

void view_song_info(const gchar *path)
{
	GtkWidget *info_widget;
	GtkWidget *window;
	GtkWidget *vbox;
	GtkWidget *hbox;
	GtkWidget *label;
	GtkWidget *button;
	gchar *buf;

	if (!path) return;

	info_widget = player_module_songdata_detail_info(path);

	window = gtk_window_new(GTK_WINDOW_TOPLEVEL);
	gtk_window_set_policy (GTK_WINDOW (window),FALSE,FALSE,TRUE);
	gtk_signal_connect (GTK_OBJECT (window), "delete_event",(GtkSignalFunc) destroy_song_info_window, NULL);
	buf = g_strconcat(_("Song info - "), filename_from_path(path), NULL);
	gtk_window_set_title (GTK_WINDOW (window), buf);
	g_free(buf);
	gtk_container_border_width (GTK_CONTAINER(window), 5);

	vbox = gtk_vbox_new(FALSE, 0);
	gtk_container_border_width (GTK_CONTAINER (vbox), 5);
        gtk_container_add(GTK_CONTAINER(window), vbox);
        gtk_widget_show(vbox);

	if (info_widget)
		{
		gtk_box_pack_start(GTK_BOX(vbox), info_widget, FALSE, FALSE, 0);
		gtk_widget_show(info_widget);
		}
	else
		{
		label = gtk_label_new(_("Unknown audio type"));
		gtk_box_pack_start(GTK_BOX(vbox), label, FALSE, FALSE, 0);
		gtk_widget_show(label);
		}

	hbox = gtk_hbox_new(FALSE, 0);
	gtk_box_pack_end(GTK_BOX(vbox), hbox, FALSE, FALSE, 0);
	gtk_widget_show(hbox);

	button = gtk_button_new_with_label(_("Close"));
	gtk_signal_connect (GTK_OBJECT (button), "clicked",(GtkSignalFunc) close_song_info_window, window);
	gtk_box_pack_end(GTK_BOX(hbox), button, FALSE, FALSE, 10);
	gtk_widget_show(button);

	gtk_widget_show(window);
}

