/*
 * (SLIK) SimpLIstic sKin functions
 * (C) 2002 John Ellis
 *
 * Author: John Ellis
 *
 * This software is released under the GNU General Public License (GNU GPL).
 * Please read the included file COPYING for more information.
 * This software comes with no warranty of any kind, use at your own risk!
 */

#include "ui2_includes.h"
#include "ui2_typedefs.h"
#include "ui2_init.h"

#include "ui2_button.h"
#include "ui2_dial.h"
#include "ui2_item.h"
#include "ui2_list.h"
#include "ui2_number.h"
#include "ui2_slider.h"
#include "ui2_text.h"

/*
 * To add/register new widgets with the ui, simply place the init function here,
 * and it will be run the first time ui_new() is called.
 * 
 * Or you can call the widget's init function directly, if you want. - This is
 * merely a function that encapsulates all the default included widgets, and is
 * automatically called when the ui functions are used.
 */

void ui_init_types(void)
{
	static gint init_done = FALSE;

	if (init_done) return;
	init_done = TRUE;

	button_type_init();
	dial_type_init();
	item_type_init();
	digit_type_init();
	number_type_init();
	list_type_init();
	slider_type_init();
	font_type_init();
	text_type_init();
}

