/*
 * GQmpeg
 * (C) 2001 John Ellis
 *
 * Author: John Ellis
 *
 * This software is released under the GNU General Public License (GNU GPL).
 * Please read the included file COPYING for more information.
 * This software comes with no warranty of any kind, use at your own risk!
 */


#include "gqmpeg.h"
#include "window.h"

#include "btn_funcs.h"
#include "display.h"
#include "menus.h"
#include "playlist.h"
#include "playlist-window.h"
#include "preferences.h"
#include "ui2_display.h"
#include "ui2_main.h"

#include <gdk/gdkkeysyms.h> /* for key values */

static void key_pressed(GtkWidget *widget, GdkEventKey *event)
{
	static gint last_key = 0;
	static gint last_state = 0;
	static guint32 last_time = 0;

	/* cheap hacks/checks to avoid problems caused by holding down
	 * keys with fast repeat rates */
	if (event->keyval == last_key && event->state == last_state &&
			last_time + 500 >= event->time)
		{
		return;
		}
	else
		{
		last_key = event->keyval;
		last_state = event->state;
		last_time = event->time;
		}

	if (debug_mode) printf("key pressed: %d\n", event->keyval);

	if (event->state & GDK_CONTROL_MASK)
		{
		switch (event->keyval)
			{
			case 's': case 'S':
				btn_shuffle_pressed();
				break;
			case 'r': case 'R':
				btn_repeat_pressed();
				break;
			case 't': case 'T':
				time_toggle_pressed();
				break;
			case 'q': case 'Q':
				gqmpeg_exit();
				break;
			case 'a': case 'A':
				show_about_info();
				break;
			case 'o': case 'O':
				show_configuration_window();
				break;
			case 'i': case 'I':
				btn_iconify_pressed();
				break;
			case '-':
				btn_balance_left_pressed();
				btn_balance_released();
				break;
			case '+': case '=':
				btn_balance_right_pressed();
				btn_balance_released();
				break;
			case '1':
				btn_repeat_1_pressed();
				break;
			default:
				break;
			}
		}
	else
		{
		switch (event->keyval)
			{
			case 'p': case 'P': case ' ':
				btn_play_pressed();
				break;
			case 's': case 'S':
				btn_stop_pressed();
				break;
			case 'n': case 'N': case GDK_Page_Down: case GDK_KP_Page_Down:
				btn_next_down();
				btn_next_pressed();
				break;
			case 'b': case 'B': case GDK_Page_Up: case GDK_KP_Page_Up:
				btn_prev_down();
				btn_prev_pressed();
				break;
			case 'l': case 'L':
				playlist_window_show();
				break;
			case 'm': case 'M':
				btn_mixer_pressed();
				break;
			case 'w': case 'W':
				btn_mode_pressed();
				break;
			case 'i': case 'I':
				current_song_info_pressed();
				break;
			case '-':
				btn_volume_down_pressed();
				btn_volume_released();
				break;
			case '+': case '=':
				btn_volume_up_pressed();
				btn_volume_released();
				break;
			case '1':
				preset_1_pressed();
				break;
			case '2':
				preset_2_pressed();
				break;
			case '3':
				preset_3_pressed();
				break;
			case '4':
				preset_4_pressed();
				break;
			case '5':
				preset_5_pressed();
				break;
			case '6':
				preset_6_pressed();
				break;
			case '7':
				preset_7_pressed();
				break;
			case '8':
				preset_8_pressed();
				break;
			case '9':
				preset_9_pressed();
				break;
			case '0':
				preset_10_pressed();
				break;
			case GDK_Home: case GDK_KP_Home:
				current_song_set(playlist_get_first(), NULL);
				break;
			case GDK_End: case GDK_KP_End:
				current_song_set(playlist_get_last(), NULL);
				break;
			case 'a': case 'A':
				btn_loop_ab_pressed();
				break;
			case GDK_Escape:
				if (loop_ab_enabled)
					{
					loop_ab_enabled = FALSE;
					display_set_loop_ab(FALSE);
					}
				break;
			case '!':
				ui_debug_print_all_keys(main_window);
				break;
			case '~': case '`':
				btn_edit_skin_pressed();
				break;
			default:
				break;
			}
		}
}

static gint destroy(GtkWidget *widget, GdkEventAny *event, gpointer data)
{
	gqmpeg_exit();

	return TRUE;
}

void main_window_set_title(const gchar *title)
{
	if (main_window)
		{
		gchar *buf;

		if (title && !dock_mode)
			{
			buf = g_strconcat(title, " - GQmpeg", NULL);
			}
		else
			{
			buf = g_strdup("GQmpeg");
			}

		ui_title_set(main_window, buf);
		g_free(buf);
		}
}

static void main_window_mouse_cb(UIData *ui, gint button, guint32 time, gpointer data)
{
	if (button == 3 || (dock_mode && button == 2))
		{
		GtkWidget *menu;

		menu = menu_main();
		gtk_menu_popup(GTK_MENU(menu), NULL, NULL, NULL, NULL, button, time);
		return;
		}

	/* mouse wheel */
	else if (button == 4)
		{
		btn_volume_up_pressed();
		btn_volume_released();
		return;
		}
	else if (button == 5)
		{
		btn_volume_down_pressed();
		btn_volume_released();
		return;
		}

}

UIData *main_window_create(const gchar *skin_path)
{
	UIData *ui;

	ui = ui_new("GQmpeg", "gqmpeg", wm_decorations, "GQmpeg");
	ui_set_icon(ui, (const char **)gqmpeg_icon_xpm, NULL);

	gtk_signal_connect (GTK_OBJECT (ui->window), "delete_event", (GtkSignalFunc) destroy, ui);
	gtk_signal_connect (GTK_OBJECT (ui->window), "key_press_event",(GtkSignalFunc) key_pressed, ui);

	ui_set_mouse_callback(ui, main_window_mouse_cb, NULL);

	/* register the right stuff */
	display_register_widgets(ui);

/* ----	dnd_set_drop(display_area, display_area->window);
*/

	if (skin_path)
		{
		printf(_("loading skin..\n"));
		if (!ui_skin_load(ui, skin_path, NULL))
			{
			if (skin_default_path)
				{
				if (!ui_skin_load(ui, skin_default_path, skin_mode_key))
					{
					printf(_("Default skin not loaded, using built-in default\n"));
					ui_skin_load(ui, NULL, NULL);
					}
				}
			else
				{
				printf(_("Skin not loaded, using built-in default\n"));
				ui_skin_load(ui, NULL, NULL);
				}
			}
		}
	else if (skin_default_path)
		{
		if (!ui_skin_load(ui, skin_default_path, skin_mode_key))
			{
			printf(_("Skin in config file not loaded, using built-in default\n"));
			ui_skin_load(ui, NULL, NULL);
			}
		}
	else
		{
		ui_skin_load(ui, NULL, skin_mode_key);
		}

	playlist_window_update_titles();

	return ui;
}

