/*
 * GQmpeg
 * (C) 2001 John Ellis
 *
 * Author: John Ellis
 *
 * This software is released under the GNU General Public License (GNU GPL).
 * Please read the included file COPYING for more information.
 * This software comes with no warranty of any kind, use at your own risk!
 */


#include "gqmpeg.h"
#include "io_xmp.h"

#include "players.h"
#include "playlist.h"
#include "ui_fileops.h"

static void add_label_info(GtkWidget *vbox, const gchar *text, const gchar *data)
{
	gchar *buf;
	GtkWidget *label;

	if (data)
		{
		buf = g_strconcat(text, data, NULL);
		label = gtk_label_new(buf);
		g_free(buf);
		}
	else
		label = gtk_label_new(text);
	gtk_misc_set_alignment (GTK_MISC (label), 0, 0);
	gtk_box_pack_start(GTK_BOX(vbox), label, FALSE, FALSE, 0);
	gtk_widget_show(label);

}

static void add_label_info_number(GtkWidget *vbox, const gchar *text, gint n, const gchar *extra)
{
	gchar *buf;

	buf = g_strdup_printf("%d%s", n, extra ? extra : "");
	add_label_info(vbox, text, buf);
	g_free(buf);
}

GtkWidget *mod_create_info_window(const gchar *file)
{
	GtkWidget *vbox;
	GtkWidget *vbox1;
	GtkWidget *label;
	GtkWidget *frame;
	gchar *buf;
	SongData *sd;

	sd = player_module_songdata_init(file);
	if (sd) player_module_songdata_update(sd, TRUE);

	vbox = gtk_vbox_new(FALSE, 0);
	gtk_widget_show(vbox);

	buf = g_strconcat(_("Filename: "), filename_from_path(file), NULL);
	label = gtk_label_new(buf);
	g_free(buf);
	gtk_misc_set_alignment (GTK_MISC (label), 0, 0);
	gtk_box_pack_start(GTK_BOX(vbox), label, FALSE, FALSE, 0);
	gtk_widget_show(label);

	frame = gtk_frame_new(_("Song info"));
	gtk_container_border_width (GTK_CONTAINER (frame), 5);
	gtk_box_pack_start(GTK_BOX(vbox), frame, FALSE, FALSE, 0);
	gtk_widget_show(frame);

	vbox1 = gtk_vbox_new(FALSE, 0);
	gtk_container_border_width (GTK_CONTAINER (vbox1), 5);
	gtk_container_add(GTK_CONTAINER(frame), vbox1);
        gtk_widget_show(vbox1);

	if (sd)
		{
		add_label_info(vbox1, _("Title : "), sd->title);
		add_label_info(vbox1, _("Type : "), xmp_extra_data_get_type(sd));
		add_label_info(vbox1, _("Tracker name : "), xmp_extra_data_get_tracker(sd));

		add_label_info_number(vbox1, _("Length (estimated) : "), sd->length, _(" seconds"));
		add_label_info_number(vbox1, _("Length (patterns) : "), xmp_extra_data_get_positions(sd), NULL);
		add_label_info_number(vbox1, _("Unique patterns : "), xmp_extra_data_get_patterns(sd), NULL);
		add_label_info_number(vbox1, _("Instruments : "), xmp_extra_data_get_instruments(sd), NULL);
		add_label_info_number(vbox1, _("Channels : "), xmp_extra_data_get_channels(sd), NULL);
		}

	playlist_data_free(sd);

	return vbox;
}

