/*
 * GQmpeg
 * (C) 2001 John Ellis
 *
 * Author: John Ellis
 *
 * This software is released under the GNU General Public License (GNU GPL).
 * Please read the included file COPYING for more information.
 * This software comes with no warranty of any kind, use at your own risk!
 */


#include "gqmpeg.h"
#include "menus.h"

#include "btn_funcs.h"
#include "playlist-window.h"
#include "preferences.h"
#include "ui_menu.h"


/*
 *----------------
 * the menus
 *----------------
 */

static void load_preset_from_menu(GtkWidget *widget, gpointer data)
{
	gint n = GPOINTER_TO_INT(data);

	load_preset(n);
}

static GtkWidget *menu_preset(void)
{
	GtkWidget *menu;
	gint i;
	menu = gtk_menu_new();
	for (i=0; i<10; i++)
		{
		gchar *s;

		if (preset_name[i] && preset_file[i])
			{
			s = g_strdup_printf("%d - %s", i + 1, preset_name[i]);
			menu_item_add(menu, s, GTK_SIGNAL_FUNC(load_preset_from_menu), GINT_TO_POINTER(i));
			g_free(s);
			}
		else
			{
			s = g_strdup_printf(_("%d - (empty)"), i + 1);
			menu_item_add(menu, s, NULL, NULL);
			g_free(s);
			}
                }

	menu_item_add_divider(menu);
	menu_item_add(menu, _("Set preset to playlist..."), GTK_SIGNAL_FUNC(set_preset_to_playlist), preset_file[i]);
	menu_item_add(menu, _("Set preset to song..."), GTK_SIGNAL_FUNC(set_preset_to_song), preset_file[i]);

	return menu;
}

GtkWidget *menu_main(void)
{
	GtkWidget *menu;
	GtkWidget *item;
	GtkWidget *submenu;
	gint enabled;

	enabled = (current_song_get_data() != NULL);

	menu = popup_menu_short_lived();

	item = menu_item_add_sensitive(menu, _("Play"), enabled, btn_play_pressed, NULL);
	item = menu_item_add_sensitive(menu, _("Pause"), enabled, btn_pause_pressed, NULL);
	item = menu_item_add_sensitive(menu, _("Stop"), enabled, btn_stop_pressed, NULL);

	menu_item_add_divider(menu);

	menu_item_add(menu, _("Playlist..."), GTK_SIGNAL_FUNC(playlist_window_show), NULL);

	item = menu_item_add(menu, _("Presets"), NULL, NULL);
	submenu = menu_preset();
	gtk_menu_item_set_submenu(GTK_MENU_ITEM(item), submenu);

	item = menu_item_add(menu, _("Open"), NULL, NULL);
	submenu = gtk_menu_new();
	menu_item_add(submenu, _("Playlist..."), GTK_SIGNAL_FUNC(btn_load_playlist_pressed), NULL);
	menu_item_add(submenu, _("File..."), GTK_SIGNAL_FUNC(btn_load_file_pressed), NULL);
	menu_item_add(submenu, _("Custom..."), GTK_SIGNAL_FUNC(btn_load_custom_pressed), NULL);
        gtk_menu_item_set_submenu(GTK_MENU_ITEM(item), submenu);

	menu_item_add_divider(menu);

	item = menu_item_add(menu, _("Toggle"), NULL, NULL);
	submenu = gtk_menu_new();
	menu_item_add_check(submenu, _("Shuffle"), shuffle_mode, btn_shuffle_pressed, NULL);
	menu_item_add_check(submenu, _("Repeat"), repeat_mode, btn_repeat_pressed, NULL);
	menu_item_add_check(submenu, _("Repeat 1"), repeat_1_enabled, btn_repeat_1_pressed, NULL);
	menu_item_add_check(submenu, _("Time Total"), show_total_time, time_toggle_pressed, NULL);
	menu_item_add_check(submenu, _("Time Remaining"), show_remaining_time, time_remaining_pressed, NULL);
        gtk_menu_item_set_submenu(GTK_MENU_ITEM(item), submenu);

	menu_item_add(menu, _("Preferences..."), show_configuration_window, NULL);

	menu_item_add_divider(menu);

	item = menu_item_add_sensitive(menu, _("Current song"), enabled, NULL, NULL);
	submenu = gtk_menu_new();
	menu_item_add(submenu, _("Song Info..."), GTK_SIGNAL_FUNC(current_song_info_pressed), NULL);
	menu_item_add(submenu, _("Add to playlist"), GTK_SIGNAL_FUNC(current_song_pl_add_pressed), NULL);
	menu_item_add(submenu, _("Remove from playlist"), GTK_SIGNAL_FUNC(current_song_pl_rem_pressed), NULL);
        gtk_menu_item_set_submenu(GTK_MENU_ITEM(item), submenu);

	menu_item_add(menu, _("Run mixer..."), GTK_SIGNAL_FUNC(btn_mixer_pressed), NULL);
	menu_item_add_divider(menu);
	menu_item_add(menu, _("Skin Editor..."), GTK_SIGNAL_FUNC(btn_edit_skin_pressed), NULL);
	menu_item_add(menu, _("About..."), GTK_SIGNAL_FUNC(show_about_info), NULL);
	menu_item_add_divider(menu);
	menu_item_add(menu, _("Iconify"), GTK_SIGNAL_FUNC(btn_iconify_pressed), NULL);
	menu_item_add(menu, _("Exit"), GTK_SIGNAL_FUNC(gqmpeg_exit), NULL);

	return menu;
}

GtkWidget *menu_filelist_dir(void)
{
	GtkWidget *menu;

	menu = popup_menu_short_lived();

	menu_item_add(menu, _("Add"), GTK_SIGNAL_FUNC(plw_add_dir_pressed), NULL);
	menu_item_add(menu, _("Add Recursive"), GTK_SIGNAL_FUNC(plw_add_dir_recursive_pressed), NULL);

	return menu;
}

GtkWidget *menu_filelist_file(void)
{
	GtkWidget *menu;

	menu = popup_menu_short_lived();

	menu_item_add(menu, _("Add"), GTK_SIGNAL_FUNC(plw_filelist_add_pressed), NULL);
	menu_item_add(menu, _("Insert"), GTK_SIGNAL_FUNC(plw_filelist_insert_pressed), NULL);
	menu_item_add_divider(menu);
	menu_item_add(menu, _("Play"), GTK_SIGNAL_FUNC(plw_filelist_play_pressed), NULL);
	menu_item_add(menu, _("Add and Play"), GTK_SIGNAL_FUNC(plw_filelist_add_play_pressed), NULL);
	menu_item_add(menu, _("Song Info..."), GTK_SIGNAL_FUNC(plw_filelist_songinfo_pressed), NULL);
	menu_item_add_divider(menu);
	menu_item_add(menu, _("Copy"), GTK_SIGNAL_FUNC(plw_filelist_copy_pressed), NULL);
	menu_item_add(menu, _("Move"), GTK_SIGNAL_FUNC(plw_filelist_move_pressed), NULL);
	menu_item_add(menu, _("Rename"), GTK_SIGNAL_FUNC(plw_filelist_rename_pressed), NULL);
	menu_item_add(menu, _("Delete"), GTK_SIGNAL_FUNC(plw_filelist_delete_pressed), NULL);

	return menu;
}

GtkWidget *menu_filelist_playlist(void)
{
	GtkWidget *menu;

	menu = popup_menu_short_lived();

	menu_item_add(menu, _("Open"), GTK_SIGNAL_FUNC(plw_load_pressed), NULL);
	menu_item_add(menu, _("Append"), GTK_SIGNAL_FUNC(plw_append_pressed), NULL);
	menu_item_add_divider(menu);
	menu_item_add(menu, _("Copy"), GTK_SIGNAL_FUNC(plw_filelist_copy_pressed), NULL);
	menu_item_add(menu, _("Move"), GTK_SIGNAL_FUNC(plw_filelist_move_pressed), NULL);
	menu_item_add(menu, _("Rename"), GTK_SIGNAL_FUNC(plw_filelist_rename_pressed), NULL);
	menu_item_add(menu, _("Delete"), GTK_SIGNAL_FUNC(plw_filelist_delete_pressed), NULL);

	return menu;
}

static void menu_playlist_add_defaults(GtkWidget *menu)
{
	menu_item_add(menu, _("Play"), GTK_SIGNAL_FUNC(plw_playlist_play_pressed), NULL);
	menu_item_add_divider(menu);
	menu_item_add(menu, _("Remove"), GTK_SIGNAL_FUNC(plw_playlist_remove_pressed), NULL);
	menu_item_add(menu, _("Song Info..."), GTK_SIGNAL_FUNC(plw_playlist_songinfo_pressed), NULL);
	menu_item_add_divider(menu);
}

static void menu_playlist_add_shuffle(GtkWidget *menu)
{
	menu_item_add_divider(menu);
	menu_item_add(menu, _("Randomize list"), GTK_SIGNAL_FUNC(plw_playlist_randomize_pressed), NULL);
}

GtkWidget *menu_playlist(void)
{
	GtkWidget *menu;

	menu = popup_menu_short_lived();

	menu_playlist_add_defaults(menu);

	menu_item_add(menu, _("Copy"), GTK_SIGNAL_FUNC(plw_playlist_copy_pressed), NULL);
	menu_item_add(menu, _("Move"), GTK_SIGNAL_FUNC(plw_playlist_move_pressed), NULL);
	menu_item_add(menu, _("Rename"), GTK_SIGNAL_FUNC(plw_playlist_rename_pressed), NULL);
	menu_item_add(menu, _("Delete"), GTK_SIGNAL_FUNC(plw_playlist_delete_pressed), NULL);

	menu_playlist_add_shuffle(menu);

	return menu;
}

GtkWidget *menu_playlist_custom(void)
{
	GtkWidget *menu;

	menu = popup_menu_short_lived();

	menu_playlist_add_defaults(menu);

	menu_item_add(menu, _("Edit..."), GTK_SIGNAL_FUNC(plw_playlist_edit_pressed), NULL);

	menu_playlist_add_shuffle(menu);

	return menu;
}

