/*
    GQ -- a GTK-based LDAP client
    Copyright (C) 1998-2001 Bert Vermeulen

    This file (syntax.h) is
    Copyright (C) 2002 by Peter Stamfest and Bert Vermeulen

    This program is released under the Gnu General Public License with
    the additional exemption that compiling, linking, and/or using
    OpenSSL is allowed.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

/* $Id: syntax.h,v 1.5 2002/06/08 05:46:44 stamfest Exp $ */

#ifndef GQ_SYNTAX_H_INCLUDED
#define GQ_SYNTAX_H_INCLUDED

#include "formfill.h"

/* This is not as generic as one could wish, but we have to somehow map
   syntaxes to our code... */

struct syntax_handler {
     char *syntax_oid;
     char *desc;
     int displaytype;
     int (*displayTypeFunc)(const char *attr, const char *syn_oid);
     int must_binary;
};

typedef struct _display_type_handler {
     GtkWidget* (*get_widget)(struct formfill *form, 
			      GByteArray *data, 
			      GtkSignalFunc *activatefunc,
			      GHashTable *hash);
     GByteArray* (*get_data)(struct formfill *form, 
			     GtkWidget *widget);
     void (*set_data)(struct formfill *form, 
		      GByteArray *data, 
		      GtkWidget *widget);
     LDAPMod* (*buildLDAPMod)(struct formfill *form,
			      int op,
			      GList *values);
} display_type_handler;

#define DISPLAY_TYPE_HANDLER(objpointer) ((display_type_handler*)(objpointer))

struct syntax_handler *get_syntax_handler_of_attr(struct ldapserver *server, 
						  const char *attrname,
						  const char *oid);

int get_display_type_of_attr(struct ldapserver *server, 
			     const char *attrname);

display_type_handler *get_dt_handler(int type);

void init_syntaxes(void);

/* Utility functions */
LDAPMod *bervalLDAPMod(struct formfill *form, int op, GList *values);

GByteArray *identity(const char *val, int len);

#endif

/* 
   Local Variables:
   c-basic-offset: 5
   End:
 */
