/*
    GQ -- a GTK-based LDAP client
    Copyright (C) 1998-2001 Bert Vermeulen

    This program is released under the Gnu General Public License with
    the additional exemption that compiling, linking, and/or using
    OpenSSL is allowed.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

/* $Id: errorchain.h,v 1.5 2002/06/27 08:21:20 stamfest Exp $ */

#ifndef GQ_ERRORCHAIN_H_INCLUDED
#define GQ_ERRORCHAIN_H_INCLUDED

#include <ldap.h>		/* LDAP */

int error_new_context(char *title);
void error_push_production(int context, char *msg);

#ifdef ERROR_SHOW_LINE

void error_push_debug(int context, char *msg, char *file, int line);
#  define error_push(c, m) error_push_debug((c), (m), __FILE__, __LINE__)

#else
#  define error_push(c, m) error_push_production((c), (m))
#endif


struct errchain *error_chain_by_context(int q);
void error_flush(int context);
void error_popup(char *title, char *message);
void error_clear(int context);
void error_free(int context);

void push_ldap_addl_error(LDAP *ld, int context);

#define MAX_ERRTITLE_SIZE   128
#define MAX_ERRMSG_SIZE     256

struct errmsgs {
     char msg[MAX_ERRMSG_SIZE];
     struct errmsgs *next;
};

struct errchain {
     int context;
     char title[MAX_ERRTITLE_SIZE];
     struct errmsgs *msgs;
     struct errchain *next;
};

#endif

/* 
   Local Variables:
   c-basic-offset: 5
   End:
 */
