/*
    GQ -- a GTK-based LDAP client
    Copyright (C) 1998-2001 Bert Vermeulen

    This file (dt_clist.h) is
    Copyright (C) 2002 by Peter Stamfest and Bert Vermeulen

    This program is released under the Gnu General Public License with
    the additional exemption that compiling, linking, and/or using
    OpenSSL is allowed.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

/* $Id: dt_clist.h,v 1.1 2002/06/11 21:15:25 stamfest Exp $ */

#ifndef DT_CLIST_H_INCLUDED
#define DT_CLIST_H_INCLUDED

#include <config.h>
#ifdef HAVE_LIBCRYPTO

#include "syntax.h"
#include "dt_generic_binary.h"


#define DT_CLIST_EMPTY_HEIGHT 25
#define DT_CLIST_FULL_HEIGHT 100

typedef struct _dt_clist_handler {
     dt_generic_binary_handler dt_generic;

     void (*fill_clist)(struct formfill *form,
			GtkWidget *hbox, GtkWidget *data_widget,
			GByteArray *internal,
			GtkWidget *clist);
     void (*fill_details)(struct formfill *form,
			  GtkWidget *hbox, GtkWidget *data_widget,
			  GByteArray *internal,
			  GtkWidget *clist);
} dt_clist_handler;

#define DT_CLIST(objpointer) ((dt_clist_handler*)(objpointer))

display_type_handler *dt_clist_get_handler();

/* Methods, only to be used by subclasses */
GtkWidget *dt_clist_get_widget(struct formfill *form, 
			       GByteArray *data,
			       GtkSignalFunc *activatefunc,
			       GHashTable *hash);

GtkWidget *dt_clist_get_data_widget(struct formfill *form, 
				    GtkSignalFunc *activatefunc,
				    GHashTable *hash);

GByteArray *dt_clist_get_data(struct formfill *form,
			      GtkWidget *hbox);

void dt_clist_store_data(struct formfill *form, 
			 GtkWidget *hbox,
			 GtkWidget *data_widget,
			 const GByteArray *data);

void dt_clist_delete_data(struct formfill *form,
			  GtkWidget *hbox, 
			  GtkWidget *data_widget);

void dt_clist_show_entries(struct formfill *form, 
			   GtkWidget *hbox, gboolean what);

void free_internal_data(GByteArray *gb);

#endif /* HAVE_LIBCRYPTO */

#endif

/* 
   Local Variables:
   c-basic-offset: 5
   End:
 */
