/*
    GQ -- a GTK-based LDAP client
    Copyright (C) 1998-2001 Bert Vermeulen

    This program is released under the Gnu General Public License with
    the additional exemption that compiling, linking, and/or using
    OpenSSL is allowed.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

/* $Id: common.h,v 1.14 2002/06/13 10:02:51 stamfest Exp $ */

#ifndef GQ_COMMON_H_INCLUDED
#define GQ_COMMON_H_INCLUDED

#include <lber.h>
#include <ldap.h>

#include <glib.h>

#define MAX_SERVERNAME_LEN    64
#define MAX_HOSTNAME_LEN      64

#define MAX_NUM_ATTRIBUTES   256
#define MAX_DN_LEN          1024
#define MAX_ATTR_LEN          64
#define MAX_BINDPW_LEN        32

#define DEFAULT_SHOWDN         1
#define DEFAULT_SHOWOC         1
#define DEFAULT_SHOW_RDN_ONLY  1

#define SEARCHARG_BEGINS_WITH    0
#define SEARCHARG_ENDS_WITH      1
#define SEARCHARG_CONTAINS       2
#define SEARCHARG_EQUALS         3

#define LDIF_UMICH               0
#define LDIF_V1                  1


struct server_schema {
     GList *oc;
     GList *at;
     GList *mr;
     GList *s;
};


#define SERVER_HAS_NO_SCHEMA     1

struct ldapserver {
     char name[MAX_SERVERNAME_LEN];
     char ldaphost[MAX_HOSTNAME_LEN];
     int ldapport;
     char basedn[MAX_DN_LEN];
     char binddn[MAX_DN_LEN];
     char bindpw[MAX_BINDPW_LEN];
     /* split the "configuration" password from the one entered by
	hand. This simplifies the handling of the configured password
	considerably */
     char enteredpw[MAX_BINDPW_LEN];
     int bindtype;
     char searchattr[MAX_ATTR_LEN];
     int maxentries;
     int cacheconn;
     int enabletls;
     long local_cache_timeout;
     int ask_pw;

     LDAP *connection;
     int missing_closes; /* incremented on every open_connection,
			    decrementen on each close, close_connection
			    really closes only if this drops to zero */
     struct server_schema *ss;
     int flags;

     struct ldapserver *next;
     int version;
     /* server_down is a flag set by the SIGPIPE signal handler and in
	case of an LDAP_SERVER_DOWN error. It indicates that we should
	reconnect the next time open_connection gets called. There is
	no (simple) way to find out which connection has been broken
	in case of a SIGPIPE, thus we have to record this for every
	connection. We MIGHT instead check for ld_errno in the LDAP
	structure, but that is neither really documented (some man
	pages mention it though) nor is it actually available through
	ldap.h */
     int server_down;
};


struct tokenlist {
     int token;
     char keyword[32];
     gpointer data;
};

#endif

/* 
   Local Variables:
   c-basic-offset: 5
   End:
 */
