/*
    GQ -- a GTK-based LDAP client
    Copyright (C) 1998-2001 Bert Vermeulen

    This program is released under the Gnu General Public License with
    the additional exemption that compiling, linking, and/or using
    OpenSSL is allowed.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include <gtk/gtk.h>


LDAP *open_connection(struct ldapserver *server);
void close_connection(struct ldapserver *server, int always);
void clear_server_schema(struct ldapserver *server);
gboolean delete_entry(struct ldapserver *server, char *dn);
void set_busycursor(void);
void set_normalcursor(void);
void make_message(char *buffer, int cnt, char *singular, char *plural, char *suffix);
int close_on_esc(GtkWidget *widget, GdkEventKey *event, gpointer obj);
int func_on_esc(GtkWidget *widget, GdkEventKey *event, GtkWidget *window);
int tokenize(struct tokenlist *list, char *keyword);
char *detokenize(struct tokenlist *list, int token);
char *get_username(void);
void statusbar_msg(char *message);
struct ldapserver *server_by_name(char *name);
int is_leaf_entry(struct ldapserver *server, char *dn);
GList *ar2glist(char *ar[]);
void warning_popup(GList *messages);
void single_warning_popup(char *message);
GList *find_at_by_mr_oid(struct ldapserver *server, char *oid);
GList *find_at_by_s_oid(struct ldapserver *server, char *oid);
GList *find_mr_by_s_oid(struct ldapserver *server, char *oid);
GList *find_oc_by_at(struct ldapserver *server, char *atname);
struct gq_template *find_template_by_name(char *templatename);
void dump_mods(LDAPMod **mods);
