/*
    GQ -- a GTK-based LDAP client
    Copyright (C) 1998-2001 Bert Vermeulen

    This program is released under the Gnu General Public License with
    the additional exemption that compiling, linking, and/or using
    OpenSSL is allowed.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/


#define DISPLAYTYPE_DN          1
#define DISPLAYTYPE_ENTRY	2
#define DISPLAYTYPE_TEXT	3
#define DISPLAYTYPE_PASSWORD	4

#define FLAG_NOT_IN_SCHEMA      0x01
#define FLAG_ENCODE_CRYPT	0x10
#define FLAG_ENCODE_MD5		0x20
#define FLAG_ENCODE_SHA		0x40

#define ENCODING_MASK           ( FLAG_ENCODE_CRYPT | FLAG_ENCODE_MD5 | FLAG_ENCODE_SHA )


struct formfill {
     char attrname[MAX_ATTR_LEN];
     int num_inputfields;
     int displaytype;
     int flags;
     GList *values;
};


struct formfill *new_formfill(void);
void free_formlist(GList *formlist);
void free_formfill(struct formfill *form);
GList *formlist_append(GList *formlist, struct formfill *form);
GList *formlist_from_entry(struct ldapserver *server, char *dn, int ocvalues_only);
GList *dup_formlist(GList *formlist);
void dump_hash(GHashTable *hash);
void dump_formlist(GList *formlist);
struct formfill *lookup_attribute(GList *formlist, char *attr);
void set_displaytype(struct formfill *form);
