/*-
 * Copyright (c) 2001 Jordan DeLong
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of the author nor the names of contributors may be
 *    used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */
#ifndef KEYS_H
#define KEYS_H

/* actions keys can have */
enum {
	KEY_ICONIFY,
	KEY_ZOOM,
	KEY_SWITCHDESK,
	KEY_MOVEVIEWPORT,
	KEY_SETVIEWPORT,
	KEY_COMMAND,
	KEY_DELETE,
	KEY_CYCLEFOCUS,
	KEY_RAISE,
	KEY_LOWER,
	KEY_DGROUPSWITCH,
	KEY_STICKY,
	KEY_ABORT,
	KEY_RESTART,
	KEY_EXIT
};

/* directions for moveviewport */
#define MV_UP		0
#define MV_DOWN		1
#define MV_LEFT		2
#define MV_RIGHT	3
#define MV_UPRIGHT	4
#define MV_DOWNRIGHT	5
#define MV_DOWNLEFT	6
#define MV_UPLEFT	7

/*
 * types of focus cycling, all of these % 2 == 0 are forward,
 * and % 2 != 0 are backward.
 */
#define CF_FWS		0	/* cycle forward on the focused window's workspace */
#define CF_BWS		1	/* cycle backward on the focused window's workspace */
#define CF_FSCR		2	/* cycle forward by screen */
#define CF_BSCR		3	/* cycle backward by screen */
#define CF_FALL		4	/* cycle forward through all visible windows on all screens */
#define CF_BALL		5	/* cycle backward through all visible windows on all screens */

/* structure for a keybinding */
struct keybind {
	int	keycode;	/* keycode we are binding */
	int	modifiers;	/* modifiers for the bind */
	int	action;		/* what the key does */

	union {
		void	*generic;	/* gen to set this */
		char	*cmd;		/* for KEY_COMMAND */
		point_t	*pt;		/* for KEY_SETVIEWPORT */
		int	num;		/* for KEY_SWITCHDESK */
		int	dir;		/* for KEY_MOVEVIEWPORT */
		int	cycletype;	/* type of focus cycline for KEY_CYCLEFOCUS */
	} dat;

	SLIST_ENTRY(keybind) k_list;
};

void keys_shutdown();
keybind_t *keys_add(int keycode, int modifiers, int action, void *dat);
void keys_grab(screen_t *screen);
void keys_press(screen_t *screen, XKeyEvent *e);

#endif
