/*-
 * Copyright (c) 2001 Jordan DeLong
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of the author nor the names of contributors may be
 *    used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */
#include "wm.h"

/* global options structure */
options_t options;

/* setup default option values */
void options_init() {
	/* string options */
	options.title_font = NULL;
	options.titleclr = NULL;
	options.linefgclr = NULL;

	options.focus = FOCUS_CLICK;
	options.placement = PLACEMENT_SMART;

	/* numeric options */
	options.mouse_modifier = Mod1Mask;
	options.anim_delay = 5000;
	options.interact_timeout = 0;
	options.linewidth = 1;
	options.desktop_count = 1;
	options.desktop_width = 1;
	options.desktop_height = 1;

	/* decoration groups */
	options.dgroup_default = &dgroup_empty;
	options.dgroup_trans = &dgroup_empty;
	options.dgroup_internal = &dgroup_empty;

	/* boolean options */
	options.opaquemove = 0;
	options.place_nonzeros = 0;
	options.place_transients = 1;
	options.place_interactive = 0;
	options.fullscreen_zoom = 0;
	options.focus_new = 1;
}

/* free strings and such that we don't use after init */
void options_clean() {
	if (options.title_font)
		free(options.title_font);
	if (options.titleclr)
		free(options.titleclr);
	if (options.linefgclr)
		free(options.linefgclr);
}
