#!/bin/sh
#
# Copyright (c) 2001 Jordan DeLong
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions
# are met:
# 1. Redistributions of source code must retain the above copyright
#    notice, this list of conditions and the following disclaimer.
# 2. Redistributions in binary form must reproduce the above copyright
#    notice, this list of conditions and the following disclaimer in the
#    documentation and/or other materials provided with the distribution.
# 3. Neither the name of the author nor the names of contributors may be
#    used to endorse or promote products derived from this software
#    without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
# ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
# FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
# OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
# HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
# LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
# OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
# SUCH DAMAGE.
#

#
# make the animation handler table for animations plugin
#

#
# inform stdout
#
echo "Making animtab.c and animtab.h"

#
# copy skel files to their destinations
#
cp animtab.c.skel animtab.c
cp animtab.h.skel animtab.h

#
# counter variable of the number of animations we find
#
animcount=0

#
# find ANIMATION_DECLARE in animation c files, and put
# the proper information into the animtab.c, and prototype
# functions in animtab.h.
#
files=`ls anim_*.c`
for file in $files ; do
	#
	# XXX: no file can have more than _one_ ANIMATION_DECLARE.
	# this isn't an issue for now; just worth noting.
	#
	decl=`grep ANIMATION_DECLARE $file`
	if [ $? -eq 0 ] ; then
		# get our information
		name=`echo $decl | sed -e 's/.*(//g' -e 's/,.*//g'`
		funcname=`echo $decl | sed -e 's/.*,\ *//g' -e 's/).*//g'`

		# function prototype and table entry
		echo "void ${funcname}(client_t *client, int event);"	>> animtab.h
		echo "	{$name, $funcname},"				>> animtab.c

		# increment count
		animcount=$(( $animcount + 1 ))
	fi
done

#
# add one more to animcount for the "none" anim
#
animcount=$(( $animcount + 1 ))

#
# fill in animtab.h with the NUMANIMS define, and animtab proto
#
echo ""					>> animtab.h
echo "#define NUMANIMS	$animcount"	>> animtab.h
echo ""					>> animtab.h
echo "extern anim_t animtab[NUMANIMS];"	>> animtab.h
echo ""					>> animtab.h
echo "#endif"				>> animtab.h
echo ""					>> animtab.h

#
# fill in the end of animtab.c
#
echo "	{\"none\", NULL}"		>> animtab.c
echo "};"				>> animtab.c
echo ""					>> animtab.c
