/*
 *	for new GOGO-no-coda (1999/09)
 *	Copyright (C) 1999 PEN@MarineCat, shigeo, Noisyu
 */

#include <stdio.h>
#include <stdlib.h>
#include <assert.h>
#ifdef USE_BTHREAD
#include <OS.h>
#include <SupportDefs.h>
#include "haveunit.h"
#endif
#include "common.h"
#include "global.h"
#include "readsmpl.h"
#include "musenc.h"

#define		SAMPLE_LENGTH		2304
struct _SAMPLE_CONVERTER {
	unsigned long		pitch_lo, pitch_hi;
	unsigned long		pos_lo, pos_hi;
	unsigned long		pcmreadpos;
	unsigned long		fill_len;
	int					bFirstAttach;
	int					bHitEof;
	short	sample_org[ SAMPLE_LENGTH + 4];
} samplecnverter;


extern struct MCP_INPDEV_USERFUNC	mc_userfunc;		// extern/桼ؿ

int		InitializeSampleConverter( int freq_in, int freq_out )
{
	double	pitch_tmp;
	if( freq_in <= 0 || freq_out <= 0){
		return FALSE;
	}
	memset( &samplecnverter, 0, sizeof( samplecnverter ) );
	if(freq_in == freq_out ){
	/* freqin == freqoutΤȤϥС̤ʤɰ׻Ƥ */
		samplecnverter.pitch_hi = 1;
		samplecnverter.pitch_lo = 0;
	} else {
		pitch_tmp = (double)freq_in / (double) freq_out;
		samplecnverter.pitch_hi = (unsigned long)pitch_tmp;
		samplecnverter.pitch_lo = (unsigned long)(pitch_tmp * ((double)4294967296.)) & 0xffffffff;
	}

	samplecnverter.pcmreadpos   = -4 - SAMPLE_LENGTH;
	samplecnverter.bFirstAttach = TRUE;

	return TRUE;
}

/* wait for realtime-encoding by zin@jaist.ac.jp (00/02/22) */
static
size_t fread_nitems(
	void *buf,
	size_t size,
	size_t nitems,
	FILE *stream)
{
  size_t nread;
  size_t nleft = nitems;
  char *ptr = (char *)buf;

  while (nleft > 0) {
    nread = fread(ptr, size, nleft, stream);

    if (nread < 0) return -1; /* ERROR */
    if (nread == 0) break;    /* EOF */

    nleft -= nread;
    ptr += (nread * size);
  }

  return(nitems - nleft);
}

static
unsigned long read_samples_sub(
	FILE *musicin,
	short		*sample_buffer,
	unsigned long frame_size)
{
	unsigned long samples_read;
	samples_read = frame_size;

	if( mc_userfunc.pUserFunc == MPGE_NULL_FUNC ){
		if( !bBitConvert ){
			// 16BIT PCM
			samples_read = fread_nitems(sample_buffer, sizeof(short), (int)samples_read, musicin);
#ifdef RAW_INPUT
			if( bSwapByte == TRUE ){
				int i;
				char low, high;
				for( i = 0; i < samples_read; i++ ){
					low = sample_buffer[i] & 0xFF;
					high = (unsigned)sample_buffer[i] >> 8;
					sample_buffer[i] = high + ( low << 8 );
				}
			}
#endif /* RAW_INPUT */
		} else {
			// 8BIT PCM
			int		i;
			unsigned char	org_buffer[4096];
			if ((samples_read =	fread_nitems(org_buffer, sizeof(char), (int)samples_read, musicin)) == 0){
	//			printf("Hit end of audio data\n");
			}
			// 8BIT to 16BIT 
#ifdef RAW_INPUT
			if( bTownsSND ){
				for( i = 0; i < samples_read; i++ ){
					char data;
					data = org_buffer[i];
					if( data & 0x80 ){
						sample_buffer[i] = ((short)( data - 128 )) << 8;
					}else{
						sample_buffer[i] = ((short)( - data )) << 8;
					}
				}
			}else
#endif /* RAW_INPUT */
			for(i = 0;i < (signed)samples_read;i++){
				sample_buffer[i] = (org_buffer[i] - 128) << 8;
			}
		}
	} else {
		// 桼ؿ١
		if( !bBitConvert ){
			// 16BIT PCM
			memset( sample_buffer, 0, (int)samples_read * 2 );
			if ( mc_userfunc.pUserFunc( sample_buffer, (int)samples_read * 2) == ME_NOERR ){
				samples_read = samples_read * 2;
			} else {
	//			printf("Hit end of audio data\n");
				samples_read = 0;
			}
		} else {
			// 8BIT PCM
			int		i;
			unsigned char	org_buffer[4096];
			memset( org_buffer, 0, (int)samples_read );
			if ( mc_userfunc.pUserFunc( org_buffer, (int)samples_read ) == ME_NOERR ){
			} else {
	//			printf("Hit end of audio data\n");
				samples_read = 0;
			}
			// 8BIT to 16BIT 
			for(i = 0;i < (signed)samples_read;i++)
				sample_buffer[i] = (org_buffer[i] - 128) << 8;
		}
	}
	if( samples_read < frame_size ){
		int	clr = samples_read;
		for (; clr < (signed)frame_size; sample_buffer[clr++] = 0);
	}

	return(samples_read);
}

static
int		getsample(unsigned long pos, FILE *musicin )
{
	if( (int)pos >= (int)(samplecnverter.pcmreadpos + samplecnverter.fill_len) ){
		int		readsamplenum;

		if( samplecnverter.bHitEof )
			return 0;				// ʹߥǡ̵

		*(long *)(&samplecnverter.sample_org[0]) = *(long *)(&samplecnverter.sample_org[SAMPLE_LENGTH    ]);
		*(long *)(&samplecnverter.sample_org[2]) = *(long *)(&samplecnverter.sample_org[SAMPLE_LENGTH + 2]);
		
		readsamplenum = read_samples_sub( musicin, samplecnverter.sample_org + 4, SAMPLE_LENGTH);
		if( readsamplenum != SAMPLE_LENGTH ){
			samplecnverter.bHitEof = TRUE;
		}
		samplecnverter.pcmreadpos += readsamplenum;
		samplecnverter.fill_len    = 4 + readsamplenum;

		return	getsample( pos, musicin );			// Ƶ
	}
	return samplecnverter.sample_org[ pos - samplecnverter.pcmreadpos];
}

static
unsigned long read_samples(
	FILE *musicin,
	short sample_buffer[2304],
	unsigned long frame_size,
	int chn)
{
	int		i;
	if( gl.enc_freqHz == gl.inp_freqHz ){
		// Τޤޥ롼
		return read_samples_sub( musicin, sample_buffer, frame_size );
	} else {
		if( samplecnverter.bHitEof && (samplecnverter.pos_hi * 2) >= samplecnverter.pcmreadpos + samplecnverter.fill_len ){
			memset( sample_buffer, 0, frame_size );
			return 0;				// ɤ߹ߤǤʤ
		}
		if( chn == 1 ){
			// MONO
			for(i = 0;i < (signed)frame_size;i++){
				int		s1, s2;
				int		pts;
				s1 = getsample( samplecnverter.pos_hi, musicin );
				if( samplecnverter.pos_lo == 0 ){
					sample_buffer[ i ] = s1 ;
				} else {
					pts = samplecnverter.pos_lo >> 17;
					s2 = getsample( samplecnverter.pos_hi + 1, musicin );
					sample_buffer[ i ] = (s1 * ( 0x8000 - pts ) + s2 * pts) >> 15;  
				}

				{
					unsigned long		org_low;
					org_low = samplecnverter.pos_lo;
					samplecnverter.pos_lo += samplecnverter.pitch_lo;
					if( samplecnverter.pos_lo < org_low ){
						samplecnverter.pos_hi += samplecnverter.pitch_hi + 1;
					} else {
						samplecnverter.pos_hi +=samplecnverter.pitch_hi;
					}
				}
			}
		} else {
			// STEREO
			for(i = 0;i < (signed)frame_size;i += 2){
				int		s1, s2, sa;
				int		pts;

				// LEFT 
				s1 = getsample( samplecnverter.pos_hi * 2, musicin );
				if( samplecnverter.pos_lo == 0 ){
					sample_buffer[ i ] = s1;
				} else {
					pts = samplecnverter.pos_lo >> 17;
					s2 = getsample( samplecnverter.pos_hi * 2 + 2, musicin );
					sa = s1 * ( 0x8000 - pts ) + s2 * pts; 
					sample_buffer[ i ] = sa >> 15;
				}

				// RIGHT
				s1 = getsample( samplecnverter.pos_hi * 2 + 1, musicin );
				if( samplecnverter.pos_lo == 0 ){
					sample_buffer[ i + 1 ] = s1;
				} else {
					pts = samplecnverter.pos_lo >> 17;
					s2 = getsample( samplecnverter.pos_hi * 2 + 3, musicin );
					sa = s1 * ( 0x8000 - pts ) + s2 * pts; 
					sample_buffer[ i + 1 ] = sa >> 15;
				}

				{
					unsigned long		org_low;
					org_low = samplecnverter.pos_lo;
					samplecnverter.pos_lo += samplecnverter.pitch_lo ;
					if( samplecnverter.pos_lo < org_low ){
						samplecnverter.pos_hi += samplecnverter.pitch_hi + 1;
					} else {
						samplecnverter.pos_hi +=samplecnverter.pitch_hi;
					}
				}
			}
		}
	}

	return frame_size;
}

#if defined(USE_BTHREAD)
static int maxthread_read = 0;
static int curthread_read = 0;
#endif

#if defined(USE_BTHREAD)
#define MAX_BUFFSIZE		30								/* 30ʾϤޤʤߤ */
#define READ_BLOCKSIZE	2304UL
#define MAX_READBUFF	READ_BLOCKSIZE * MAX_BUFFSIZE

static sem_id	mutex_read_audio;
static port_id	port_buf;
static port_id	empty_buf;
static short 	*pread = NULL;
static short 	*pwrite = NULL;
static short 	*plast = NULL;
static short 	*preadbuf = NULL;
static long 	bufremain = 0;
static thread_id	ptid_read;
FILE *cur_musicin;

static void *read_samples_thread(void *);
#endif

#if	defined(USE_BTHREAD)
static
void *
read_samples_thread(void *arg)		/* ɤߥХåե񤭹ߥå */
#endif
#if	defined(USE_BTHREAD)
{
	unsigned long samples_read = 1;
	curthread_read = 1;
	do {
		/* ץ󥰥Сޤƥޥåɲ */
		if(bufremain < MAX_READBUFF) {	/* bufremainѰդȺ뤬ᥤ󥹥å¦ǤϸǽʤΤ
									    ޥեݸɬפʤ? */
									/* 30ĤХåեäѤˤʤ뤳Ȥʼ¬ǤϤʤäΤǡˤifʸ롼פ
									    ưȤϤʤǤ礦ʤۤȤ */
			samples_read = read_samples(cur_musicin, pwrite, READ_BLOCKSIZE, 2);
			pwrite += samples_read;
			if((preadbuf + MAX_READBUFF) <= pwrite)
				pwrite = preadbuf;
			atomic_add(&bufremain,samples_read);		/* ؤ­ԤPOSIXǤϥޥեݸʤƤϤʤʤ */
			write_port_etc(port_buf,0,0,0,B_TIMEOUT,0);		/* ɹߤ줿Τ롣 */
		} else {
			/* ХåեˤʤäƿƤ˵ΤԤ */
			int32 j;
			read_port(empty_buf,&j,(void *)&j,0);
		}
	} while(samples_read > 0);
	curthread_read = 0;
	plast = pwrite;
	write_port(port_buf,0,0,0);	/* λ */
	return 0;
}
#endif

#if	defined(USE_BTHREAD)
/* ɤߥХåեɹ */
static
unsigned long read_samples_mt(
	FILE *musicin,
	short bufferL[],
	short bufferR[],
	unsigned long frame_size,
	int chn)
{
	int32 readlast,j;
	/*  */
	if(!curthread_read && !maxthread_read) {
		/* Initilize semaphore / port */
		mutex_read_audio = create_sem(1,"read_audio");	/* ܤ(mutex_frame)ݸƤ뤫餤ʤ */
		port_buf = create_port(1,"port_buf");	/* 񤭹ߥåɤȤ̿ݡȤ򳫤 */
		empty_buf = create_port(1,"empty_buf");
	}
	/* 󥳡ɥåɤФåϤǹԤ */
	acquire_sem(mutex_read_audio);
	if(!curthread_read && !maxthread_read) {
		int intpriority;
		/* create read buffer */
		preadbuf = (short *)malloc(MAX_READBUFF * 2);
		pread = preadbuf;
		pwrite = preadbuf;
		plast = NULL;
		bufremain = 0;		/* ޥեɬפʤ?(POSIXϤɬ) */
		cur_musicin = musicin;
		/* create read thread */
		MPGE_getConfigure(MG_READTHREAD_PRIORITY,&intpriority);
		if((ptid_read = spawn_thread((thread_func)read_samples_thread,"gogoReadthread",intpriority,(void *)NULL)) > 0) {
			resume_thread(ptid_read);
			maxthread_read = 1;
		}
	}
	/* եХåեΤԤ */
	while(bufremain < frame_size && plast == NULL) {	/* Ǹʳɬ̤ɤǤʤΤ롩 */
		write_port_etc(empty_buf,0,0,0,B_TIMEOUT,0);	/* ̵ʤäȤ롣ʤդϲ;ͭ */
										/* ޤ̵ʤΤϤäݤɹ߸٤礰餤Ǥ */
		read_port(port_buf,&j,(void *)&j,0);			/* 㣱ɤ߹ޤΤޤ */
	}
										/* posixϤǤpthread_cond_waitϤȤäƤޤäȤ˽ľƤ(..; */
	if(bufremain >= frame_size) {
		/* ߤɤ߼Хåե飱֥åФ */
		readlast = (((unsigned long)pread - (unsigned long)preadbuf)) / 2 + frame_size;
		if(chn == 1) {
			/* ƥ쥪->ΥؤѴξϽءʼȴ */
			if(readlast <= MAX_READBUFF) {
				for ( j = 0; j < frame_size; j++ ){
					bufferL[j] = *pread++;
					bufferR[j] = 0;
				}
				if(readlast == MAX_READBUFF)
					pread = preadbuf;
			} else {
				/* Ⱦ */
				for ( j = 0; j < frame_size - (readlast - MAX_READBUFF); j++ ){
					bufferL[j] = *pread++;
					bufferR[j] = 0;
				}
				/* Ⱦ */
				pread = preadbuf;
				for (; j < frame_size ; j++ ){
					bufferL[j] = *pread++;
					bufferR[j] = 0;
				}
			}
		} else {
			if(readlast <= MAX_READBUFF) {
				for ( j = 0; j < frame_size / 2; j++ ){
					bufferL[ j ] = *pread++;
					bufferR[ j ] = *pread++;
				}
				if(readlast == MAX_READBUFF)
					pread = preadbuf;
			} else {
				/* Ⱦ */
				for ( j = 0; j < (frame_size - (readlast - MAX_READBUFF)) / 2; j++ ){
					bufferL[ j ] = *pread++;
					bufferR[ j ] = *pread++;
				}
				/* Ⱦ */
				pread = preadbuf;
				for (; j < frame_size / 2 ; j++ ){
					bufferL[ j ] = *pread++;
					bufferR[ j ] = *pread++;
				}
			}
		}
		atomic_add(&bufremain,-frame_size);	/* ؤ­ԤPOSIXǤϥޥեݸʤƤϤʤʤ */
		release_sem(mutex_read_audio);
		return(frame_size);
	} else {
		/* 褿(ʤ󤫤θǡɹߥåɤϤʤʤäƤ */
		if(curthread_read && maxthread_read){
			/* åɤ򻦤Ƥ */
			kill_thread(ptid_read);
			curthread_read = 0;
		}
		if(bufremain > 0) {
			/* ߤɤ߼Хåե飱֥åФ */
			readlast = (((unsigned long)pread - (unsigned long)preadbuf)) / 2 + bufremain;
			if(chn == 1) {
				/* ƥ쥪->ΥؤѴξϽءʼȴ */
				if(readlast <= MAX_READBUFF) {
					for ( j = 0; j < bufremain; j++ ){
						bufferL[j] = *pread++;
						bufferR[j] = 0;
					}
				} else {
					/* Ⱦ */
					for ( j = 0; j < bufremain - (readlast - MAX_READBUFF); j++ ){
						bufferL[j] = *pread++;
						bufferR[j] = 0;
					}
					/* Ⱦ */
					pread = preadbuf;
					for (; j < bufremain; j++ ){
						bufferL[j] = *pread++;
						bufferR[j] = 0;
					}
				}
			} else {
				if(readlast <= MAX_READBUFF) {
					for ( j = 0; j < bufremain / 2; j++ ){
						bufferL[ j ] = *pread++;
						bufferR[ j ] = *pread++;
					}
				} else {
					/* Ⱦ */
					for ( j = 0; j < (bufremain - (readlast - MAX_READBUFF)) / 2; j++ ){
						bufferL[ j ] = *pread++;
						bufferR[ j ] = *pread++;
					}
					/* Ⱦ */
					pread = preadbuf;
					for (; j < bufremain / 2; j++ ){
						bufferL[ j ] = *pread++;
						bufferR[ j ] = *pread++;
					}
				}
			}
			for(;j < frame_size / chn;j++) {
				bufferL[j] = 0;
				bufferR[j] = 0;
			}
		}
		j = atomic_add(&bufremain,-bufremain);
		/* Ȥޤ */
		if(preadbuf != NULL)
			free(preadbuf);
		preadbuf = NULL;
		if(port_buf != 0)
			delete_port(port_buf);
		port_buf = 0;
		if(empty_buf != 0)
			delete_port(empty_buf);
		empty_buf = 0;
		if(mutex_read_audio != 0)
			delete_sem(mutex_read_audio);	/* Τ¾Ԥåɤ뤫ΤʤΤǺǸ */
		mutex_read_audio = 0;
		return( j );
	}
	return(0);
}
#endif

unsigned long get_audio(
	FILE *musicin,
	short bufferL[1152],
	short bufferR[1152] )
{
	short insamp[1152*2];
	unsigned long j, num, readNum;

	num = gl.frameSize;
	if( gl.stereo == 2 ){
		readNum = read_samples( musicin, insamp, num * 2, 2 );
		for( j = 0; j < num; j++ ){
			bufferL[j] = insamp[j * 2];
			bufferR[j] = insamp[j * 2 + 1];
		}
		return readNum;
	}
	/* mono */
	/* bufferRϤɬפ̵ */
	if( bForceMono == FALSE ){
		return read_samples( musicin, bufferL, num, 1 );
	}else{
		readNum = read_samples( musicin, insamp, num * 2, 2 );
		for( j = 0; j < num; j++ ){
			bufferL[j] = ( (int)insamp[j * 2] + (int)insamp[j * 2 + 1] ) / 2;
		}
		return readNum;
	}
}

#if defined(USE_BTHREAD)
unsigned long get_audio_thread(
	FILE *musicin,
	short bufferL[1152],
	short bufferR[1152] )
{
	unsigned num;

	num = gl.frameSize;
	if( gl.stereo == 2 ){
		return read_samples_mt(musicin, bufferL, bufferR, num * 2, 2);
	}
	if( bForceMono == FALSE ){
		return read_samples_mt( musicin, bufferL, bufferR, num, 1 );
	}else{
		unsigned long j;
		short insamp[1152*2];
		unsigned	long readNum;
		readNum = read_samples(musicin, insamp, num * 2, 2);
		for( j = 0; j < num; j++ ){
			bufferL[j] = ( (int)insamp[j * 2] + (int)insamp[j * 2 + 1] ) / 2;
		}
		return readNum;
	}
}
#endif
