/*
 *	for new GOGO-no-coda (1999/09)
 *	Copyright (C) 1999 PEN@MarineCat, shigeo
 */
/*
 *	99/01/18 Linuxɸб
 *	99/03/02 󥰥ե̾б
 *	99/03/18 󥿡եʬΥ
 *	99/09/07 -skipץѻߤWAV_checkFMT()ǼưȽ
 *	99/09/11  & 
 *	99/09/26 ľΤ
 *	99/10/03 -e {n,c,5} եץɲ
 *	99/10/07 MTbeta, VBR-beta
 *	99/11/04 RAW-PCMбΤoffsetbswapץɲ
 *	99/11/09 detele option by Steve
 *	99/11/20 stdin for WinNT
 *	00/01/18 lame3.55 VBR partially
 */

#ifdef	WIN32
#include <windows.h>
#include <conio.h>
#ifdef	USE_8HZ
	#include <windowsx.h>
	#include <commctrl.h>
#endif
#endif

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#if	defined(DISPLAY_REALTIME)
/* clock()Τgettimeofday()Ȥ */
/* times()Ǥϥåɤ׻֤Ǥʤä */
#include <unistd.h>
#include <sys/time.h>
#else
#include <time.h>
#endif
#include <stdarg.h>
#include <limits.h>
#ifndef __unix__
#include <dos.h>
#endif

#include "common.h"
#include "musenc.h"
#include "haveunit.h"

#ifndef WIN32
	#ifdef	USE_8HZ
		#undef USE_8HZ		/* Win32ǰʳǤʤ */
	#endif
#endif
#ifdef	USE_8HZ
	#undef	clock
	#define	clock	GetTickCount
#endif

//#define IOSTREAM_BUFFERING	/* եϤΥХåե󥰤Ԥ */
//#define NO_KANJI	/* don't print NIHONGO */

/* lame3.30beta BRHISTϻȤʤ(Ȥʤ) */

#ifndef _WINDOWS	/* Win GUIʳǤdebugѿȤ */
extern int debug;
#else
static int debug = 0;
#endif
/* »ɽѹȤ */
//#define	DISPLAY_REALTIME
static int silentFlag = 0;
static int deleteFlag = 0;
static int testmodeFlag = 0;
static int enc_testtime = 0;
static char szInName[MAX_FILE_LEN], szOutName[MAX_FILE_LEN];

/*
 *   顼ɽ
 */
void disp_err( const char *mesg, ... )
{
	char	bufs[1024];

	va_list vlist;
	va_start( vlist, mesg );
	vsprintf( bufs, mesg, vlist );
#ifndef		USE_8HZ
	fputs( bufs, stderr );
#else
	MessageBox( NULL, bufs, "Τ 8HzMP3եȥ", MB_OK );
#endif
	va_end( vlist );
}

#ifndef NO_KANJI

#define mes_GOGO      "Τ "
#define mes_err_opt_m "-mץߥ"
#define mes_err_opt_b "-b[r]ץߥ"
#define mes_err_opt_s "-sץߥ"
#define mes_err_opt_emp "-empץߥ"
#define mes_err_rate  "ʥ졼"
#define mes_err_opt_d "-dץߥ"
#define mes_err_opt_off "-offץߥ"
#define mes_err_opt_lpf "-lpfץߥ"
#define mes_err_opt_outputdir "ϥǥ쥯ȥꥪץߥ"
#if   defined(USE_PTHREAD) || defined(USE_BTHREAD) || defined(USE_WINTHREAD) || defined(USE_OS2THREAD)
#define mes_err_opt_cpu "-cpuץߥ"
#endif
#if	defined(BeOS)
#define mes_err_opt_priority "-priorityץߥ"
#endif
#if	defined(USE_BTHREAD)
#define mes_err_opt_readpriority "-readthreadץߥ"
#endif
#define mes_err_inp "%s¸ߤޤ"
#define mes_err_riff_opt "-riffץߥ"
#define mes_err_else "ʥץǤ "
#define mes_mono      "Υ"
#define mes_stereo    "ƥ쥪"
#define mes_j_stereo  "祤ȥƥ쥪"
#define mes_ms_stereo "ߥåɥɥƥ쥪"
#define mes_dual      "ǥ奢ͥ"
#define mes_undefined "̤"
#define mes_in_freq   "ϼȿ"
#define mes_out_freq  "ϼȿ"
#define mes_bitrate   "ӥåȥ졼"
#define mes_in_name   "ϥե"
#define mes_out_name  "ϥե"
#define mes_finish    "\n󥳡ɽλ\nв"
#ifdef USE_VBR
#define mes_err_opt_v "-vץ󥨥顼"
#endif
#ifdef RAW_INPUT
#define mes_err_opt_offset "-offsetץ󥨥顼"
#endif

#else /* NO_KANJI */

#define mes_GOGO      "GOGO-no-coda "
#define mes_err_opt_m "illegal -m option"
#define mes_err_opt_b "illegal -b[r] option"
#define mes_err_opt_s "illegal -s option"
#define mes_err_opt_emp "illegal -emp option"
#define mes_err_rate  "rate is zero?"
#define mes_err_opt_d "illegal -d option"
#define mes_err_opt_off "illegal -off option"
#define mes_err_opt_lpf "illegal -lpf option"
#define mes_err_opt_outputdir "illegal -o option"
#if   defined(USE_PTHREAD) || defined(USE_BTHREAD) || defined(USE_WINTHREAD) || defined(USE_OS2THREAD)
#define mes_err_opt_cpu "illegal -cpu option"
#endif
#if	defined(BeOS)
#define mes_err_opt_priority "illegal -priority option"
#endif
#if	defined(USE_BTHREAD)
#define mes_err_opt_readpriority "illegal -readthread option"
#endif
#define mes_err_inp "%s is not found"
#define mes_err_riff_opt "illegal -riff option"
#define mes_err_else "illegal option "
#define mes_mono "mono"
#define mes_stereo  "stereo"
#define mes_j_stereo "j-stereo"
#define mes_ms_stereo "m/s stereo"
#define mes_dual      "dual channel"
#define mes_undefined "undefined"
#define mes_in_freq   "inp sampling-freq"
#define mes_out_freq  "out sampling-freq"
#define mes_bitrate   "bitrate"
#define mes_in_name   "input  file"
#define mes_out_name  "output file"
#define mes_finish    "\nEnd of encoding\ntime"
#ifdef USE_VBR
#define mes_err_opt_v "illegal -v option"
#endif
#ifdef RAW_INPUT
#define mes_err_opt_offset "illegal -offset option"
#endif

#endif /* NO_KANJI */

static void usage(void){
#ifndef		USE_8HZ
#ifndef NO_KANJI
	fprintf(stderr, "ΤLAME3.29beta򸵤LGPL˴ŤƸ줿եȤǤ\n");
	fprintf(stderr, "Ȥ\n");
	fprintf(stderr, "gogo inputPCM [outputPCM] [options]\n");
	fprintf(stderr, " inputPCM  wavե\n");
#ifdef __linux__
	fprintf(stderr, "inputPCM'stdin'ꤹɸϥ⡼ɤˤʤ\n");
#endif
//	fprintf(stderr, "outputPCM Ͼάǽ\n\n");
	fprintf(stderr, "Ѳǽʥץ\n");
	fprintf(stderr,	"-b  kbps/-br bps     ӥåȥ졼[ñ kpbs/bps]\n");
//	fprintf(stderr,	"-br bps      ӥåȥ졼[ñ bps]\n");
	fprintf(stderr,	"-silent      вɽ[̤ɽ]\n");
	fprintf(stderr, "-m  {s,m,j}  Ϸ s:ƥ쥪, m:Υ, j:jointƥ쥪\n");
	fprintf(stderr, "-nopsy       ⡼̵(̤ͭ)\n");
	fprintf(stderr, "-off         {3dn,mmx,kni(sse),e3dn}\n");
#ifdef USE_VBR
	fprintf(stderr, "-v {0,..,9}  VBRư [0:ⲻ 9:ⰵ]\n");
#endif
#ifdef RAW_INPUT
//	fprintf(stderr, "WAVEإåϤʤǼʬꤹ\n");
	fprintf(stderr, "-offset bytes ɤФإå\n");
	fprintf(stderr, "  -8bit       8bit-PCM [̤ 16bit-PCM]\n");
	fprintf(stderr, "  -mono       mono-PCM [̤ stereo-PCM]\n");
	fprintf(stderr, "  -bswap      16bitPCMlow, high byte\n");
	fprintf(stderr,	"  -s  kHz     WAVμȿѴ[ñ kHz]\n");
#ifdef __HIGHC__
//	fprintf(stderr, "  -tos        TownsOSSNDե\n");
#endif /* __HIGHC__ */
#endif /* RAW_INPUT */
#if     defined(__linux__) || defined(USE_BTHREAD) || defined(USE_WINTHREAD) || defined(USE_OS2THREAD)
	fprintf(stderr, "-cpu n       ƤCPUο(̤ϼư)\n");
#endif
#if	defined(BeOS)
	fprintf(stderr, "-priority num  󥳡ɥåɤΥץ饤ƥʾά 10\n");
#if	defined(USE_BTHREAD)
	fprintf(stderr, "-readthread num  ǡɹߥåɤΥץ饤ƥʾά Ѥʤ\n");
#endif
#endif
	fprintf(stderr,	"-d  kHz      MP3μȿѴ[ñ kHz]\n");
	fprintf(stderr, "-emp {n,c,5} de-emphasis\n");
//	fprintf(stderr, "-lpf {on,off} 16kHե륿(ά128kbpsʲʤͭ:160kbpsʾʤ̵)\n");
	fprintf(stderr, "-riff {wave, rmp} RIFF/WAVE ޤ RIFF/RMP \n");
	fprintf(stderr, "-test        ٥ޡ⡼\n");
#ifdef WIN32
	fprintf(stderr, "꥿󥭡򲡤Ƥ\n");
	getchar();
#endif

#else /* NO_KANJI */

	fprintf(stderr, "This is based on LAME3.29beta and distributed under the LGPL\n");
	fprintf(stderr, "usage\n");
	fprintf(stderr, "gogo inputPCM [outputPCM] [options]\n\n");
	fprintf(stderr, " inputPCM is input  wav file\n");
#ifdef __linux__
	fprintf(stderr, "if input.wav is `stdin' then stdin-mode\n");
#endif
	fprintf(stderr, "outputPCM is output mp3 file (omissible)\n\n");
	fprintf(stderr, "options\n");
	fprintf(stderr,	"-b  kbps     bitrate [kpbs]\n");
	fprintf(stderr,	"-br bps      bitrate [ bps]\n");
	fprintf(stderr,	"-silent      dont' print progress report\n");
	fprintf(stderr, "-off         {3dn,mmx,kni(sse),e3dn}\n");
#ifdef USE_VBR
	fprintf(stderr, "-v {0,..,9}  VBR [0:high quality 9:high compression]\n");
	fprintf(stderr, "             You should combine this with -b option\n");
#endif
#ifdef RAW_INPUT
	fprintf(stderr, "for only RAW-PCM input\n");
	fprintf(stderr, "-offset bytes skip header size\n");
	fprintf(stderr, "  -8bit       8bit-PCM [dflt 16bit-PCM]\n");
	fprintf(stderr, "  -mono       mono-PCM [dflt stereo-PCM]\n");
	fprintf(stderr, "  -bswap      low, high byte swapping for 16bitPCM\n");
	fprintf(stderr, "  -s kHz      freq of PCM [dflt 44.1kHz]\n");
#endif
#if	defined(USE_PTHREAD) || defined(USE_BTHREAD)
#if     defined(__linux__) || defined(USE_BTHREAD)
	fprintf(stderr, "-cpu n       the number of CPU(auto detected if unspecified)\n");
#else
	fprintf(stderr, "-cpu n       the number of CPU(1 if unspecified)\n");
#endif
#endif
#if	defined(BeOS)
	fprintf(stderr, "-priority num  Encode thread priority (10 if unspecified)\n");
#if	defined(USE_BTHREAD)
	fprintf(stderr, "-readthread num  Read thread priority (No use if unspecified)\n");
#endif
#endif
	fprintf(stderr, "-nopsy       disable psycho-acoustics\n");
	fprintf(stderr, "-m  {s,m,j}  output format s:stereo, m:mono, j:j-stereo\n");
	fprintf(stderr,	"-d  kHz      change sampling-rate of output MP3\n");
	fprintf(stderr, "-emh {n,c,5} de-emphasis\n");
	fprintf(stderr, "-lpf {on,off} 16kHz filter [dflt use if <= 128kbps; not use if >= 160kbps]\n");
	fprintf(stderr, "-test        benchmark mode\n");
	fprintf(stderr, "-delete      delete input file, after encoding\n");
	fprintf(stderr, "-i           verify and overwrite\n");
	fprintf(stderr, "-o dir       change output directory\n");
	fprintf(stderr, "-riff {wave, rmp} wrapping format wave:RIFF/WAVE rmp:RIFF/RMP\n");
#ifdef WIN32
	fprintf(stderr, "push return key.\n");
	getchar();
#endif

#endif /* NO_KANJI */
#else /* USE_8HZ */
	disp_err(
"Ȥ\n\n"
"ܥץ 8Hz-MP3 ڤ L3enc Υޥɥ饤᤹뤿Υ󥸥Ǥ\n"
"бեȥɥեȡCDåѡʻƤȤ\n\n"
"gogo_8hz [options] inputPCM [outputPCM] \n\n"
"-b  kbps		ӥåȥ졼[ñ kpbs]\n"
"-br bps		ӥåȥ졼[ñ bps]\n"
"-silent		вɽ, ̤ɽ\n"
"-e		顼ݸͭ, ̵̤\n"
"-off		{3dn,mmx,kni(sse)}\n"
"-nopsy		⡼̵, ̤ͭ\n"
"-m  s/m/j/d/f	s:ƥ쥪, m:Υ, j:jointƥ쥪 \n"
"-s  kHz		WAVEΥץ󥰥졼ȶ[ñ kHz]\n"
"-d  kHz		MP3Υץ󥰥졼ȶ[ñ kHz]\n"
"-c		ԡ饤ȥե饰 (̵)\n"
"-o		ꥸʥե饰 (̵)\n"
"-q		ƥ (̵)\n"
"-dm		Υǡ˥ߥåƥ󥳡ɤ\n"
"-crc		CRCǡղ (̵)\n"
"-hq		ϥƥ (̵)\n" );
#endif /* USE_8HZ */
}


/*
 *	MS-DOSե̾󥰥ե̾
 *	ȥե뤬¸ߤʤ ERR ֤
 *	WIN32Ƥʤв⤷ʤ
 */

#define isKANJI1(x) ((unsigned char)((x^0x20)-0xA1)<=0x3B)

static int convertToLongFileName(char *fname, const int max_len )
{
#ifndef WIN32
	return NOERR;
#else
	LPHANDLE hdl;
	WIN32_FIND_DATA info;
	int i,j;
	hdl = FindFirstFile( fname, &info );
	if( hdl == INVALID_HANDLE_VALUE  )
		return ERR;
	if( !*info.cFileName ){
		FindClose( hdl );
		return ERR;
	}

	i = ( fname[1] == ':' ) ? 2 : 0;	/* ɥ饤֤ʬ */
	j = i - 1;
	while( i < strlen( fname ) ){
#ifndef NO_KANJI
		if( isKANJI1( fname[i] ) ){
			i++;
		}else
#endif
		{
			if( fname[i] == '\\' ) j = i;
		}
		i++;
	}
	fname[j+1] = NUL;	/* path̾Ф */
	if( strlen( fname ) + strlen( info.cFileName ) >= max_len ) return ERR;
	strcat( fname, info.cFileName ); /* եѥˤ */
	if( debug ) fprintf( stderr, "long file name : %s\n", fname );
	FindClose( hdl );
	return NOERR;
#endif /* WIN32 */
}
//#undef isKANJI1

/*
 *	CPUɽ
 */
static void put_statUNIT(void){
	unsigned long statUNIT;
	MPGE_getUnitStates( &statUNIT );//	statUNIT = haveUNIT();
	if( statUNIT & tFAMILY4 )fprintf(stderr,"familiy 4:");
	if( statUNIT & tFAMILY5 )fprintf(stderr,"familiy 5:");
	if( statUNIT & tFAMILY6 )fprintf(stderr,"familiy 6(or over):");
	fprintf(stderr,"vendor ");
	if( statUNIT & tINTEL )fprintf(stderr,"Intel\n");
	else if( statUNIT & tAMD   )fprintf(stderr,"AMD\n");
	else if( statUNIT & tCYRIX )fprintf(stderr,"Cyrix\n");
	else if( statUNIT & tIDT   )fprintf(stderr,"IDT\n");
	else fprintf(stderr,"unkown\n");
	fprintf(stderr,"extended instruction - ");
	if( statUNIT & tMMX )fprintf(stderr,"MMX ");
	if( statUNIT & tCMOV )fprintf(stderr,"CMOV ");
	if( statUNIT & t3DN )fprintf(stderr,"3D Now! ");
	if( statUNIT & tE3DN)fprintf(stderr,"Ext. 3D Now! ");
	if( statUNIT & tSSE )fprintf(stderr,"SSE");
	fprintf(stderr,"\n");
}

/*
 *	ץ
 */

static int getOpt(int argc,char **argv)
{
//	char	*inPath, *outPath;
	char	bInPath, bOutPath;

	bInPath = bOutPath = FALSE;
	/***   analize options   ***/
	argc--,argv++;
	while(argc){
		if(!strcmp(*argv,"-m")){		/* mono/stereo */
			argc--,argv++;
			if(argc){
				if(!strcmp(*argv,"m")){
					argc--,argv++;
					MPGE_setConfigure( MC_ENCODEMODE, MC_MODE_MONO, 0);
					continue;
				}else if(!strcmp(*argv,"s")){
					argc--,argv++;
					MPGE_setConfigure( MC_ENCODEMODE, MC_MODE_STEREO, 0);
					continue;
				}else if(!strcmp(*argv,"j")){
					argc--,argv++;
					MPGE_setConfigure( MC_ENCODEMODE, MC_MODE_JOINT, 0);
					continue;
				}else if(!strcmp(*argv,"f")){
					argc--,argv++;
					MPGE_setConfigure( MC_ENCODEMODE, MC_MODE_MSSTEREO, 0);
					continue;
				}else if(!strcmp(*argv,"d")){
					argc--,argv++;
					MPGE_setConfigure( MC_ENCODEMODE, MC_MODE_DUALCHANNEL, 0);
					continue;
				}
			}
			disp_err( mes_err_opt_m "[%s]\n",*argv);
			return ERR;
		}else
#ifdef RAW_INPUT /* Thanks to Gonn 99/11/09 */
		if( !strcmp( *argv, "-bswap") ){
			argc--,argv++;
			MPGE_setConfigure( MC_BYTE_SWAP, TRUE, 0 );
		}else
#endif /* RAW_INPUT */
		if(!strncmp(*argv,"-b",2)){	/* bitrate */
			int unit=-1;
			if((*argv)[2]==NUL){
				unit=1;				/* bps */
			}else if((*argv)[2]=='r' && (*argv)[3]==NUL){
				unit=1000;			/* kbps */
			}
			if(unit==-1 || argc<=1){
				disp_err(mes_err_opt_b "[%s]\n",*argv);
				return ERR;
			}
			argc--,argv++;
			MPGE_setConfigure( MC_BITRATE, atoi(*argv)/unit, 0);
			argc--,argv++;
		}else if(!strcmp(*argv,"-s")){	/* INPUT sampling rate */
			int	freqHz;
			argc--,argv++;
			if(!argc){
				disp_err(mes_err_opt_s "\n");
				return ERR;
			}
			freqHz=(int)(atof(*argv)*1000.0+0.5);
			if( freqHz == 0 ){
			  disp_err(mes_err_rate "\n");
			  return ERR;
			}
			argc--,argv++;
			MPGE_setConfigure( MC_INPFREQ, freqHz, 0);
		}else if(!strcmp(*argv,"-d")){	/* OUTPUT sampling rate */
			int	freqHz;
			argc--,argv++;
			if(!argc){
				disp_err(mes_err_opt_d "\n");
				return ERR;
			}
			freqHz=(int)(atof(*argv)*1000.0+0.5);
			argc--,argv++;
			MPGE_setConfigure( MC_OUTFREQ, freqHz, 0);
		}else
		if( !strcmp(*argv, "-emp") ){	/* emphasis */
			argc--,argv++;
			if( argc && !strcmp(*argv, "n") ){
				MPGE_setConfigure( MC_EMPHASIS, 0, 0);
			}else
			if( argc && !strcmp(*argv, "5") ){
				MPGE_setConfigure( MC_EMPHASIS, 1, 0);
			}else
			if( argc && !strcmp(*argv, "c") ){
				MPGE_setConfigure( MC_EMPHASIS, 3, 0);
			}else
			{
				disp_err(mes_err_opt_emp "\n");
				return ERR;
			}
			argc--,argv++;
		}else
		/* special units */
		if( !strcmp(*argv,"-off") ){
			argc--,argv++;
			if( argc && !strcmp(*argv,"mmx") ){
				MPGE_setConfigure( MC_USEMMX, FALSE, 0);
			}else
			if( argc && !strcmp(*argv,"3dn") ){
				MPGE_setConfigure( MC_USE3DNOW, FALSE, 0);
			}else
			if( argc && ( !strcmp(*argv,"kni") || !strcmp(*argv,"sse") ) ){
				MPGE_setConfigure( MC_USEKNI, FALSE, 0);
			}else
			if( argc && !strcmp(*argv,"e3dn") ){
				MPGE_setConfigure( MC_USEE3DNOW, FALSE, 0);
			}else
			{
				disp_err(mes_err_opt_off "\n");
				return ERR;
			}
			argc--,argv++;
		}else
		if( !strcmp(*argv, "-lpf") ){
			argc--,argv++;
			if( argc && !strcmp(*argv, "on") ){
				MPGE_setConfigure( MC_USELPF16, TRUE, 0 );
			}else
			if( argc && !strcmp(*argv, "off") ){
				MPGE_setConfigure( MC_USELPF16, FALSE, 0 );
			}else
			{
				disp_err(mes_err_opt_lpf "\n");
				return ERR;
			}
			argc--,argv++;
		}else
		if( !strcmp( *argv, "-i") ){ /* verify and overwirte */
			argc--,argv++;
			MPGE_setConfigure( MC_VERIFY, TRUE, 0 );
		}else
#if   defined(USE_PTHREAD) || defined(USE_BTHREAD) || defined(USE_WINTHREAD) || defined(USE_OS2THREAD)
		/* SMP */
		if( !strcmp(*argv,"-cpu") ){
			int	cpu;
			argc--,argv++;
			if(!argc){
				disp_err(mes_err_opt_cpu "\n");
				return ERR;
			}
			cpu=atoi(*argv);
			argc--,argv++;
			MPGE_setConfigure( MC_CPU, cpu, 0);
		}else
#endif
#if	defined(BeOS)
		/* Priority */
		if( !strcmp(*argv,"-priority") ){
			int	priority;
			argc--,argv++;
			if(!argc){
				disp_err(mes_err_opt_priority "\n");
				return ERR;
			}
			priority=atoi(*argv);
			argc--,argv++;
			MPGE_setConfigure( MC_THREAD_PRIORITY, priority, 0);
		}else
#endif
#if	defined(USE_BTHREAD)
		/* ReadThreadPriority */
		if( !strcmp(*argv,"-readthread") ){
			int	priority;
			argc--,argv++;
			if(!argc){
				disp_err(mes_err_opt_readpriority "\n");
				return ERR;
			}
			priority=atoi(*argv);
			argc--,argv++;
			MPGE_setConfigure( MC_READTHREAD_PRIORITY, priority, 0);
		}else
#endif
		if( !strcmp(*argv,"-spc1") ){
			argc--,argv++;
			MPGE_setConfigure( MC_USESPC1, TRUE, 0);
		}else
		if( !strcmp(*argv,"-spc2") ){
			argc--,argv++;
			MPGE_setConfigure( MC_USESPC2, TRUE, 0);
		}else
		if( !strcmp(*argv,"-debug") ){
			argc--,argv++;
			debug = 1;
		}else
#ifdef USE_VBR
		if( !strcmp(*argv,"-v") ){
		  argc--,argv++;
		  if( argc && isdigit(**argv) && (*argv)[1]=='\0' ){
		    MPGE_setConfigure( MC_VBR, **argv - '0', 0);
		  }else{
		    disp_err(mes_err_opt_v "\n");
		    return ERR;
		  }
		  argc--,argv++;
		}else
#endif /* USE_VBR */
#ifdef RAW_INPUT
		if( !strcmp( *argv, "-offset") ){
			argc--,argv++;
			if( !argc ){
				disp_err( mes_err_opt_offset "\n" );
				return ERR;
			}
			MPGE_setConfigure( MC_STARTOFFSET, atoi( *argv ), 0);
			argc--,argv++;
		}else
		if( !strcmp( *argv, "-8bit") ){
			argc--,argv++;
			MPGE_setConfigure( MC_8BIT_PCM, TRUE, 0 );
		}else
		if( !strcmp( *argv, "-mono") ){
			argc--,argv++;
			MPGE_setConfigure( MC_MONO_PCM, TRUE, 0 );
		}else
		if( !strcmp( *argv, "-tos") ){
			argc--,argv++;
			MPGE_setConfigure( MC_TOWNS_SND, TRUE, 0 );
		}else
#endif /* RAW_INPUT */
#ifndef USE_8HZ
		if( !strcmp(*argv,"-o") ){
			/* output directory */
			argc--,argv++;
			if( !argc ){
				disp_err( mes_err_opt_outputdir "\n" );
				return ERR;
			}
			MPGE_setConfigure( MC_OUTPUTDIR, (UPARAM)*argv, 0 );
			argc--,argv++;
		}else
#else
		if( !strcmp(*argv,"-c") ){
			/* ԡ饤ȥե饰 */
			argc--,argv++;
		}else
		if( !strcmp(*argv,"-o") ){
			/* ꥸʥե饰 */
			argc--,argv++;
		}else
		if( !strcmp(*argv,"-q") ){
			/* ƥ */
			argc--,argv++;
			argc--,argv++;
		}else
		if( !strcmp(*argv,"-dm") ){
			/* DownMix to MONO */
			argc--,argv++;
			MPGE_setConfigure( MC_ENCODEMODE, MC_MODE_MONO, 0);
		}else
		if( !strcmp(*argv,"-crc") ){
			/* Create CRC */
			argc--,argv++;
		}else
		if( !strcmp(*argv,"-hq") ){
			/* HighQuality */
			argc--,argv++;
		}else
#endif /* USE_8HZ */
		if(!strcmp(*argv,"-silent")){ /* вɽ */
			argc--,argv++;
			silentFlag++;
		}else
		if(!strncmp(*argv,"-test", 5)){		/* benchmark mode */
			testmodeFlag++;
			enc_testtime = atoi( *argv + 5 );
			if( !enc_testtime ) enc_testtime = 60 * 10; /* sec */
			fprintf( stderr, "test time %dsec\n", enc_testtime );
			argc--,argv++;
		}else
		if(!strcmp(*argv,"-nopsy")){  /* ̵ */
			MPGE_setConfigure( MC_USEPSY, FALSE, 0);
			argc--,argv++;
		}else
		if(!strcmp(*argv,"-delete")){
			deleteFlag++;
			argc--,argv++;
		}else
		if( !strcmp(*argv,"-riff") ){  /* RIFF/WAVE or RIFF/RMP3 */
			argc--;
			argv++;
			if( !argc ){
				disp_err( mes_err_riff_opt "\n" );
				return ERR;
			}
			if (!strcmp(*argv,"wave")) {
				MPGE_setConfigure( MC_OUTPUT_FORMAT, MC_OUTPUT_RIFF_WAVE, 0 );
			}
			else 
			if (!strcmp(*argv,"rmp")) {
				MPGE_setConfigure( MC_OUTPUT_FORMAT, MC_OUTPUT_RIFF_RMP, 0 );
			}
			else
			{
				disp_err( mes_err_riff_opt "\n" );
				return ERR;
			}
			argc--;
			argv++;
		}else
		{
			if(bInPath==FALSE){			/* input file name */
				if( !strcmp( *argv, "stdin" ) ){
					MPGE_setConfigure( MC_INPUTFILE, MC_INPDEV_STDIO, (UPARAM)0 );
				}
				else{
					char inPath[ MAX_FILE_LEN ];
					if( strlen( *argv ) >= MAX_FILE_LEN ){
						fprintf( stderr, "Sorry, this file name is too long.[%s]\n", *argv );
						return ERR;
					}
					strcpy( inPath, *argv );
					if( convertToLongFileName( inPath, MAX_FILE_LEN ) == ERR ){
						disp_err(mes_err_inp "\n",inPath);
						*inPath = NUL;
						return ERR;
					}
					MPGE_setConfigure( MC_INPUTFILE, MC_INPDEV_FILE, (UPARAM)inPath );
				}
				bInPath++;
				argc--,argv++;
			}else if(bOutPath==FALSE){	/* output file name */
				MPGE_setConfigure( MC_OUTPUTFILE, MC_OUTDEV_FILE, (UPARAM)*argv );
				bOutPath++;
				argc--,argv++;
			}else{
				disp_err(mes_err_else "[%s]\n",*argv);
				argc--,argv++;
				/* ץ³ */
			}
		}
	}
	return NOERR;
}

static void putConfig(void)
{
	int		nParam;
	char	*strBuf;

	fprintf(stderr,"MPEG 1, layer 3 ");
	if( !MPGE_getConfigure( MG_ENCODEMODE, &nParam ) ){
		switch( nParam ){
			case MC_MODE_MONO:
				strBuf = mes_mono;
				break;
			case MC_MODE_STEREO:
				strBuf = mes_stereo;
				break;
			case MC_MODE_JOINT:
				strBuf = mes_j_stereo;
				break;
			case MC_MODE_MSSTEREO:
				strBuf = mes_ms_stereo;
				break;
			case MC_MODE_DUALCHANNEL:
				strBuf = mes_dual;
				break;
			default:
				strBuf = mes_undefined;
		}
		fprintf(stderr,"%s\n", strBuf );
	}

	if( !MPGE_getConfigure( MG_INPFREQ, &nParam ) ){
		fprintf(stderr,mes_in_freq "=%.1fkHz ", (float)(nParam / 1000.));
	}
	if( !MPGE_getConfigure( MG_OUTFREQ, &nParam ) ){
		fprintf(stderr,mes_out_freq "=%.1fkHz ", (float)(nParam / 1000.));
	}
	if( !MPGE_getConfigure( MG_BITRATE, &nParam ) ){
		fprintf(stderr,mes_bitrate "=%dkbps\n", nParam );
	}

	if( !MPGE_getConfigure( MG_INPUTFILE, szInName )  &&
	    !MPGE_getConfigure( MG_OUTPUTFILE, szOutName ) ){
		fprintf(stderr,mes_in_name " `%s'\n" mes_out_name " `%s'\n"
					,(*szInName)?szInName:"stdin",szOutName);
	}
}

static int
GetErrorMesg( int nErrorCode, char *lpszNameOut, int nLength )
{
	static struct ERRORMESG {
		int	nErr;
		const char *pMesg;
	} szErrorMessage[] = {
#ifndef NO_KANJI
		{ ME_NOERR,				"˽λޤ" },
		{ ME_EMPTYSTREAM,		"ȥ꡼बǸޤãޤ󥳡ɤ˽λޤ"},
		{ ME_INTERNALERROR,		"顼ȯޤ" },
		{ ME_PARAMERROR,		"ѥ᡼ϰϤ㤤ޤ" },
		{ ME_NOFPU,				"FPU夷Ƥޤ"},
		{ ME_INFILE_NOFOUND,	"ϥեޤǤ" },
		{ ME_OUTFILE_NOFOUND,	"ϥեޤǤ" },
		{ ME_FREQERROR,			"ϼȿޤ" },
		{ ME_BITRATEERROR,		"ϥӥåȥ졼Ȥޤ" },
		{ ME_WAVETYPE_ERR,		"֥פޤ" },
		{ ME_CANNOT_SEEK,		"ޤǤ" },
		{ ME_BITRATE_ERR,		"ӥåȥ졼Ȥ꤬ޤ" },
		{ ME_HALTED,		"Ǥޤ" },
#else
		{ ME_NOERR,				"Complete" },
		{ ME_EMPTYSTREAM,		"Complete. no error"},
		{ ME_INTERNALERROR,		"Internal error" },
		{ ME_PARAMERROR,		"Illegal parameter" },
		{ ME_NOFPU,				"FPU is not found"},
		{ ME_INFILE_NOFOUND,	"Can't open input file" },
		{ ME_OUTFILE_NOFOUND,	"Can't open output file" },
		{ ME_FREQERROR,			"Illegal input sampling frequency" },
		{ ME_BITRATEERROR,		"Illegal output bitrate" },
		{ ME_WAVETYPE_ERR,		"Illegal wave type" },
		{ ME_CANNOT_SEEK,		"Can't seek" },
		{ ME_BITRATE_ERR,		"Illegal bitrate" },
		{ ME_HALTED,		"interrupted" },
#endif
	};

	int		i;
	for(i = 0; i < sizeof( szErrorMessage ) / sizeof( szErrorMessage[0] ) ; i++){
		if( nErrorCode == szErrorMessage[i].nErr ){
			if( strlen(szErrorMessage[i].pMesg) >= nLength ){
				return strlen(szErrorMessage[i].pMesg) + 1;
			}
			strcpy( lpszNameOut , szErrorMessage[i].pMesg );
			return 0;
		}
	}
	strcpy( lpszNameOut ,"undefined error code" );
	return -1;
}

static void
clock_to_hms( double sec, int *h, int *m, int *s, int *ms)
{
	int		t = (int)(sec * 100.);

	*ms = t % 100; t /= 100;
	*s  = t % 60 ; t /= 60;
	*m  = t % 60 ; t /= 60;
	*h  = t;
}

/**********************************************************************
 *                               
 **********************************************************************/

#ifdef	USE_8HZ
	#include "res_8hz.h"
	BOOL CALLBACK DialogProc(
			  HWND hwndDlg,  // handle to dialog box
			  UINT uMsg,     // message
			  WPARAM wParam, // first message parameter
			  LPARAM lParam  // second message parameter
			);
	static  DWORD WINAPI ThreadFunc(LPVOID pvoid);
	static	DWORD			idThread;
	static	HANDLE			hThread;
	static  HINSTANCE		m_hInstance;
	static	BOOL			m_bCancel = FALSE;			// GUI
	typedef	struct {
		BOOL				bVailed;					// ι¤Τͭ
		char				szPathName[ _MAX_PATH ];	// ե̾
		int					nProgress;					// 0-1000
		int					nResTime;					// Ļ()
		int					nBitRate;					// ӥåȥ졼
		int					nEncMode;					// 󥳡ɥ⡼
		BOOL				bUsePsy;					// ON/OFF
	} DISPLAYINFO;
	static	DISPLAYINFO		dispinfo;
#endif

static int GENRAND()
{
	static unsigned int seed = 0;
	seed = seed * 0x32842851 + 12398321;
	return seed & INT_MAX;
}

/* ----------------------------------------------------------------------- */
#define		MAX_CHANNEL			16	
static	short test_sample[MAX_CHANNEL][2304];
static
MERET	enctest_inputfunc(void *buf, unsigned long nLength )
{
	static	int firstcall = 1;
	static	int	nRestFrame;
	if( firstcall ){
		int		i, j, nMax;

		firstcall = 0;
		for(i = 0;i < MAX_CHANNEL; i ++ ){
			nMax = 0x4000 + 0x6000 * i / MAX_CHANNEL;
			for(j = 0;j < 2304;j++){
				test_sample[i][j] = (GENRAND() % nMax) - nMax/2 ;
			}
		}
		nRestFrame = (enc_testtime*44100*2*2)/4608;		// Ĥե졼
	}
	if( 0 < nRestFrame-- ){
		memcpy( buf, test_sample[ GENRAND() % MAX_CHANNEL ], nLength );
		return ME_NOERR;
	}
	return ME_EMPTYSTREAM;
}

static
MERET	enctest_outputfunc(void *buf, unsigned long nLength )
{
//	printf("%d bytes wrote.\n", nLength );
	return ME_NOERR;
}
/* ----------------------------------------------------------------------- */


int main(int argc,char **argv)
{
#if	defined(DISPLAY_REALTIME)
	struct timeval	startTime, curTime;
	int mpegversion;
	int nEncMode;
#else
	int mpegversion;
	int nEncMode;
	clock_t	startTime;
#endif
	float	dclock;
	MERET	rval;
	int		total_frame, frameNum;
	int		samplesPerFrame;

	fprintf(stderr,mes_GOGO VERSION "\n");
	fprintf(stderr,"Copyright (C) 1999 PEN@MarineCat and shigeo\n");
	fprintf(stderr,"          Special thanks to Keiichi SAKAI, URURI, Noisyu and Kei\n");

	/* print help */
	if( argc == 1 ){
		usage();
		return ERR;
	}

	/* initialize */

	if( MPGE_initializeWork() == ME_NOFPU ){
		fprintf(stderr,"This CPU doesn't have FPU.\n");
		return ERR;
	}

	/* analize options */

	if( getOpt(argc, argv) ){
		usage();
		MPGE_endCoder();
		return ERR;
	}

	/* if bench mark mode */
	if( testmodeFlag ){
		/* TEST : measure the time to encode 10 minutes PCM */

		struct	MCP_INPDEV_USERFUNC		userfunc;
		
		memset( &userfunc, 0, sizeof userfunc );
		userfunc.pUserFunc = enctest_inputfunc;
		userfunc.nSize     = 44100 * 2 * 2 * enc_testtime;
		userfunc.nChn      = 2;				// stereo
		userfunc.nFreq     = 44100;			// 44100Hz
		userfunc.nBit      = 16;			// 16bit PCM

		MPGE_setConfigure( MC_INPUTFILE, MC_INPDEV_USERFUNC, (UPARAM)&userfunc );
		MPGE_setConfigure( MC_OUTPUTFILE, MC_OUTDEV_USERFUNC, (UPARAM)enctest_outputfunc );
#ifndef NO_KANJI
		fprintf(stderr, " *** Υ٥ [benchmark mode] ***\n");
#else
		fprintf(stderr, " *** at bench in the early afternoon [benchmark mode] ***\n");
#endif
	}

	/* 1Ĥwav뤴Ȥɬ */

	rval = MPGE_detectConfigure();
	if( rval != ME_NOERR ){
		char	bufs[1024];
		GetErrorMesg( rval, bufs, sizeof(bufs));
		disp_err(  "%s\n", bufs );
#ifdef	WIN32
	#ifndef USE_8HZ
		getch();
	#endif

#endif
		return ERR;
	}

	/* ɽ */

	putConfig();
	MPGE_getConfigure( MG_COUNT_FRAME, &total_frame );
	MPGE_getConfigure( MG_NUM_OF_SAMPLES, &samplesPerFrame );
	if( debug )put_statUNIT();

	frameNum = 0;
#if	defined(DISPLAY_REALTIME)
	gettimeofday(&startTime, NULL);
#else
	startTime = clock();
#endif
	MPGE_getConfigure( MG_MPEG_VERSION, (UPARAM *)&mpegversion );
	MPGE_getConfigure( MG_ENCODEMODE, (UPARAM *)&nEncMode );

	/* main loop */
#ifdef USE_8HZ
	{
		memset( &dispinfo, 0, sizeof dispinfo );
		hThread = CreateThread(
					NULL,						// pointer to thread security attributes
					0,							// initial thread stack size, in bytes
					ThreadFunc,					// pointer to thread function
					0,							// argument for new thread
					CREATE_SUSPENDED,			// creation flags
					&idThread					// pointer to returned thread identifier
				);	
		SetThreadPriority( hThread, THREAD_PRIORITY_LOWEST );
		ResumeThread( hThread );
	}
	{
		// ե̾ʬΤ
		char	buf[ _MAX_PATH ];
		UPARAM	tmp;
		int		i, n;

		MPGE_getConfigure( MC_INPUTFILE, (UPARAM *)&buf[0]);
		for(i = n = 0;buf[i] != '\0';i++){
			if( buf[i] == '\\' )
				n = i;
			else if( isKANJI1( buf[i] ) )
				i++;
		}
		if( n ) n ++;
		strcpy( dispinfo.szPathName, buf + n );
		MPGE_getConfigure( MG_ENCODEMODE, (UPARAM *)&dispinfo.nEncMode );
		MPGE_getConfigure( MG_BITRATE   , (UPARAM *)&dispinfo.nBitRate );
		MPGE_getConfigure( MG_USEPSY    , (UPARAM *) &tmp );
		dispinfo.bUsePsy = tmp;
	}
#endif
	for(;;){
		if( !silentFlag ){
			if( (frameNum & 31) == 31 ){ /* ǹ٤Ĵ */
#ifndef		USE_8HZ
				float	frame_per;
				float	total_sec;
				int		h, m, s, ms, eh, em, es, ems;
				int		freqHz;

				frame_per = 100.* frameNum / total_frame;

#ifdef DISPLAY_REALTIME
				gettimeofday(&curTime, NULL);
				dclock = (double)(curTime.tv_sec - startTime.tv_sec)
					+ (double)(curTime.tv_usec - startTime.tv_usec)/1000000.0;
				if(dclock < 0.0) dclock += 24*60*60;	/* դѤä */
#else
				dclock = (clock() - startTime)*(1.0/CLOCKS_PER_SEC);
#endif
				total_sec = dclock * total_frame / frameNum;

				MPGE_getConfigure( MG_OUTFREQ, &freqHz );

				clock_to_hms( total_sec, &h, &m, &s, &ms);
				clock_to_hms( total_sec - dclock, &eh, &em, &es, &ems);

				/* arrive time from start(sec) */

				printf("{%7d/%7d} %4.1f%% (%6.2fx)  "
					"re:[%02d:%02d:%02d.%02d] to:[%02d:%02d:%02d.%02d]\r"
					,frameNum, total_frame, frame_per
					,(frameNum * samplesPerFrame) / (freqHz * dclock)
					,eh,em,es,ems, h,m,s,ms);
				fflush(stdout);
#else /* USE_8HZ */
				double	dclock = (clock() - startTime)*(1.0/CLOCKS_PER_SEC);
				double	frame_per = 100.* frameNum / total_frame;
				double	total_sec = dclock * total_frame / frameNum;

				dispinfo.nProgress = 1000 * frameNum / total_frame;
				dispinfo.nResTime  = total_sec - dclock;
				dispinfo.bVailed   = TRUE;
#endif /* USE_8HZ */
			}
			frameNum++;	
#ifdef	USE_8HZ
			if( m_bCancel )
				break;
#endif
		}
#ifdef USE_BTHREAD
		/* BeOSξ硢󥳡ɥåɤɽåɤƱΤʤΤ
		    󥳡ɥåɤ餢ִ֤μ¹ԤƤframeNum򥹥åɴ̿Ǥ餦 */
		rval = MPGE_processFrame(&frameNum);	/* ޥåɻframeNumѤ뤬1åɻϥ롼 */
#else
		rval = MPGE_processFrame();
#endif
		if( rval == ME_EMPTYSTREAM )
			break;
#ifdef	USE_8HZ
		if( m_bCancel == TRUE ){
			//disp_err("󥳡ɤǤޤ");
			break;
		}
#endif
		if( rval != ME_NOERR  ){
//			disp_err(  "󥳡Υ顼(%d)\n", rval );
			char	buf[1024];
			GetErrorMesg( rval, buf, sizeof buf );
			disp_err( buf );
			break;
		}
	} /* main loop */

	MPGE_endCoder(); /* finish */

	if( deleteFlag && *szInName ){
		remove( szInName );
		if( debug ) fprintf( stderr, "Deleted input file %s.\n", szInName );
	}


#if	defined(DISPLAY_REALTIME)
	gettimeofday(&curTime, NULL);
	dclock = (double)(curTime.tv_sec - startTime.tv_sec)
		+ (double)(curTime.tv_usec - startTime.tv_usec)/1000000.0;
	if(dclock < 0.0) dclock += 24*60*60;
#else
	dclock = ( clock() - startTime ) / (float)CLOCKS_PER_SEC;
#endif
	if( testmodeFlag ){
		fprintf(stderr,mes_finish "=%8.3fsec (%6.2fx)\n", dclock, enc_testtime / dclock );
	}else{
		fprintf(stderr,mes_finish "=%8.3fsec\n" , dclock);
	}
#ifndef USE_8HZ
	if( debug ){
		extern int CLKcount;extern float CLKclock;
		printf("call %dtimes:ave %fclk\n",CLKcount,CLKclock/CLKcount);
		memFreeChk();
	}
#endif
	return NOERR;
}

#ifdef	USE_8HZ
int WINAPI WinMain(
  HINSTANCE hInstance,		// handle to current instance
  HINSTANCE hPrevInstance,	// handle to previous instance
  LPSTR lpCmdLine,			// pointer to command line
  int nCmdShow				// show state of window
)
{
	int			argc, i, nLength;
	char		**argv;
	char		*lpszCmdLine ;
	LPCTSTR		cmdline;
	
	m_hInstance = hInstance;
	cmdline		= GetCommandLine();
	nLength		= strlen( cmdline );
	lpszCmdLine	= (char *)malloc( nLength + 4 );
	memset( lpszCmdLine, 0, nLength + 4 );
	while( *cmdline == ' ' ){
		cmdline ++;
		nLength --;
	}
	while( cmdline[ nLength - 1 ]  == ' ' ){
		nLength --;
	}
	strncpy( lpszCmdLine, cmdline, nLength );

	/* ޥɥ饤η׻ */
	{
		LPCTSTR		tmp = lpszCmdLine;
		argc = 0;
		while( *tmp ){
			if( *tmp == ' ' ){
				while( *tmp == ' ' )
					tmp ++;
			}
			if( *tmp == '\0' )
				break;
			if( *tmp == '\"' ){
				tmp ++;
				while( *tmp && *tmp != '\"' ){
					tmp ++;
				}
				tmp++;

			} else {
				while( *tmp != ' ' && *tmp != '\0' ){
					tmp ++;
				}
			}
			argc ++;
		}
	}

	argv = (char **)malloc( sizeof( char *) * (argc + 1) );

	/* °ΰϤ */
	{
		LPCTSTR		tmp = lpszCmdLine;
		for(i = 0;i < argc && *tmp ;i++){
			char	*dst;
			dst = argv[ i ] = (char *)malloc( nLength );
			if( *tmp == ' ' ){
				while( *tmp == ' ' )
					tmp ++;
			}
			if( *tmp == '\"' ){
				tmp ++;
				while( *tmp && *tmp != '\"' ){
					*dst = *tmp;
					tmp ++;
					dst ++;
				}
				tmp++;
				*dst = '\0';
			} else {
				while( *tmp != ' ' && *tmp != '\0' ){
					*dst = *tmp;
					tmp ++;
					dst ++;
				}
			}
			*dst = '\0';
		}
	}

//	char	*console[] = {"AAA",NULL};
	return	main( argc, argv );
}


static DWORD WINAPI ThreadFunc(LPVOID pvoid)
{

	MSG msg;
	CreateDialog( 
		m_hInstance, 
		MAKEINTRESOURCE( IDD_ENCODING ),
		NULL,
		DialogProc );

	while (GetMessage(&msg, NULL, 0, 0)) {
		TranslateMessage(&msg);
		DispatchMessage(&msg);
	}
	return 0;
}


static		DISPLAYINFO		dispHistory;

/* β̹Ԥ */
void
DisplayUpdate( HWND hDlg )
{
	if( !dispinfo.bVailed ){		// ͭǤϤʤ
		return;
	}
	if( strcmp( dispinfo.szPathName, dispHistory.szPathName ) ){
		TCHAR	buf[1024];
		wsprintf( buf, "MP3եΥ󥳡Ǥ ... %s", dispinfo.szPathName ); 
		SetDlgItemText(hDlg, IDC_TXT_FILENAME, buf );
	}
	if( dispinfo.nProgress != dispHistory.nProgress ){
		HWND	hProgress = GetDlgItem( hDlg, IDC_PROGRESS );
		SendMessage( hProgress, PBM_SETPOS, dispinfo.nProgress / 10, 0);
	}
	if( dispinfo.nResTime != dispHistory.nResTime ){
		int		min, sec;
		TCHAR	buf[1024];
		sec = dispinfo.nResTime;
		min = sec / 60; sec %= 60;
		wsprintf( buf, "Ĥ  :  %02d:%02d ", min, sec ); 
		SetDlgItemText(hDlg, IDC_RESV_TIME, buf );
	}
	if( dispinfo.nEncMode != dispHistory.nEncMode ||
		dispinfo.nBitRate != dispHistory.nBitRate ){
		TCHAR	buf[1024], *p2;
		switch( dispinfo.nEncMode ){
		case 	MC_MODE_MONO:
			p2 = "Υ⡼";
			break;
		case	MC_MODE_STEREO:
			p2 = "ƥ쥪⡼";
			break;
		case	MC_MODE_JOINT:
			p2 = "祤ȥƥ쥪";
			break;
		case	MC_MODE_MSSTEREO:
			p2 = "ߥåɥɥƥ쥪";
			break;
		case	MC_MODE_DUALCHANNEL:
			p2 = "ǥ奢ͥ";
			break;
		default:
			p2 = "̤ΤΥ⡼";
			break;
		}
		wsprintf( buf, "%s  %d kbps  %s", p2, dispinfo.nBitRate, dispinfo.bUsePsy ? "ͭ" : "̵" );
		SetDlgItemText(hDlg, IDC_TXT_ENCODESTATUS, buf );
	}
	
	dispHistory = dispinfo;
}

#define		TIMER_ID		1000
BOOL CALLBACK DialogProc(
  HWND hDlg,  // handle to dialog box
  UINT uMsg,     // message
  WPARAM wParam, // first message parameter
  LPARAM lParam  // second message parameter
)
{
//    char szText[1024];

    switch (uMsg) {
		case WM_INITDIALOG:
			// ǥåȥܥå
			{
				HWND	hProgress = GetDlgItem( hDlg, IDC_PROGRESS );
				SendMessage( hProgress, PBM_SETRANGE, 0, MAKELONG(0,100));
				SendMessage( hProgress, PBM_SETPOS, 0, 0);
				{
					// ַ
					int		left, top;
					RECT		deskRect, winRect;
					HWND hDesk = GetDesktopWindow();
					GetClientRect( hDesk, &deskRect );
					GetClientRect( hDlg,  &winRect );
					left = ( deskRect.right - winRect.right ) / 2;
					top  = ( deskRect.bottom ) / 2;
					SetWindowPos( hDlg, NULL, left, top, 0, 0, SWP_NOZORDER | SWP_NOSIZE );
				}
				ShowWindow( hDlg, SW_SHOW );
				SetTimer( hDlg, TIMER_ID, 300, NULL );
				memset( &dispHistory, 0, sizeof dispHistory );
			}
			return TRUE;
		case WM_COMMAND:
			switch (LOWORD(wParam)) {
				case IDOK:
				case IDCANCEL:
					KillTimer( hDlg, TIMER_ID );
					m_bCancel = TRUE;					
			}
			return FALSE;
		case WM_NOTIFY:
			switch( wParam ){
				default:
					return FALSE;
			}
			break;
		case WM_TIMER:
			if( wParam == TIMER_ID ){
				DisplayUpdate( hDlg );
				return TRUE;
			}
    }
    return FALSE;

}

#endif
