/* -*- TABSIZE = 4 -*- */
/*
 *	for new GOGO-no-coda ( 2000/1/15 )
 *	Copyright (C)1999,2000 PEN@MarineCat
 */
#ifndef __MUSUI_H__
#define __MUSUI_H__

#include <limits.h>

typedef	signed int				MERET;
#ifndef __os2__
typedef	unsigned long			MPARAM;
#else
typedef  unsigned long          MUPARAM;
#endif
typedef	unsigned long			UPARAM;

#ifdef GOGO_DLL_EXPORTS
#define		EXPORT				__declspec(dllexport) 
#else
#define		EXPORT					
#endif


#define	ME_NOERR					(0)		// return normally;ｪλ
#define	ME_EMPTYSTREAM				(1)		// stream becomes empty;ȥ꡼बǸã
#define	ME_HALTED					(2)		// stopped by user;(桼μˤ)Ǥ줿
#define	ME_INTERNALERROR			(10)	// internal error; 顼
#define	ME_PARAMERROR				(11)	// parameters error;ǥѥ᡼顼
#define	ME_NOFPU					(12)	// no FPU;FPU夷Ƥʤ!!
#define	ME_INFILE_NOFOUND			(13)	// can't open input file;ϥեʤ
#define	ME_OUTFILE_NOFOUND			(14)	// can't open output file;ϥեʤ
#define	ME_FREQERROR				(15)	// frequency is not good;ϼȿʤ
#define	ME_BITRATEERROR				(16)	// bitrate is not good;ϥӥåȥ졼Ȥʤ
#define	ME_WAVETYPE_ERR				(17)	// WAV format is not good;֥פʤ
#define	ME_CANNOT_SEEK				(18)	// can't seek;ʤ
#define	ME_BITRATE_ERR				(19)	// only for compatibility;ӥåȥ졼꤬ʤ
#define	ME_BADMODEORLAYER			(20)	// mode/layer not good;⡼ɡ쥤۾
#define	ME_NOMEMORY					(21)	// fail to allocate memory;ꥢ
#define	ME_CANNOT_SET_SCOPE			(22)	// thread error;å°顼(pthread only)
#define	ME_CANNOT_CREATE_THREAD		(23)	// fail to create thear;å顼
#define	ME_WRITEERROR				(24)	// lock of capacity of disk;Τ­


// definition of call-back function for user;桼ΥХåؿ
typedef	MERET	(*MPGE_USERFUNC)(void *buf, unsigned long nLength );
#define MPGE_NULL_FUNC (MPGE_USERFUNC)NULL	// for HighC

///////////////////////////////////////////////////////////////////////////
// Configuration
///////////////////////////////////////////////////////////////////////////
// for INPUT
#define		MC_INPUTFILE			(1)
// para1 choice of input device
	#define		MC_INPDEV_FILE		(0)		// input device is file;ϥǥХϥե
	#define		MC_INPDEV_STDIO		(1)		//                 stdin;ϥǥХɸ
	#define		MC_INPDEV_USERFUNC	(2)		//       defined by user;ϥǥХϥ桼
	// para2 (ɬפǤ)ե̾ݥ󥿤ꤹ
	// ꥨ󥳡ɤλϰʲι¤ΤΥݥ󥿤ꤹ.
	struct MCP_INPDEV_USERFUNC {
		MPGE_USERFUNC	pUserFunc;			// pointer to user-function for call-back or MPGE_NULL_FUNC if none
											// ХåоݤΥ桼ؿ̤MPGE_NULL_FUNC
		unsigned int	nSize;				// size of file or MC_INPDEV_MEMORY_NOSIZE if unknown
											// ե륵λ MC_INPDEV_MEMORY_NOSIZE
		int				nBit;				// nBit = 8 or 16 ; PCMӥåȿ٤
		int				nFreq;				// input frequency ; ϼȿλ
		int				nChn;				// number of channel(1 or 2) ; ͥ
	};
	#define		MC_INPDEV_MEMORY_NOSIZE		(UINT_MAX)
/*
  Using userfunction input;
  桼ؿѻεư
  ^^^^^^^^^^^^^^^^^^^^^^^^

  桼Ͽؿ UsefFuncФơDLLɤ߹׵᤬Ԥ롣
  MERET	UserFunc_input(void *buf, unsigned long nLength );

  ׵ݤ
     void *buf ˤ nLength ХʬΥǡǼ return ME_NOERRȴ
	 եκǸãơnLengthʬɤ߹ʤ(ľʤȤ1ХȰʾɤ߹)硢
	    memset( buf + ɤ߹ǡbyte, 0, nLength - ɤ߹ǡ) ;
	   Ȥ return ME_NOERR 롣
	 ХȤɤʤϡ⤻ return ME_EMPTYSTREAM; ȴ
*/

///////////////////////////////////////////////////////////////////////////
// for OUTPUT ( now stdout is not support )
#define		MC_OUTPUTFILE			(2)
// para1 choice of output device
	#define		MC_OUTDEV_FILE		(0)		// output device is file;ϥǥХϥե
	#define		MC_OUTDEV_STDOUT	(1)		//                  stdout; ϥǥХɸ
	#define		MC_OUTDEV_USERFUNC	(2)		//        defined by user;ϥǥХϥ桼
	#define		MC_OUTDEV_USERFUNC_WITHVBRTAG	(3)	//       defined by user;ϥǥХϥ桼/VBR񤭽Ф
// para2 pointer to file if necessary ;(ɬפǤ)ե̾ݥ󥿻

/*
  Using userfunction output
  桼ؿѻεư
  ^^^^^^^^^^^^^^^^^^^^^^^^

  桼Ͽؿ UsefFuncФơDLL׵᤬Ԥ롣
  MERET	UserFunc_output(void *buf, unsigned long nLength );

  ׵ݤ
     void *buf ˤ nLength ХʬΥǡǼƤΤ 
	   fwrite( buf, 1, nLength, fp );ͤˤƽ񤭽Фreturn ME_NOERRȴ.
	   񤭽Ф˼Ԥϡreturn ME_WRITEERROR;ȴ.
	 Ǹ buf == NULL1ٸƤӽФ. return ͤϲǤɤ
	(MC_OUTDEV_USERFUNC_WITHVBRTAGϿݤˤϡʲεưɲä)
	 ⤦buf == NULLǸƤӽФ.κݤ˥եƬإ
	   եΤΥ returnͤȤ롣filesize<=0λϽλ
	   (ä return ME_NOERR; ȴʤͤ!! )
	 XING-VBRǡ bufˡXINGVBRΥ nLength˳ǼƸƤӽФ.
	 Ǹˤ⤦buf == NULLǸƤӽФ.
*/

///////////////////////////////////////////////////////////////////////////
// mode of encoding ;󥳡ɥ
#define		MC_ENCODEMODE			(3)
// para1 mode;⡼
	#define		MC_MODE_MONO		(0)		// mono;Υ
	#define		MC_MODE_STEREO		(1)		// stereo;ƥ쥪
	#define		MC_MODE_JOINT		(2)		// joint-stereo;祤
	#define		MC_MODE_MSSTEREO	(3)		// mid/side stereo;ߥåɥ
	#define		MC_MODE_DUALCHANNEL	(4)		// dual channel;ǥ奢ͥ

///////////////////////////////////////////////////////////////////////////
// bitrate;ӥåȥ졼
#define		MC_BITRATE				(4)
// para1 bitrate;ӥåȥ졼 ¨ͻ


///////////////////////////////////////////////////////////////////////////
// frequency of input file (force);ϤѤ륵ץȿζ
#define		MC_INPFREQ				(5)
// para1 frequency;ϤѤǡ

///////////////////////////////////////////////////////////////////////////
// frequency of output mp3 (force);ϤѤ륵ץȿζ
#define		MC_OUTFREQ				(6)
// para1 frequency;ϤѤǡ

///////////////////////////////////////////////////////////////////////////
// size ofheader if you ignore WAV-header (for example cda);󥳡ɳϰ֤ζ(إå̵뤹)
#define		MC_STARTOFFSET			(7)

///////////////////////////////////////////////////////////////////////////
// psycho-acoustics ON/OFF; ON/OFF
#define		MC_USEPSY				(8)
// PARA1 boolean(TRUE/FALSE)

///////////////////////////////////////////////////////////////////////////
// 16kHz low-pass filter ON/OFF;16KHzӰե륿 ON/OFF
#define		MC_USELPF16				(9)
// PARA1 boolean(TRUE/FALSE)

///////////////////////////////////////////////////////////////////////////
// use special UNIT, para1:boolean; ˥åȻ para1:BOOL
#define		MC_USEMMX				(10)	// MMX
#define		MC_USE3DNOW				(11)	// 3DNow!
#define		MC_USEKNI				(12)	// SSE(KNI)
#define		MC_USEE3DNOW			(13)	// Enhanced 3D Now!
#define		MC_USESPC1				(14)	// special switch for debug
#define		MC_USESPC2				(15)	// special switch for debug

///////////////////////////////////////////////////////////////////////////
// addition of TAG; ե륿ղ
#define		MC_ADDTAG				(16)
// dwPara1  length of TAG;Ĺ  
// dwPara2  pointer to TAG;ǡΥݥ

///////////////////////////////////////////////////////////////////////////
// emphasis;եפ
#define		MC_EMPHASIS				(17)	
// para1 type of emphasis;եפ
	#define		MC_EMP_NONE			(0)		// no empahsis;եʤ(dflt)
	#define		MC_EMP_5015MS		(1)		// 50/15ms    ;ե50/15ms
	#define		MC_EMP_CCITT		(3)		// CCITT      ;եCCITT

///////////////////////////////////////////////////////////////////////////
// use VBR;VBRפ
#define		MC_VBR					(18)

///////////////////////////////////////////////////////////////////////////
// SMP support para1: interger
#define		MC_CPU					(19)

///////////////////////////////////////////////////////////////////////////
// for RAW-PCM; ʲ4ĤRAW-PCMΤ
// byte swapping for 16bitPCM; PCMϻlow, high bit Ѵ
#define		MC_BYTE_SWAP			(20)

///////////////////////////////////////////////////////////////////////////
// for 8bit PCM
#define		MC_8BIT_PCM				(21)

///////////////////////////////////////////////////////////////////////////
// for mono PCM
#define		MC_MONO_PCM				(22)

///////////////////////////////////////////////////////////////////////////
// for Towns SND
#define		MC_TOWNS_SND			(23)

///////////////////////////////////////////////////////////////////////////
// BeOS Encode thread priority
#define		MC_THREAD_PRIORITY		(24)

///////////////////////////////////////////////////////////////////////////
// BeOS Read thread priority
//#if	defined(USE_BTHREAD)
#define		MC_READTHREAD_PRIORITY	(25)
//#endif

///////////////////////////////////////////////////////////////////////////
// output format 
#define		MC_OUTPUT_FORMAT		(26)
// para1 
	#define		MC_OUTPUT_NORMAL	(0)		// mp3+TAG(see MC_ADDTAG)
	#define		MC_OUTPUT_RIFF_WAVE	(1)		// RIFF/WAVE
	#define		MC_OUTPUT_RIFF_RMP	(2)		// RIFF/RMP

///////////////////////////////////////////////////////////////////////////
// LIST/INFO chunk of RIFF/WAVE or RIFF/RMP 
#define		MC_RIFF_INFO			(27)
// para1 size of info(include info name)
// para2 pointer to info
//   offset            contents
//   0..3              info name
//   4..size of info-1 info

///////////////////////////////////////////////////////////////////////////
// verify and overwrite
#define		MC_VERIFY			(28)

///////////////////////////////////////////////////////////////////////////
// output directory
#define		MC_OUTPUTDIR			(29)

MERET	EXPORT	MPGE_initializeWork();
#ifndef __os2__
MERET	EXPORT	MPGE_setConfigure(MPARAM mode, UPARAM dwPara1, UPARAM dwPara2 );
MERET	EXPORT	MPGE_getConfigure(MPARAM mode, void *para1 );
#else
MERET EXPORT   MPGE_setConfigure(MUPARAM mode, UPARAM dwPara1, UPARAM dwPara2 );
MERET EXPORT   MPGE_getConfigure(MUPARAM mode, void *para1 );
#endif
MERET	EXPORT	MPGE_detectConfigure();
#ifdef USE_BETHREAD
MERET	EXPORT	MPGE_processFrame(int *frameNum);
#else
MERET	EXPORT	MPGE_processFrame();
#endif
MERET	EXPORT	MPGE_closeCoder();
MERET	EXPORT	MPGE_endCoder();
MERET	EXPORT	MPGE_getUnitStates( unsigned long *unit );

// This function is effective for gogo.dll;Υե󥯥DLLСΤͭ
MERET	EXPORT	MPGE_getVersion( unsigned long *vercode,  char *verstring );
// vercode = 0x125 ->  version 1.25
// verstring       ->  "ver 1.25 1999/09/25" (allocate abobe 260bytes buffer)



////////////////////////////////////////////////////////////////////////////
// for getting configuration
////////////////////////////////////////////////////////////////////////////

#define		MG_INPUTFILE			(1)		// name of input file ;ϥե̾
#define		MG_OUTPUTFILE			(2)		// name of output file;ϥե̾
#define		MG_ENCODEMODE			(3)		// type of encoding   ;󥳡ɥ⡼
#define		MG_BITRATE				(4)		// bitrate            ;ӥåȥ졼
#define		MG_INPFREQ				(5)		// input frequency    ;ϼȿ
#define		MG_OUTFREQ				(6)		// output frequency   ;ϼȿ
#define		MG_STARTOFFSET			(7)		// offset of input PCM;ȥեå
#define		MG_USEPSY				(8)		// psycho-acoustics   ;ϤѤ/ʤ
#define		MG_USEMMX				(9)		// MMX
#define		MG_USE3DNOW				(10)	// 3DNow!
#define		MG_USEKNI				(11)	// SSE(KNI)
#define		MG_USEE3DNOW			(12)	// Enhanced 3DNow!

#define		MG_USESPC1				(13)	// special switch for debug
#define		MG_USESPC2				(14)	// special switch for debug
#define		MG_COUNT_FRAME			(15)	// amount of frame
#define		MG_NUM_OF_SAMPLES		(16)	// number of sample for 1 frame;1ե졼ढΥץ
#define		MG_MPEG_VERSION			(17)	// MPEG VERSION
#define		MG_READTHREAD_PRIORITY	(18)	// thread priority to read for BeOS

#endif /* __MUSUI_H__ */
