/*
 *	for new GOGO-no-coda (1999/09)
 *	Copyright (C) 1999 PEN@MarineCat, shigeo, sakai, Noisyu
 */


/*
 *	99/10/02 POSIX thread б
 *	99/10/03 MC_EMPHASISɲ
 *	99/10/13 musenc.cmusenc.c饤󥯥롼ɤMTѤSTѤδؿ
 *		 ˤ -spc2 MTSTǤ
 *	99/10/14 -cpu  CPU Ǥ褦ˤ
 *		 nCPU <= 1 λϥ󥰥륹ågogo
 *
 *	99/11/09 thread priority down (BeOS)
 *
 */

#ifdef	WIN32

#pragma message("--[ Detect Configure ]----------------------------------")

#ifdef	USE_VBR
#pragma message("Using VBR code")
#else
#pragma message("NotUse VBR code")
#endif

#ifdef	USE_E3DN
#pragma message("Using Enhanced3DNow code")
#else
#pragma message("NotUse Enhanced3DNow code")
#endif

#ifdef	USE_WINTHREAD
#pragma message("Using Multithread Kernel")
#else
#pragma message("NotUse Multithread Kernel")
#endif

#ifdef	LAME355
#pragma message("Including a part of LAME 3.55")
#else
#pragma message("Not including a part of LAME 3.55")
#endif

#if		defined(GOGO_DLL_EXPORTS) && defined(USE_REGISTRY)
#pragma message("Using Registry Database")
#else
#pragma message("NotUse Registry Database")
#endif

#if  defined(RAW_INPUT)
#pragma message("Using Raw-PCM Input")
#else
#pragma message("NotUse Raw-PCM Input")
#endif

#pragma message("--------------------------------------------------------")

#endif


#if	!defined(MUSENC_PASS2)
#define		COMPATIBLE_MUSICIN_C		
/* defined in makefile */

#define _MAIN_C	/* ΤΤΥǤ */

#define ALIGN16	/* 16 byte alignԤ(߲Τ̤ۤʤ뤳ȤĴ) */
#ifdef	GOGO_DLL_EXPORTS
#include "stdafx.h"
#endif

/* ˺ʤ */
#ifdef WINDOWS
#if		!defined( LAME355 ) | !defined ( USE_VBR ) !defined ( USE_E3DN )
#error "define LAME355, USE_VBR and USE_E3DN"
#endif
#endif

/* longjmp()Ȥ/Ȥʤ */

#ifdef WIN32

#ifdef _WINDOWS
#define USE_LONGJMP			/* GUI */
#else
#define DONT_USE_LONGJMP
#endif

#else /* WIN32 */

#define DONT_USE_LONGJMP	/* console */

#endif /* WIN32 */

#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <stdlib.h>
#include <time.h>
#include <assert.h>
#include <setjmp.h>
#include <limits.h>	/* for LONG_MAX */
#if defined(USE_PTHREAD)
#include <pthread.h>
#include <semaphore.h>
#endif
#ifdef	USE_WINTHREAD
#include <windows.h>
#include <winbase.h>
#include <process.h>
#endif
#ifdef   USE_OS2THREAD
#define INCL_DOS
#include <os2.h>
#include <stdlib.h>
#endif
#ifdef USE_BTHREAD
#include <OS.h>
#endif
#include "common.h"
#include "global.h"
#include "musenc.h"
#include "subband.h"
#include "reserv.h"
#include "l3bs.h"
#include "readsmpl.h"
#include "bitstrem.h"
#include "l3psy.h"
#include "mdct.h"
#include "loop.h"
#include "vbrtag.h"
#include "haveunit.h"

#if		defined( WIN32 ) | defined ( __HIGHC__ )
#include <io.h>
#endif
#ifdef __FreeBSD__
#include <floatingpoint.h>
#endif
#ifdef ABORTFP
#include <fpu_control.h>
#endif


#define MIE

/*
 *	ߴΤĤ(defined in common.h)
 */

int bForceMono   = FALSE;
int force_ms      = FALSE;
int gpsycho       = 1;
int sfb21         = 1;
int experimentalX = 0;
int experimentalY = 0;
int experimentalZ = 0; /* ߼Ƥޤ ͤѹʤǲ 99/10/10 */
int VBR           = 0;
int VBR_q         = -1;/* -1: no VBR */
int VBR_min_rate_idx = 6;   /* 80kbs */
int VBR_max_rate_idx = 13;  /* 256kbs */

//int highq         = 0; /* 󥵥ݡ */
int fast_mode     = 0;
//int allow_diff_short = 0;
int g_bWriteVbrTag = 1;
int bBitConvert		= FALSE;		/* 8bit->16bit */
int bSwapByte		= FALSE;		/* low, high bit convert */
int bTownsSND		= FALSE;		/* SND for TownsOS */
int bOutputVBR_userfunc = TRUE;		/* Userfncϻ XingVBRѤ */
struct MCP_INPDEV_USERFUNC	mc_userfunc;		// extern/桼ؿ
MPGE_USERFUNC				mc_userStore;
#define		ISUSERFUNCIN()	(mc_userfunc.pUserFunc != MPGE_NULL_FUNC )

static FILE			*musicin;
static int			firstcall;
int					debug = 0;
static III_side_info_t		l3_side;
static int			totalframes;
static jmp_buf		_longjmp_ptr;				/* goto longjmp */

#if               defined(USE_WINTHREAD) || defined(USE_OS2THREAD)
static int			boot_thread = 0;			/* åɵưϥ֡ȸΤߤȤ */
static MERET		error_notify = ME_NOERR;	/* 顼ȯߤ뤿 */
//static DWORD		nThreadClass;
static int			nThreadPrio;
#endif

#ifdef USE_VBR
static float VBR_pe_sum = 0;
#endif
#ifdef RAW_INPUT
static int nStartOffset = -1;
static int is8bitPCM = FALSE;
static int isMonoPCM = FALSE;
#endif /* RAW_INPUT */

static int	outputFormat = MC_OUTPUT_NORMAL;
static char*	pRiffInfos = NULL;
static int	riffInfosLen = 0;
static int	outputOffset = 0;
static int	verifyFlag = 0;
static char 	outputDir[MAX_FILE_LEN];

//	RIFF ƬΥ󥯥إå
struct CK_RIFF {
	long	chunk;						/* "RIFF" */
	long	size;						/* sizeof "RIFF" */
	long	form;						/* "WAVE" or etc */
} ;

//	RIFF/WAVE  fmt 
struct CK_FMT {
	long	chunk;						/* "fmt " */
	long	size;						/* 30 */
	short	formatID;					/* 0x55 = WAVE_FORMAT_MPEGLAYER3 */
	short	num_of_channel;				/* 1 or 2 */
	long	srate;						/* 44100 etc. */
	long	avg_bytes_par_sec;			/* ʿѥӥåȥ졼(Х/) */
	short	block_size;					/* 1 */
	short	bits_par_sample;			/* 0 */
	short	cbSize;						/* 12 */
	short 	wID;						/* 1 = MPEGLAYER3_ID_MPEG */
	long	fdwFlags;					/* 2 */
  	short	nBlockSize;					/* ե졼ΥХȿ */
  	short	nFramesPerBlock;			/* 1 */
  	short	nCodecDelay;				/* ?? */
} ;

//	RIFF/WAVE  fact 
struct CK_FACT {
	long	chunk;						/* "fact" */
	long	size;						/* 4 */
	long	num_of_sample;				/* ץ */
} ;

//	RIFF  data 󥯤Υإå
struct CK_DATA {
	long	chunk;						/* "data" */
	long	size;						/* sizeof "DATA" */
} ;

//	RIFF/WAVE  mp3 Τʬ
struct CK_WAVE {
	struct	CK_RIFF		riff;
	struct	CK_FMT		fmt;
	struct  CK_FACT		fact;
	struct	CK_DATA		data;
} ;

//	RIFF/RMP  mp3 Τʬ
struct CK_RMP {
	struct	CK_RIFF		riff;
	struct	CK_DATA		data;
};

//	RIFF  LIST 󥯤Υإå
struct CK_LIST {
	long	chunk;						/* "LIST" */
	long	size;						/* sizeof "LIST" */
	long	form;						/* "INFO" etc */
} ;




#ifdef LAME355
float lowpass1, lowpass2;
#endif

#if	defined(_DEBUG) && defined(WIN32)
void tprintf( const char *mesg, ... )
{
	char	bufs[1024];

	va_list vlist;
	va_start( vlist, mesg );
	vsprintf( bufs, mesg, vlist );
	OutputDebugString( bufs );
	va_end( vlist );
}
#else
#ifdef __os2__
void tprintf( const char *mesg, ... )
{
}
#else
#define	tprintf
#endif /* __os2__ */
#endif

/* change suffix of src to mp3  */
/* suppose sizeof(dest)>=sizeof(src) */
static int changeSuf( char *dest, const char *src, const int max_len )
{
	char *p;
	int i, len;
	strcpy( dest, src );
	len = strlen( dest );
	p = &dest[ len - 1 ];
	len = Min( len, 4 ); /* if the len of suffix < 4 then replace it with "mp3" */
	for( i = 0; i< len; i++,p-- ){
		if( *p == '\\' || *p == '/' )break; /* no suffix */
		if( *p == '.' ){
			*p = '\0';
			break;
		}
	}
	if( strlen( dest ) + 4 >= max_len ) return ERR;
	strcat( dest, ".mp3" );
	return NOERR;
}


/* destե̾ΤߤФpathθˤĤdest˽ */
#ifdef __unix__
#define SEP '/'
#else
#define SEP '\\'
#endif
static int changePath( char *dest, const char *path, const int max_len )
{
	char tmp[ MAX_FILE_LEN ];
	int len, i;
	char *p;
	strcpy( tmp, path );
	len = strlen( tmp );
	if( tmp[len - 1] != SEP ){
		tmp[len] = SEP;
		tmp[len + 1] = NUL;
	}
	len = strlen( dest );
#ifdef NO_KANJI
	for( i = len - 1; i >= 0 && dest[i] != SEP; i-- ) ; /* void */
	p = &dest[i];
	p++;
#else
#define isKANJI1(x) ((unsigned char)((x^0x20)-0xA1)<=0x3B)
	p = dest;
	for( i = 0; i < len; i++ ){
		if( isKANJI1( dest[i] ) ){
			i++;
			continue;
		}
		if( dest[i] == SEP ){
			p = &dest[i];
		}
	}
	if( *p == SEP ) p++;
#undef isKANJI1
#endif /* NO_KANJI */
	if( strlen( tmp ) + strlen( dest ) >= max_len ) return ERR;
	strcat( tmp, p );
	strcpy( dest, tmp );
	return NOERR;
}
#undef SEP

///////////////////////////////////////////////////////////////////////////

static char		szInFile[ MAX_FILE_LEN ];
static char		szOutFile[ MAX_FILE_LEN ];
static int		bInputStdio;
static int		bOutputStdio;
static int		useUNIT;
#if   defined(USE_PTHREAD) || defined(USE_BTHREAD) || defined(USE_WINTHREAD) || defined(USE_OS2THREAD)
static int		nCPU;
#define			ISMULTI()		(nCPU > 1)
#else
#define			ISMULTI()		0
#endif
///////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////
#if	defined(BeOS)
static int		intEncodeThreadPriority = 10;
static int		intReadThreadPriority = 0;
#endif
///////////////////////////////////////////////////////////////////////////

#define EXTRADELAY 56
#define bitsPerSlot 8

/* 顼åɽ */

static void err_puts(char *mes){
#ifndef _WINDOWS
	fprintf(stderr,"%s\n",mes);
#endif
}

/*
 *	SSE󥵥ݡOSǤν
 */

#if defined( __unix__ ) | defined( WIN32 )
#include <signal.h>

void SSE_not_support(int sig)
{
	if(debug)err_puts("This OS doesn't support SSE instructions.");
//	err_puts("So gogo doesn't use SSE,");
//	err_puts("but please use -off sse option if in trouble.");
	signal( SIGILL, SIG_DFL );		// or SIG_IGN
	longjmp( _longjmp_ptr, 1);
}
#endif
#endif	/* !defined(MUSENC_PASS2) */


#if	!defined(MUSENC_PASS2)
#if	defined(USE_WINTHREAD)

// ʥåɤκꡣ
#define	NTHREADS	3		/* Ǥ3ĤOKĴ */
static char __frmBuffer[ 2 * 1152 * sizeof(short) + 16]; /*  */
static unsigned __stdcall encodeframe(void *);

static CRITICAL_SECTION	mutex_mfbuf;
static CRITICAL_SECTION	mutex_l3_sb_sample;
static CRITICAL_SECTION	mutex_l3_side;
static CRITICAL_SECTION	mutex_frmBuffer ;
static CRITICAL_SECTION mutex_fmt_bitstm ;
static HANDLE	cond_frmBuffer;


typedef struct {
	short				(*buf)[1152];
	int					tid;		/* Thread ID */
	unsigned			threadaddr;
	unsigned long		hThread;	/* Thread Handle */
	BOOL				finthread;
	CRITICAL_SECTION	section;
	HANDLE				hEnterFrame;
	HANDLE				hLeaveFrame;
	HANDLE				hWaitEncoding;
	HANDLE				hExistThread;
} encodeframe_arg_t;

encodeframe_arg_t	encodeframe_arg[NTHREADS];
#endif

#if   defined(USE_OS2THREAD)
// ʥåɤκꡣ
#define	NTHREADS 3		/* Ǥ3ĤOKĴ  wassat do anyway ?? */
static char __frmBuffer[ 2 * 1152 * sizeof(short) + 16]; /*  */
static void _System encodeframe(void *);

static HMTX mutex_mfbuf;
static HMTX mutex_l3_sb_sample;
static HMTX mutex_l3_side;
static HMTX mutex_frmBuffer ;
static HMTX mutex_fmt_bitstm ;
static HEV	cond_frmBuffer;

typedef struct {
	short 				(*buf)[1152];
	int					tid;		/* Thread ID */
	unsigned 			threadaddr;
	unsigned long		hThread; /* Thread Handle */
	BOOL					finthread;
	HMTX					section;
	HEV					hEnterFrame;
	HEV					hLeaveFrame;
	HEV					hWaitEncoding;
	HEV					hExistThread;
} encodeframe_arg_t;

encodeframe_arg_t encodeframe_arg[NTHREADS];
#endif /* USE_OS2THREAD */

MERET EXPORT
MPGE_initializeWork()
{
	int statUNIT;

#if		defined(GOGO_DLL_EXPORTS) && defined(USE_REGISTRY)
	static	BOOL	bRegistered = FALSE;
#define ParentKey HKEY_CURRENT_USER				//ƥ
#define SubKey "Software\\MarineCat\\GOGO_DLL"	//륵֥
	if( !bRegistered ){
		HKEY	hKey;
		DWORD	dwPosition;
		LONG	lResult;
		static const char	*szName = "INSTPATH";
		char	szPathName[ _MAX_PATH ];
		extern	HINSTANCE	hDLLInstance;

		GetModuleFileName(hDLLInstance, szPathName, sizeof szPathName);
		if( RegCreateKeyEx(
				ParentKey,
				SubKey,
				0,
				"",
				REG_OPTION_NON_VOLATILE,
				KEY_ALL_ACCESS,
				NULL,
				&hKey,
				&dwPosition) == ERROR_SUCCESS 
		){
			lResult = RegSetValueEx(hKey,
				szName,
				0,
				REG_SZ,
				(CONST BYTE *)szPathName,
				lstrlen(szPathName));
			RegCloseKey(hKey);
		}
		bRegistered = TRUE;
	}
#endif

	memset(&gl, 0, sizeof(gl) );

	gl.mode        = -1;
	gl.inp_freqHz  = -1;
	gl.enc_freqHz  = -1;
	gl.rate_kbps   = -1;
	gl.freq_idx    = 0; /* enc_freqHz ꤵ */
	l3_side.rate_idx    = 0; /* rate_kbps ꤵ */
	gl.original    = 1;
//	gl.error_protection	= FALSE;

	gpsycho       = 1;
	sfb21         = -1;
	experimentalX = 0;
	experimentalY = 0;
	experimentalZ = 0;
	VBR           = 0;
	VBR_q         = -1;
	VBR_min_rate_idx = 6;   /* 80kbs */
	VBR_max_rate_idx = 13;  /* 256kbs */
#ifdef USE_VBR
	VBR_pe_sum = 0;
#endif
//	highq         = 0;
	fast_mode     = 0;
//	allow_diff_short = 0;
	g_bWriteVbrTag = 1;
	firstcall     = 1;
	bBitConvert	  = FALSE;		/* 8bit->16bit */
	bSwapByte	  = FALSE;
	bTownsSND	  = FALSE;
#ifdef RAW_INPUT
	nStartOffset  = -1;		/* -1ǤʤȤRAW-PCM⡼ */
	is8bitPCM	  = FALSE;
	isMonoPCM	  = FALSE;
#endif /* RAW_INPUT */

	szInFile[ 0 ] = '\0';
	szOutFile[ 0 ] = '\0';
	bInputStdio   = FALSE;
	bOutputStdio  = FALSE;
	bForceMono = FALSE;

	if( pid3tag ){
		mem_free( (void **)&pid3tag );
	}
	nid3taglen = 0;
	pid3tag = NULL;

	memset( &mc_userfunc, 0, sizeof mc_userfunc );
	memset( &l3_side, 0, sizeof( l3_side ) );
	mc_userStore = MPGE_NULL_FUNC;

	outputFormat = MC_OUTPUT_NORMAL;
	riffInfosLen = 0;
	outputOffset = 0;
	verifyFlag = 0;
	*outputDir = NUL;
	if( pRiffInfos ){
		mem_free( (void**)&pRiffInfos );
	}

#ifdef __FreeBSD__
	{
		fp_except_t mask;
		mask=fpgetmask();
		/*  printf("FreeBSD mask is 0x%x\n",mask); */
	}
#endif
#ifdef ABORTFP
	{
		unsigned int mask;
		_FPU_GETCW(mask);
		/* Set the Linux mask to the FreeBSD default mask */
		mask &= ~( _FPU_MASK_IM | _FPU_MASK_ZM | _FPU_MASK_OM );
		_FPU_SETCW(mask);
	}
#endif

	/*	3D Now!ܳǧ */
	statUNIT = haveUNIT();
	if( !( statUNIT & tFPU ) ){
		return ME_NOFPU;
	}
	useUNIT = statUNIT;	/* 礨Ȥ뵡ǽϻȤ(optionϤޤ) */

#if defined(USE_PTHREAD) && defined(__linux__)
	/* ץåγǧ */
	{
		FILE	*cpuinfo;
		char	buffer[256];

		nCPU = 0;
		if((cpuinfo = fopen("/proc/cpuinfo", "r")) != NULL){
			while(fgets(buffer, sizeof buffer, cpuinfo) != NULL){
				if(memcmp(buffer, "processor", (sizeof "processor") - 1) == 0){
					nCPU++;
				}
			}
			fclose(cpuinfo);
		}
		// if(nCPU > 0) printf("The number of processor is %d\n", nCPU);
	}
#elif defined(USE_BTHREAD)
	/* ץåμ */
	{
		system_info udtsystem_info;
		nCPU = 1;
		get_system_info(&udtsystem_info);
		nCPU = udtsystem_info.cpu_count;
		if(nCPU > 1) printf("The number of processor is %d\n", nCPU);
	}
#endif

#if defined(USE_WINTHREAD)
	/* ץåμ */
	{
		SYSTEM_INFO		cpuinfo;
		GetSystemInfo( &cpuinfo );
		nCPU = cpuinfo.dwNumberOfProcessors;
		tprintf("The number of processor is %d\n", nCPU);
	}

	if( !boot_thread  ){
		int		i;

		boot_thread = !0;			// boot_thread <- true
		memset( &encodeframe_arg, 0, sizeof( encodeframe_arg ) );

		InitializeCriticalSection( &mutex_mfbuf );
		InitializeCriticalSection( &mutex_l3_sb_sample );
		InitializeCriticalSection( &mutex_l3_side );
		InitializeCriticalSection( &mutex_frmBuffer );
		InitializeCriticalSection( &mutex_fmt_bitstm );
		
		for(i = 0; i < NTHREADS; i++){
			encodeframe_arg[i].tid = i;
			encodeframe_arg[i].buf = (short (*)[1152])( (int)(__frmBuffer+15) & -16 );
			encodeframe_arg[i].finthread = FALSE;

			InitializeCriticalSection( &encodeframe_arg[i].section );
			encodeframe_arg[i].hEnterFrame = CreateEvent( NULL, TRUE, FALSE, NULL );
			encodeframe_arg[i].hLeaveFrame = CreateEvent( NULL, TRUE, FALSE, NULL );
			encodeframe_arg[i].hWaitEncoding = CreateEvent( NULL, TRUE, FALSE, NULL );

			if( (encodeframe_arg[i].hThread = _beginthreadex( 
					NULL,			// security
					0,				// stksize 
					encodeframe,
					(void *)&encodeframe_arg[i] , 0, &encodeframe_arg[i].threadaddr ) ) == 0 ){
				return ME_CANNOT_CREATE_THREAD;
			}
		}
	}

	error_notify = ME_NOERR;
#endif	/* USE_WINTHREAD */

#if defined(USE_OS2THREAD)
	{
		#define QSV_NUMPROCESSORS 26
		APIRET  apiretRc=0;
		apiretRc=DosQuerySysInfo(QSV_NUMPROCESSORS, QSV_NUMPROCESSORS, &nCPU, sizeof(nCPU));
		if(apiretRc!=0)
			 nCPU=1;
		printf("The number of processor is %d\n", nCPU);
	}

	if( !boot_thread	){
		int		i;

		boot_thread = !0; 		// boot_thread <- true
		memset( &encodeframe_arg, 0, sizeof( encodeframe_arg ) );

		DosCreateMutexSem(NULL,&mutex_mfbuf,0,FALSE);
		DosCreateMutexSem(NULL,&mutex_l3_sb_sample,0,FALSE);
		DosCreateMutexSem(NULL,&mutex_l3_side,0,FALSE);
		DosCreateMutexSem(NULL,&mutex_frmBuffer,0,FALSE);
		DosCreateMutexSem(NULL,&mutex_fmt_bitstm,0,FALSE);

		for(i = 0; i < NTHREADS; i++){
			encodeframe_arg[i].tid = i;
			encodeframe_arg[i].buf = (short (*)[1152])( (int)(__frmBuffer+15) & -16 );
			encodeframe_arg[i].finthread = FALSE;

			DosCreateMutexSem(NULL,&encodeframe_arg[i].section,0,FALSE);
			DosCreateEventSem(NULL,&encodeframe_arg[i].hEnterFrame,0,FALSE);
			DosCreateEventSem(NULL,&encodeframe_arg[i].hLeaveFrame,0,FALSE);
			DosCreateEventSem(NULL,&encodeframe_arg[i].hWaitEncoding,0,FALSE);

			if( (encodeframe_arg[i].hThread = _beginthread( encodeframe, 0, 65536, &encodeframe_arg[i])) == -1 ){
				return ME_CANNOT_CREATE_THREAD;
			}
		}
	}

	error_notify = ME_NOERR;
#endif	/* USE_OS2THREAD */

	return ME_NOERR;
}
#endif	/* !defined(MUSENC_PASS2) */

#if	!defined(MUSENC_PASS2)
//enum { FALSE, TRUE };
MERET EXPORT

#ifndef __os2__
MPGE_setConfigure(MPARAM mode, UPARAM dwPara1, UPARAM dwPara2 )
#else
MPGE_setConfigure(MUPARAM mode, UPARAM dwPara1, UPARAM dwPara2 )
#endif
{
	// 󥳡ɤϤƤӽФʤ
	if( musicin )
		return ME_PARAMERROR;

	switch( mode ){
		case MC_INPUTFILE:
			if( dwPara1 == MC_INPDEV_FILE ){
				bInputStdio = FALSE;
				mc_userfunc.pUserFunc = MPGE_NULL_FUNC;
				if( strlen( (char *)dwPara2 ) >= MAX_FILE_LEN ) return ME_PARAMERROR;
				strcpy( szInFile, (char *)dwPara2 );
				return ME_NOERR;
			} else if( dwPara1 == MC_INPDEV_STDIO ){
				bInputStdio = TRUE;
				mc_userfunc.pUserFunc = MPGE_NULL_FUNC;
				return ME_NOERR;
			} else if( dwPara1 == MC_INPDEV_USERFUNC ){
				bInputStdio = FALSE;
				mc_userfunc = *((struct MCP_INPDEV_USERFUNC *)dwPara2);
				return ME_NOERR;
			}
			return ME_PARAMERROR;
		case MC_OUTPUTFILE:
			if( dwPara1 == MC_OUTDEV_FILE ){
				bOutputStdio = FALSE;
				if( strlen( (char *)dwPara2 ) >= MAX_FILE_LEN ) return ME_PARAMERROR;
				strcpy( szOutFile, (char *)dwPara2 );
				mc_userStore = MPGE_NULL_FUNC;
				return ME_NOERR;
			} else if( dwPara1 == MC_OUTDEV_FILE ){
				bOutputStdio = TRUE;
				mc_userStore = MPGE_NULL_FUNC;
				return ME_NOERR;
			} else if( dwPara1 == MC_OUTDEV_USERFUNC ){
				mc_userStore = (MPGE_USERFUNC )dwPara2;
				bOutputStdio = FALSE;
				bOutputVBR_userfunc = FALSE;
				return ME_NOERR;
			} else if( dwPara1 == MC_OUTDEV_USERFUNC_WITHVBRTAG ){
				mc_userStore = (MPGE_USERFUNC )dwPara2;
				bOutputStdio = FALSE;
				bOutputVBR_userfunc = TRUE;
				return ME_NOERR;
			}
			return ME_PARAMERROR;
		case MC_ENCODEMODE:
			if( dwPara1 == MC_MODE_MONO ){
				gl.mode = MPG_MD_MONO; 
				l3_side.mode_ext = 0;
				force_ms = FALSE;
				return ME_NOERR;
			} else
			if( dwPara1 == MC_MODE_STEREO ){
				gl.mode = MPG_MD_STEREO; 
				l3_side.mode_ext = 0; 
				force_ms = 0;
				return ME_NOERR;
			} else
			if( dwPara1 == MC_MODE_JOINT ){
				gl.mode = MPG_MD_JOINT_STEREO; 
				l3_side.mode_ext = 0;
				force_ms = 0;
				return ME_NOERR;
			} else
			if( dwPara1 == MC_MODE_MSSTEREO ){
				gl.mode = MPG_MD_JOINT_STEREO; 
				l3_side.mode_ext = 0;
				force_ms = 1;
				return ME_NOERR;
			} else
			if( dwPara1 == MC_MODE_DUALCHANNEL ){
				gl.mode = MPG_MD_DUAL_CHANNEL;
				l3_side.mode_ext = 0;
				force_ms = 0;
				return ME_NOERR;
			}
			return ME_PARAMERROR;
		case MC_BITRATE:
			gl.rate_kbps = dwPara1;
			return ME_NOERR;
		case MC_EMPHASIS:
			gl.emphasis = dwPara1;
			return ME_NOERR;
		case MC_INPFREQ:
			gl.inp_freqHz = dwPara1;
			return ME_NOERR;
		case MC_OUTFREQ:
			gl.enc_freqHz = dwPara1;
			return ME_NOERR;
#ifdef USE_VBR
		case MC_VBR:
			VBR = 1;
			VBR_q = dwPara1;
			if( VBR_q < 0 ) VBR_q = 4;
			return ME_NOERR;
#endif /* USE_VBR */
#ifdef RAW_INPUT
		case MC_STARTOFFSET:
			nStartOffset = dwPara1;
			return ME_NOERR;
		case MC_BYTE_SWAP:
			bSwapByte = TRUE;
			return ME_NOERR;
		case MC_8BIT_PCM:
			is8bitPCM = TRUE;
			return ME_NOERR;
		case MC_MONO_PCM:
			isMonoPCM = TRUE;
			return ME_NOERR;
		case MC_TOWNS_SND:
			bTownsSND = TRUE;
			return ME_NOERR;
#endif /* RAW_INPUT */
		case MC_USEPSY:
			fast_mode = dwPara1 ? FALSE: TRUE ;
			return ME_NOERR;
		case MC_USELPF16:
			sfb21 = dwPara1 ? TRUE: FALSE ;
			return ME_NOERR;
		case MC_USEMMX:
			if( dwPara1 ) {
				useUNIT |= tMMX;
			} else {
				useUNIT &= ~(tMMX);
			}
			return ME_NOERR;
		case MC_USE3DNOW:
			if( dwPara1 ) {
				useUNIT |= t3DN;
			} else {
				useUNIT &= ~(t3DN);
				useUNIT &= ~(tE3DN);	/* 3DNȤʤE3DNȤʤ */
			}
			return ME_NOERR;
		case MC_USEKNI:
			if( dwPara1 ) {
				useUNIT |= tSSE;
			} else {
				useUNIT &= ~(tSSE);
			}
			return ME_NOERR;
		case MC_USEE3DNOW:
			if( dwPara1 ) {
				useUNIT |= tE3DN ;
				useUNIT |= t3DN ;	/* E3DNȤ3DNȤ */
			} else {
				useUNIT &= ~tE3DN ;
			}
			return ME_NOERR;
		case MC_USESPC1:
			if( dwPara1 ) {
				useUNIT |= tSPC1;
			} else {
				useUNIT &= ~(tSPC1);
			}
			return ME_NOERR;
		case MC_USESPC2:
			if( dwPara1 ) {
				useUNIT |= tSPC2;
			} else {
				useUNIT &= ~(tSPC2);
			}
			return ME_NOERR;
#if   defined(USE_PTHREAD) || defined(USE_BTHREAD) || defined(USE_WINTHREAD) || defined(USE_OS2THREAD)
		case MC_CPU:
			if( dwPara1 > 0) {
				nCPU = dwPara1;
			}
			return ME_NOERR;
#endif
#if	defined(BeOS)
		case MC_THREAD_PRIORITY:
			if( dwPara1 > 0) {
				intEncodeThreadPriority = dwPara1;
			}
			return ME_NOERR;
#endif
#if	defined(USE_BTHREAD)
		case MC_READTHREAD_PRIORITY:
			if( dwPara1 >= 0) {
				intReadThreadPriority = dwPara1;
			}
			return ME_NOERR;
#endif
		case MC_ADDTAG:
			{
				//nid3taglen = dwPara1;
				if( dwPara1 ){
					if( pid3tag ){
						char	*ptmp = mem_alloc( dwPara1 + nid3taglen + 4, "ID3TAG" );
						if( ptmp == NULL ){
							mem_free( (void **)&pid3tag );
							nid3taglen = 0;
							return ME_NOMEMORY;
						}
						memcpy( ptmp, pid3tag, nid3taglen );
						memcpy( ptmp + nid3taglen, (void *)dwPara2, dwPara1 );
						nid3taglen += dwPara1;
						mem_free( (void **)&pid3tag );
						pid3tag = ptmp;
					} else {
						nid3taglen = dwPara1;
						pid3tag = mem_alloc( nid3taglen + 4, "ID3TAG" );
						if( pid3tag == NULL ){
							nid3taglen = 0;
							return ME_NOMEMORY;
						}
						memcpy( pid3tag, (void*)dwPara2, nid3taglen );
					}
				}
			}
			return ME_NOERR;			
		case MC_OUTPUT_FORMAT:
			{
				switch(dwPara1) {
					case MC_OUTPUT_NORMAL:
					case MC_OUTPUT_RIFF_WAVE:
					case MC_OUTPUT_RIFF_RMP:
						outputFormat = dwPara1;
						break;
					default:
						return ME_PARAMERROR;
				}
			}
			return ME_NOERR;
		case MC_RIFF_INFO:
			{
				if( 4 <= dwPara1 && dwPara2 ){
					int		addInfoSize = (dwPara1 & 1) ? dwPara1 + 5 : dwPara1 + 4;
					if( pRiffInfos ){
						char	*pTmp = mem_alloc( riffInfosLen + addInfoSize, "RIFFINFO" );
						if( pTmp == NULL ){
							mem_free( (void **)&pRiffInfos );
							riffInfosLen = 0;
							return ME_NOMEMORY;
						}
						memmove( pTmp, pRiffInfos, riffInfosLen );
						memmove( pTmp + riffInfosLen, (void *)dwPara2, 4 );
						*(int *)(pTmp + riffInfosLen + 4) = dwPara1-4;
						memmove( pTmp + riffInfosLen + 8, (void *)((char *)dwPara2+4), dwPara1-4 );
						riffInfosLen += addInfoSize;
						mem_free( (void **)&pRiffInfos );
						pRiffInfos = pTmp;
					} else {
						pRiffInfos = mem_alloc( addInfoSize, "RIFFINFO" );
						if( pRiffInfos == NULL ){
							riffInfosLen = 0;
							return ME_NOMEMORY;
						}
						memmove( pRiffInfos, (void *)dwPara2, 4 );
						*(int *)(pRiffInfos + 4) = dwPara1-4;
						memmove( pRiffInfos + 8, (void *)((char *)dwPara2+4), dwPara1-4 );
						riffInfosLen = addInfoSize;
					}
				}
			}
			return ME_NOERR;
		case MC_VERIFY:
			verifyFlag = 1;
			return ME_NOERR;
		case MC_OUTPUTDIR:
			if( strlen( (char *)dwPara1 ) >= MAX_FILE_LEN ) return ME_PARAMERROR;
			strcpy( outputDir, (char *)dwPara1 );
			return ME_NOERR;

	}
	return ME_PARAMERROR;
}
#endif	/* !defined(MUSENC_PASS2) */



#if	!defined(MUSENC_PASS2)
MERET EXPORT
MPGE_detectConfigure()
{
	int size, bit, channel;

	if( musicin != NULL )
		return ME_INTERNALERROR;
	/* open input file */
	if( ISUSERFUNCIN() ){
		musicin = (FILE *)-1;
	} else if( bInputStdio ){ /* Thanks to Tomoya Tokairin */
#ifdef WIN32
#ifdef __BORLANDC__
		setmode( _fileno( stdin ), _O_BINARY );
#else
		_setmode( _fileno( stdin ), _O_BINARY );
#endif
#elif __HIGHC__
		_setmode( stdin, _BINARY );
#endif
		musicin = stdin;/* unix */
	} else {
		musicin = fopen( szInFile, "rb" );
		if( !musicin ) return ME_INFILE_NOFOUND;
	}
	/* detective the name of output file */
	if( szOutFile[0] == '\0' ){
		if( bInputStdio ){
			return ME_OUTFILE_NOFOUND;
		}
		if( !*szInFile ){
			strcpy( szOutFile, "default.mp3" );
		}else{
			if( changeSuf( szOutFile, szInFile, MAX_FILE_LEN ) == ERR ) return ME_INTERNALERROR;
		}
	}
	if( *outputDir ){
		if( changePath( szOutFile, outputDir, MAX_FILE_LEN ) == ERR ) return ME_INTERNALERROR;
	}
#ifndef WINDOWS /* only console */
	if( verifyFlag ){
		FILE *fp;
		fp = fopen( szOutFile, "r" );
		if( fp ){
			char tmp[4];
			fclose(fp);
			fprintf( stderr, "\noverwrite [%s]?(y/n)\n", szOutFile );
			fgets( tmp, sizeof(tmp), stdin );
			if( *tmp != 'y' && *tmp != 'Y' ) return ME_HALTED;
		}
	}
#endif /* WINDOWS */
	/* /PCMμȿꤹ */
#ifdef RAW_INPUT
	if( nStartOffset != -1 && !ISUSERFUNCIN() ){
		int i;
		if( !bInputStdio ){
			fseek( musicin, 0, SEEK_END );
			size = ftell( musicin );
			rewind( musicin );
		}else{
			size = LONG_MAX;
		}
		size -= nStartOffset; /* subtract size of header */
		for( i = 0; i < nStartOffset; i++ ){
			fgetc( musicin );	/* header skip. Don't use fseek */
		}
		bit = is8bitPCM ? 8 : 16;
		channel = isMonoPCM ? 1 : 2;
	}else
#endif /* RAW_INPUT */
	if( !ISUSERFUNCIN() ){
		if( !WAV_checkFMT( musicin, &size, &bit, &gl.inp_freqHz, &channel) ){
			fclose( musicin );
			return ME_WAVETYPE_ERR;				/* WAVE format error */
		}
	} else {
		size = mc_userfunc.nSize;
		bit  = mc_userfunc.nBit;
		gl.inp_freqHz = mc_userfunc.nFreq;
		channel = mc_userfunc.nChn;
	}

	bBitConvert = ( bit == 16 ) ? FALSE : TRUE;		/* ӥåȿѴ */

	if( channel == 1 ){
		gl.mode = MPG_MD_MONO; 
		l3_side.mode_ext = 0;
		force_ms = FALSE;
	} else
	if( channel == 2 ){
		if( gl.mode == MPG_MD_MONO ){
			bForceMono = TRUE;			/* ΥѴ */
			channel     = 1;			/* Υ */
		}
	}

	if( mc_userStore == MPGE_NULL_FUNC ){
		if( !open_bit_stream_w( szOutFile, ENC_BUFFER_SIZE) ){
			musicin = NULL;
			return	ME_OUTFILE_NOFOUND;
		}
	} else {
		open_bit_stream_userfunc( mc_userStore , ENC_BUFFER_SIZE);
	}
	

	if( gl.inp_freqHz == -1 ){ /* ϼȿꤵƤʤä44.1kHz */
		gl.inp_freqHz = 44100;
	}
	if( gl.enc_freqHz == -1 ){ /* ϼȿꤵƤʤäϤƱ */
		gl.enc_freqHz = gl.inp_freqHz;
	}

	gl.enc_freqHz = NormalizeSmpFreq( gl.enc_freqHz ); /* 󥳡ɲǽʽϼȿ˰ֶᤤΤ */

	/* ץ󥰥Сν */
	InitializeSampleConverter( gl.inp_freqHz, gl.enc_freqHz );

	/* MPEG1/2Ƚ */
	if( (gl.freq_idx = SmpFrqIndex( gl.enc_freqHz, &gl.version)) < 0){
		if( ISUSERFUNCIN() )
			mc_userfunc.pUserFunc( NULL, 0 );
		else
			fclose( musicin );
		musicin = NULL;
		return ME_FREQERROR;
	}
	gl.frameSize = ( gl.version ) ? 1152 : 576;

	/* ⡼ */
	if( gl.mode < 0 ){
		gl.mode = MPG_MD_JOINT_STEREO;/* ǥեȤ JOINT-STEREO */
		l3_side.mode_ext = 0;
		force_ms = 0;
	}

	/* ե졼λ */
	if( size != MC_INPDEV_MEMORY_NOSIZE ){
		{
			int	num = (double)size * (double)gl.enc_freqHz / (double)gl.inp_freqHz;
			int perFrame = gl.frameSize * 2 * bit/8;
			if( gl.mode == MPG_MD_MONO && !bForceMono ){
				perFrame /= 2;
			}
			totalframes = ( num + gl.frameSize - 1 ) / perFrame;
		}
	} else {
		totalframes = 0;
	}

	/* ӥåȥ졼 */
	if( gl.rate_kbps <= 0 ){
		gl.rate_kbps = 128;
	}
	l3_side.rate_idx = BitrateIndex( 3 /* =gl.lay */, gl.rate_kbps, gl.version);
	if( l3_side.rate_idx < 0 ){
		if( ISUSERFUNCIN() )
			mc_userfunc.pUserFunc( NULL, 0 );
		else
			fclose( musicin );
		musicin = NULL;
		return ME_BITRATEERROR;
	}
    /* a bit rate was specified.  for VBR, take this to be the minimum */
	VBR_min_rate_idx = l3_side.rate_idx;

	if( gl.rate_kbps >= 192 ){
		if( gl.mode != MPG_MD_MONO && gl.mode != MPG_MD_DUAL_CHANNEL ){
			/* 192kbpsʾΥӥåȥ졼ȤǤ϶ŪSTEREOȤ */
			gl.mode = MPG_MD_STEREO; 
			l3_side.mode_ext = 0;
			force_ms = 0;
		}
	}
	/* ⰵ̤ʤȤ ե륿 */
	if( sfb21 == -1 ){
#ifdef LAME355
		float compression_ratio;
		lowpass1 = lowpass2 = 0;
		compression_ratio = gl.enc_freqHz * channel * 16 / ( gl.rate_kbps * 1000.0 );
		if( gl.rate_kbps / channel <= 32 ){
			sfb21 = 0;
			if( compression_ratio > 15.5 ){
				lowpass1 = 0.35; /* for 16kHz 16kbps */
				lowpass2 = 0.50;
			}else if( compression_ratio > 14 ){
				lowpass1 = 0.40; /* for 22kHz 24kbps */
				lowpass2 = 0.55;
			}else{
				lowpass1 = 0.55; /* for 16kHz 24kbps */
				lowpass2 = 0.70;
			}
		}
#endif
		if( gl.rate_kbps / channel <= 64 ){
			sfb21 = 1;
		} else {
			sfb21 = 0;
		}
	}

	/* ϥեޥå */
	if( mc_userStore != MPGE_NULL_FUNC || bOutputStdio ) {
		// 桼ϡɸϻϡ̾եޥå(mp3+pid3tag)Τ߲ǽ
		outputFormat = MC_OUTPUT_NORMAL;
	}
	// եޥåΥեƬ mp3 ΤؤΥեåȤ
	switch( outputFormat ) {
		case MC_OUTPUT_NORMAL: 
			outputOffset = 0;
			break;
		case MC_OUTPUT_RIFF_WAVE: 
			outputOffset = sizeof(struct CK_WAVE);
			break;
		case MC_OUTPUT_RIFF_RMP: 
			outputOffset = sizeof(struct CK_RMP);;
			break;
		default:
			return ME_INTERNALERROR;
	}
	// mp3 ΤǡʬƤ
	{
		// ľ fseek ȸγĥ bitstream.c δؿ礬Ǥ饤
		// putbits Ƥ
		int seekPoint = outputOffset;
		while( seekPoint ){
			putbits(0, 8);
			seekPoint--;
		}
	}

	/* ¾Υѥ᡼ν */
	gl.stereo = ( gl.mode == MPG_MD_MONO ) ? 1 : 2;
	gl.mode_gr = ( gl.version == 1 ) ? 2 : 1;

	/* ǥХ */
#if defined( __unix__ ) | defined( WIN32 )
	if( useUNIT & tSSE ){
		MERET	jmpval;
		jmpval = setjmp( _longjmp_ptr );
		if( !jmpval ){
			if(debug)err_puts("check whether OS supports SSE.");
			signal(SIGILL,SSE_not_support);
			setPIII_round();
			if(debug)err_puts("... yes.");
		} else {
			useUNIT &= ~tSSE;
		}
	}
#endif
	if( useUNIT & tSSE ){
		setPIII_round();	/* SSEȤʤͼθ⡼ɤ˥å */
	}

	if( gl.version == 0 ) g_bWriteVbrTag = 0;
	if( !VBR ) g_bWriteVbrTag = 0;
#ifdef USE_VBR
	if( l3_side.rate_idx == 14 ) VBR = 0;  /* dont bother with VBR at 320kbs */

	if( VBR ){
		if( l3_side.rate_idx == 13 ) VBR_max_rate_idx = 14;  
		if( VBR_q == 0 ) VBR_max_rate_idx = 14;  
		if( VBR_q >= 5 ) VBR_max_rate_idx = 12;
		if( VBR_q >= 8 ) VBR_max_rate_idx = 9;
		fast_mode = FALSE; 
//    highq = TRUE;	/* ˤl3psy.cѹɬ */
		if( VBR_q < 4 ) sfb21 = 0;
		if( g_bWriteVbrTag ) InitVbrTag(gl.version-1,gl.mode,gl.freq_idx);
	}
#endif /* USE_VBR */


	/* Windows MultiThreadѽ */
#if		0//def	USE_WINTHREAD
	if( ISMULTI() ){
		int		i;
		memset( &encodeframe_arg, 0, sizeof( encodeframe_arg ) );

		InitializeCriticalSection( &mutex_mfbuf );
		InitializeCriticalSection( &mutex_l3_sb_sample );
		InitializeCriticalSection( &mutex_l3_side );
		InitializeCriticalSection( &mutex_frmBuffer );
		InitializeCriticalSection( &mutex_fmt_bitstm );
		
		for(i = 0; i < NTHREADS; i++){
			encodeframe_arg[i].tid = i;
			encodeframe_arg[i].buf = (short (*)[1152])( (int)(__frmBuffer+15) & -16 );
			encodeframe_arg[i].finthread = FALSE;

			InitializeCriticalSection( &encodeframe_arg[i].section );
			encodeframe_arg[i].hEnterFrame = CreateEvent( NULL, TRUE, FALSE, NULL );
			encodeframe_arg[i].hLeaveFrame = CreateEvent( NULL, TRUE, FALSE, NULL );

#if		0
			if( _beginthread( encodeframe, 0 /*stksize*/, &encodeframe_arg[i] ) == -1 ){
				// error
				return ME_CANNOT_CREATE_THREAD;
			}
#else
			if( (encodeframe_arg[i].hThread = _beginthreadex( 
					NULL,			// security
					0,				// stksize 
					encodeframe,
					(void *)&encodeframe_arg[i] , 0, &encodeframe_arg[i].threadaddr ) ) == 0 ){
				return ME_CANNOT_CREATE_THREAD;
			}
		//	ResumeThread( (HANDLE)encodeframe_arg[i].hThread  );
#endif
		}
	}
#endif


	/* ¾ν */
	firstcall = 1;

	setupUNIT( useUNIT );
	L3psy_init( gl.enc_freqHz );
	window_subband_init();
	framebitstable_init();
	
	tableInitForMDCT();		/* 1٤ɤ */
	InitReservoir();		/* reserv.c */
	InitFormatBitStream();		/* l3bs.c */
	InitLoop();				/* loop.c */

	return ME_NOERR;
}
#endif	/* !defined(MUSENC_PASS2) */

#if	!defined(MUSENC_PASS2)
MERET EXPORT
#ifndef __os2__
MPGE_getConfigure(MPARAM mode, void *param )
#else
MPGE_getConfigure(MUPARAM mode, void *param )
#endif
{
	int		*iparam = (int *)param;

	// 󥳡ɤϤޤƤӽФʤ
	if( !musicin )
		return ME_PARAMERROR;

	switch( mode ){
		case MG_INPUTFILE:
			if( bInputStdio )
				((char *)param)[0] = '\0';
			else
				strcpy( param, szInFile);
			return ME_NOERR;
		case MG_OUTPUTFILE:
			if( bOutputStdio ){
				((char *)param)[0] = '\0';
			} else {
				strcpy( param, szOutFile);
			}
			return ME_NOERR;
		case MG_ENCODEMODE:
			switch( gl.mode ){
				case MPG_MD_MONO:
					*iparam = MC_MODE_MONO;
					return ME_NOERR;
				case MPG_MD_STEREO:
					*iparam = MC_MODE_STEREO;
					return ME_NOERR;
				case MPG_MD_JOINT_STEREO:
					if( !force_ms )
						*iparam = MC_MODE_JOINT;
					else
						*iparam = MC_MODE_MSSTEREO;
					return ME_NOERR;
				case MPG_MD_DUAL_CHANNEL:
					*iparam = MC_MODE_DUALCHANNEL;
					return ME_NOERR;
			}
			return ME_PARAMERROR;
		case MG_BITRATE:
			*iparam = gl.rate_kbps;
			return ME_NOERR;
		case MG_INPFREQ:
			*iparam = gl.inp_freqHz;
			return ME_NOERR;
		case MG_OUTFREQ:
			*iparam = gl.enc_freqHz;
			return ME_NOERR;
		case MG_STARTOFFSET:
			*iparam = -1;
			return ME_NOERR;
		case MG_USEPSY:
			*iparam = fast_mode ? FALSE: TRUE ;
			return ME_NOERR;
		case MG_USEMMX:
			*iparam = ( useUNIT & tMMX ) ? TRUE : FALSE;
			return ME_NOERR;
		case MG_USE3DNOW:
			*iparam = ( useUNIT & t3DN ) ? TRUE : FALSE;
			return ME_NOERR;
		case MG_USEKNI:
			*iparam = ( useUNIT & tSSE ) ? TRUE : FALSE;
			return ME_NOERR;
		case MG_USEE3DNOW:
			*iparam = ( useUNIT & tE3DN ) ? TRUE : FALSE;
			return ME_NOERR;
		case MG_USESPC1:
			*iparam = ( useUNIT & tSPC1 ) ? TRUE : FALSE;
			return ME_NOERR;
		case MG_USESPC2:
			*iparam = ( useUNIT & tSPC2 ) ? TRUE : FALSE;
			return ME_NOERR;
		case MG_COUNT_FRAME:
			*iparam = totalframes;
			return ME_NOERR;
		case MG_NUM_OF_SAMPLES:
			*iparam = gl.frameSize;
			return ME_NOERR;
		case MG_MPEG_VERSION:
			*iparam = gl.version;
			return ME_NOERR;
#if	defined(USE_BTHREAD)
		case MG_READTHREAD_PRIORITY:
			*iparam = intReadThreadPriority;
			return ME_NOERR;
#endif
	}
	return ME_PARAMERROR;
}
#endif	/* !defined(MUSENC_PASS2) */

#if	!defined(MUSENC_PASS2)

#if   defined(USE_WINTHREAD) || defined(USE_PTHREAD)  || defined(USE_BTHREAD) || defined(USE_OS2THREAD)
static int maxthread = 0;
static int curthread = 0;
#endif

#if defined(USE_PTHREAD)
#define	NTHREADS	2	/* Ȥꤢ2Ǥ */

static pthread_mutex_t	mutex_mfbuf = PTHREAD_MUTEX_INITIALIZER;
static pthread_mutex_t	mutex_l3_sb_sample = PTHREAD_MUTEX_INITIALIZER;
static pthread_mutex_t	mutex_l3_side = PTHREAD_MUTEX_INITIALIZER;
static pthread_mutex_t mutex_fmt_bitstm = PTHREAD_MUTEX_INITIALIZER;
static pthread_t	ptid[NTHREADS];		/* POSIX thread ID */
static pthread_mutex_t	mutex_frames = PTHREAD_MUTEX_INITIALIZER;
static sem_t	sem_frames;

static void *encodeframethread(void *);
#endif

#if !defined(USE_WINTHREAD) && !defined(USE_OS2THREAD)
static int encodeframe(short frmBuffer[2][1152]);
#endif

#if defined(USE_BTHREAD)
static sem_id	mutex_mfbuf;
static sem_id	mutex_l3_sb_sample;
static sem_id	mutex_l3_side;
static sem_id	mutex_fmt_bitstm;
static thread_id	ptid[B_MAX_CPU_COUNT];	/* BeOSǥݡȤƤCPUƱ */
static sem_id	mutex_frames;
static port_id	port_frames;	/* åɴ̿ݡ */

static void *encodeframethread(void *);
static int	frameNum = 0;		/* 󥳡ɥåɤθߤνե졼 */

#endif

#ifdef USE_BTHREAD
MERET EXPORT
MPGE_processFrame(int * frameNum)
#else
MERET EXPORT
MPGE_processFrame()
#endif
{
	int		iread;
#if   defined(USE_WINTHREAD) || defined(USE_OS2THREAD)
	static int	i;
	short (*frmBuffer)[1152] = (short (*)[1152])( (int)(__frmBuffer+15) & -16 );
#else
#ifdef ALIGN16
	char __frmBuffer[ 2 * 1152 * sizeof(short) + 16]; /*  */
	short (*frmBuffer)[1152] = (short (*)[1152])( (int)(__frmBuffer+15) & -16 );
#else
	short frmBuffer[2][1152];
#endif
#endif

#ifdef	USE_LONGJMP
	{
		MERET	jmpval;
		jmpval = setjmp( _longjmp_ptr );
		if( jmpval )
			return (MERET)jmpval;
	}
#else
#ifndef DONT_USE_LONGJMP
#error "define *_LONGJMP "
#endif

#endif /* USE_LONGJMP */

	/* ǽΤ߼¹Ԥʬ */
#if	defined( USE_WINTHREAD )
	if( firstcall ){
//		nThreadClass = GetPriorityClass( GetCurrentProcess() );
		nThreadPrio = GetThreadPriority( GetCurrentThread() );
	}
#ifdef	USE_LONGJMP
	if( error_notify ){
		// 󥳡ɤƤåǥ顼ȯƤ
		return error_notify;
	}
#endif
	iread = get_audio( musicin, frmBuffer[0], frmBuffer[1] );
	if( iread ){
		if( ISMULTI() ){
#ifdef	_DEBUG
			tprintf("Set Event In\n");
#endif
			if( !ResetEvent( encodeframe_arg[i].hWaitEncoding ) ){
				return ME_INTERNALERROR;
			}
			// Եե饰򤪤
			SetEvent( encodeframe_arg[i].hEnterFrame );				// ե졼ե饰夲
			WaitForSingleObject( encodeframe_arg[i].hLeaveFrame, INFINITE );	// ȤޤԤ
			ResetEvent( encodeframe_arg[i].hLeaveFrame );			// CloseHandle( encodeframe_arg[i].hLeaveFrame );

#ifdef	_DEBUG
			tprintf("Leave Event\n");
#endif

			/* RR scheduling */
			if(++i >= NTHREADS) i = 0;
		} else {
			encodeframe( NULL );
		}
		return ME_NOERR;
	} else {
		MERET	rval = MPGE_closeCoder();
		if( rval != ME_NOERR )
			return rval;
		return ME_EMPTYSTREAM;
	}

#elif   defined( USE_OS2THREAD )
	if( firstcall ){
// 	nThreadClass = GetPriorityClass( GetCurrentProcess() );
// 	nThreadPrio = GetThreadPriority( GetCurrentThread() );
	}
#ifdef	USE_LONGJMP
	if( error_notify ){
		// 󥳡ɤƤåǥ顼ȯƤ
		return error_notify;
	}
#endif
	iread = get_audio( musicin, frmBuffer[0], frmBuffer[1] );
	if( iread ){
		if( ISMULTI() ){
			ULONG resetcount;
			APIRET ulrc;

#ifdef	_DEBUG
			tprintf("Set Event In\n");
#endif
			ulrc = DosResetEventSem( encodeframe_arg[i].hWaitEncoding, &resetcount );
			if( ulrc != 0 && ulrc != 300 ){
				return ME_INTERNALERROR;
			}
			// Եե饰򤪤
			DosPostEventSem( encodeframe_arg[i].hEnterFrame ); 			 // ե졼ե饰夲
			DosWaitEventSem( encodeframe_arg[i].hLeaveFrame, -1);  // ȤޤԤ
			DosResetEventSem( encodeframe_arg[i].hLeaveFrame, &resetcount );			 // CloseHandle( encodeframe_arg[i].hLeaveFrame );

#ifdef	_DEBUG
			tprintf("Leave Event\n");
#endif

			/* RR scheduling */
			if(++i >= NTHREADS) i = 0;
		} else {
			encodeframe( NULL );
		}
		return ME_NOERR;
	} else {
		MERET rval = MPGE_closeCoder();
		if( rval != ME_NOERR )
			return rval;
		return ME_EMPTYSTREAM;
	}

#elif defined(USE_PTHREAD)
	if( ISMULTI() ){
		/* ΤȤCPU2İʾ夢뤫ɤ򸫤Ƥ */
		if(curthread){
			sem_wait(&sem_frames);
			return ME_NOERR;
		} else if (maxthread){
			MERET	rval;

			/* all threads have terminated */
			pthread_mutex_lock(&mutex_frames);
			rval = MPGE_closeCoder();
			if( rval != ME_NOERR )
				return rval;
			return ME_EMPTYSTREAM;
		} else {
			pthread_attr_t	attr_child;
			int	i;
        
			/* create */
			pthread_mutex_lock(&mutex_frames);
			sem_init(&sem_frames, 0, 0);
			pthread_attr_init(&attr_child);
			pthread_attr_setdetachstate(&attr_child, PTHREAD_CREATE_DETACHED);
			if(pthread_attr_setscope(&attr_child, PTHREAD_SCOPE_SYSTEM)){
				return ME_CANNOT_SET_SCOPE;
			}
			for(i = 0; i < NTHREADS; i++){
				if(pthread_create(&ptid[i], &attr_child, encodeframethread, NULL)){
					return ME_CANNOT_CREATE_THREAD;
				}
			}
			pthread_mutex_unlock(&mutex_frames);
			nice(100);	/* ƥåɤˤCPUƤʤ */
			sem_wait(&sem_frames);
			return ME_NOERR;
		}
	}else{
		iread = get_audio( musicin, frmBuffer[0], frmBuffer[1] );
		if( iread ){
			encodeframe( frmBuffer );
			return ME_NOERR;
		} else {
			MERET	rval = MPGE_closeCoder();
			if( rval != ME_NOERR )
				return rval;
			return ME_EMPTYSTREAM;
		}
	}
#elif defined(USE_BTHREAD)
	if( ISMULTI() ){
		int i;
		if(curthread){
			/* 󥳡Υåɤ */
			read_port(port_frames,(int32 *)frameNum,(void *)&i,0);
			return ME_NOERR;
		} else if (maxthread){
			/* 󥳡ɤƽä */
			MERET	rval;

			/* all threads have terminated */
			acquire_sem(mutex_frames);
			delete_sem(mutex_mfbuf);
			delete_sem(mutex_l3_sb_sample);
			delete_sem(mutex_l3_side);
			delete_sem(mutex_frames);
			delete_port(port_frames);
			rval = MPGE_closeCoder();
			if( rval != ME_NOERR )
				return rval;
			return ME_EMPTYSTREAM;
		} else {
	
			/* ޤåɤưƤʤ */
			/* Ѥ륻ޥեκ */
			mutex_mfbuf = create_sem(1,"mfbuf");
			mutex_l3_sb_sample = create_sem(1,"l3_sb_sample");
			mutex_l3_side = create_sem(1,"l3_side");
			mutex_fmt_bitstm = create_sem(1,"fmt_bitstm");
			mutex_frames = create_sem(1,"frames");
			port_frames = create_port(1,"port_frames");
			/* create */
			acquire_sem(mutex_frames);
			/* Ф줿CPUοåɤ */
			for(i = 0; i < nCPU; i++){
			  /* bring thread-priority down 99/11/12 */
			  /* What is suitable value? set 100 if you want to run gogo faster, but it's dangerous. */
				if((ptid[i] = spawn_thread((thread_func)encodeframethread,"gogoEncodeThread",intEncodeThreadPriority,(void *)NULL)) < 0) {
					return ME_CANNOT_CREATE_THREAD;
				}
				resume_thread(ptid[i]);
			}
			release_sem(mutex_frames);
//			set_thread_priority(find_thread((void *)0),11);	/* ɽåɤͥ٤äȤ(default 10) */
			read_port(port_frames,(int32 *)frameNum,(void *)&i,0);	/* 󥳡ɥåɤ̿Ԥ */
			return ME_NOERR;
		}
	}else{
		iread = get_audio( musicin, frmBuffer[0], frmBuffer[1] );
		if( iread ){
			encodeframe( frmBuffer );
			return ME_NOERR;
		} else {
			MERET	rval = MPGE_closeCoder();
			if( rval != ME_NOERR )
				return rval;
			return ME_EMPTYSTREAM;
		}
	}
#else
	iread = get_audio( musicin, frmBuffer[0], frmBuffer[1] );
	if( iread ){
		encodeframe( frmBuffer );
		return ME_NOERR;
	} else {
		MERET	rval = MPGE_closeCoder();
		if( rval != ME_NOERR )
			return rval;
		return ME_EMPTYSTREAM;
	}
#endif
}
#endif	/* !defined(MUSENC_PASS2) */


#if	!defined(MUSENC_PASS2)
MERET EXPORT
MPGE_endCoder()
{
#if		defined( USE_WINTHREAD )
	if( boot_thread ){
		int	i;

		boot_thread = 0;
		/* åɤ٤ߤȤǧ */
		for(i = NTHREADS - 1; i >= 0 ; i--){
			tprintf("th %d : Enc.finthread = TRUE\n", i);
			encodeframe_arg[i].finthread = TRUE;
			SetEvent( encodeframe_arg[i].hEnterFrame );
			LeaveCriticalSection( &mutex_mfbuf );
			WaitForSingleObject( encodeframe_arg[i].hExistThread, INFINITE );	/* ॢ 1sec */
			tprintf("th %d : ClsoeHandle\n", i);
			CloseHandle( encodeframe_arg[i].hEnterFrame );
			CloseHandle( encodeframe_arg[i].hLeaveFrame );
			CloseHandle( encodeframe_arg[i].hExistThread );
			CloseHandle( encodeframe_arg[i].hWaitEncoding );
		}
		/* åɤθ */
		for(i = NTHREADS - 1;i >= 0; i--){
			DeleteCriticalSection( &encodeframe_arg[i].section );
			if( encodeframe_arg[i].hThread )
				CloseHandle( (HANDLE) encodeframe_arg[i].hThread );			// _beginthreadexѻ...
		}
		DeleteCriticalSection( &mutex_mfbuf );
		DeleteCriticalSection( &mutex_l3_sb_sample );
		DeleteCriticalSection( &mutex_l3_side );
		DeleteCriticalSection( &mutex_frmBuffer );
		DeleteCriticalSection( &mutex_fmt_bitstm );
	}
#endif

#if      defined( USE_OS2THREAD )
	if( boot_thread ){
		int	i;

		boot_thread = 0;
		/* åɤ٤ߤȤǧ */
		for(i = NTHREADS - 1; i >= 0 ; i--){
			tprintf("th %d : Enc.finthread = TRUE\n", i);
			encodeframe_arg[i].finthread = TRUE;
			DosPostEventSem( encodeframe_arg[i].hEnterFrame );
			DosReleaseMutexSem( mutex_mfbuf );
			DosWaitEventSem( encodeframe_arg[i].hExistThread, -1); /* ॢ 1sec */
			tprintf("th %d : CloseHandle\n", i);
			DosCloseEventSem( encodeframe_arg[i].hEnterFrame );
			DosCloseEventSem( encodeframe_arg[i].hLeaveFrame );
			DosCloseEventSem( encodeframe_arg[i].hExistThread );
			DosCloseEventSem( encodeframe_arg[i].hWaitEncoding );
		}
		/* åɤθ */
		for(i = NTHREADS - 1;i >= 0; i--){
			DosCloseMutexSem( encodeframe_arg[i].section );
			if( encodeframe_arg[i].hThread )
				DosKillThread( encodeframe_arg[i].hThread ); 		  // _beginthreadexѻ...
		}
		DosCloseMutexSem( mutex_mfbuf );
		DosCloseMutexSem( mutex_l3_sb_sample );
		DosCloseMutexSem( mutex_l3_side );
		DosCloseMutexSem( mutex_frmBuffer );
		DosCloseMutexSem( mutex_fmt_bitstm );
	}
#endif /* USE_OS2THREAD */

	if( pid3tag ){
		mem_free( (void **)&pid3tag );
	}
	nid3taglen = 0;
	pid3tag = NULL;

	if( pRiffInfos ){
		mem_free( (void **)&pRiffInfos );
	}
	riffInfosLen = 0;
	pRiffInfos = NULL;

	return ME_NOERR;
}
#endif	/* !defined(MUSENC_PASS2) */


#if	defined(USE_PTHREAD)
static
void *
encodeframethread(void *arg)
#elif	defined(USE_WINTHREAD)
static
unsigned __stdcall
encodeframe(void *arg)
#elif defined(USE_OS2THREAD)
static
void _System
encodeframe(void *arg)
#elif	defined(USE_BTHREAD)
static
void *
encodeframethread(void *arg)
#else
static
int
encodeframe(short frmBuffer[2][1152])
#endif
{

#ifdef ALIGN16
#if 0
	/* 16byte align (¤ϤääΤ) 99/08/14 */
	/* align.nasǳ */
	extern float Axr[2][2][576];
	extern int Al3_enc[2][2][576];
#else
	char __l3_enc[ 2 * 2 * 576 * sizeof(int) + 16 ];	/*  */
	char __xr[ 2 * 2 * 576 * sizeof(float) + 16 ];

	int (*Al3_enc)[2][576] = (int (*)[2][576])( (int)(__l3_enc+15) & -16 );
	float (*Axr)[2][576] = (float (*)[2][576])( (int)(__xr+15) & -16 );
//	static char __mfbuf[ 2 * (1152+576+EXTRADELAY) * sizeof(int) + 16 ];
//	int (*Amfbuf)[1152+576+EXTRADELAY]
//		= (int (*)[1152+576+EXTRADELAY])( (int)(__mfbuf+15) & -16 );
#endif
	extern int Amfbuf[2][1152+576+EXTRADELAY];	/* static (align.nasǳ) */

/* xr, l3_encϥХѿȺƱʤƬ`A'Ĥ */
#define xr Axr
#define l3_enc Al3_enc
#define mfbuf Amfbuf

#else	/* ALIGN16 */

	int l3_enc[2][2][576];
	float xr[2][2][576];
	static int mfbuf[2][1152+576+EXTRADELAY];	/*  */
//	float win_que[2][HAN_SIZE];
//	int *win_buf[2];
#endif	/* ALIGN16 */

	III_psy_ratio ratio;
	III_scalefac_t scalefac;

	int ch,gr,mean_bits;
	int bitsPerFrame;
	float pe[2][2];
	int i;

	float ms_ener_ratio[2] = {0, 0};
	int blocktype[2][2];
	III_side_info_t		L_l3_side;
#if	defined(USE_PTHREAD) || defined(USE_BTHREAD)
	char __frmBuffer[ 2 * 1152 * sizeof(short) + 16]; /*  */
	short (*frmBuffer)[1152] = (short (*)[1152])( (int)(__frmBuffer+15) & -16 );
	int	mfbuf_private[2][1152+576+EXTRADELAY];
	int	tid, iread;
#elif defined(USE_WINTHREAD) || defined(USE_OS2THREAD)
	encodeframe_arg_t	*private_data = (encodeframe_arg_t *)arg;
	short	(*frmBuffer)[1152];
	int		mfbuf_private[2][1152+576+EXTRADELAY];
#endif


	/* פ static ѿ */

	static int check_ms_stereo;
	static unsigned long sentBits;	/* for only VBR */
	static int old_bitrate;			/* for only VBR */
	static float frac_SpF;
	static float slot_lag;
	extern L3SBS l3_sb_sample[1]; /* align16 for SSE */


#if	defined(USE_PTHREAD)
	pthread_mutex_lock(&mutex_frames);
	tid = curthread++;
	maxthread = curthread;
#elif	defined(USE_WINTHREAD)
	if( private_data ){		// ThreadBoot?
		private_data->hExistThread = CreateEvent( NULL, FALSE, FALSE, NULL ); 
		SetEvent( private_data->hWaitEncoding );							// Ե֤
		WaitForSingleObject( private_data->hEnterFrame, INFINITE );

//		SetPriorityClass( GetCurrentProcess(), nThreadClass );
		SetThreadPriority( GetCurrentThread(), nThreadPrio );
		
		ResetEvent( private_data->hWaitEncoding );							// Ե֤ȴ
		ResetEvent( private_data->hEnterFrame );
		if( private_data->finthread ){
			SetEvent( private_data->hExistThread );
			tprintf("%d : Stop Thread \n", private_data->tid );
			return 0;
		}
		tprintf("Starting thread(tid = %d)\n", private_data->tid);
		frmBuffer = private_data->buf;
	} else {
		frmBuffer = (short (*)[1152])( (int)(__frmBuffer+15) & -16 );
	}
#elif defined(USE_OS2THREAD)
	if( private_data ){		// ThreadBoot?
		ULONG resetcount;

		DosCreateEventSem(NULL,&private_data->hExistThread,0,FALSE);
		DosPostEventSem( private_data->hWaitEncoding ); 			 // Ե֤
		DosWaitEventSem( private_data->hEnterFrame, -1);

// 	SetPriorityClass( GetCurrentProcess(), nThreadClass );
// 	SetThreadPriority( GetCurrentThread(), nThreadPrio );

		DosResetEventSem( private_data->hWaitEncoding, &resetcount );							 // Ե֤ȴ
		DosResetEventSem( private_data->hEnterFrame, &resetcount  );
		if( private_data->finthread ){
			DosPostEventSem( private_data->hExistThread );
			tprintf("%d : Stop Thread \n", private_data->tid );
			return 0;
		}
		tprintf("Starting thread(tid = %d)\n", private_data->tid);
		frmBuffer = private_data->buf;
	} else {
		frmBuffer = (short (*)[1152])( (int)(__frmBuffer+15) & -16 );
	}
#elif	defined(USE_BTHREAD)
	acquire_sem(mutex_frames);
	tid = curthread++;
	maxthread = curthread;
#endif


#if	defined(USE_WINTHREAD)
loop:
#ifdef	USE_LONGJMP
	if( error_notify )
		return -1;
#endif
	if( ISMULTI() ){
		EnterCriticalSection(&mutex_mfbuf);
		if( private_data->finthread ){
			SetEvent( private_data->hExistThread );
			tprintf("%d : Stop Thread \n", private_data->tid );
			return 0;
		}
		curthread ++;
		if( curthread > maxthread){
			maxthread = curthread;
		}
		tprintf("%d : Enter Thread (%d / %d)\n", private_data->tid, curthread, maxthread );
	}

#elif   defined(USE_OS2THREAD)
loop:
#ifdef	USE_LONGJMP
	if( error_notify )
		return -1;
#endif
	if( ISMULTI() ){
		DosRequestMutexSem(mutex_mfbuf, -1);
		if( private_data->finthread ){
			DosPostEventSem( private_data->hExistThread );
			tprintf("%d : Stop Thread \n", private_data->tid );
			return 0;
		}
		curthread ++;
		if( curthread > maxthread){
			maxthread = curthread;
		}
		tprintf("%d : Enter Thread (%d / %d)\n", private_data->tid, curthread, maxthread );
	}

#endif
	
	if( firstcall ){
		float avg_slots_per_frame;
		int whole_SpF;

		firstcall = 0;

		sentBits = 0;
		memset((char *) mfbuf, 0, 2 * (1152+576+EXTRADELAY) * sizeof(int) );

		/* Figure average number of 'slots' per frame. */
		/* Bitrate means TOTAL for both channels, not per side. */

		avg_slots_per_frame
			 = gl.frameSize * gl.rate_kbps / (gl.enc_freqHz * 0.001 * bitsPerSlot );
#ifdef USE_WINTHREAD /* Why is it different? */
		whole_SpF = (int) (avg_slots_per_frame  + 1e-5);
#else
		whole_SpF = (int) avg_slots_per_frame;
#endif
		frac_SpF  = avg_slots_per_frame - (float)whole_SpF;
		slot_lag  = -frac_SpF;
		l3_side.padding = 1;
		if (fabs(frac_SpF) < 1e-9) l3_side.padding = 0;

		check_ms_stereo =( gl.mode == MPG_MD_JOINT_STEREO &&
					!force_ms && gl.version == 1 && gl.stereo == 2 );

		old_bitrate = l3_side.rate_idx;

		memset( &l3_sb_sample, 0, sizeof( l3_sb_sample ) );
	}

#if	defined(USE_PTHREAD)
loop:
	iread = get_audio( musicin, frmBuffer[0], frmBuffer[1] );
	if( !iread ){
		curthread--;
		sem_post(&sem_frames);
		pthread_mutex_unlock(&mutex_frames);
		return NULL;
	}
	sem_post(&sem_frames);	/* λȤʤʤ */
	pthread_mutex_lock(&mutex_mfbuf);
	pthread_mutex_unlock(&mutex_frames);
#elif	defined(USE_BTHREAD)
loop:
	if(intReadThreadPriority) {
		iread = get_audio_thread( musicin, frmBuffer[0], frmBuffer[1] );
	} else {
		iread = get_audio( musicin, frmBuffer[0], frmBuffer[1] );
	}
	if( !iread ){
		curthread--;
		write_port_etc(port_frames,frameNum,0,0,B_TIMEOUT,0);
		release_sem(mutex_frames);
		return NULL;
	}
	write_port_etc(port_frames,frameNum++,0,0,B_TIMEOUT,0);
	acquire_sem(mutex_mfbuf);
	release_sem(mutex_frames);
#endif
	//	l3_side.mode_ext = 0;	// defer updating

	/* 576+EXTRADELAY ٤餻ƿɸܤ shift in */
	/* EXTRADELAY is used in l3psya.nas */

	frame_shiftin( (int *)mfbuf, (short *)frmBuffer, gl.frameSize, gl.stereo);
#if 0
	for( ch = 0; ch < gl.stereo; ch++ ){
		for( i = 0; i < 576 + EXTRADELAY; i++ ){
			mfbuf[ch][i] = mfbuf[ch][i+gl.frameSize];
		}
	}
	for(ch = 0; ch < gl.stereo; ch++ ){
		for( i = 0; i < gl.frameSize; i++ ){
			mfbuf[ch][i+576+EXTRADELAY] = frmBuffer[ch][i];
		}
	}
#endif

#if	defined(USE_WINTHREAD)
	if( ISMULTI() ){
		SetEvent( private_data->hLeaveFrame ) ;
	}
#endif

#if   defined(USE_OS2THREAD)
	if( ISMULTI() ){
		DosPostEventSem( private_data->hLeaveFrame ) ;
	}
#endif

#if	defined(USE_PTHREAD) || defined(USE_WINTHREAD) || defined(USE_BTHREAD) || defined(USE_OS2THREAD)
	L_l3_side.padding = -1; /* Բ */
#endif
	if( !VBR ){
		if( frac_SpF ){
			float temp = frac_SpF - 1;
			if( slot_lag > temp ){
				slot_lag -= frac_SpF;
#if   defined(USE_PTHREAD) || defined(USE_WINTHREAD) || defined(USE_BTHREAD) || defined(USE_OS2THREAD)
                L_l3_side.padding = 0;    // defered update
#else
                l3_side.padding = 0;
#endif
			}else{
				slot_lag -= temp;
#if   defined(USE_PTHREAD) || defined(USE_WINTHREAD) || defined(USE_BTHREAD) || defined(USE_OS2THREAD)
                L_l3_side.padding = 1;    // defered update
#else
                l3_side.padding = 1;
#endif
			}
		}
	}

	if( force_ms ){
		for( i = 0; i < gl.frameSize; i++ ){
			int mid = ( mfbuf[0][576+i] + mfbuf[1][576+i] ) / 2; /* shiftǤ⹽ʤ */
			int side= ( mfbuf[0][576+i] - mfbuf[1][576+i] ) / 2;
			mfbuf[0][576+i] = mid;
			mfbuf[1][576+i] = side;
		}
	}

/***************************** Layer 3 **********************************
 * mfbuf contains 3 granules:  [0 1 2 ]
 * encoder will encode granules 0 1
 * psy-model will be fed granules 1 2, and because of its 1 granule delay
 * it will return thresholds for granules 0 1 */

	if( !fast_mode ){
		/* psychoacoustic model
		* psy model adds a 544 delay to sync with the filterbanks
		* in addition to this delay, it also adds a 1 granule (576) delay
		* that we must compensate for (mt 6/99).
		*/
		int *bufp[2];  /* address of beginning of left & right granule */

		for( gr = 0; gr < gl.mode_gr; gr++ ){

			bufp[0] = &mfbuf[0][576 + gr*576];
			if( gl.stereo == 2 ){
				bufp[1] = &mfbuf[1][576 + gr*576];
			}
			L3psycho_anal( bufp, check_ms_stereo,
			&ms_ener_ratio[gr], ratio.l[gr], ratio.s[gr], pe[gr], blocktype[gr]);

			L_l3_side.gr[gr].ch[0].tt.block_type=blocktype[gr][0];
			if( gl.stereo == 2 ){
				L_l3_side.gr[gr].ch[1].tt.block_type=blocktype[gr][1];
			}
		}
	}else{
		for( gr = 0; gr < gl.mode_gr; gr++ ){
			blocktype[gr][0] = NORM_TYPE;
			L_l3_side.gr[gr].ch[0].tt.block_type = blocktype[gr][0];
			pe[gr][0] = 700;
			if( gl.stereo == 2 ){
				blocktype[gr][1] = NORM_TYPE;
				L_l3_side.gr[gr].ch[1].tt.block_type = blocktype[gr][1];
				pe[gr][1] = 700;
			}
		}
	}
#if	defined(USE_PTHREAD)
	pthread_mutex_lock(&mutex_l3_sb_sample);
	memcpy( mfbuf_private, mfbuf, sizeof mfbuf_private );
	pthread_mutex_unlock(&mutex_mfbuf);
	#undef	mfbuf
	#define	mfbuf	mfbuf_private
#elif	defined(USE_WINTHREAD)
	if( ISMULTI() ){
		EnterCriticalSection(&mutex_l3_sb_sample);
		memcpy( mfbuf_private, mfbuf, sizeof mfbuf_private );
		LeaveCriticalSection( &mutex_mfbuf );
	} else {
		memcpy( mfbuf_private, mfbuf, sizeof mfbuf_private );
	}
	#undef	mfbuf
	#define	mfbuf	mfbuf_private
#elif defined(USE_OS2THREAD)
	if( ISMULTI() ){
		DosRequestMutexSem(mutex_l3_sb_sample, -1);
		memcpy( mfbuf_private, mfbuf, sizeof mfbuf_private );
		DosReleaseMutexSem( mutex_mfbuf );
	} else {
		memcpy( mfbuf_private, mfbuf, sizeof mfbuf_private );
	}
	#undef	mfbuf
	#define	mfbuf mfbuf_private
#elif	defined(USE_BTHREAD)
	acquire_sem(mutex_l3_sb_sample);
	memcpy( mfbuf_private, mfbuf, sizeof mfbuf_private );
	release_sem(mutex_mfbuf);
	#undef	mfbuf
	#define	mfbuf	mfbuf_private
#endif

#ifdef MIE
	window_filter_subband( mfbuf[0], 0, (*l3_sb_sample)[0][1][0], gl.mode_gr );
	if( gl.stereo == 2 ){
		window_filter_subband( mfbuf[1], 1, (*l3_sb_sample)[1][1][0], gl.mode_gr);
	}

#else
	win_buf[0] = &mfbuf[0][0];
	win_buf[1] = &mfbuf[1][0];
	/* polyphase filtering  */
	for( gr = 0; gr < gl.mode_gr; gr++ ){
		for ( ch = 0; ch < gl.stereo; ch++ ){
			for ( j = 0; j < 18; j++ ){
				window_subband( &win_buf[ch], &win_que[ch][0], ch );
				filter_subband( &win_que[ch][0],  &(l3_sb_sample)[ch][gr+1][j][0] );
			}
		}
	}
#endif


	/* MDCT¿ŰϤŬ */
	mdct_sub( l3_sb_sample, xr, gl.stereo, &L_l3_side, gl.mode_gr );

#if	defined(USE_PTHREAD)
	pthread_mutex_lock(&mutex_l3_side);
	pthread_mutex_unlock(&mutex_l3_sb_sample);
#elif	defined(USE_WINTHREAD)
	if( ISMULTI() ){
		EnterCriticalSection(&mutex_l3_side);
		LeaveCriticalSection(&mutex_l3_sb_sample);
	}
#elif defined(USE_OS2THREAD)
	if( ISMULTI() ){
		DosRequestMutexSem(mutex_l3_side, -1);
		DosReleaseMutexSem(mutex_l3_sb_sample);
	}
#elif	defined(USE_BTHREAD)
	acquire_sem(mutex_l3_side);
	release_sem(mutex_l3_sb_sample);
#endif
#ifdef USE_VBR
	if( VBR ){
		float pe_sum_old;
		pe_sum_old = VBR_pe_sum;
		VBR_pe_sum = 0;
		for( gr = 0; gr < gl.mode_gr; gr++ ){
			VBR_pe_sum += pe[gr][0];
			if( gl.stereo == 2 ) VBR_pe_sum += pe[gr][1];
		}  
	  /* for VBR, what bitrate should we try first? */
		l3_side.rate_idx = old_bitrate - 1;
		if( abs( pe_sum_old - VBR_pe_sum ) > 200 ){
			if( pe_sum_old > VBR_pe_sum ) l3_side.rate_idx--;
		}

		if( l3_side.rate_idx < VBR_min_rate_idx ){
			l3_side.rate_idx = VBR_min_rate_idx;
		}else if( l3_side.rate_idx > VBR_max_rate_idx ){
			l3_side.rate_idx = VBR_max_rate_idx;
		}
	}
#endif /* USE_VBR */

	/* block type flags */
	for( gr = 0; gr < gl.mode_gr; gr++ ){
		for ( ch = 0; ch < gl.stereo; ch++ ){
			gr_info *cod_info = &l3_side.gr[gr].ch[ch].tt;

			cod_info->mixed_block_flag = 0;     /* never used by this model */
			cod_info->block_type = blocktype[gr][ch];
			if (cod_info->block_type == NORM_TYPE )
				cod_info->window_switching_flag = 0;
			else
				cod_info->window_switching_flag = 1;
		}
	}

	/* data was scaled by 1/2.  fix so effectively it was scaled by 1/sqrt(2) */
	if( force_ms ){
		for( gr = 0; gr < gl.mode_gr; gr++ ){
			for( ch = 0; ch < gl.stereo; ch++ ){
				for(i =0 ; i< 576; i++ ){
					xr[gr][ch][i] *= (float)SQRT2;//sqrt(2.0);
				}
			}
		}
	}

	/* ƥͥ block tye ƱΤ */

#if   defined(USE_PTHREAD) || defined(USE_WINTHREAD) || defined(USE_BTHREAD) || defined(USE_OS2THREAD)
    if(L_l3_side.padding >= 0) l3_side.padding = L_l3_side.padding;    // update at here
#endif
#if 1 /* #ifndef LAME355 顼ϽФʤɤǤȤϻפʤ... ɤäѤǤ? by PEN */
	l3_side.mode_ext = 0;
	if( force_ms || fast_mode ){
	  ms_ener_ratio[0] = 0.25;
	  ms_ener_ratio[1] = 0.25;
	}
#endif

	if( check_ms_stereo
	&&	l3_side.gr[0].ch[0].tt.block_type == l3_side.gr[0].ch[1].tt.block_type
	&&	l3_side.gr[1].ch[0].tt.block_type == l3_side.gr[1].ch[1].tt.block_type
	&&	ms_ener_ratio[0] + ms_ener_ratio[1] < 0.70 ){
		l3_side.mode_ext = MPG_MD_MS_LR;
		ms_ener_ratio[0] = Min( ms_ener_ratio[0], 0.5 );
		ms_ener_ratio[1] = Min( ms_ener_ratio[1], 0.5 );
	}

#ifdef USE_VBR
	if( VBR ){
	  VBR_iteration_loop( pe, ms_ener_ratio, xr, &ratio, &l3_side, l3_enc, &scalefac );
	}else
#endif /* USE_VBR */
	  {
	    iteration_loop( pe, ms_ener_ratio, xr, &ratio, &l3_side, l3_enc, &scalefac );
	  }
	/* flag for our ms_stereo with psy-model on mid & side channels */


	if( force_ms ) l3_side.mode_ext = MPG_MD_MS_LR;

	/* bitstream  frame 񤭤 */
	getframebits(&bitsPerFrame,&mean_bits,l3_side.rate_idx,l3_side.padding);

#if    defined(USE_PTHREAD)
	pthread_mutex_lock(&mutex_fmt_bitstm);
	L_l3_side = l3_side;
	pthread_mutex_unlock(&mutex_l3_side);

	III_format_bitstream( bitsPerFrame, l3_enc, &L_l3_side, &scalefac );

	/* III_format_bitstream() ǻȤ칹褦 */
	/* 顢֤mutex_l3_side γǹƤ */
	l3_side.main_data_begin = L_l3_side.main_data_begin;
	/* ʤl3_side ΤʳΥФϤǤϻȤΤ */
#elif	defined(USE_WINTHREAD)
	if( ISMULTI() )
		EnterCriticalSection(&mutex_fmt_bitstm);
	L_l3_side = l3_side;
	if( ISMULTI() )
		LeaveCriticalSection( &mutex_l3_side);

	III_format_bitstream( bitsPerFrame, l3_enc, &L_l3_side, &scalefac );

	l3_side.main_data_begin = L_l3_side.main_data_begin;
#elif defined(USE_OS2THREAD)
	if( ISMULTI() )
		DosRequestMutexSem(mutex_fmt_bitstm, -1);
	L_l3_side = l3_side;
	if( ISMULTI() )
		DosReleaseMutexSem( mutex_l3_side);

	III_format_bitstream( bitsPerFrame, l3_enc, &L_l3_side, &scalefac );

	l3_side.main_data_begin = L_l3_side.main_data_begin;
#elif	defined(USE_BTHREAD)
	acquire_sem(mutex_fmt_bitstm);
	L_l3_side = l3_side;
	release_sem(mutex_l3_side);

	III_format_bitstream( bitsPerFrame, l3_enc, &L_l3_side, &scalefac );

	l3_side.main_data_begin = L_l3_side.main_data_begin;
#else
	III_format_bitstream( bitsPerFrame, l3_enc, &l3_side, &scalefac );
#endif
	if( g_bWriteVbrTag ){
		unsigned long frameBits;
		frameBits = sstell( ) - sentBits;
		sentBits += frameBits;
		AddVbrFrame( sentBits / 8 );
	}
#if	defined(USE_PTHREAD)
	pthread_mutex_unlock(&mutex_fmt_bitstm);    /* λ*/
	pthread_mutex_lock(&mutex_frames);			/*  */
	goto loop;
#elif	defined(USE_WINTHREAD)
	if( ISMULTI() ){
		tprintf("%d : Leave Thread \n", private_data->tid );
		LeaveCriticalSection(&mutex_fmt_bitstm);    /* λ*/
		curthread --;

		SetEvent( private_data->hWaitEncoding );							// Ե֤
		WaitForSingleObject( private_data->hEnterFrame, INFINITE );
		ResetEvent( private_data->hWaitEncoding );							// Ե֤ȴ
		ResetEvent( private_data->hEnterFrame );
		if( !private_data->finthread )
			goto loop;
		tprintf("%d : Stop Thread \n", private_data->tid );
		SetEvent( private_data->hExistThread );
	}
	return 0;
#elif defined(USE_OS2THREAD)
	if( ISMULTI() ){
		ULONG resetcount;

		tprintf("%d : Leave Thread \n", private_data->tid );
		DosReleaseMutexSem(mutex_fmt_bitstm);	  /* λ*/
		curthread --;

		DosPostEventSem( private_data->hWaitEncoding ); 						 // Ե֤
		DosWaitEventSem( private_data->hEnterFrame, -1 );
		DosResetEventSem( private_data->hWaitEncoding, &resetcount );							 // Ե֤ȴ
		DosResetEventSem( private_data->hEnterFrame, &resetcount );
		if( !private_data->finthread )
			goto loop;
		tprintf("%d : Stop Thread \n", private_data->tid );
		DosPostEventSem( private_data->hExistThread );
	}
	return 0;
#elif	defined(USE_BTHREAD)
    release_sem(mutex_fmt_bitstm);  /* λ*/
	acquire_sem(mutex_frames);	/*  */
	goto loop;
#else
	return 1152;
#endif

#undef xr
#undef l3_enc
#undef mfbuf
}

#if	!defined(MUSENC_PASS2)
MERET	EXPORT	MPGE_closeCoder()
{
	/* clean up if we were producing an mp3 file */
	if( musicin ){
#if		0//defined(USE_WINTHREAD)
		if( ISMULTI() ){
			int	i;

			/* åɤ٤ߤȤǧ */
			for(i = NTHREADS - 1; i >= 0 ; i--){
				tprintf("MECC%d : Enc.finthread = TRUE\n", i);
				encodeframe_arg[i].finthread = TRUE;
				SetEvent( encodeframe_arg[i].hEnterFrame );
				LeaveCriticalSection( &mutex_mfbuf );
				WaitForSingleObject( encodeframe_arg[i].hExistThread, INFINITE );	/* ॢ 1sec */
				tprintf("MECC%d : ClsoeHandle\n", i);
				CloseHandle( encodeframe_arg[i].hEnterFrame );
				CloseHandle( encodeframe_arg[i].hLeaveFrame );
				CloseHandle( encodeframe_arg[i].hExistThread );
			}
			/* åɤθ */
			for(i = NTHREADS - 1;i >= 0; i--){
				DeleteCriticalSection( &encodeframe_arg[i].section );
				if( encodeframe_arg[i].hThread )
					CloseHandle( (HANDLE) encodeframe_arg[i].hThread );			// _beginthreadexѻ...
			}
			DeleteCriticalSection( &mutex_mfbuf );
			DeleteCriticalSection( &mutex_l3_sb_sample );
			DeleteCriticalSection( &mutex_l3_side );
			DeleteCriticalSection( &mutex_frmBuffer );
			DeleteCriticalSection( &mutex_fmt_bitstm );
		}
#endif

#if		defined( USE_WINTHREAD )
		if( ISMULTI() ){
			int	i;

			/* åɤ٤ߤȤǧ */
			for(i = NTHREADS - 1; i >= 0 ; i--){
				WaitForSingleObject( encodeframe_arg[i].hWaitEncoding, INFINITE );				// ե졼˥ǡΤԤ
			}
			/* åɤθ */
		}
#elif      defined( USE_OS2THREAD )
		if( ISMULTI() ){
			int	i;

			/* åɤ٤ߤȤǧ */
			for(i = NTHREADS - 1; i >= 0 ; i--){
				DosWaitEventSem( encodeframe_arg[i].hWaitEncoding, -1 ); 			  // ե졼˥ǡΤԤ
			}
			/* åɤθ */
		}
#endif
		III_FlushBitstream();
		close_bit_stream_w();
		if( ISUSERFUNCIN() )
			mc_userfunc.pUserFunc( NULL, 0 );
		else
			if( !bInputStdio )
				fclose(musicin);
		musicin = NULL;
		/* ϤեλΤ߽ */
		if( mc_userStore == MPGE_NULL_FUNC && !bOutputStdio ){
			switch( outputFormat ) {
				case MC_OUTPUT_NORMAL:
					if( g_bWriteVbrTag ){
						int nQuality=VBR_q*100/9;
						PutVbrTag(szOutFile,nQuality); /* ǽϥեopen() */
					}
					break;
				case MC_OUTPUT_RIFF_WAVE: {
						struct CK_WAVE header;
						FILE*	stream;
						int		fileSize;
						int		dataSize;
						
						stream=fopen(szOutFile,"rb+");
						if (stream==NULL) return ME_OUTFILE_NOFOUND;
						fseek(stream, 0, SEEK_END);
						fileSize = ftell(stream);
						dataSize = fileSize-outputOffset;
						if( fileSize % 2 ) {
							fputc(0, stream);
							fileSize++;
						}
						fseek(stream, 0, SEEK_SET);

						memmove( &(header.riff.chunk), "RIFF", 4);
						header.riff.size = fileSize-8;
						if( riffInfosLen ) {
							header.riff.size += riffInfosLen+12;
						}
						memmove( &(header.riff.form), "WAVE", 4);
						
						memmove( &(header.fmt.chunk), "fmt ", 4);
						header.fmt.size = sizeof(header.fmt)-8;
						header.fmt.formatID = 0x55;
						header.fmt.num_of_channel = (gl.mode == MPG_MD_MONO) ? 1 : 2;
						header.fmt.srate = gl.enc_freqHz;
						header.fmt.avg_bytes_par_sec = VBR ? 1.0*(fileSize-outputOffset)*gl.enc_freqHz/(1.0*totalframes*gl.frameSize) : gl.rate_kbps*1000/8;
						header.fmt.block_size = 1;
						header.fmt.bits_par_sample = 0;
						header.fmt.cbSize = 12;
					 	header.fmt.wID = 1;
					 	header.fmt.fdwFlags = 2;
					 	header.fmt.nBlockSize = VBR ? 144.0*320000/gl.enc_freqHz : 144.0*gl.rate_kbps*1000/gl.enc_freqHz;
					 	header.fmt.nFramesPerBlock = 1;
					 	header.fmt.nCodecDelay = 0x0571;
					 	
					 	memmove( &(header.fact.chunk), "fact", 4);
					 	header.fact.size = 4;
					 	header.fact.num_of_sample = totalframes*gl.frameSize;
					 	
					 	memmove( &(header.data.chunk), "data", 4);
					 	header.data.size = dataSize;
						
						fwrite(&header, sizeof(header), 1, stream);

						if( g_bWriteVbrTag ){
							int nVBRTagSize;
							BYTE pbtBuffer[216];
							int nQuality=VBR_q*100/9;
							nVBRTagSize = PutVbrTagStream( (char *)pbtBuffer, nQuality, dataSize, gl.freq_idx);
							fwrite(pbtBuffer, nVBRTagSize, 1, stream);
						}
						
						if( riffInfosLen ) {
							struct CK_LIST list;
							fseek(stream, 0, SEEK_END);
							memmove(&(list.chunk), "LIST", 4);
							list.size = riffInfosLen+4;
							memmove( &(list.form), "INFO", 4);
							fwrite(&list, sizeof(list), 1, stream);
							fwrite(pRiffInfos, riffInfosLen, 1, stream);
						}
						
						fclose(stream);
					}
					break;
				case MC_OUTPUT_RIFF_RMP: {
						struct CK_RMP header;
						FILE*	stream;
						int		fileSize;
						int		dataSize;
						
						stream=fopen(szOutFile,"rb+");
						if (stream==NULL) return ME_OUTFILE_NOFOUND;
						fseek(stream, 0, SEEK_END);
						fileSize = ftell(stream);
						dataSize = fileSize-outputOffset;
						if( fileSize % 2 ) {
							fputc(0, stream);
							fileSize++;
						}
						fseek(stream, 0, SEEK_SET);

						memmove( &(header.riff.chunk), "RIFF", 4);
						header.riff.size = fileSize-8;
						if( riffInfosLen ) {
							header.riff.size += riffInfosLen+12;
						}
						memmove( &(header.riff.form), "RMP3", 4);
						
					 	
					 	memmove( &(header.data.chunk), "data", 4);
					 	header.data.size = dataSize;
						
						fwrite(&header, sizeof(header), 1, stream);

						if( g_bWriteVbrTag ){
							int nVBRTagSize;
							BYTE pbtBuffer[216];
							int nQuality=VBR_q*100/9;
							nVBRTagSize = PutVbrTagStream( (char *)pbtBuffer, nQuality, dataSize, gl.freq_idx);
							fwrite(pbtBuffer, nVBRTagSize, 1, stream);
						}
						
						if( riffInfosLen ) {
							struct CK_LIST list;
							fseek(stream, 0, SEEK_END);
							memmove(&(list.chunk), "LIST", 4);
							list.size = riffInfosLen+4;
							memmove( &(list.form), "INFO", 4);
							fwrite(&list, sizeof(list), 1, stream);
							fwrite(pRiffInfos, riffInfosLen, 1, stream);
						}
						
						fclose(stream);
					}
					break;
			}
		}
		else	/* by kazumi-t@ss.iij4u.or.jp */
		if( mc_userStore != MPGE_NULL_FUNC && bOutputVBR_userfunc ){
			/* ȥ꡼ϤλVBRTag񤭤ߤ kazumi-t@ss.iij4u.or.jp
			 * mc_userStore( NULL, 0 ); θƽл˥Хå¦
			 * եݥ󥿤Ƭإ(ͤϥե륵)
			 */
				if( g_bWriteVbrTag ){
				int nVBRTagSize;
				long lFileSize;
				BYTE pbtBuffer[216];
				int nQuality=VBR_q*100/9;
				/* եݥ󥿤Ƭ˥ */
				if( 0 < (lFileSize = mc_userStore( NULL, 0)) ){
					nVBRTagSize = PutVbrTagStream( (char *)pbtBuffer, nQuality, lFileSize, gl.freq_idx);
					mc_userStore( pbtBuffer, nVBRTagSize );		// write TAG
					mc_userStore( NULL, 0 );					// to close
				}
			}
		}
	}
	return ME_NOERR;
}
#endif	/* !defined(MUSENC_PASS2) */


#if	!defined(MUSENC_PASS2)

void term( MERET  err)
{
#ifdef	USE_LONGJMP
#if		defined( USE_WINTHREAD  ) || defined ( USE_OS2THREAD )
	if( error_notify != ME_NOERR )
		return;
	error_notify = err;
#endif
	if( ISMULTI() ){
		// Υåɤߤ
		return;
	} else {
		longjmp( _longjmp_ptr, err);
	}
#else
#ifdef DONT_USE_LONGJMP
	const char	*msg = NULL;
	if( err < ME_INTERNALERROR )
		return;								// ߥ顼ǤϤʤ
	switch ( err ){
		case ME_PARAMERROR:
#ifndef NO_KANJI
			msg = "顼 / ѥ᡼ְäƤޤ" ;
#else
			msg = "Internal ERR : parameter ERR" ;
#endif
			break;
		case ME_NOFPU:
#ifndef NO_KANJI
			msg = "顼 / x87 FPUĤޤǤ" ;
#else
			msg = "Internal ERR : x87 FPU is not found" ;
#endif
			break;
		case ME_INFILE_NOFOUND:
#ifndef NO_KANJI
			msg = "ϥեΥץ˼Ԥޤ" ;
#else
			msg = "Can't open input file" ;
#endif
			break;
		case ME_OUTFILE_NOFOUND:
#ifndef NO_KANJI
			msg = "ϥեΥץ˼Ԥޤ" ;
#else
			msg = "Can't open output file" ;
#endif
			break;
		case ME_BITRATEERROR:
#ifndef NO_KANJI
			msg = "ӥåȥ졼Ȥְ꤬äƤޤ" ;
#else
			msg = "bitrate err" ;
#endif
			break;
		case ME_WAVETYPE_ERR:
#ifndef NO_KANJI
			msg = "WAVEեμ̤˼Ԥޤ" ;
#else
			msg = "Can't analize WAVE format" ;
#endif
			break;
		case ME_WRITEERROR:
#ifndef NO_KANJI
			msg = "ǥν񤭽Ф˼Ԥޤ" ;
#else
			msg = "MP3-file write failed" ;
#endif
			break;		default:
#ifndef NO_KANJI
			msg = "顼ȯޤ" ;
#else
			msg = "Internal ERR" ;
#endif
			break;
	}
	fprintf( stderr, "\n\n%s\n", msg );
	exit( err );
#else
#error "define *_LONGJMP"
#endif /* DONT_USE_LONGJMP */
#endif /* USE_LONGJMP */
}

void
term2(int rval, const char *lpszFile, int	line )
{
#ifdef	WINDOWS
	char	buf[1024];
	wsprintf( buf, "terminated on %s line %d / err = %d\n", lpszFile, line, rval );
	MessageBox( NULL, buf, "GOGO2DLL", MB_OK ); 
#else
	fprintf( stderr, "terminated on %s line %d / err = %d\n", lpszFile, line, rval );
#endif
	term( rval );
}

#endif	/* !defined(MUSENC_PASS2) */

#if	!defined(MUSENC_PASS2)
MERET	EXPORT	MPGE_getUnitStates( unsigned long *pUnit )
{
	static unsigned long	unit = 0;

	if( unit == 0 ){
		unit = haveUNIT();
		if( unit & tSSE ){
			MERET	jmpval;
			jmpval = setjmp( _longjmp_ptr );
			if( jmpval ){		// OSSSEб
				unit &= ~tSSE;
			}
		}
	}
	*pUnit = unit;
	return ME_NOERR;
}
#endif	/* !defined(MUSENC_PASS2) */


#if	!defined(MUSENC_PASS2)
#ifdef		GOGO_DLL_EXPORTS
MERET	EXPORT	MPGE_getVersion( unsigned long *vercode,  char *verstring )
{
	*vercode = VERSION_NUM;
	strcpy( verstring, VERSION );

	return ME_NOERR;
}
#endif
#endif	/* !defined(MUSENC_PASS2) */

#if	!defined(MUSENC_PASS2)
/* pass 2 for defining the single thread function */
#if	defined(USE_PTHREAD)
/* multithreaded functions are defined in pass 1. */
#undef USE_PTHREAD
#define MUSENC_PASS2
#include "musenc.c"
#endif
/* BeOS */
#if	defined(USE_BTHREAD)
/* multithreaded functions are defined in pass 1. */
#undef USE_BTHREAD
#define MUSENC_PASS2
#include "musenc.c"
#endif
#endif

