/*
 *	for new GOGO-no-coda (1999/09)
 *	modified by PEN@MarineCat
 */
/*
 *   99.09.23  ɤǥХåѥΤߤ˸
 */
#include    "common.h"
#include	<ctype.h>
#include <assert.h>
#include <errno.h>

#include "musenc.h"

float  s_freq[2][4] = {{22.05, 24, 16, 0}, {44.1, 48, 32, 0}};

/* 1: MPEG-1, 0: MPEG-2 LSF, 1995-07-11 shn */
int     bitrate[2][3][15] = {
          {{0,32,48,56,64,80,96,112,128,144,160,176,192,224,256},
           {0,8,16,24,32,40,48,56,64,80,96,112,128,144,160},
           {0,8,16,24,32,40,48,56,64,80,96,112,128,144,160}},
	  {{0,32,64,96,128,160,192,224,256,288,320,352,384,416,448},
           {0,32,48,56,64,80,96,112,128,160,192,224,256,320,384},
           {0,32,40,48,56,64,80,96,112,128,160,192,224,256,320}}
        };

/* getframebits Υơ֥벽 */
/* ǽ˸ƤФΤ samp  gl.enc_freqHz ѹ뤳ȤʤɤϽʤ */

int bitsPerFrame_table[15][2]; 	//
int mean_bits_table[15][2]; 	//

#ifdef  UseFrameBitsTable
void old_getframebits( int *bitsPerFrame, int *mean_bits, int rate_idx, int padding )
#else
void getframebits( int *bitsPerFrame, int *mean_bits, int rate_idx, int padding )
#endif
{
	int whole_SpF;
	float bit_rate,samp;
	int sideinfo_len;
  
	samp =      s_freq[gl.version][gl.freq_idx];
	bit_rate = bitrate[gl.version][ 2 /* info->lay-1 */ ][rate_idx];
  
	/* determine the mean bitrate for main data */
	sideinfo_len = 32;
	if( gl.version == 1 ){   /* MPEG 1 */
		sideinfo_len += ( gl.stereo == 1 ) ? 136 : 256;
        }else{ /* MPEG 2 */
		sideinfo_len += ( gl.stereo == 1 ) ? 72 : 136;
        }

	whole_SpF = ( gl.frameSize /samp ) * ( bit_rate /  8.0 );
	*bitsPerFrame = 8 * ( whole_SpF + padding );
	*mean_bits = ( *bitsPerFrame - sideinfo_len ) / gl.mode_gr;
}

#ifdef  UseFrameBitsTable
void
framebitstable_init(void)
{
	struct GLOBAL_VAR keep_gl;
	int   br;
	int   padding;
	keep_gl = gl;
	
	for( br = 0; br < 15; br++ ){
		for( padding = 0; padding < 2; padding++ ){
			old_getframebits(
				&bitsPerFrame_table[br][padding], 
				&mean_bits_table[br][padding],
				br, padding);
		}
	}
	gl = keep_gl;
}

#if 0
void 
getframebits( int *bitsPerFrame, int *mean_bits )
{
	int  br      = gl.rate_idx;
	int  padding = gl.padding;
	
	if (padding < 0) printf("error:%d\n", __LINE__);
	if (2 <= padding) printf("error:%d\n", __LINE__);
	if (br < 0) printf("error:%d\n", __LINE__);
	if (15 <= br) printf("error:%d\n", __LINE__);
	
	*bitsPerFrame = bitsPerFrame_table[br][padding];
	*mean_bits    = mean_bits_table[br][padding];
}
#endif
#endif


int BitrateIndex(int layr,int bRate,int version)
{
	int i = 0;
	for( i = 0; i < 15; i++ ){
		if( bitrate[version][layr-1][i] == bRate ) return i;
	}
        fprintf(stderr, "BitrateIndex: %d (layer %d) is not a legal bitrate\n", bRate, layr);
        return -1;
}

int SmpFrqIndex(long sRate,int *version)
{
    if (sRate == 44100L) {
        *version = MPEG_AUDIO_ID; return(0);
    }
    else if (sRate == 48000L) {
        *version = MPEG_AUDIO_ID; return(1);
    }
    else if (sRate == 32000L) {
        *version = MPEG_AUDIO_ID; return(2);
    }
    else if (sRate == 24000L) {
        *version = MPEG_PHASE2_LSF; return(1);
    }
    else if (sRate == 22050L) {
        *version = MPEG_PHASE2_LSF; return(0);
    }
    else if (sRate == 16000L) {
        *version = MPEG_PHASE2_LSF; return(2);
    }
    else {
        return(-1);     /* Error! */
    }
}

int NormalizeSmpFreq(long freqHz)
{
	static	int	legal_rate[] = {
		16000, 22050, 24000, 32000, 44100, 48000
	};
	int		nDist = 0x7fff;
	int		nIndex = -1;
	int i;
	for(i = 0;i < sizeof( legal_rate ) / sizeof( legal_rate[0] ) ;i++ ){
		int		ld = abs( legal_rate[i] - freqHz );
		if( nDist > ld ){
			nDist = ld;
			nIndex = i;
		}
	}
	return legal_rate [ nIndex ];
}

/*
 *	size byteݤƤΥݥ󥿤֤
 *	0ʤ
 *	ݤ˼Ԥexit(1)¹Ԥ
 */
#ifndef NDEBUG
#define MAX_ALLOC_NUM	64
static void *allocPtr[MAX_ALLOC_NUM];
static int allocNum = 0;
#endif

void *mem_alloc(unsigned long size, char *item){
	void *ptr;
#ifndef	NDEBUG
	int i;
	if(allocNum==MAX_ALLOC_NUM){
#ifdef	WIN32
//		char	buf[1024];
//		sprintf( buf,"reached limit num(=%d) in memAlloc\n",MAX_ALLOC_NUM);
//		OutputDebugString( buf );
#else
		fprintf(stderr,"reached limit num(=%d) in memAlloc\n",MAX_ALLOC_NUM);
#endif
		TERM( ME_NOMEMORY );
	}
#endif

	ptr = (void *)calloc(size, 1);
	if( ptr == NULL ){
		fprintf(stderr,"malloc err [%d]byte.\n",(int)size);
		TERM( ME_NOMEMORY );
	}

#ifndef	NDEBUG
	/* only debug build */
	for(i=0;i<MAX_ALLOC_NUM;i++){
		if(allocPtr[i]==NULL){
			allocPtr[i]=(char *)ptr;
			allocNum++;
			return ptr;
      }
    }
	fprintf(stderr,"unexpected err in memAlloc\n");
      exit(1);
	return NULL;
#else
	return ptr;
#endif
}

/* *ptrǳݤ줿 *ptrNULLˤʤ */

void mem_free(void **ptr)
{
#ifndef	NDEBUG
	/* only debug build */
	int i;
	for(i=0;i<MAX_ALLOC_NUM;i++){
		if(allocPtr[i]==*ptr){
			free(*ptr);
			*ptr=NULL;
			allocPtr[i]=NULL;
			allocNum--;
			return;
		}
	}
	fprintf(stderr,"invalid ptr=%p in memFree\n",ptr);
	exit(1);
#else
	free( *ptr );
	*ptr = NULL;
#endif
}

/* ˺Υ̵꤬Ĵ٤ */

void memFreeChk(void){
#ifndef	NDEBUG
	int i;
	if(!allocNum){
		fprintf(stderr,"There is no un-free ptrs. O.K.\n");
		return;
	}
	fprintf(stderr,"The # of un-free ptrs is %d\n",allocNum);
	for(i=0;i<MAX_ALLOC_NUM;i++){
		if(allocPtr[i]){
			fprintf(stderr,"ptr=%p\n",allocPtr[i]);
		}
	}
#endif
}

/* RIFF_DATA_CHUNK */
struct CK_RIFF {
	long	chunk;						/* "RIFF" */
	long	size;					/* sizeof "RIFF" */
} ;

struct CK_FMT {
	long	chunk;						/* "WAVE" */
	long	form;						/* "fmt " */
	long	size;						/* 16 */
	short	formatID;					/*  1 = RAW WAVE */
	short	num_of_channel;				/* 1 or 2 */
	long	srate;						/* 44100 etc. */
	long	avg_bytes_par_sec;			/* freq * elementsize */
	short	block_size;					/* byte per element */
	short	bits_par_sample;			/* 16 */
} ;

struct CK_DATA {
	long	chunk;						/* "DATA" */
	long	size;						/* sizeof "DATA" */
} ;

struct CK_WAVE {
	struct	CK_RIFF		riff;
	struct	CK_FMT		fmt;
} ;

int
WAV_checkFMT(FILE *fp, int *size, int *bit, int *freq, int *channel)
{
	struct	CK_WAVE		wav;
	char	prevbuf[8];
	int i, c;

	*size = *freq = *channel = 0;
	if( fp == NULL ) return FALSE;

        /* because we can't use fread() in stdin-mode */

	for( i = 0; i < sizeof( wav ); i++ ){
		c = fgetc( fp );
		if( c == EOF )return FALSE;
		*( ((char *)&wav) + i ) = c;
	}

//	rewind( fp );
	if( memcmp( &wav.riff.chunk, "RIFF", 4) )
		return FALSE;
	if( memcmp( &wav.fmt.chunk, "WAVEfmt ", 8) )
		return FALSE;
//	if( wav.fmt.size != 16 )
//		return FALSE;
	if( wav.fmt.formatID != 1 )
		return FALSE;
//	if( wav.fmt.bits_par_sample != 16 )
//		return FALSE;
	memset( prevbuf, 0, sizeof(prevbuf) );

	do{
		memcpy( prevbuf, prevbuf+1, sizeof(prevbuf) - 1);
		c = fgetc( fp );
		if( c == EOF ) return FALSE;

		prevbuf[sizeof(prevbuf)-1] = c;
        }while( memcmp( prevbuf, "data", 4 ) );
	/* prevbuf='data...'(...DWORDdata󥯤Υ)Ȥʤ */

	*size    = *(unsigned int *)( prevbuf + 4 );
	*freq    = wav.fmt.srate;
	*bit     = wav.fmt.bits_par_sample;
	*channel = wav.fmt.num_of_channel; 

/*
fprintf(stderr,"եϷ : RIFF-WAVE FMT\n");
fprintf(stderr,"ȿ       : %d Hz\n", wav.fmt.srate);
fprintf(stderr,"ϥͥ     : %d ch\n", *channel);
fprintf(stderr,"ϥ(byte) : %d byte\n", *size);
fprintf(stderr,"ǡ(byte) : %d byte\n", ftell(fp));
*/

	return TRUE;
}
