/* Josh Pieper, (c) 2000
   Robert Munafo, (c) 2001

   This file is distributed under the GPL, see file COPYING for details */

/* Highest used dqi so far: 0x0188 */

#ifndef GNUT_LIB_H
#define GNUT_LIB_H 0

#ifdef WIN32
# define VERSION "0.4.28/win32"
#endif

/* Define YTAGS to enable tagging of all memory blocks to trace leaks. Once
 * defined, rebuild and use 'debug' command to display info. This is not
 * for release versions because it is slow and causes a 4-byte per block
 * memory overhead. */
#define YTAGS 0

#define GDEBUG_ENABLE 0



#include "td.h"

/* 0.4.28.c17 */
#include "sh_sys_types.h"

#include <sys/socket.h>
#include <netinet/in.h>

#ifdef DMALLOC
# include <dmalloc.h>
#endif

#include <pthread.h>



#if YTAGS
  #define YPROBE(x,y) yprobe((x),(y))
#else
  #define YPROBE(x,y) if(0) { }
#endif

/* 0.4.28.c19 Add these macros, and replace all calls to the gd_xxx
   routines with calls to the macros. This removes a lot of useless
   overhead for most users who don't have to do debugging, but it also
   means some users will need to recompile to re-enable the debugging */
#if GDEBUG_ENABLE
# define GD_S(l,s)      gl_gd_s((l),(s))
# define GD_02X(l,c)    gl_gd_02x((l),(c))
# define GD_I(l,x)      gl_gd_i((l),(x))
# define GD_U(l,x)      gl_gd_u((l),(x))
# define GD_X(l,x)      gl_gd_x((l),(x))
# define GD_LI(l,x)     gl_gd_li((l),(x))
# define GD_LU(l,x)     gl_gd_lu((l),(x))
# define GD_F64(l,x)    gl_gd_f64((l),(x))
# define GD_P(l,p)      gl_gd_p((l),(p))
# define GD_PERROR(l,s) gl_gd_perror((l),(s))
#else
# define GD_S(l,s)      while (0) { }
# define GD_02X(l,c)    while (0) { }
# define GD_I(l,x)      while (0) { }
# define GD_U(l,x)      while (0) { }
# define GD_X(l,x)      while (0) { }
# define GD_LI(l,x)     while (0) { }
# define GD_LU(l,x)     while (0) { }
# define GD_F64(l,x)    while (0) { }
# define GD_P(l,p)      while (0) { }
# define GD_PERROR(l,s) while (0) { }
#endif

/* close_f is for closing a file. This is close() under both Windows and
 * Unix. */
#define close_f(f) close((f))

#ifndef MIN
# define MIN(a,b) (((a < b)) ? (a) : (b))
# define MAX(a,b) (((a > b)) ? (a) : (b))
#endif

/* #define TEST_BE1 */
/* #define TEST_BE2 10 */

/* 0.4.28.c08 Replace old endian conversion with these macros. I didn't tag
   all the places the macros are called, just fgrep the source if you
   want to find them */

#if YTAGS
# ifdef WORDS_BIGENDIAN
    /* Host is bigendian, enforce typechecking */
#   define GET_LEU16(p,tn)   be_get_leu16(p,tn)
#   define PUT_LEU16(p,x,tn) be_put_leu16((p),(x),tn)
#   define GET_LEU32(p,tn)   be_get_leu32(p,tn)
#   define PUT_LEU32(p,x,tn) be_put_leu32((p),(x),tn)
# else
    /* Host is littleendian, enforce typechecking */
#   define GET_LEU16(p,tn)   le_get_leu16(p,tn)
#   define PUT_LEU16(p,x,tn) le_put_leu16((p),(x),tn)
#   define GET_LEU32(p,tn)   le_get_leu32(p,tn)
#   define PUT_LEU32(p,x,tn) le_put_leu32((p),(x),tn)
# endif
#else
# ifdef WORDS_BIGENDIAN
    /* Host is bigendian, no typechecking */
#   define GET_LEU16(p,tn) ( (((uint16) ((p)[1])) << 8) | ((uint16) (*(p))) )
#   define PUT_LEU16(p,x,tn) { *(p) = ((x) & 0xff); \
                            (p)[1] = (((x) >> 8) & 0xff);     }
#   define GET_LEU32(p,tn) ((((uint32) ((p)[3])) << 24) \
                       | (((uint32) ((p)[2])) << 16) \
                       | (((uint32) ((p)[1])) << 8) \
                        | ((uint32) (*(p))) )
#   define PUT_LEU32(p,x,tn) { *(p) = ((x) & 0xff); \
                            (p)[1] = (((x) >> 8) & 0xff); \
                            (p)[2] = (((x) >> 16) & 0xff); \
                            (p)[3] = (x) >> 24;               }
# else
    /* Host is littleendian, no typechecking */
#   define GET_LEU16(p,tn)   (*((uint16 *) (p)))
#   define PUT_LEU16(p,x,tn) (*((uint16 *) (p))) = (x)
#   define GET_LEU32(p,tn)   (*((uint32 *) (p)))
#   define PUT_LEU32(p,x,tn) (*((uint32 *) (p))) = (x)
# endif
#endif

#define SMCPY(d,s) memcpy((d),(s),sizeof(d))

#define g_debug undefined_g_debug1 undefined_g_debug2;

#define OCTAL(a,b,c) (((a) << 6) | ((b) << 3) | (c))

/* 0.4.28.c18 Added these macros -- if you are implementing this change you
   should also fgrep the rest of the source code to find the places the
   ctype routines are called, and substitute each with the corresponding
   macro

   Some systems (notably gcc on Solaris) complain if you pass a 'char'
   parameter to isspace, isalpha, etc. Note that 'man isspace' specifies
   the argument should be 'int'. So, we have to define these stupid macros */
#define G_ISALNUM(c) (isalnum((int)(c)))
#define G_ISBLANK(c) (g_isblank((int)(c)))
#define G_ISDIGIT(c) (isdigit((int)(c)))
#define G_ISLOWER(c) (islower((int)(c)))
#define G_ISPRINT(c) (isprint((int)(c)))
#define G_ISSPACE(c) (isspace((int)(c)))

#ifdef __cplusplus
extern "C" {
#endif
  extern char *path_separator;
  extern char *path_slash;

  extern int gnut_lib_debug;

#define DQ_SIZE 256
  extern uint16 dq[DQ_SIZE];
#define DQT_CHUNK_SIZE 128
#define DQT_CHUNK_NUM 64
#define DQT_CHUNK_MASK 31
  extern uint16 dqt[DQT_CHUNK_SIZE * DQT_CHUNK_NUM];
  extern int32 dqtp[DQT_CHUNK_NUM];
  extern int32 dqptr;
  extern uint16 dqtt;

  void dq_init(void);
  void dq_hi_init(void);

#define DQ_TID (((int) pthread_self()) & DQT_CHUNK_MASK)
  void dq_start(char *thtype, uint16 dqinum);
  void dq_end(void * retval);

#define dqi(x) (dq[dqptr] = (x), dqptr = (dqptr + 1) % DQ_SIZE, \
		dqtt = DQ_TID, \
		dqt[(dqtt * DQT_CHUNK_SIZE) + dqtp[dqtt]] = (x), \
		dqtp[dqtt] = (dqtp[dqtt] + 1) % DQT_CHUNK_SIZE, 0)
  void dql(uint32 x);
  void dqp(void *p);
  void dq_dump(char *msg);

#define gnut_mprobe(x) _gnut_mprobe(x)
  int gnut_mprobe(void *);

  char *expand_path(char *);

  void init_leaks(void);
  void reset_leaks(void);
  void check_reset(void);
  void tell_leaks(void);
  int yprobe(void *a, int tracking_number);
  void yfre(void **, int tracking_number);
  void fre_v(void **x, int bugnum);
  void fre_strl(char ***x, int bugnum);
  void fre_str(char **x, int bugnum);
  void *ymaloc(int size, int tracking_number);
  char *ystdup(const char *s, int tracking_number);
  void *ycaloc(size_t nmemb, size_t size, int tracking_number);

  int g_isblank(int c); /* 0.4.28.c18 */

  void fre_vs(varstring_data **x, int bugnum); /* 0.4.28.c06 */
  char * vs_new(void); /* 0.4.28.c06 */
  void vs_free(char **vs); /* 0.4.28.c06 */

  /* 0.4.28.c08 */
#if YTAGS
  uint16 be_get_leu16(uint8 * x, int tn);
  uint16 le_get_leu16(uint8 * x, int tn);
  void be_put_leu16(uint8 * p, uint16 x, int tn);
  void le_put_leu16(uint8 * p, uint16 x, int tn);
  uint32 be_get_leu32(uint8 * x, int tn);
  uint32 le_get_leu32(uint8 * x, int tn);
  void be_put_leu32(uint8 * p, uint32 x, int tn);
  void le_put_leu32(uint8 * p, uint32 x, int tn);
#endif

#ifdef WIN32
#include <windows.h>

#define HAVE_STRTOK_R

  typedef unsigned int uint;

#define stricmp(x,y) strcasecmp(x,y)
#define sleep(x) Sleep(x*1000)
#define usleep(x) Sleep(x)
  char *strtok_r(char *, const char *, char **);
  int getopt(int argc, char *argv[], char *);
  extern char *optarg;
  extern int optind;

#define strncasecmp strnicmp
#define strcasecmp stricmp

#define inet_aton(string, ip) (ip)->s_addr = inet_addr(string)

#define write(sock, buf, len) send((sock), (buf), (len), 0)
#define read(sock, buf, len) recv((sock), (buf), (len), 0)
#define close_s(sock) closesocket(sock)

#define F_SETFL 1
#define O_NONBLOCK 1
  int fcntl(int sock, int, uint);

#define flock(a,b) 0
#else
#define close_s(sock) close(sock)
#endif

#if GDEBUG_ENABLE
  void gl_gd_s(int level, char * str);
  void gl_gd_02x(int level, uchar c);
  void gl_gd_i(int level, int32 x);
  void gl_gd_u(int level, uint32 x);
  void gl_gd_x(int level, int32 x);
  void gl_gd_li(int level, int32 x);
  void gl_gd_lu(int level, uint32 x);
  void gl_gd_f64(int level, float64 x);
  void gl_gd_p(int level, void * p);
  void gl_gd_perror(int level, char * s);
#endif

  char *gnut_strdelimit(char *string, char *delimeters, char new_delim);
  void gnut_strstrip(char *string);
  char *munge_time(int secs);
  char *format_si(float64 x, char *s);

  int strlen_an(char *s);

  void crc32_start(uint32 *crc);
  void crc32_add8(uint32 *crc, uchar data);  
  uint32 crc32_string(char *data);
  uint32 crc32_block(void * data, uint32 len);
  void print_ascii(uchar *s);
  void print_asc_n(uchar *s, int len);
  int writestr(int sock, char *str);
  int trycmd(char *cmd, char *pat);
  void strcatlim(char *dest, char *src, int maxlen);
  void make_lc(char *str);
  void make_7bit(char *str);
  int keyword_match(char *query, char *str, int and, int ignorecase);
  void make_htmlsafe(char *str); /* 0.4.28.c15 */
  int gl_strncmp(char *a, char* b, int len, int igcase);
  uint32 gl_stou32(char *s, char **p);

#ifdef __cplusplus
}
#endif

#endif
