/* Josh Pieper, (c) 2000 */

/* This file is distributed under the GPL, see file COPYING for details */

#ifndef CLI_OUTPUT_H
#define CLI_OUTPUT_H

#ifdef __cplusplus
extern "C" {
#endif

  int cli_output_init();
  int cli_output_reset();

  /* give this function the number of lines after this one that
   * shouldn't be separated over a page break */
  int cli_output_line(int, char *);
  void cli_outline_nl(char *t);
  void cli_out_lines(char *t1, char *t2, char *t3, char *t4, char *t5,
		     char *t6);

  char wait_key_callback(void (*a)(void));
  void raw_mode(int);

  extern char *output_bold_on;
  extern char *output_special_off;

#ifdef HAVE_LIBTERMCAP
#  define tputs_x(x) tputs(x,1,putchar)
#else
#  define tputs_x(x)
#endif

#ifdef __cplusplus
}
#endif

#endif
