/* Josh Pieper, (c) 2000 */

/* This file is distributed under the GPL, see file COPYING for details */

#ifndef GNUT_TRANSFER_H
#define GNUT_TRANSFER_H

#include <pthread.h>
#include <time.h>
#include "lib.h"

typedef struct {
  int sock;
  uint8 ip[4];
  uint16 port;
  int fsock;
  char *fname;
  int type;  /* indicates whether an upload, or download, or push */
  uint32 gt_bytes;
  uint32 total; /* 0.4.27.c11 */
  uint32 rate_bytes;
  time_t rate_incr_time;
  uint32 rate_limit;
  int state;  /* states are the same as for connections */
  int substate;
  int32 gt_uindex;  /* for ui purposes... */
  pthread_t tid;
  int gt_dest_cache;
} gnut_transfer;

#ifdef __cplusplus
extern "C" {
#endif

  void fre_gt(gnut_transfer **x, int bugnum);
  gnut_transfer * gnut_xfer_new();
  int gnut_xfer_delete(gnut_transfer *gt);

  void decay_rate(gnut_transfer *gt);
  int gnut_xfer_loop(gnut_transfer *gt, int overlap, char *overlap_buf,
			 int dest_cache);

  int gnut_xfer_enumerate( int(*a)(gnut_transfer *));

  int gnut_xfer_num();

#ifdef __cplusplus
}
#endif

#endif
