/* Josh Pieper, (c) 2000 */

/* This file is distributed under the GPL, see file COPYING for details */

#ifndef ROUTE_H
#define ROUTE_H

#include "hash.h"
#include "lib.h"
#include "connection.h"

typedef struct _route_entry route_entry;

struct _route_entry {
  uchar guid[16];
  gcs *p;
};

#ifdef __cplusplus
extern "C" {
#endif

  extern lru_hash qreplies;
  extern Gnut_Queue *route_queue;

  void fre_re(route_entry **x, int bugnum);
  int route_guid_add(uchar guid[16], gcs *gc);
  gcs * route_guid_find(uchar guid[16], route_entry **the_re);
  int route_guid_clear(gcs *gc);
  int route_init();

  /* %%% Want to make this a settable parameter with an enforced minimum,
   * to support bigger networks/greater bandwidth/etc
   * 20 bytes per route_entry, plus 8 bytes for the list node, times 10000
   * would be 280000 bytes */
#define ROUTE_MAX 10000

#ifdef __cplusplus
}
#endif

#endif
