/* Josh Pieper, (c) 2000 */

/* This file is distributed under the GPL, see file COPYING for details */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <pthread.h>

#ifndef WIN32
# include <sys/socket.h>
# include <netinet/in.h>
# include <arpa/inet.h>
# include <unistd.h>
#endif

#include "monitor.h"
#include "queue.h"

Gnut_Queue * monitor_queue;

#ifndef PTHREADS_DRAFT4
 pthread_mutex_t monitor_mutex = PTHREAD_MUTEX_INITIALIZER;
#else
 pthread_mutex_t monitor_mutex;
#endif

void fre_ms(monitored_search **x, int bugnum)
{
  yfre((void **) x, bugnum);
}

/* sets up our own monitor queue */
int monitor_init()
{
  monitor_queue = gnut_queue_new(513);
  return 0;
}

extern int deb1;

/* add a search request to the tail of the `monitor' list */
int monitor_search_add(char *search, int matched)
{
  monitored_search *ms;
  uchar * s;

  gd_s(3, "monitor_search_add entering\n");

  ms = (monitored_search *)ymaloc(sizeof(monitored_search), 305);
  ms->search = ystdup(search, 454);
  ms->matched = matched;

  for(s = ms->search; *s; s++) {
    if ((*s < 32) || (*s >= 127)) { /* tagok */
      *s = '#';
    }
  }

  pthread_mutex_lock(&monitor_mutex);
  gnut_queue_insert(monitor_queue, ms, 505);
  pthread_mutex_unlock(&monitor_mutex);

  gd_s(3, "monitor_search_add leaving\n");
  return 0;
}

monitored_search *monitor_search_get()
{
  monitored_search *ms;

  pthread_mutex_lock(&monitor_mutex);
  ms = gnut_queue_remove(monitor_queue);
  pthread_mutex_unlock(&monitor_mutex);
  
  return ms;
}
