/* Josh Pieper, (c) 2000 */

/* This file is distributed under the GPL, see file COPYING for details */

#ifndef GNUT_HASH_H
#define GNUT_HASH_H

#include "lib.h"
#include "list.h"
#include "queue.h"

typedef struct _Gnut_Hash Gnut_Hash;

struct _Gnut_Hash {
  uchar (*hash_func)(void *);
  int (*compare_func)(void *, void *);
  Gnut_List *list[256];
};

typedef struct crcptr {
  uint32 crc;
  void * ptr;
  uint32 datalen;
} crcptr;

typedef struct lru_hash {
  uint32 maxaloc;
  Gnut_Hash * hash;
  Gnut_Queue * queue;
  uint32 alocnum;
} lru_hash;

typedef struct age_node {
  struct age_node * next;
  uint32 crc;
  void * data;
  uint32 len;
  uint16 age;
} age_node;

typedef struct age_hash {
  uchar (*hash_func)(void *, uint32);
  int (*compare_func)(void *, uint32, void *, uint32);
  age_node *list[256];
  uint32 maxaloc;
  uint32 curaloc;
  uchar agenext;
} age_hash;

#ifdef __cplusplus
extern "C" {
#endif

  void fre_gh(Gnut_Hash **x, int bugnum);
  void fre_crcp(crcptr **x, int bugnum);
  int gnut_hash_foreach(Gnut_Hash *, int (*a)(void *, void *), void *);
  Gnut_Hash * gnut_hash_new(uchar (*hash_func)(void *), 
			    int (*compare_func)(void *, void *));
  int gnut_hash_bucketnum(Gnut_Hash *gh, void *data);
  int gnut_hash_bucketsize(Gnut_Hash *gh, void *data);
  void * gnut_hash_bucketoldest(Gnut_Hash *gh, void *data);
  void gnut_hash_insert(Gnut_Hash *gh, void *data, int tracking_number);
  void * gnut_hash_find(Gnut_Hash *,void *);
  void * gnut_hash_find_raw(Gnut_Hash *,void *);
  uint32 gnut_hash_remove(Gnut_Hash *,void *);
  uint32 gnut_hash_fre(Gnut_Hash *);

  void lru_init(lru_hash * h, uint32 maxaloc);
  void lru_gc(lru_hash *h);
  int lru_store(lru_hash * h, void * key, uint32 keylen, void * data,
		uint32 datalen);
  int lru_storecopy(lru_hash * h, void * key, uint32 keylen, void * data,
		    uint32 datalen, int tracking_number);
  void * lru_get(lru_hash * h, void * key, uint32 keylen, uint32 * datalen,
		 int needlock); /* 0.4.27.c16 */
  void * lru_copy(lru_hash * h, void * key, uint32 keylen,
		  uint32 * datalen);

#ifdef __cplusplus
}
#endif

#endif
