/* Josh Pieper, (c) 2000 */

/* This file is distributed under the GPL, see file COPYING for details */

#ifdef HAVE_READLINE

#include <stdio.h>
#include <stdlib.h>
#include <readline/readline.h>
#include <readline/history.h>

#include "lib.h"
#include "cli.h"
#include "conf.h"

char *command_generator();
char **gnut_completion();

int initialize_readline()
{
  /* Allow conditional parsing of ~/.inputrc */
  rl_readline_name = "Gnut";
  
  /* The the completer that we want first crack */
  rl_attempted_completion_function = (CPPFunction *)gnut_completion;
  
  /* commented out because not supported on all platforms, too lazy
   * to check... */
  /*  rl_completion_query_items=30; */
  
  return 0;
}

   
char *command_generator(char *text, int state)
{
  static int list_index, len;
  char *name;
  
  if (!state) {
    list_index = 0;
    len = strlen(text);
  }
  
  while ((name = commands[list_index].name)) {
    list_index++;

    if (strncmp(name, text, len) == 0) {
      return (strdup(name));
    }
  }
  
  return 0;
}

char *key_generator(char *text, int state)
{
  static int list_index,len;
  char *name;
  
  if (!state) {
    list_index = 0;
    len = strlen(text);
  }
  
  while ((name = configuration_pairs[list_index].ckp_key)) {
    list_index++;
    
    if (strncmp(name, text,len)==0) {
      return(strdup(name));
    }
  }
  
  return 0;
}    

/* Attempt to complete on the contents of TEXT.  START and END bound the
   region of rl_line_buffer that contains the word to complete. TEXT is
   the word to complete.  We can use the entire contents of rl_line_buffer
   in case we want to do some simple parsing.  Return the array of matches,
   or 0 if there aren't any. */
char **gnut_completion (char *text, int start, int end)
{
  char **matches = 0;
  
  if (start == 0) {
    matches = completion_matches(text, command_generator);
  }
  if ((start>3) && (strncmp(rl_line_buffer, "se", 2)==0)) {
    matches = completion_matches(text, key_generator);
  }
    
  return matches;
}

#endif
