/* Josh Pieper, (c) 2000 */

/* This file is distributed under the GPL, see file COPYING for details */

#ifndef CLI_INPUT_H
#define CLI_INPUT_H

/* 0.4.27.c15 */
#include "qry.h"

typedef struct {
  char *name;
  int (*func)(char *);
  char *doc;
  char *longdoc;
} COMMAND;

#ifdef __cplusplus
extern "C" {
#endif

  extern char * ratings[];
  extern COMMAND commands[];

  extern int monitor_query;
  extern int monitor_reply;
  extern int monitor_push;
  extern int readline_firsttime;
  extern int readline_crashed;

  void gpl_top(void);
  void gpl_copying(void);
  void gpl_no_warranty(void);
  void gpl_bottom(void);
  void gpl_full(void);

  int com_blacklist(char *);

  int com_clear_callback(int32 a, void *b); /* 0.4.27.c15 */
  int com_clear(char *);

  int com_cls(char *),
    com_debug(char *),
    com_eval(char *),
    com_find(char *);

  int com_forget_callback(int32 a, void *b); /* 0.4.27.c15 */
  int com_forget_alpha_filter(query_resp *a_qrp); /* 0.4.27.c15 */
  int com_forget(char *);

  int com_get_callback(int32 a, void *b); /* 0.4.27.c15 */
  int com_get(char *);

  int com_help(char *), com_hosts(char *),
    com_info(char *);

  int com_kill_callback(int32 a, void *b); /* 0.4.27.c15 */
  int com_kill(char *);

  int com_last(char *), com_lclear(char *), com_limit(char *),
    com_list(char *), com_load(char *), com_log(char *),
    com_lshare(char *),
    com_monitor(char *), com_mpush(char *), com_mreply(char *),
    com_open(char  *),
    com_play(char *), com_player(char *), com_push(char *),
    com_quit(char *);

  int query_response_compare(const void *a, const void *b);
  int cr_display(query_resp * a_qrp, int32 uindex);
  int com_response(char *);

  int com_save(char *), com_scan(char *), com_set(char *),
    com_share(char *), com_shell(char *), com_sleep(char *);

  int com_stop_cb1(int32 a, void *b); /* 0.4.27.c15 */
  int com_stop(char *);

  int com_update(char *), com_version(char *);

  int recu_up(void);
  void recu_down(void);
  int recu_click(int cl);

  int get_command_index(char *command);
  int parse_command(char *a);
  void check_gnut_mainloop(void);
  int command_loop();
  int run_config_file(char *f, int doall, int echo, int comset);
  int input_parse_range(char *range, int (*a)(int32, void *), void *userdata);
  char *info_str_type(int a);
  char *info_str_state(int a, int s);

#ifdef __cplusplus
}
#endif

#endif
