dnl Check for a tar program that speaks ustar format
dnl Copyright (C) 2005 Free Software Foundation, Inc.
dnl
dnl This file is free software, distributed under the terms of the GNU
dnl General Public License.  As a special exception to the GNU General
dnl Public License, this file may be distributed as part of a program
dnl that contains a configuration script generated by Autoconf, under
dnl the same distribution terms as the rest of that program.

AC_DEFUN([GNUPG_CHECK_USTAR],
[
  AC_ARG_WITH(tar,
     AC_HELP_STRING([--with-tar=PATH],[look for a tar program in PATH]),
     [_do_tar=$withval])

  if test x$_do_tar != xno ; then

     if test x$_do_tar = x ; then
        AC_PATH_PROG(TAR,"tar")
        _mytar=$ac_cv_path_TAR
     fi

     # Check if our tar is ustar format.  If so, it's good.  TODO: Add some
     # code to check various options, etc, to try and create ustar
     # format.

     if test x$_mytar != x ; then
        AC_MSG_CHECKING([whether $_mytar speaks USTAR])
        echo hithere > conftest.txt
        $_mytar -cf - conftest.txt | grep -q ustar
        _tar_bad=$?
        rm conftest.txt

	if test x$_tar_bad = x0 ; then
	   AC_MSG_RESULT([yes])
	else
	   AC_MSG_RESULT([no])
	fi
     fi
  fi

  AM_CONDITIONAL(HAVE_USTAR, test x$_tar_bad = x0)
])dnl
