/* gMUDix -- MUDix for X windows
 * Copyright (c) 2002 Marko Boomstra (m.boomstra@chello.nl)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <sys/time.h>
#include <ctype.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include "mudix.h"


bool open_log(USER *user, char *filename)
{
    struct timeval current_time;
    char           path[MAX_FILEPATH];

    /* if a logfile is already open, return immediately */
    if (user->logfile)
    {
	return FALSE;
    }

    /* make it a .log file */
    sprintf(path, "%s/" LOG_PATH "%s.log", getenv("HOME"), filename);

    /* open the file - in append mode */
    if (!(user->logfile = fopen(path, "a")))
    {
	return FALSE;
    }

    /* unbuffered writes to the file! :) */
    setbuf(user->logfile, NULL);

    /* get the current time */
    gettimeofday(&current_time, NULL);

    /* first print a log started message in the file */
    fprintf(user->logfile, "%%%% STARTING NEW LOG, %s\n", ctime(&current_time.tv_sec));

    return TRUE;
} 


bool close_log(USER *user)
{
    /* no logfile open? */
    if (!user->logfile)
    {
	return FALSE;
    }

    /* write an end of log mesage in the file */
    fprintf(user->logfile, "\n%%%% END OF LOG.\n");

    /* close the file */
    fclose(user->logfile);

    user->logfile = NULL;

    return TRUE;
}
	

void write_log(USER *user, gchar *data, gsize length)
{
    /* safety check - is there a logfile open? */
    if (!user->logfile)
    {
	return;
    }

    /* just dump the data in the file */
    fwrite(data, sizeof(gchar), length, user->logfile);
    return;
}
